/*	**************************************************************
	Copyright 1996-2000 Netsize Corporation. All Rights reserved.
	e-mail	:	support@netsize.com
				info@netsize.com
	web		:	http://www.netsize.com/

	DO NOT MODIFY
	**************************************************************	*/

#ifndef _STANDARD_PORT_H_
#define _STANDARD_PORT_H_

#if defined(DEBUG) && !defined(_DEBUG)
#	define _DEBUG
#endif	/*	defined(DEBUG) && !defined(_DEBUG) */

/* Version 2.1.0 */
#define AG_VERSION	20100

/**************************************************************************
	Using AGCore Dynamicaly Linked Library
**************************************************************************/

#ifdef AG_USES_AG_CORE
#define AG_USES_AG_CORE_HEADER
#define AG_USES_AG_CORE_DLL
#endif	/*	def AG_USES_AG_CORE	*/

#ifdef AG_CREATE_DLL
#define AG_USES_AG_CORE_HEADER
#endif	/*	def AG_CREATE_DLL	*/

#ifdef AG_CREATE_AG_CORE_DLL
#define AG_USES_AG_CORE_HEADER
#endif	/*	def AG_CREATE_AG_CORE_DLL	*/

#ifdef AG_CREATE_CONTROL
#define AG_USES_AG_CORE_HEADER
#endif	/*	def AG_CREATE_CONTROL	*/

/**************************************************************************
	Using AGEndpoint Dynamicaly Linked Library
**************************************************************************/

#ifdef AG_USES_AG_ENDPOINT
#define AG_USES_AG_ENDPOINT_HEADER
#define AG_USES_AG_ENDPOINT_DLL
#endif	/*	def AG_USES_AG_ENDPOINT	*/

#ifdef AG_CREATE_AG_ENDPOINT_DLL
#define AG_USES_AG_ENDPOINT_HEADER
#endif	/*	def AG_CREATE_AG_ENDPOINT_DLL	*/

#ifdef AG_CREATE_CONTROL
#define AG_USES_AG_ENDPOINT_HEADER
#endif	/*	def AG_CREATE_CONTROL	*/


/**************************************************************************
	Unicode
**************************************************************************/

#if defined(UNICODE) && !defined(_UNICODE)
#	define _UNICODE
#endif	/*	defined(UNICODE) && !defined(_UNICODE)	*/
#if defined(_UNICODE) && !defined(UNICODE)
#	define UNICODE
#endif	/*	defined(_UNICODE) && !defined(UNICODE)	*/

/**************************************************************************
	Platform recognized
		WIN32			Windows 95, 98 and NT WKS and SRV
		_WIN32_WCE		Windows CE (WIN32 is defined)
		__PSISOFT32__	EPOC32
		_LINUX			Linux
			_LINUX_SLACKWARE	Linux Slackware distribution
			_LINUX_RED_HAT		Linux Red Hat distribution
		_SUN_OS			SunOS (sun4)
			_SUN_OS_X86
		_HP_UX			HP-UX
		_DIGITAL_UNIX	Digital Unix
		_GNU_WIN32		Gnu under Win32
		_BE_OS			BeOS
		__PILOT_H__		PalmOS (Palm Pilot)
		_OS_400			AS/400
		_QNX			QNX
		_VXWORKS		VxWorks
		_LYNX			Lynx
		_OS9			OS9
**************************************************************************/

/**************************************************************************
	**	Win 32 (95, 98, NT and CE)
*/
#ifdef WIN32
#	define AG_PF_WIN32		WIN32

#	ifndef _WIN32_WCE
#		define AG_PF_WIN32_NO_WCE
#	endif	/*	ndef _WIN32_WCE	*/

#	define AG_PF_OK
#endif	/*	WIN32	*/

#ifdef _WIN32_WCE

#	ifndef AG_PF_WIN32
#		define AG_PF_WIN32	_WIN32_WCE
#	endif	/*	ndef AG_PF_WIN32	*/

#	define AG_PF_WINCE	_WIN32_WCE

#	define AG_PF_OK
#endif	/*	def else _WIN32_WCE	*/

/**************************************************************************
	**	EPOC (i.e. Psion Series 5)
*/
#ifdef __PSISOFT32__

#define AG_PF_EPOC
#define AG_PF_OK

#endif	/*	def __PSISOFT32__	*/

/**************************************************************************
	**	PALM_OS (i.e. Pilot)
*/
#ifdef __PILOT_H__

#define AG_PF_PALMOS
#define AG_PF_OK

#endif	/*	def __PILOT_H__	*/


/**************************************************************************
	**	UNIX
*/
#ifdef _LINUX

#define AG_PF_LINUX
#define	AG_PF_UNIX

#define AG_PF_OK

#	ifdef _LINUX_SLACKWARE
#		define AG_PF_LINUX_SLACKWARE
#	endif	/* def _LINUX_SLACKWARE */

#	ifdef _LINUX_RED_HAT
#		ifdef _LINUX_SLACKWARE
#			error
#		endif	/* def _LINUX_SLACKWARE */
#		define AG_PF_LINUX_RED_HAT
#	endif	/* def _LINUX_RED_HAT */

#endif	/*	def _LINUX	*/

#ifdef _SUN_OS

#define AG_PF_SUN_OS
#define	AG_PF_UNIX

#define AG_PF_OK

#	ifdef _SUN_OS_X86
#		define AG_PF_SUN_OS_X86
#	endif	/* def _SUN_OS_X86 */

#endif	/*	def _SUN_OS	*/

#ifdef _HP_UX

#define AG_PF_HP_UX
#define	AG_PF_UNIX

#define AG_PF_OK

#endif	/*	def _HP_UX	*/

#ifdef _DIGITAL_UNIX

#define AG_PF_DIGITAL_UNIX
#define	AG_PF_UNIX

#define AG_PF_OK

#endif	/*	def _DIGITAL_UNIX	*/

#ifdef _GNU_WIN32

#define AG_PF_GNU_WIN32
#define	AG_PF_UNIX

#define AG_PF_OK

#endif	/*	def _GNU_WIN32	*/

#ifdef _QNX

#define AG_PF_QNX
#define	AG_PF_UNIX

#define AG_PF_OK

#endif	/*	def _QNX	*/

#ifdef _VXWORKS

#define AG_PF_VXWORKS
#define	AG_PF_UNIX

#define AG_PF_OK

#endif	/*	def _VXWORKS	*/

#ifdef _LYNX

#define AG_PF_LYNX
#define	AG_PF_UNIX

#define AG_PF_OK

#endif	/*	def _LYNX	*/

#ifdef _OS9

#define AG_PF_OS9
#define AG_PF_UNIX

#define AG_PF_OK

#endif	/*	def _OS9	*/

/**************************************************************************
	**	AS/400
*/
#ifdef _OS_400

#define AG_PF_OS_400
#define AG_PF_OK

#endif	/*	def _OS_400	*/

/**************************************************************************
	**	Checking undefined or unknown platform
*/
#ifndef AG_PF_OK
#error: undefined or unknown platform
#endif	/*	ndef AG_PF_OK	*/

/***************************************************************************/
#if	defined(AG_PF_WIN32)
/*	**	Win 32 (95, 98, NT and CE)	*/

#	ifdef _UNICODE
#		define AG_USE_API_STRING
#	else
#		define AG_USE_UNICODE_STRING
#	endif	/*	def _UNICODE	*/

#	define AG_USE_WINTHREAD
#	define AG_USE_WINTHREAD_CRT

#	define AG_USE_REMOTE_ACCESS
#	define AG_USE_REGISTRY

#	if	defined(AG_PF_WINCE)

#		if		(AG_PF_WINCE == 200)
#			define	AG_PF_WINCE_200
#			if	defined(AG_CREATE_AG_CORE_DLL) || defined(AG_COM_CONTROL)
#				if	defined(_WIN32_WCE_EMULATION)
#					ifdef _DEBUG	
#						pragma	comment(linker, "/NODEFAULTLIB:libcmtd.lib")
#						pragma	comment(linker, "/DEFAULTLIB:msvcrtd.lib")
#					else
#						pragma	comment(linker, "/NODEFAULTLIB:libcmt.lib")
#						pragma	comment(linker, "/DEFAULTLIB:msvcrt.lib")
#					endif	/*	def _DEBUG	*/
#					pragma	comment(linker, "/DEFAULTLIB:oleautm.lib")
#					pragma	comment(linker, "/DEFAULTLIB:ole32m.lib")
#				endif	/*	defined(_WIN32_WCE_EMULATION)	*/
#			endif	/*	def AG_CREATE_AG_CORE_DLL	*/

#		elif	(AG_PF_WINCE == 201)
#			define	AG_PF_WINCE_201

#			define	AG_DONT_USE_ATL			/*	for Palm-size PC	*/
#			define	AG_DONT_USE_VARIANT		/*	for Palm-size PC	*/

#			ifdef AG_CREATE_AG_CORE_DLL
#				if	defined(_WIN32_WCE_EMULATION)
#					pragma	comment(linker, "/DEF:.\\AGCoreWinCE.x86.NoVariant.Def")
#					pragma	comment(linker, "/NODEFAULTLIB")
#				else
#					pragma	comment(linker, "/DEF:.\\AGCoreWinCE.SH3.MIPS.NoVariant.Def")
#				endif	/*	defined(_WIN32_WCE_EMULATION)	*/
#			endif	/*	def AG_CREATE_AG_CORE_DLL	*/

#			ifdef AG_CREATE_AG_ENDPOINT_DLL
#				if	defined(_WIN32_WCE_EMULATION)
#					ifdef _DEBUG	
#						pragma	comment(linker, "/NODEFAULTLIB:msvcrtd.lib")
#					else
#						pragma	comment(linker, "/NODEFAULTLIB:msvcrt.lib")
#					endif	/*	def _DEBUG	*/
#					pragma	comment(linker, "/NODEFAULTLIB:oldnames.lib")
#				endif	/*	defined(_WIN32_WCE_EMULATION)	*/
#			endif	/*	def AG_CREATE_AG_ENDPOINT_DLL	*/

#		elif	(AG_PF_WINCE == 211)
#			define	AG_PF_WINCE_211
#			if	defined(AG_CREATE_AG_CORE_DLL) || defined(AG_COM_CONTROL)
#				if	defined(_WIN32_WCE_EMULATION)
#					ifdef _DEBUG	
#						pragma	comment(linker, "/NODEFAULTLIB:msvcrtd.lib")
#					else
#						pragma	comment(linker, "/NODEFAULTLIB:msvcrt.lib")
#					endif	/*	def _DEBUG	*/
#					pragma	comment(linker, "/DEFAULTLIB:oleaut32.lib")
#					pragma	comment(linker, "/DEFAULTLIB:ole32.lib")
#				endif	/*	defined(_WIN32_WCE_EMULATION)	*/
#			endif	/*	def AG_CREATE_AG_CORE_DLL	*/

#			ifdef AG_CREATE_AG_ENDPOINT_DLL
#				if	defined(_WIN32_WCE_EMULATION)
#					ifdef _DEBUG	
#						pragma	comment(linker, "/NODEFAULTLIB:msvcrtd.lib")
#					else
#						pragma	comment(linker, "/NODEFAULTLIB:msvcrt.lib")
#					endif	/*	def _DEBUG	*/
#				endif	/*	defined(_WIN32_WCE_EMULATION)	*/
#			endif	/*	def AG_CREATE_AG_ENDPOINT_DLL	*/

#		elif	(AG_PF_WINCE == 212)
#			define	AG_PF_WINCE_212

#		else
#			error: Invalid WinCE configuration

#		endif

#		define AG_DO_NOT_USE_EXCEPTION
#		define AG_DO_NOT_USE_CPP_EXCEPTION

#		pragma warning(disable: 4514)
#		if (AG_PF_WINCE < 200)
#			error WinCE v2.0 or later required
#		endif /* (AG_PF_WINCE < 200)	*/
#		if (AG_PF_WINCE >= 200)
#			ifndef AG_DONT_USE_ATL
#				ifndef	AG_USE_ATL
#					define AG_USE_ATL			/*	To use VARIANT type	*/
#				endif	/*	ndef	AG_USE_ATL	*/
#			endif	/*	ndef AG_DONT_USE_ATL	*/
#			ifndef AG_DONT_USE_VARIANT
#				ifndef	AG_USE_VARIANT
#					define AG_USE_VARIANT			/*	To use VARIANT type	*/
#				endif	/*	ndef	AG_USE_VARIANT	*/
#			endif	/*	ndef AG_DONT_USE_VARIANT	*/
#		endif	/* (AG_PF_WINCE >= 200)	*/
#	endif	/*	defined(AG_PF_WINCE)	*/

#	ifdef AG_PF_WIN32_NO_WCE
#		ifndef AG_DONT_USE_ATL
#			ifndef	AG_USE_ATL
#				define AG_USE_ATL			/*	To use VARIANT type	*/
#			endif	/*	ndef	AG_USE_ATL	*/
#		endif	/*	ndef AG_DONT_USE_ATL	*/
#		ifndef AG_DONT_USE_VARIANT
#			ifndef	AG_USE_VARIANT
#				define AG_USE_VARIANT			/*	To use VARIANT type	*/
#			endif	/*	ndef	AG_USE_VARIANT	*/
#		endif	/*	ndef AG_DONT_USE_VARIANT	*/
#		define  _AG_USE_NAMED_PIPES_
#	endif	/*	def AG_PF_WIN32_NO_WCE	*/


#	ifndef STRICT
#		define STRICT 1	/*	STRICT is the only supported option	*/
#	endif	/*	ndef STRICT	*/

#	ifdef AG_USE_ATL
#		ifndef	AG_USE_VARIANT
#			define AG_USE_VARIANT			/*	To use VARIANT type	*/
#		endif	/*	ndef	AG_USE_VARIANT	*/
#		pragma warning(disable: 4510)
#		pragma warning(disable: 4610)

#		define AG_CHECK_POINTER_RETURN_SCODE(ptr)	{if (ptr == NULL) return E_POINTER;}
#		define RETURN_AGRETURNCODE(nError)			{*pnAGReturnCode = nError;return S_OK;}
#		define CHECK_AGRETURNCODE_TO_RETURN(nError)\
		{\
			AGReturnCode nReturnCode = nError;\
			if (nReturnCode != agSuccess)\
			{\
				*pnAGReturnCode = nReturnCode;\
				return S_OK;\
			}\
		}

#		define VARIANT_VARIABLE(vVariant)			VARIANT vVariant;VariantInit(&vVariant);

#	endif	/*	def AG_USE_ATL	*/


#	ifndef AG_DO_NOT_USE_EXCEPTION
#		define AG_USE_EXCEPTION
#	endif	/*	ndef AG_DO_NOT_USE_EXCEPTION	*/

#	ifndef AG_DO_NOT_USE_CPP_EXCEPTION
#		define AG_USE_CPP_EXCEPTION
#	endif	/*	ndef AG_DO_NOT_USE_CPP_EXCEPTION	*/

#	if defined(_DEBUG) || defined(RLSDBG)

#		ifndef AG_OUTPUT_DEBUGSTRING_ONLY_DEBUG
#			define AG_OUTPUT_DEBUGSTRING_ONLY_DEBUG(op) OutputDebugString((LPCTSTR)op)
#		endif	/*	ndef AG_OUTPUT_DEBUGSTRING_ONLY_DEBUG	*/
#		ifndef AG_OUTPUT_DEBUGSTRING_ONLY_DEBUG_WCE
#			ifdef WINCE_OUTPUT_DEBUG_STRING
#				ifdef AG_PF_WINCE
#					define AG_OUTPUT_DEBUGSTRING_ONLY_DEBUG_WCE(op) OutputDebugString((LPCTSTR)op)
#				else	/*	ifdef AG_PF_WINCE	*/
#					define AG_OUTPUT_DEBUGSTRING_ONLY_DEBUG_WCE(op) (op)
#				endif	/*	def else AG_PF_WINCE	*/
#			else	/*	ifdef WINCE_OUTPUT_DEBUG_STRING	*/
#				define AG_OUTPUT_DEBUGSTRING_ONLY_DEBUG_WCE(op)
#			endif	/*	def else ifdef WINCE_OUTPUT_DEBUG_STRING	*/
#		endif	/*	ndef AG_OUTPUT_DEBUGSTRING_ONLY_DEBUG_WCE	*/

#	else	/*	if defined(_DEBUG) || defined(RLSDBG)	*/

#		ifndef AG_OUTPUT_DEBUGSTRING_ONLY_DEBUG
#			define AG_OUTPUT_DEBUGSTRING_ONLY_DEBUG(op)
#		endif	/*	ndef AG_OUTPUT_DEBUGSTRING_ONLY_DEBUG	*/
#		ifndef AG_OUTPUT_DEBUGSTRING_ONLY_DEBUG_WCE
#			define AG_OUTPUT_DEBUGSTRING_ONLY_DEBUG_WCE(op)
#		endif	/*	ndef AG_OUTPUT_DEBUGSTRING_ONLY_DEBUG	*/

#	endif	/*	else defined(_DEBUG) || defined(RLSDBG)	*/

#	define AG_STDCALL	__stdcall
#	define AG_CDECL		__cdecl

#	ifndef AG_USES_MFC
#		ifndef AG_USES_NO_MFC
#			define AG_USES_NO_MFC
#		endif	/*	ndef AG_USES_NO_MFC	*/
#	endif	/*	ndef AG_USES_MFC	*/

#	ifdef AG_USES_MFC
#		ifdef _DEBUG
#			define _DEBUG_MFC
#		endif	/*	def _DEBUG	*/

#		include <afxwin.h>         /* MFC core and standard components	*/
#		include <afxext.h>         /* MFC extensions	*/
#		ifndef _AFX_NO_AFXCMN_SUPPORT
#			include <afxcmn.h>		/* MFC support for Windows Common Controls	*/
#		endif /* _AFX_NO_AFXCMN_SUPPORT	*/
#		include <afxdisp.h>        /* MFC OLE automation classes	*/
#		ifdef AG_PF_WIN32_NO_WCE
#			include <io.h>
#			include <afxSock.h>
#			include <sys/types.h>
#			include <sys/stat.h>
#			include <fcntl.h>
#		endif	/*	def AG_PF_WIN32_NO_WCE	*/

#	endif	/*	def AG_USES_MFC	*/


#	ifdef AG_USES_NO_MFC
#		pragma warning(disable: 4127)
#		pragma warning(disable: 4201)
#		pragma warning(disable: 4701)
#		pragma warning(disable: 4702)

#		include <stdlib.h>

#		ifdef AG_PF_WIN32
#			include <windows.h>
#			include <tchar.h>
#		endif /*AG_PF_WIN32	*/

#		ifndef AG_PF_WINCE
#			include <stdio.h>
#			include <limits.h>
#			include <fcntl.h>
#			include <io.h>
#			include <sys/types.h>
#			include <sys/stat.h>
#			include <string.h>
#		endif	/*	ndef AG_PF_WINCE	*/

#		ifdef AG_PF_WINCE
#			define LIMITED_WIN32
#			ifdef _UNICODE
#				ifndef _WIN32_WCE_EMULATION
#					if (AG_PF_WINCE < 200) /* WIN CE Ver lower than 2.00	*/
#						define _T(s) L#	#	s
#					endif /*	(AG_PF_WINCE < 200) WIN CE Ver lower than 2.00	*/
#				endif /* #	ifndef _WIN32_WCE_EMULATION	*/
#			endif	/*	def _UNICODE	*/
#		endif	/*	def AG_PF_WINCE	*/

#		ifndef DEBUG_NEW
#			define DEBUG_NEW new
#		endif	/*	ndef DEBUG_NEW	*/

#		ifdef _DEBUG
#			ifdef AG_PF_WINCE
#				ifndef ASSERT
#					define ASSERT(cond)
#				endif	/*	ndef ASSERT	*/
#				ifndef VERIFY
#					define VERIFY(cond)	cond
#				endif	/*	ndef VERIFY	*/
#			else	/*	def AG_PF_WINCE	*/
#				include <assert.h>
#				ifndef ASSERT
#					define ASSERT(cond)	assert(cond)
#				endif	/*	ndef ASSERT	*/
#				ifndef VERIFY
#					define VERIFY(cond)	assert(cond)
#				endif	/*	ndef VERIFY	*/
#			endif	/*	def else AG_PF_WINCE	*/

#		else	/*	def _DEBUG	*/

#			ifndef ASSERT
#				define ASSERT(cond)
#				define VERIFY(cond)	cond
#			endif	/*	ndef ASSERT	*/

#		endif	/*	def else _DEBUG	*/

#	endif	/*	AG_USES_NO_MFC	*/


/**************************************************************************
	Including the libraries to use AGCore Dynamicaly Linked Library
**************************************************************************/
/*	
	AGCore.20.dll					Win32										RELEASE
	AGCore.20.D.dll					Win32										DEBUG
	AGCore.20.U.dll					Win32			UNICODE						RELEASE
	AGCore.20.U.D.dll				Win32			UNICODE						DEBUG
	***
	AGCore.20.200.SH3.dll			WinCE 2.00		UNICODE		SH3				RELEASE
	AGCore.20.200.SH3.D.dll			WinCE 2.00		UNICODE		SH3				DEBUG
	AGCore.20.200.MIPS.dll			WinCE 2.00		UNICODE		MIPS			RELEASE
	AGCore.20.200.MIPS.D.dll		WinCE 2.00		UNICODE		MIPS			DEBUG
	AGCore.20.200.x86em.dll			WinCE 2.00		UNICODE		x86em			RELEASE
	AGCore.20.200.x86em.D.dll		WinCE 2.00		UNICODE		x86em			DEBUG
	***
	AGCore.20.201.SH3.dll			WinCE 2.01		UNICODE		SH3				RELEASE
	AGCore.20.201.SH3.D.dll			WinCE 2.01		UNICODE		SH3				DEBUG
	AGCore.20.201.MIPS.dll			WinCE 2.01		UNICODE		MIPS			RELEASE
	AGCore.20.201.MIPS.D.dll		WinCE 2.01		UNICODE		MIPS			DEBUG
	AGCore.20.201.x86em.dll			WinCE 2.01		UNICODE		x86em			RELEASE
	AGCore.20.201.x86em.D.dll		WinCE 2.01		UNICODE		x86em			DEBUG
	***
	AGCore.20.211.ARM.dll			WinCE 2.11		UNICODE		ARM				RELEASE
	AGCore.20.211.ARM.D.dll			WinCE 2.11		UNICODE		ARM				DEBUG
	AGCore.20.211.MIPS.dll			WinCE 2.11		UNICODE		MIPS			RELEASE
	AGCore.20.211.MIPS.D.dll		WinCE 2.11		UNICODE		MIPS			DEBUG
	AGCore.20.211.PPC.dll			WinCE 2.11		UNICODE		PPC				RELEASE
	AGCore.20.211.PPC.D.dll			WinCE 2.11		UNICODE		PPC				DEBUG
	AGCore.20.211.SH3.dll			WinCE 2.11		UNICODE		SH3				RELEASE
	AGCore.20.211.SH3.D.dll			WinCE 2.11		UNICODE		SH3				DEBUG
	AGCore.20.211.SH4.dll			WinCE 2.11		UNICODE		SH4				RELEASE
	AGCore.20.211.SH4.D.dll			WinCE 2.11		UNICODE		SH4				DEBUG
	AGCore.20.211.x86.dll			WinCE 2.11		UNICODE		x86				RELEASE
	AGCore.20.211.x86.D.dll			WinCE 2.11		UNICODE		x86				DEBUG
	AGCore.20.211.x86em.dll			WinCE 2.11		UNICODE		x86 emulation	RELEASE
	AGCore.20.211.x86em.D.dll		WinCE 2.11		UNICODE		x86 emulation	DEBUG
*/

#if defined(_DEBUG) && defined(_INTERNAL_DEBUG_AG)
#define AG_USES_AG_CORE_DLL_DEBUG
#endif	/* defined(_DEBUG) && defined(_INTERNAL_DEBUG_AG)	*/

#	ifdef AG_USES_AG_CORE_DLL

#		ifdef AG_PF_WIN32_NO_WCE
#			ifdef _UNICODE
#				ifdef AG_USES_AG_CORE_DLL_DEBUG
#					pragma comment(lib, "AGCore.20.U.D.lib")
#				else	/*	ifdef AG_USES_AG_CORE_DLL_DEBUG	*/
#					pragma comment(lib, "AGCore.20.U.lib")
#				endif	/*	def else AG_USES_AG_CORE_DLL_DEBUG	*/
#			else	/*	ifdef _UNICODE	*/
#				ifdef AG_USES_AG_CORE_DLL_DEBUG
#					pragma comment(lib, "AGCore.20.D.lib")
#				else	/*	ifdef AG_USES_AG_CORE_DLL_DEBUG	*/
#					pragma comment(lib, "AGCore.20.lib")
#				endif	/*	def else AG_USES_AG_CORE_DLL_DEBUG	*/
#			endif	/*	ifdef else _UNICODE	*/
#		endif	/*	def AG_PF_WIN32_NO_WCE	*/

#		ifdef AG_PF_WINCE_200
#			ifdef AG_USES_AG_CORE_DLL_DEBUG
#				if		defined(_WIN32_WCE_EMULATION)
#					pragma comment(lib, "AGCore.20.200.x86em.D.lib")
#				elif		defined(_SH3_)
#					pragma comment(lib, "AGCore.20.200.SH3.D.lib")
#				elif	defined(_MIPS_)
#					pragma comment(lib, "AGCore.20.200.MIPS.D.lib")
#				endif
#			else	/*	ifdef AG_USES_AG_CORE_DLL_DEBUG	*/
#				if		defined(_WIN32_WCE_EMULATION)
#					pragma comment(lib, "AGCore.20.200.x86em.lib")
#				elif		defined(_SH3_)
#					pragma comment(lib, "AGCore.20.200.SH3.lib")
#				elif	defined(_MIPS_)
#					pragma comment(lib, "AGCore.20.200.MIPS.lib")
#				endif
#			endif	/*	def else AG_USES_AG_CORE_DLL_DEBUG	*/
#		endif	/*	def AG_PF_WINCE_200	*/

#		ifdef AG_PF_WINCE_201
#			ifdef AG_USES_AG_CORE_DLL_DEBUG
#				if		defined(_SH3_)
#					pragma comment(lib, "AGCore.20.201.SH3.D.lib")
#				elif	defined(_MIPS_)
#					pragma comment(lib, "AGCore.20.201.MIPS.D.lib")
#				elif	defined(_WIN32_WCE_EMULATION)
#					pragma comment(lib, "AGCore.20.201.x86em.D.lib")
#				endif
#			else	/*	ifdef AG_USES_AG_CORE_DLL_DEBUG	*/
#				if		defined(_SH3_)
#					pragma comment(lib, "AGCore.20.201.SH3.lib")
#				elif	defined(_MIPS_)
#					pragma comment(lib, "AGCore.20.201.MIPS.lib")
#				elif	defined(_WIN32_WCE_EMULATION)
#					pragma comment(lib, "AGCore.20.201.x86em.lib")
#				endif
#			endif	/*	def else AG_USES_AG_CORE_DLL_DEBUG	*/
#		endif	/*	def AG_PF_WINCE_201	*/

#		ifdef AG_PF_WINCE_211
#			ifdef AG_USES_AG_CORE_DLL_DEBUG
#				if		defined(_WIN32_WCE_EMULATION)
#					pragma comment(lib, "AGCore.20.211.x86em.D.lib")
#				elif	defined(_ARM_)
#					pragma comment(lib, "AGCore.20.211.ARM.D.lib")
#				elif	defined(_MIPS_)
#					pragma comment(lib, "AGCore.20.211.MIPS.D.lib")
#				elif	defined(_PPC_)
#					pragma comment(lib, "AGCore.20.211.PPC.D.lib")
#				elif	defined(_SH3_)
#					pragma comment(lib, "AGCore.20.211.SH3.D.lib")
#				elif	defined(_SH4_)
#					pragma comment(lib, "AGCore.20.211.SH4.D.lib")
#				elif	defined(_x86_)
#					pragma comment(lib, "AGCore.20.211.x86.D.lib")
#				endif	/*	processors	*/
#			else	/*	ifdef AG_USES_AG_CORE_DLL_DEBUG	*/
#				if		defined(_WIN32_WCE_EMULATION)
#					pragma comment(lib, "AGCore.20.211.x86em.lib")
#				elif	defined(_ARM_)
#					pragma comment(lib, "AGCore.20.211.ARM.lib")
#				elif	defined(_MIPS_)
#					pragma comment(lib, "AGCore.20.211.MIPS.lib")
#				elif	defined(_PPC_)
#					pragma comment(lib, "AGCore.20.211.PPC.lib")
#				elif	defined(_SH3_)
#					pragma comment(lib, "AGCore.20.211.SH3.lib")
#				elif	defined(_SH4_)
#					pragma comment(lib, "AGCore.20.211.SH4.lib")
#				elif	defined(_x86_)
#					pragma comment(lib, "AGCore.20.211.x86.lib")
#				endif	/*	processors	*/
#			endif	/*	def else AG_USES_AG_CORE_DLL_DEBUG	*/
#		endif	/*	def AG_PF_WINCE_211	*/

#		ifdef AG_PF_WINCE_212
#			ifdef AG_USES_AG_CORE_DLL_DEBUG
#				if		defined(_WIN32_WCE_EMULATION)
#					pragma comment(lib, "AGCore.20.212.x86em.D.lib")
#				elif	defined(_ARM_)
#					pragma comment(lib, "AGCore.20.212.ARM.D.lib")
#				elif	defined(_MIPS_)
#					pragma comment(lib, "AGCore.20.212.MIPS.D.lib")
#				elif	defined(_PPC_)
#					pragma comment(lib, "AGCore.20.212.PPC.D.lib")
#				elif	defined(_SH3_)
#					pragma comment(lib, "AGCore.20.212.SH3.D.lib")
#				elif	defined(_SH4_)
#					pragma comment(lib, "AGCore.20.212.SH4.D.lib")
#				elif	defined(_x86_)
#					pragma comment(lib, "AGCore.20.212.x86.D.lib")
#				endif	/*	processors	*/
#			else	/*	ifdef AG_USES_AG_CORE_DLL_DEBUG	*/
#				if		defined(_WIN32_WCE_EMULATION)
#					pragma comment(lib, "AGCore.20.212.x86em.lib")
#				elif	defined(_ARM_)
#					pragma comment(lib, "AGCore.20.212.ARM.lib")
#				elif	defined(_MIPS_)
#					pragma comment(lib, "AGCore.20.212.MIPS.lib")
#				elif	defined(_PPC_)
#					pragma comment(lib, "AGCore.20.212.PPC.lib")
#				elif	defined(_SH3_)
#					pragma comment(lib, "AGCore.20.212.SH3.lib")
#				elif	defined(_SH4_)
#					pragma comment(lib, "AGCore.20.212.SH4.lib")
#				elif	defined(_x86_)
#					pragma comment(lib, "AGCore.20.212.x86.lib")
#				endif	/*	processors	*/
#			endif	/*	def else AG_USES_AG_CORE_DLL_DEBUG	*/
#		endif	/*	def AG_PF_WINCE_212	*/

#	endif	/*	ndef AG_USES_AG_CORE	*/


/**************************************************************************
	Including the libraries to use AGEndpoint Dynamicaly Linked Library
**************************************************************************/
/*
	AGEndpoint.20.dll					Win32										RELEASE
	AGEndpoint.20.D.dll					Win32										DEBUG
	AGEndpoint.20.U.dll					Win32			UNICODE						RELEASE
	AGEndpoint.20.U.D.dll				Win32			UNICODE						DEBUG
	***
	AGEndpoint.20.200.SH3.dll			WinCE 2.00		UNICODE		SH3				RELEASE
	AGEndpoint.20.200.SH3.D.dll			WinCE 2.00		UNICODE		SH3				DEBUG
	AGEndpoint.20.200.MIPS.dll			WinCE 2.00		UNICODE		MIPS			RELEASE
	AGEndpoint.20.200.MIPS.D.dll		WinCE 2.00		UNICODE		MIPS			DEBUG
	AGEndpoint.20.200.x86em.dll			WinCE 2.00		UNICODE		x86em			RELEASE
	AGEndpoint.20.200.x86em.D.dll		WinCE 2.00		UNICODE		x86em			DEBUG
	***
	AGEndpoint.20.201.SH3.dll			WinCE 2.01		UNICODE		SH3				RELEASE
	AGEndpoint.20.201.SH3.D.dll			WinCE 2.01		UNICODE		SH3				DEBUG
	AGEndpoint.20.201.MIPS.dll			WinCE 2.01		UNICODE		MIPS			RELEASE
	AGEndpoint.20.201.MIPS.D.dll		WinCE 2.01		UNICODE		MIPS			DEBUG
	AGEndpoint.20.201.x86em.dll			WinCE 2.01		UNICODE		x86em			RELEASE
	AGEndpoint.20.201.x86em.D.dll		WinCE 2.01		UNICODE		x86em			DEBUG
	***
	AGEndpoint.20.211.ARM.dll			WinCE 2.11		UNICODE		ARM				RELEASE
	AGEndpoint.20.211.ARM.D.dll			WinCE 2.11		UNICODE		ARM				DEBUG
	AGEndpoint.20.211.MIPS.dll			WinCE 2.11		UNICODE		MIPS			RELEASE
	AGEndpoint.20.211.MIPS.D.dll		WinCE 2.11		UNICODE		MIPS			DEBUG
	AGEndpoint.20.211.PPC.dll			WinCE 2.11		UNICODE		PPC				RELEASE
	AGEndpoint.20.211.PPC.D.dll			WinCE 2.11		UNICODE		PPC				DEBUG
	AGEndpoint.20.211.SH3.dll			WinCE 2.11		UNICODE		SH3				RELEASE
	AGEndpoint.20.211.SH3.D.dll			WinCE 2.11		UNICODE		SH3				DEBUG
	AGEndpoint.20.211.SH4.dll			WinCE 2.11		UNICODE		SH4				RELEASE
	AGEndpoint.20.211.SH4.D.dll			WinCE 2.11		UNICODE		SH4				DEBUG
	AGEndpoint.20.211.x86.dll			WinCE 2.11		UNICODE		x86				RELEASE
	AGEndpoint.20.211.x86.D.dll			WinCE 2.11		UNICODE		x86				DEBUG
	AGEndpoint.20.211.x86em.dll			WinCE 2.11		UNICODE		x86 emulation	RELEASE
	AGEndpoint.20.211.x86em.D.dll		WinCE 2.11		UNICODE		x86 emulation	DEBUG
*/

#if defined(_DEBUG) && defined(_INTERNAL_DEBUG_AG)
#define AG_USES_AG_ENDPOINT_DLL_DEBUG
#endif	/* defined(_DEBUG) && defined(_INTERNAL_DEBUG_AG)	*/

#	ifdef AG_USES_AG_ENDPOINT_DLL

#		ifdef AG_PF_WIN32_NO_WCE
#			ifdef _UNICODE
#				ifdef AG_USES_AG_ENDPOINT_DLL_DEBUG
#					pragma comment(lib, "AGEndpoint.20.U.D.lib")
#				else	/*	ifdef AG_USES_AG_ENDPOINT_DLL_DEBUG	*/
#					pragma comment(lib, "AGEndpoint.20.U.lib")
#				endif	/*	def else AG_USES_AG_ENDPOINT_DLL_DEBUG	*/
#			else	/*	ifdef _UNICODE	*/
#				ifdef AG_USES_AG_ENDPOINT_DLL_DEBUG
#					pragma comment(lib, "AGEndpoint.20.D.lib")
#				else	/*	ifdef AG_USES_AG_ENDPOINT_DLL_DEBUG	*/
#					pragma comment(lib, "AGEndpoint.20.lib")
#				endif	/*	def else AG_USES_AG_ENDPOINT_DLL_DEBUG	*/
#			endif	/*	ifdef else _UNICODE	*/
#		endif	/*	def AG_PF_WIN32_NO_WCE	*/

#		ifdef AG_PF_WINCE_200
#			ifdef AG_USES_AG_ENDPOINT_DLL_DEBUG
#				if		defined(_SH3_)
#					pragma comment(lib, "AGEndpoint.20.200.SH3.D.lib")
#				elif	defined(_MIPS_)
#					pragma comment(lib, "AGEndpoint.20.200.MIPS.D.lib")
#				elif	defined(_WIN32_WCE_EMULATION)
#					pragma comment(lib, "AGEndpoint.20.200.x86em.D.lib")
#				endif
#			else	/*	ifdef AG_USES_AG_ENDPOINT_DLL_DEBUG	*/
#				if		defined(_SH3_)
#					pragma comment(lib, "AGEndpoint.20.200.SH3.lib")
#				elif	defined(_MIPS_)
#					pragma comment(lib, "AGEndpoint.20.200.MIPS.lib")
#				elif	defined(_WIN32_WCE_EMULATION)
#					pragma comment(lib, "AGEndpoint.20.200.x86em.lib")
#				endif
#			endif	/*	def else AG_USES_AG_ENDPOINT_DLL_DEBUG	*/
#		endif	/*	def AG_PF_WINCE_200	*/

#		ifdef AG_PF_WINCE_201
#			ifdef AG_USES_AG_ENDPOINT_DLL_DEBUG
#				if		defined(_SH3_)
#					pragma comment(lib, "AGEndpoint.20.201.SH3.D.lib")
#				elif	defined(_MIPS_)
#					pragma comment(lib, "AGEndpoint.20.201.MIPS.D.lib")
#				elif	defined(_WIN32_WCE_EMULATION)
#					pragma comment(lib, "AGEndpoint.20.201.x86em.D.lib")
#				endif
#			else	/*	ifdef AG_USES_AG_ENDPOINT_DLL_DEBUG	*/
#				if		defined(_SH3_)
#					pragma comment(lib, "AGEndpoint.20.201.SH3.lib")
#				elif	defined(_MIPS_)
#					pragma comment(lib, "AGEndpoint.20.201.MIPS.lib")
#				elif	defined(_WIN32_WCE_EMULATION)
#					pragma comment(lib, "AGEndpoint.20.201.x86em.lib")
#				endif
#			endif	/*	def else AG_USES_AG_ENDPOINT_DLL_DEBUG	*/
#		endif	/*	def AG_PF_WINCE_201	*/

#		ifdef AG_PF_WINCE_211
#			ifdef AG_USES_AG_ENDPOINT_DLL_DEBUG
#				if		defined(_WIN32_WCE_EMULATION)
#					pragma comment(lib, "AGEndpoint.20.211.x86em.D.lib")
#				elif	defined(_ARM_)
#					pragma comment(lib, "AGEndpoint.20.211.ARM.D.lib")
#				elif	defined(_MIPS_)
#					pragma comment(lib, "AGEndpoint.20.211.MIPS.D.lib")
#				elif	defined(_PPC_)
#					pragma comment(lib, "AGEndpoint.20.211.PPC.D.lib")
#				elif	defined(_SH3_)
#					pragma comment(lib, "AGEndpoint.20.211.SH3.D.lib")
#				elif	defined(_SH4_)
#					pragma comment(lib, "AGEndpoint.20.211.SH4.D.lib")
#				elif	defined(_x86_)
#					pragma comment(lib, "AGEndpoint.20.211.x86.D.lib")
#				endif	/*	processors	*/
#			else	/*	ifdef AG_USES_AG_ENDPOINT_DLL_DEBUG	*/
#				if		defined(_WIN32_WCE_EMULATION)
#					pragma comment(lib, "AGEndpoint.20.211.x86em.lib")
#				elif	defined(_ARM_)
#					pragma comment(lib, "AGEndpoint.20.211.ARM.lib")
#				elif	defined(_MIPS_)
#					pragma comment(lib, "AGEndpoint.20.211.MIPS.lib")
#				elif	defined(_PPC_)
#					pragma comment(lib, "AGEndpoint.20.211.PPC.lib")
#				elif	defined(_SH3_)
#					pragma comment(lib, "AGEndpoint.20.211.SH3.lib")
#				elif	defined(_SH4_)
#					pragma comment(lib, "AGEndpoint.20.211.SH4.lib")
#				elif	defined(_x86_)
#					pragma comment(lib, "AGEndpoint.20.211.x86.lib")
#				endif	/*	processors	*/
#			endif	/*	def else AG_USES_AG_ENDPOINT_DLL_DEBUG	*/
#		endif	/*	def AG_PF_WINCE_211	*/

#		ifdef AG_PF_WINCE_212
#			ifdef AG_USES_AG_ENDPOINT_DLL_DEBUG
#				if		defined(_WIN32_WCE_EMULATION)
#					pragma comment(lib, "AGEndpoint.20.212.x86em.D.lib")
#				elif	defined(_ARM_)
#					pragma comment(lib, "AGEndpoint.20.212.ARM.D.lib")
#				elif	defined(_MIPS_)
#					pragma comment(lib, "AGEndpoint.20.212.MIPS.D.lib")
#				elif	defined(_PPC_)
#					pragma comment(lib, "AGEndpoint.20.212.PPC.D.lib")
#				elif	defined(_SH3_)
#					pragma comment(lib, "AGEndpoint.20.212.SH3.D.lib")
#				elif	defined(_SH4_)
#					pragma comment(lib, "AGEndpoint.20.212.SH4.D.lib")
#				elif	defined(_x86_)
#					pragma comment(lib, "AGEndpoint.20.212.x86.D.lib")
#				endif	/*	processors	*/
#			else	/*	ifdef AG_USES_AG_ENDPOINT_DLL_DEBUG	*/
#				if		defined(_WIN32_WCE_EMULATION)
#					pragma comment(lib, "AGEndpoint.20.212.x86em.lib")
#				elif	defined(_ARM_)
#					pragma comment(lib, "AGEndpoint.20.212.ARM.lib")
#				elif	defined(_MIPS_)
#					pragma comment(lib, "AGEndpoint.20.212.MIPS.lib")
#				elif	defined(_PPC_)
#					pragma comment(lib, "AGEndpoint.20.212.PPC.lib")
#				elif	defined(_SH3_)
#					pragma comment(lib, "AGEndpoint.20.212.SH3.lib")
#				elif	defined(_SH4_)
#					pragma comment(lib, "AGEndpoint.20.212.SH4.lib")
#				elif	defined(_x86_)
#					pragma comment(lib, "AGEndpoint.20.212.x86.lib")
#				endif	/*	processors	*/
#			endif	/*	def else AG_USES_AG_ENDPOINT_DLL_DEBUG	*/
#		endif	/*	def AG_PF_WINCE_212	*/

#	endif	/*	ndef AG_USES_AG_ENDPOINT	*/



/*	**	Win 32 (95, 98, NT and CE)	*/
/***************************************************************************/
#elif	defined(AG_PF_EPOC)
/*	**	EPOC32 (i.e. Psion Series 5)	*/

#define AG_DONT_USE_STATIC_VARIABLES

#ifdef _DEBUG

#	ifndef AG_OUTPUT_DEBUGSTRING_ONLY_DEBUG
#		define AG_OUTPUT_DEBUGSTRING_ONLY_DEBUG(op)	(op)
#	endif	/*	ndef AG_OUTPUT_DEBUGSTRING_ONLY_DEBUG	*/

#	ifndef AG_OUTPUT_DEBUGSTRING_ONLY_DEBUG_WCE
#		define AG_OUTPUT_DEBUGSTRING_ONLY_DEBUG_WCE(op) (op)
#	endif	/*ndef AG_OUTPUT_DEBUGSTRING_ONLY_DEBUG_WCE	*/

#else	/*	ifdef _DEBUG	*/

#	ifndef AG_OUTPUT_DEBUGSTRING_ONLY_DEBUG
#		define AG_OUTPUT_DEBUGSTRING_ONLY_DEBUG(op)
#	endif	/*	ndef AG_OUTPUT_DEBUGSTRING_ONLY_DEBUG	*/

#	ifndef AG_OUTPUT_DEBUGSTRING_ONLY_DEBUG_WCE
#		define AG_OUTPUT_DEBUGSTRING_ONLY_DEBUG_WCE(op)
#	endif	/*ndef AG_OUTPUT_DEBUGSTRING_ONLY_DEBUG_WCE	*/

#endif	/*	def _DEBUG	*/

#define AG_STDCALL
#define AG_CDECL

#define AG_USE_EXCEPTION
#define AG_DO_NOT_USE_CPP_EXCEPTION

#ifndef AG_USES_NO_MFC
	#define AG_USES_NO_MFC
#endif	/*	ndef AG_USES_NO_MFC	*/

#ifdef _UNICODE
#	define _T(s) L##s
#else	/*	ifdef _UNICODE	*/
#	define _T(s) s
#endif	/*	def else _UNICODE	*/

#ifndef max
#define max(a,b)            (((a) > (b)) ? (a) : (b))
#endif

#ifndef min
#define min(a,b)            (((a) < (b)) ? (a) : (b))
#endif

#define INT_MAX       2147483647    /* maximum (signed) int value	*/
#include "e32std.h"

#define PASCAL

#define TRUE				1
#define FALSE				0
#define _UPPER          0x1     /* upper case letter	*/
#define _LOWER          0x2     /* lower case letter	*/
#define _DIGIT          0x4     /* digit[0-9]	*/
#define _SPACE          0x8     /* tab, carriage return, newline,	*/
                                /* vertical tab or form feed	*/
#define _PUNCT          0x10    /* punctuation character	*/
#define _CONTROL        0x20    /* control character	*/
#define _BLANK          0x40    /* space char	*/
#define _HEX            0x80    /* hexadecimal digit	*/

#define _LEADBYTE       0x8000                  /* multibyte leadbyte	*/
#define _ALPHA          (0x0100|_UPPER|_LOWER)  /* alphabetic character	*/

#ifndef NULL
#ifdef  __cplusplus
#define NULL    0
#else
#define NULL    ((void *)0)
#endif
#endif

#define VERIFY(cond)	cond
#ifndef ASSERT
#define ASSERT(cond)
#endif	/*	ndef ASSERT	*/

#define SYSTEMTIME			struct tm
#define _tcscpy				strcpy
#define _tcsclen			strlen
#define	_tcsinc				_strinc
#define	_tcsstr				strstr
#define _istlead(ch)		ch
#define _istspace			isspace
#define isspace(_c)			_pctype((LPTSTR)_c)
#define _strinc(_pc)		((_pc)+1)

#define	_tcsupr(lpsz)	{\
char *cp;\
for (cp=lpsz; *cp; ++cp)\
{\
	if ('a' <= *cp && *cp <= 'z')\
		*cp += 'A' - 'a';\
}\
}
#define _tcslwr(lpsz)	{\
char *cp;\
for (cp=lpsz; *cp; ++cp)\
{\
	if ('A' <= *cp && *cp <= 'Z')\
		*cp += 'a' - 'A';\
}\
}

typedef unsigned char                   BYTE;
typedef unsigned short                  WORD;
typedef unsigned long                   DWORD;
typedef unsigned int                    UINT;
typedef int                             BOOL;

#ifndef __CHAR_DEFINED__
typedef char                            CHAR;
#endif

#ifdef UNICODE
typedef WCHAR                           TCHAR;
#else
typedef char                            TCHAR;
#endif

typedef unsigned short                  WCHAR;
typedef WCHAR *							LPWSTR;
typedef const WCHAR *				    LPCWSTR;
typedef CHAR *							LPSTR;
typedef const CHAR *				    LPCSTR;
typedef TCHAR *					        LPTSTR;
typedef const TCHAR *		            LPCTSTR;
typedef DWORD                           LCID;
typedef const void *					LPCVOID;

unsigned short _pctype(LPTSTR lpsz);

#pragma warning(disable: 4127)
#pragma warning(disable: 4201)
#pragma warning(disable: 4701)
#pragma warning(disable: 4702)

#include <stdlib.h>
#include <stdarg.h>
#include <errno.h>
#include <stdio.h>
#include <limits.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <string.h>
#include <unistd.h>

#ifndef DEBUG_NEW
#	define DEBUG_NEW new
#endif	/*	ndef DEBUG_NEW	*/

#ifdef _DEBUG
#	ifndef ASSERT
#		define ASSERT(cond)	assert(cond)
#	endif	/*	ndef ASSERT	*/
#	ifndef VERIFY
#		define VERIFY(cond)	assert(cond)
#	endif	/*	ndef VERIFY	*/

#else	/*	def _DEBUG	*/

#	ifndef ASSERT
#		define ASSERT(cond)
#	endif	/*	ndef ASSERT	*/
#	ifndef VERIFY
#		define VERIFY(cond)	cond
#	endif	/*	ndef VERIFY	*/
#endif	/*	def else _DEBUG	*/
/*	**	EPOC32 (i.e. Psion Series 5)	*/
/***************************************************************************/


#elif	defined(AG_PF_UNIX)
/*	**	UNIX	*/

#if	(defined(AG_PF_SUN_OS) && !defined(AG_PF_SUN_OS_X86)) || defined(AG_PF_HP_UX)
#	define	AG_BIG_LITTLE_ENDIAN_CONVERSION
#endif	/*	def AG_PF_SUN_OS	*/

#if	!defined(AG_PF_GNU_WIN32) && !defined(AG_PF_DIGITAL_UNIX) && !defined(AG_PF_HP_UX) && !defined(AG_PF_QNX) && !defined(AG_PF_VXWORKS) && !defined(AG_PF_LYNX) && !defined(AG_PF_OS9)
#	define AG_USE_PTHREAD
#endif

#define AG_USE_REGISTRY

#ifdef _DEBUG

#	ifndef AG_OUTPUT_DEBUGSTRING_ONLY_DEBUG
#		define AG_OUTPUT_DEBUGSTRING_ONLY_DEBUG(op)	printf(_T("%s"),(LPCTSTR)op)
#	endif	/*	ndef AG_OUTPUT_DEBUGSTRING_ONLY_DEBUG	*/

#else	/*	ifdef _DEBUG	*/

#	ifndef AG_OUTPUT_DEBUGSTRING_ONLY_DEBUG
#		define AG_OUTPUT_DEBUGSTRING_ONLY_DEBUG(op)
#	endif	/*	ndef AG_OUTPUT_DEBUGSTRING_ONLY_DEBUG	*/

#endif	/*	def _DEBUG	*/

#define AG_STDCALL
#define AG_CDECL

#if	!defined(AG_PF_VXWORKS)	&& !defined(AG_PF_OS9)
#	define AG_USE_EXCEPTION
#	define AG_USE_CPP_EXCEPTION
#else
#	define AG_DO_NOT_USE_EXCEPTION
#	define AG_DO_NOT_USE_CPP_EXCEPTION
#endif	/*	!defined(AG_PF_VXWORKS)	*/

#ifndef AG_USES_NO_MFC
#	define AG_USES_NO_MFC
#endif	/*	ndef AG_USES_NO_MFC	*/

#if	defined(AG_USE_PTHREAD)
#	define	_REENTRANT
#	include <pthread.h>
#	include <wchar.h>
#elif	defined(AG_PF_HP_UX) || defined(AG_PF_DIGITAL_UNIX) || defined(AG_PF_GNU_WIN32)
#	include <wchar.h>
#else
#endif

#include <stdarg.h>
#include <stdio.h>
#include <time.h>
#include <errno.h>
#include <stdlib.h>
#include <limits.h>

#ifdef AG_PF_OS9
#include <types.h>
#include <unix/stat.h>
#include <modes.h>
#include <unix/os9def.h>
#include <sg_codes.h>
#include <rbf.h>
#else
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <dirent.h>
#endif	/*	def AG_PF_OS9	*/

#include <string.h>
#include <ctype.h>
#include <math.h>

#ifdef AG_PF_VXWORKS
#include <usrLib.h>
#endif	/* def AG_PF_VXWORKS	*/

#if	!defined(AG_PF_VXWORKS)
extern int errno;
#endif	/*	!defined(AG_PF_VXWORKS)	*/

#define TRUE			1
#define FALSE			0
#define PASCAL
#define FAR

#define BOOL			int
#define UINT			unsigned int
#define BYTE			unsigned char
#define SYSTEMTIME		struct tm
#define DWORD			unsigned long
#define WORD			unsigned short

/* ANSI string	*/
#define LPCSTR			const char*
#define LPSTR			char*
#define CHAR			char

#ifdef AG_PF_QNX
/* Unicode string	*/
#	define LPCWSTR			const unsigned short*
#	define LPWSTR			unsigned short*
#	define WCHAR			unsigned short
#else
#	define LPCWSTR			const wchar_t*
#	define LPWSTR			wchar_t*
#	define WCHAR			wchar_t
#endif

#ifdef _UNICODE

#define _T(s) 			L##s
#define LPCTSTR			LPCWSTR
#define LPTSTR			LPWSTR
#define TCHAR			WCHAR

#else

#define _T(s) 			s
#define LPCTSTR			LPCSTR
#define LPTSTR			LPSTR
#define TCHAR			CHAR

#endif /* def _UNICODE	*/

#ifndef DEBUG_NEW
#	define DEBUG_NEW new
#endif	/*	ndef DEBUG_NEW	*/

#ifdef _DEBUG
#	include <assert.h>
#	ifndef ASSERT
#		define ASSERT(cond)	assert(cond)
#	endif	/*	ndef ASSERT	*/
#	ifndef VERIFY
#		define VERIFY(cond)	assert(cond)
#	endif	/*	ndef VERIFY	*/

#else	/*	def _DEBUG	*/

#	ifndef ASSERT
#		define ASSERT(cond)
#	endif	/*	ndef ASSERT	*/
#	ifndef VERIFY
#		define VERIFY(cond)	cond
#	endif	/*	ndef VERIFY	*/
#endif	/*	def else _DEBUG	*/


/*	**	UNIX	*/
/***************************************************************************/
#elif	defined(AG_PF_OS_400)
/*	**	AS/400	*/

#define	AG_BIG_LITTLE_ENDIAN_CONVERSION
#define	AG_ASCII_EBCDIC_CONVERSION
#define AG_USE_PTHREAD
#define AG_USE_REGISTRY

#ifdef _DEBUG

#	ifndef AG_OUTPUT_DEBUGSTRING_ONLY_DEBUG
#		define AG_OUTPUT_DEBUGSTRING_ONLY_DEBUG(op)	printf(_T("%s"),(LPCTSTR)op)
#	endif	/*	ndef AG_OUTPUT_DEBUGSTRING_ONLY_DEBUG	*/

#else	/*	ifdef _DEBUG	*/

#	ifndef AG_OUTPUT_DEBUGSTRING_ONLY_DEBUG
#		define AG_OUTPUT_DEBUGSTRING_ONLY_DEBUG(op)
#	endif	/*	ndef AG_OUTPUT_DEBUGSTRING_ONLY_DEBUG	*/

#endif	/*	def _DEBUG	*/

#define AG_STDCALL
#define AG_CDECL

#define AG_USE_EXCEPTION
#define AG_USE_CPP_EXCEPTION

#ifndef AG_USES_NO_MFC
#	define AG_USES_NO_MFC
#endif	/*	ndef AG_USES_NO_MFC	*/

#define _MULTI_THREADED
#ifndef AG_DONT_INCLUDE_PTHREAD
/* AS/400 Kernel Thread */
#include <pthread.h>
#endif	/* ndef AG_DONT_INCLUDE_PTHREAD */

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <time.h>
#include <fcntl.h>
#include <string.h>
#include <wchar.h>
#include <errno.h>

extern int errno;

#define TRUE			1
#define FALSE			0
#define PASCAL
#define FAR

#define BOOL			int
#define UINT			unsigned int
#define BYTE			unsigned char
#define SYSTEMTIME		struct tm
#define DWORD			unsigned long
#define WORD			unsigned short

/* ANSI string	*/
#define LPCSTR			const char*
#define LPSTR			char*
#define CHAR			char

/* Unicode string	*/
#define LPCWSTR			const wchar_t*
#define LPWSTR			wchar_t*
#define WCHAR			wchar_t

#ifdef _UNICODE

#define _T(s) 			L##s
#define LPCTSTR			LPCWSTR
#define LPTSTR			LPWSTR
#define TCHAR			WCHAR

#else

#define _T(s) 			s
#define LPCTSTR			LPCSTR
#define LPTSTR			LPSTR
#define TCHAR			CHAR

#endif /* def _UNICODE	*/

#ifndef DEBUG_NEW
#	define DEBUG_NEW new
#endif	/*	ndef DEBUG_NEW	*/

#ifdef _DEBUG
#	include <assert.h>
#	ifndef ASSERT
#		define ASSERT(cond)	assert(cond)
#	endif	/*	ndef ASSERT	*/
#	ifndef VERIFY
#		define VERIFY(cond)	assert(cond)
#	endif	/*	ndef VERIFY	*/

#else	/*	def _DEBUG	*/

#	ifndef ASSERT
#		define ASSERT(cond)
#	endif	/*	ndef ASSERT	*/
#	ifndef VERIFY
#		define VERIFY(cond)	cond
#	endif	/*	ndef VERIFY	*/
#endif	/*	def else _DEBUG	*/

#elif defined(AG_PF_PALMOS)

#define	AG_BIG_LITTLE_ENDIAN_CONVERSION

#include "NewFloatMgr.h"
#include "FileStream.h"

void DumpData(const char * pDataString);

#ifdef _DEBUG

#	ifndef AG_OUTPUT_DEBUGSTRING_ONLY_DEBUG
#		define AG_OUTPUT_DEBUGSTRING_ONLY_DEBUG(op)	DumpData(op)
#	endif	/*	ndef AG_OUTPUT_DEBUGSTRING_ONLY_DEBUG	*/

#	ifndef AG_OUTPUT_DEBUGSTRING_ONLY_DEBUG_WCE
#		define AG_OUTPUT_DEBUGSTRING_ONLY_DEBUG_WCE(op) DumpData(op)
#	endif	/*ndef AG_OUTPUT_DEBUGSTRING_ONLY_DEBUG_WCE	*/

#else	/*	ifdef _DEBUG	*/

#	ifndef AG_OUTPUT_DEBUGSTRING_ONLY_DEBUG
#		define AG_OUTPUT_DEBUGSTRING_ONLY_DEBUG(op) 
#	endif	/*	ndef AG_OUTPUT_DEBUGSTRING_ONLY_DEBUG	*/

#	ifndef AG_OUTPUT_DEBUGSTRING_ONLY_DEBUG_WCE
#		define AG_OUTPUT_DEBUGSTRING_ONLY_DEBUG_WCE(op)
#	endif	/*ndef AG_OUTPUT_DEBUGSTRING_ONLY_DEBUG_WCE	*/

#endif	/*	def _DEBUG	*/

#define AG_DO_NOT_USE_EXCEPTION

#ifdef _DEBUG
#	include <assert.h>
#	ifndef ASSERT
#		define ASSERT(cond)	assert(cond)
#	endif	/*	ndef ASSERT	*/
#	ifndef VERIFY
#		define VERIFY(cond)	assert(cond)
#	endif	/*	ndef VERIFY	*/

#else	/*	def _DEBUG	*/

#	ifndef ASSERT
#		define ASSERT(cond)
#	endif	/*	ndef ASSERT	*/
#	ifndef VERIFY
#		define VERIFY(cond)	cond
#	endif	/*	ndef VERIFY	*/
#endif	/*	def else _DEBUG	*/

#define AG_STDCALL
#define AG_CDECL

#define SYSTEMTIME			DateTimeType

#define TRUE			1
#define FALSE			0
#define PASCAL
#define FAR

typedef unsigned char                   BYTE;
typedef unsigned short                  WORD;
typedef unsigned short					DWORD;
typedef unsigned int                    UINT;
typedef int                             BOOL;

#define CHAR							Char
#define WCHAR							UShort

#define LPSTR							CharPtr
typedef const CHAR *				    LPCSTR;
#define LPWSTR							UShortPtr
typedef const WCHAR *				    LPCWSTR;

typedef DWORD                           LCID;
typedef const void *					LPCVOID;

#ifdef _UNICODE

#define _T(s) 			L##s
#define LPCTSTR			LPCWSTR
#define LPTSTR			LPWSTR
#define TCHAR			WCHAR

#else

#define _T(s) 			s
#define LPCTSTR			LPCSTR
#define LPTSTR			LPSTR
#define TCHAR			CHAR

#endif /* def _UNICODE	*/

#ifndef AG_USES_NO_MFC
	#define AG_USES_NO_MFC
#endif	/*	ndef AG_USES_NO_MFC	*/

/*	**	PALM OS	*/
/***************************************************************************/
#else
/*	Unknown platform	*/
#error no platform

#endif	/*	all platforms	*/

#ifdef AG_USES_AG_CORE_HEADER
#include <AGCore.h>
#endif	/*	def AG_USES_AG_CORE_HEADER	*/

#ifdef AG_USES_AG_ENDPOINT_HEADER
#include <AGEndpoint.h>
#endif	/*	def AG_USES_AG_ENDPOINT_HEADER	*/


#endif	/*	ndef _STANDARD_PORT_H_	*/
