// LdapDlg.cpp : implementation file
//

#include "stdafx.h"
#include "Ldap.h"
#include "LdapDlg.h"

#include <NSDirectory.h>

#include <ldap.h>
#include <ldap_ssl.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CLdapDlg dialog

CLdapDlg::CLdapDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CLdapDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CLdapDlg)
	m_sDump				= _T("");
	m_iPort				= 389;
	m_sAddr				= _T("172.17.1.203");
//	m_sLogin			= _T("scorbay@netsize.com");
//	m_sPassword			= _T("orange05");
	m_sBaseDN			= _T("o=Demo");
	m_sFirstName		= _T("");
	m_sLastName			= _T("g");
	m_sLog				= _T("");
	m_sFirstNameAttribute = _T("");
	m_sLastNameAttribute = _T("sn");
	m_sDisplay1 = _T("sn");
	m_sDisplay2 = _T("");
	m_sDisplay3 = _T("");
	//}}AFX_DATA_INIT
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CLdapDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CLdapDlg)
	DDX_Text(pDX, IDC_PORT_EDIT, m_iPort);
	DDX_Text(pDX, IDC_ADDR_EDIT, m_sAddr);
	DDX_Text(pDX, IDC_LOGIN_EDIT, m_sLogin);
	DDX_Text(pDX, IDC_PASSWORD_EDIT, m_sPassword);
	DDX_Text(pDX, IDC_BASEDN_EDIT, m_sBaseDN);
	DDX_Text(pDX, IDC_FIRSTNAME_EDIT, m_sFirstName);
	DDX_Text(pDX, IDC_LASTNAME_EDIT, m_sLastName);
	DDX_Text(pDX, IDC_LOG_EDIT, m_sLog);
	DDX_Text(pDX, IDC_OUT_EDIT, m_sDump);
	DDX_Text(pDX, IDC_FIRSTNAMEATTRIBUTE_EDIT, m_sFirstNameAttribute);
	DDX_Text(pDX, IDC_LASTNAMEATTRIBUTE_EDIT, m_sLastNameAttribute);
	DDX_Text(pDX, IDC_DISPLAY1_EDIT, m_sDisplay1);
	DDX_Text(pDX, IDC_DISPLAY2_EDIT, m_sDisplay2);
	DDX_Text(pDX, IDC_DISPLAY3_EDIT, m_sDisplay3);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CLdapDlg, CDialog)
	//{{AFX_MSG_MAP(CLdapDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_GET_BUTTON, OnGetButton)
	ON_BN_CLICKED(IDC_QUIT_BUTTON, OnQuitButton)
	ON_BN_CLICKED(IDOK, OnOk)
//	ON_BN_CLICKED(IDC_BUTTON1, OnButton1)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CLdapDlg message handlers

BOOL CLdapDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CLdapDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

HCURSOR CLdapDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

//**************************
void CLdapDlg::OnGetButton() 
{
	CAGFrame		oInMessageFrame;
	CAGFrame		oOutMessageFrame;
	CAGArray		oRetrieveAttibuteArray;
	CNSDirectory	oNSDirectory;
	CString			sSearchFilter;

	UpdateData(TRUE);
	m_sDump.Empty();
	m_sLog.Empty();

	if((!m_sFirstName.IsEmpty()) && (!m_sLastName.IsEmpty()))
	{
		sSearchFilter.Format(	"(& (%s=%s*) (%s=%s*))",
								m_sFirstNameAttribute,
								m_sFirstName,
								m_sLastNameAttribute,
								m_sLastName);
	}
	else
	{
		if(!m_sLastName.IsEmpty())
		{
			sSearchFilter.Format(	"(%s=%s*)",
									m_sLastNameAttribute,
									m_sLastName);
		}
		else
		{
			sSearchFilter.Format(	"(%s=%s*)",
									m_sFirstNameAttribute,
									m_sFirstName);
		}
	}

	m_sLog += "Filtre de recherche: ";
	m_sLog += sSearchFilter;
	m_sLog += _T(".\r\n");

	if(!m_sDisplay1.IsEmpty())
		oRetrieveAttibuteArray.AddArraySlot(m_sDisplay1);
	if(!m_sDisplay2.IsEmpty())
		oRetrieveAttibuteArray.AddArraySlot(m_sDisplay2);
	if(!m_sDisplay3.IsEmpty())
		oRetrieveAttibuteArray.AddArraySlot(m_sDisplay3);

	oInMessageFrame[NSDIRECTORY_LOGIN_SERVER_ADDRESS]		=	m_sAddr;
	oInMessageFrame[NSDIRECTORY_LOGIN_SERVER_PORT]			=	m_iPort;
	oInMessageFrame[NSDIRECTORY_LOGIN_LOGIN]				=	m_sLogin;
	oInMessageFrame[NSDIRECTORY_LOGIN_PASSWORD]				=	m_sPassword;

	if ( oNSDirectory.DoConnect(	oInMessageFrame,
									oOutMessageFrame) != agSuccess)
	{
		AfxMessageBox("Erreur de connexion au serveur LDAP.");
		AfxMessageBox((LPCTSTR)oOutMessageFrame.Dump());
		return;
	}

	oInMessageFrame.Reset();
	oOutMessageFrame.Reset();

	oInMessageFrame[NSDIRECTORY_SEARCH_BASE_DN]				=	m_sBaseDN;	
	oInMessageFrame[NSDIRECTORY_SEARCH_FILTER]				=	sSearchFilter;
	oInMessageFrame[NSDIRECTORY_SEARCH_RETRIEVE_ARRAY]		=	oRetrieveAttibuteArray;
//	oInMessageFrame[NSDIRECTORY_SEARCH_SIZE]				=	5L;

	if ( oNSDirectory.DoSearch(	oInMessageFrame,
								oOutMessageFrame) != agSuccess)
	{
		AfxMessageBox("Erreur de recherche.");
		AfxMessageBox((LPCTSTR)oOutMessageFrame.Dump());
		return;
	}

	CAGArray	oResultArray;
	oOutMessageFrame.IsArray(NSDIRECTORY_SEARCH_RESULTS,	&oResultArray);

	for(long nResultArrayPos=0;
		nResultArrayPos < oResultArray.Length();
		nResultArrayPos++)
	{
		CAGFrame	oResultFrame;

		oResultArray.IsFrame(CAGPath(nResultArrayPos),	&oResultFrame);

		m_sDump += _T("*********************************\r\n");
		m_sDump += (LPCTSTR)oResultFrame.Dump();
		m_sDump += _T("\r\n");
	}

/*
if( (m_sAttributeCN.IsEmpty())&&(m_sAttributeDept.IsEmpty())&&(m_sAttributeTel.IsEmpty()) )
{
	m_sDump += A;
	m_sDump += " : ";
	m_sDump += vals[i];
	m_sDump += "\r\n";
}
*/
	//oMessageArray.AddArraySlot(sOneMessage);
	UpdateData(FALSE);
}

//**************************
void CLdapDlg::OnQuitButton() 
{
	EndDialog(0);
}

//**********************************************
void CLdapDlg::OnOk() 
{
	UpdateData(TRUE);

	OnGetButton();
}
/*
//**********************************************
void CLdapDlg::OnButton1() 
{
	CAGFrame	oSendFrame, oGetFrame;
	
	oSendFrame[_T("SMSOrigin")]		= _T("+33612847971");
	oSendFrame[_T("SMSMessage")]	= _T("g");

	CAGFrame		oParams;
	CAGFrame		oParamFrame;
	CAGCppEndpoint	oEndpoint;
	AGReturnCode	agRet;

	oParamFrame[AG_BROKER_ADDRESS_PARAM]		= _T("127.0.0.1");
	oParamFrame[AG_BROKER_PORT_PARAM]			= _T("23789");
	oParamFrame[AG_ENDPOINT_NAME_PARAM]			= _T("Seb");
	oParamFrame[AG_TIMEOUT_PARAM]				= 5000L;
	oParamFrame[AG_PEER_NAME_PARAM]				= _T("SMSLDAPDemoExt^Netsize");
	oParamFrame[AG_COMMUNICATION_MODE_PARAM]	= (long)ag_cmSync;
	oParamFrame[AG_CHANNEL_TYPE_PARAM]			= (long)ag_ctTCPIPSocket;


	if ((agRet = oEndpoint.Open(oParamFrame)) != agSuccess)
	{
		return;
	}

	if ((agRet = oEndpoint.Send(oSendFrame, oParams)) != agSuccess)
	{
		return;
	}

	while ((agRet = oEndpoint.Get(oGetFrame, oParams)) == agTimeout){}
	if (agRet != agSuccess)
	{
		return;
	}
	else
	{
	}

}
*/