//	Copyright 1996-2000 Netsize SA. All Rights reserved.
//	e-mail	:	agsupport@netsize.com
//				aginfo@netsize.com
//	web		:	http://www.netsize.com/
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "version.h"
#include "NSDirectory.h"
#include "NSDirectoryDefines.h"
#include "NSDirectoryReturnCode.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//***********************************************
CNSDirectory::CNSDirectory()
	:	m_ld(						NULL)
		,m_sRetrieveAttributes(		NULL)
		,m_oAddAttributesList(		NULL)
		,m_sAddAttributesValues(	NULL)
		,m_oModifyAttributesList(	NULL)
		,m_sModifyAttributesValues(	NULL)
{		
}

//***********************************************
/*virtual*/CNSDirectory::~CNSDirectory()
{
	Disconnect();

	DestroyRetrieveAttributeTab();
	DestroyAddAttributeList();
	DestroyModifyAttributeList();
}

//***********************************************
AGReturnCode CNSDirectory::DoConnect(	CAGFrame	oInMessageFrame,
										CAGFrame &	oOutMessageFrame)
{
	CAGString	sPort;
	long		iPort;
	CAGString	sAddress;
	CAGString	sLogin;
	CAGString	sPassword;
	
	if (	
			(oInMessageFrame.IsString(NSDIRECTORY_LOGIN_SERVER_ADDRESS,	&sAddress)	!= agNSD_Success)
		||
			(oInMessageFrame.IsString(NSDIRECTORY_LOGIN_LOGIN,			&sLogin)	!= agNSD_Success)
		||
			(oInMessageFrame.IsString(NSDIRECTORY_LOGIN_PASSWORD,		&sPassword)	!= agNSD_Success)
		)
	{
		AGFormatReturnCode(	oOutMessageFrame,
							agNSD_AbortRequest,
							_T("One or more parameter are missing."),
							_T(""));
		return agNSD_AbortRequest;
	}

	Disconnect();

	if(oInMessageFrame.IsString(NSDIRECTORY_LOGIN_SERVER_PORT,		&sPort) == agNSD_Success)
	{
		return Bind(	(LPCTSTR)sAddress,
						(LPCTSTR)sPort,
						(LPCTSTR)sLogin,
						(LPCTSTR)sPassword);
	}
	else if(oInMessageFrame.IsLong(NSDIRECTORY_LOGIN_SERVER_PORT,	&iPort) == agNSD_Success)
	{
		return Bind(	(LPCTSTR)sAddress,
						iPort,
						(LPCTSTR)sLogin,
						(LPCTSTR)sPassword);
	}
	else
	{
		return Bind(	(LPCTSTR)sAddress,
						389L,
						(LPCTSTR)sLogin,
						(LPCTSTR)sPassword);
	}

	// on ne sera jamais la...
	return agNSD_Error;
}

//***********************************************
AGReturnCode CNSDirectory::DoDisconnect()
{
	Disconnect();

	DestroyRetrieveAttributeTab();
	DestroyAddAttributeList();
	DestroyModifyAttributeList();

	return agSuccess;
}

//***********************************************
AGReturnCode CNSDirectory::DoSearch(	CAGFrame	oInMessageFrame,
										CAGFrame &	oOutMessageFrame)
{
	AGReturnCode	agRet;
	CAGFrame		oFilterFrame;
	CAGArray		oReturnArray;
	CAGString		sBaseDN;
	CAGString		sScope;
	int				iScope = LDAP_SCOPE_ONELEVEL;
	long			iSearchTimeout;
	long			iSearchSize = -1;

	if(m_ld == NULL)
	{
		AGFormatReturnCode(	oOutMessageFrame,
							agNSD_NotConnectedToLDAPServer,
							_T("No valid LDAP connection."),
							_T("You must do a login request before querying."));
		return agNSD_NotConnectedToLDAPServer;
	}

	DestroyRetrieveAttributeTab();
	m_sFilter.Empty();

	oInMessageFrame.IsString(	NSDIRECTORY_SEARCH_BASE_DN,		&sBaseDN);

	if(oInMessageFrame.IsString(NSDIRECTORY_SEARCH_FILTER,		&m_sFilter)	== agNSD_Success)
	{
	}
	else
	{
		AGFormatReturnCode(	oOutMessageFrame,
							agNSD_AbortRequest,
							_T("Search filter missing."),
							_T(""));
		return agNSD_AbortRequest;
	}

	oInMessageFrame.IsArray(NSDIRECTORY_SEARCH_RETRIEVE_ARRAY,		&m_oRetrieveAttibuteArray);

	if((agRet=CreateRetrieveAttributeTab()) != agNSD_Success)
	{
		// TODO ERROR
		return agRet;
	}
	
	// OPTIONNAL
	if(oInMessageFrame.IsString(NSDIRECTORY_SEARCH_SCOPE,	&sScope)	== agNSD_Success)
	{
		if(sScope == NSDIRECTORY_SEARCH_SCOPE_BASE)
		{
			iScope = LDAP_SCOPE_BASE;
		}
		else if(sScope == NSDIRECTORY_SEARCH_SCOPE_SUBTREE)
		{
			iScope = LDAP_SCOPE_SUBTREE;
		}
	}
	
	if(oInMessageFrame.IsLong(		NSDIRECTORY_SEARCH_TIMEOUT,		&iSearchTimeout)	== agNSD_Success)
	{
		if (ldap_set_option( m_ld, LDAP_OPT_TIMELIMIT, &iSearchTimeout) != LDAP_SUCCESS)
		{
			//Inform(NSDIRECTORY_WARNING_PREFIX, "Cannot set search time limit option.");
		}
	}
	
	if(oInMessageFrame.IsLong(		NSDIRECTORY_SEARCH_SIZE,		&iSearchSize)		== agNSD_Success)
	{
		// il ne faut peut-tre pas positionner cela pour la connexion; les prochaine requetes utilisant
		// la mme connexion veulent peut-tre avoir la valeur par defaut si non positionn.
/*		if (ldap_set_option( m_ld, LDAP_OPT_SIZELIMIT, &iSearchSize) != LDAP_SUCCESS)
		{
			Inform(NSDIRECTORY_WARNING_PREFIX, "Cannot set search size limit option." );
		}*/
	}

	return Search(	sBaseDN,
					iScope,
					iSearchSize,
					oInMessageFrame,
					oOutMessageFrame);
}

//***********************************************
AGReturnCode CNSDirectory::DoAdd(	CAGFrame	oInMessageFrame,
									CAGFrame &	oOutMessageFrame)
{
	AGReturnCode	agRet;
	CAGString		sBaseDN;

	if(m_ld == NULL)
	{
		AGFormatReturnCode(	oOutMessageFrame,
							agNSD_NotConnectedToLDAPServer,
							_T("No valid LDAP connection."),
							_T("You must do a login request before querying."));
		return agNSD_NotConnectedToLDAPServer;
	}

	oInMessageFrame.IsString(	NSDIRECTORY_ADD_DN,					&sBaseDN);

	oInMessageFrame.IsFrame(	NSDIRECTORY_ADD_ATTRIBUTES_FRAME,	&m_oAddAttibuteFrame);

	if((agRet=CreateAddAttributeList()) != agNSD_Success)
	{
		// TODO ERROR
		return agRet;
	}
	
	return Add(	sBaseDN,
				oInMessageFrame,
				oOutMessageFrame);
}

//***********************************************
AGReturnCode CNSDirectory::DoModify(	CAGFrame	oInMessageFrame,
										CAGFrame &	oOutMessageFrame)
{
	AGReturnCode	agRet;
	CAGString		sBaseDN;

	if(m_ld == NULL)
	{
		AGFormatReturnCode(	oOutMessageFrame,
							agNSD_NotConnectedToLDAPServer,
							_T("No valid LDAP connection."),
							_T("You must do a login request before querying."));
		return agNSD_NotConnectedToLDAPServer;
	}

	oInMessageFrame.IsString(	NSDIRECTORY_MODIFY_DN,					&sBaseDN);

	oInMessageFrame.IsFrame(	NSDIRECTORY_MODIFY_ATTRIBUTES_FRAME,	&m_oModifyAttibuteFrame);

	if((agRet=CreateModifyAttributeList()) != agNSD_Success)
	{
		// TODO ERROR
		return agRet;
	}
	
	return Modify(	sBaseDN,
					oInMessageFrame,
					oOutMessageFrame);
}

//***********************************************
AGReturnCode CNSDirectory::DoDelete(	CAGFrame	oInMessageFrame,
										CAGFrame &	oOutMessageFrame)
{
	CAGString		sBaseDN;

	if(m_ld == NULL)
	{
		AGFormatReturnCode(	oOutMessageFrame,
							agNSD_NotConnectedToLDAPServer,
							_T("No valid LDAP connection."),
							_T("You must do a login request before querying."));
		return agNSD_NotConnectedToLDAPServer;
	}

	oInMessageFrame.IsString(	NSDIRECTORY_DELETE_DN,				&sBaseDN);

	return Delete(	sBaseDN,
					oInMessageFrame,
					oOutMessageFrame);
}

//***********************************************
AGReturnCode CNSDirectory::DoStoredRequest(	CAGFrame	oInMessageFrame,
											CAGFrame &	oOutMessageFrame)
{
	AGFormatReturnCode(	oOutMessageFrame,
						agNSD_Error,
						_T("Not yet implemented."),
						_T(""));

	return agNSD_Success;
}

//*************************************************************
//*************************************************************
AGReturnCode CNSDirectory::Search(	CAGString		sSEARCH_BASEDN,
									long			iScope,
									long			iSizeLimit,
									CAGFrame		oInMessageFrame,
									CAGFrame&		oOutMessageFrame)
{
	int				rc			= -1;		// Return code.
	int				parse_rc	= -1;		// Parse return code.
	int				nMessageID	= 0;
	LDAPMessage *	result		= NULL;
	LDAPMessage *	e			= NULL;
	char *			matched_msg	= NULL;
	char *			error_msg	= NULL;
	char *			dn			= NULL;

	CAGString		sOneAttribute;

	CAGString		sAttr;
	CAGString		sWord;
	CAGString		sWildcard;
	CAGString		sRetrieveAttibuteFormat;
	CAGString		sAttributeValue;

	
	if (ldap_search_ext(	m_ld,
							(LPCTSTR)sSEARCH_BASEDN,
							iScope,
							(LPCTSTR)m_sFilter,
							m_sRetrieveAttributes,
							0,
							NULL,
							NULL,
							NULL,
							3,
							&nMessageID) != LDAP_SUCCESS)
	{
		ldap_get_lderrno(m_ld, &matched_msg, &error_msg);

		if (error_msg != NULL && *error_msg != '\0')
		{
			AGFormatReturnCode(	oOutMessageFrame,
								agNSD_LDAPSearchError,
								_T("Error searching."),
								error_msg);
		}
		if (matched_msg != NULL && *matched_msg != '\0')
		{
			AGFormatReturnCode(	oOutMessageFrame,
								agNSD_LDAPSearchError,
								_T("Error searching. Part of the DN that matches an existing entry."),
								matched_msg);
		}

		return agNSD_LDAPSearchError;
	}
	else
	{
		BerElement*		ber;
		LDAPControl**	serverctrls;
		struct timeval	zerotime;
		char**			vals;
		char**			referrals;
		char*			a;
		char*			dn;
		char*			matched_msg = NULL;
		char*			error_msg = NULL;
		int				i;
		int				finished = 0;
		long			nResultPos = -1;
		int				num_refs = 0;
		
		zerotime.tv_sec = zerotime.tv_usec = 0L;

		while ( !finished )
		{
			rc = ldap_result( m_ld, nMessageID, LDAP_MSG_ONE, &zerotime, &result );

			switch(rc)
			{
				case -1:
					// An error occurred
					rc = ldap_get_lderrno( m_ld, NULL, NULL );

					AGFormatReturnCode(	oOutMessageFrame,
										agNSD_LDAPSearchError,
										_T("Error searching."),
										ldap_err2string(rc));

					return agNSD_LDAPSearchError;

				case 0:

					//	The timeout period specified by zerotime was exceeded.
					//	This means that the server has still not yet sent the 
					//	results of the search operation back to your client.
					//	Break out of this switch statement, and continue calling  
					//	ldap_result() to poll for results.

					break;

				case LDAP_RES_SEARCH_ENTRY:
					{

					//	The server sent one of the entries found by the search 
					//	operation. Print the DN, attributes, and values of the entry.
					//	Keep track of the number of entries found.

					nResultPos++;
					oOutMessageFrame[CAGPath(NSDIRECTORY_SEARCH_RESULTS) + nResultPos] = CAGFrame();
					CAGFrame	oOneResultFrame(oOutMessageFrame[CAGPath(NSDIRECTORY_SEARCH_RESULTS) + nResultPos]);


					// Get and print the DN of the entry.
					if(( dn = ldap_get_dn( m_ld, result )) != NULL )
					{
						ldap_memfree( dn );
					}

					// Iterate through each attribute in the entry.
					for	(	a = ldap_first_attribute( m_ld, result, &ber );
							a != NULL;
							a = ldap_next_attribute( m_ld, result, ber ) )
					{
						// Get and print all values for each attribute.

						sAttr = a;
						sAttr.MakeLower();

						if (( vals = ldap_get_values( m_ld, result, (LPCTSTR)sAttr )) != NULL )
						{
							for(i = 0;
								vals[i] != NULL;
								i++ )
							{
								if(oInMessageFrame.IsTrue(SMSLDAPEXT_WANT_RETRIEVE_MULTI_VALUES) == agNSD_Success)
								{
									CAGArray	oMultiValuesArray;

									oOneResultFrame.IsArray((LPCTSTR)sAttr, &oMultiValuesArray);
									oMultiValuesArray.AddArraySlot(vals[i]);
									oOneResultFrame[sAttr] = oMultiValuesArray;
								}
								else
								{
									oOneResultFrame[sAttr] = vals[i];
								}
							}
							
							ldap_value_free( vals );
						}

						ldap_memfree( a );
					}

					if(ber != NULL)
					{
						ber_free( ber, 0 );
					}

					ldap_msgfree( result );

					break;
					}

				case LDAP_RES_SEARCH_REFERENCE:

					//	The server sent a search reference encountered during the 
					//	search operation.
					//	Keep track of the number of search references returned from
					//	the server.

					num_refs++;

					//	Parse the result and print the search references. 
					//	Ideally, rather than print them out, you would follow the
					//	references.

					parse_rc = ldap_parse_reference( m_ld, result, &referrals, NULL, 1 );

					if(parse_rc != LDAP_SUCCESS)
					{
						fprintf( stderr, "ldap_parse_result: %s\n", ldap_err2string( parse_rc ) );

						AGFormatReturnCode(	oOutMessageFrame,
											agNSD_InternalError,
											_T("Internal Error. Parse reference error."),
											ldap_err2string( parse_rc ));

						return agNSD_InternalError;
					}

					if(referrals != NULL)
					{
						for(i = 0;
							referrals[ i ] != NULL;
							i++)
						{
							#ifdef _DEBUG
							//afxDump << "Search reference: " << referrals[ i ] << "\r\n\r\n";
							#endif	//def _DEBUG
						}

						ldap_value_free( referrals );
					}
					
					break;

				case LDAP_RES_SEARCH_RESULT:

					//	Parse the final result received from the server. Note the last
					//	argument is a non-zero value, which indicates that the 
					//	LDAPMessage structure will be freed when done.  (No need
					//	to call ldap_msgfree().)

					finished = 1;

					parse_rc = ldap_parse_result(	m_ld,
													result,
													&rc,
													&matched_msg,
													&error_msg,
													NULL,
													&serverctrls,
													1);

					if(parse_rc != LDAP_SUCCESS)
					{
						fprintf( stderr, "ldap_parse_result: %s\n", ldap_err2string( parse_rc ) );
						//Inform("ldap_parse_result: %s\n", (LPCTSTR)ldap_err2string( parse_rc ) );

						AGFormatReturnCode(	oOutMessageFrame,
											agNSD_InternalError,
											_T("Internal Error. Parse result error."),
											ldap_err2string( parse_rc ));

						return agNSD_InternalError;
					}

					// Check the results of the LDAP search operation.
					if(rc != LDAP_SUCCESS)
					{
						fprintf( stderr, "ldap_search_ext: %s\n", ldap_err2string( rc ) );
						//Inform("ldap_search_ext: %s\n", (LPCTSTR)ldap_err2string( rc ) );
			
						ldap_get_lderrno( m_ld, &matched_msg, &error_msg );

						if(error_msg != NULL && *error_msg != '\0')
						{
							AGFormatReturnCode(	oOutMessageFrame,
												agNSD_InternalError,
												_T("Internal Error. Parse result error."),
												ldap_err2string( parse_rc ));

							return agNSD_InternalError;
						}

						if(	(matched_msg != NULL)
							&&
							(*matched_msg != '\0'))
						{
						   fprintf( stderr, "Part of the DN that matches an existing entry: %s\n", matched_msg );
						}

					}

					break;
				default:
					break;
			}

			// Do other work here while waiting for the search operation to complete.
			if(!finished)
			{
				//TODO
			}
		}
	}

	AGFormatReturnCode(	oOutMessageFrame,
						agNSD_Success,
						_T("Success"),
						_T(""));

	return agNSD_Success;
}

//***********************************************
AGReturnCode CNSDirectory::Add(	CAGString		sADD_BASEDN,
								CAGFrame		oInMessageFrame,
								CAGFrame&		oOutMessageFrame)
{
	int			rc;
	char *		error_msg = NULL;
	char *		matched_msg = NULL;

	// Add the new entry
	if ( ( rc = ldap_add_ext_s(	m_ld,
								(LPCTSTR)sADD_BASEDN,
								m_oAddAttributesList,
								NULL,
								NULL)) != LDAP_SUCCESS )
	{
		ldap_get_lderrno(m_ld, &matched_msg, &error_msg);

		if (error_msg != NULL && *error_msg != '\0')
		{
			AGFormatReturnCode(	oOutMessageFrame,
								agNSD_LDAPAddError,
								_T("Error deleting."),
								error_msg);

			return agNSD_LDAPAddError;
		}

		AGFormatReturnCode(	oOutMessageFrame,
							agNSD_LDAPAddError,
							_T("Error adding."),
							_T(""));

		return agNSD_LDAPAddError;
	}

	AGFormatReturnCode(	oOutMessageFrame,
						agNSD_Success,
						_T("Success"),
						_T(""));

	return agNSD_Success;
}

//***********************************************
AGReturnCode CNSDirectory::Delete(	CAGString		sDELETE_BASEDN,
									CAGFrame		oInMessageFrame,
									CAGFrame&		oOutMessageFrame)
{
	int			rc;
	char *		error_msg = NULL;
	char *		matched_msg = NULL;

	// Deleting an entry
	if ( ( rc = ldap_delete_ext_s(	m_ld,
									(LPCTSTR)sDELETE_BASEDN,
									NULL,
									NULL)) != LDAP_SUCCESS )
	{
		ldap_get_lderrno(m_ld, &matched_msg, &error_msg);

		if (error_msg != NULL && *error_msg != '\0')
		{
			AGFormatReturnCode(	oOutMessageFrame,
								agNSD_LDAPDeleteError,
								_T("Error deleting."),
								error_msg);

			return agNSD_LDAPDeleteError;
		}

		AGFormatReturnCode(	oOutMessageFrame,
							agNSD_LDAPDeleteError,
							_T("Error deleting."),
							_T(""));

		return agNSD_LDAPDeleteError;
	}

	AGFormatReturnCode(	oOutMessageFrame,
						agNSD_Success,
						_T("Success"),
						_T(""));

	return agNSD_Success;
}

//***********************************************
AGReturnCode CNSDirectory::Modify(	CAGString		sADD_BASEDN,
									CAGFrame		oInMessageFrame,
									CAGFrame&		oOutMessageFrame)
{
	int			rc;
	char *		error_msg = NULL;
	char *		matched_msg = NULL;

	// Modify an existing entry
	if ( ( rc = ldap_modify_ext_s(	m_ld,
									(LPCTSTR)sADD_BASEDN,
									m_oAddAttributesList,
									NULL,
									NULL)) != LDAP_SUCCESS )
	{
		ldap_get_lderrno(m_ld, &matched_msg, &error_msg);

		if (error_msg != NULL && *error_msg != '\0')
		{
			AGFormatReturnCode(	oOutMessageFrame,
								agNSD_LDAPModifyError,
								_T("Error modifying."),
								error_msg);

			return agNSD_LDAPModifyError;
		}

		AGFormatReturnCode(	oOutMessageFrame,
							agNSD_LDAPModifyError,
							_T("Error modifying."),
							_T(""));

		return agNSD_LDAPModifyError;
	}

	AGFormatReturnCode(	oOutMessageFrame,
						agNSD_Success,
						_T("Success"),
						_T(""));

	return agNSD_Success;
}

//***********************************************
AGReturnCode CNSDirectory::Bind(	LPCTSTR		sIP,
									LPCTSTR		sPort,
									LPCTSTR		sLogin,
									LPCTSTR		sPassword)
{
	long iTmpPort;

	iTmpPort = atoi(sPort);

	return Bind(	sIP,
					iTmpPort,
					sLogin,
					sPassword);
}

//***********************************************
AGReturnCode CNSDirectory::Bind(	LPCTSTR		sIP,
									long		iPort,
									LPCTSTR		sLogin,
									LPCTSTR		sPassword)
{
	m_ld = ldap_init(	sIP,
						iPort);

	if ( m_ld != NULL)
	{
		long nErr = -1;

		if ( (nErr = ldap_simple_bind_s(	m_ld,
											sLogin,
											sPassword)) != LDAP_SUCCESS )
		{
			return agNSD_LDAPBindError;
		}
	}
	else
	{
		return agNSD_Error;
	}

	return agNSD_Success;
}

//***********************************************
AGReturnCode CNSDirectory::Disconnect()
{
	if(m_ld)
	{
		ldap_unbind(m_ld);
		m_ld = NULL;
	}

	return agNSD_Success;
}

//***********************************************
AGReturnCode CNSDirectory::CreateRetrieveAttributeTab()
{
	DestroyRetrieveAttributeTab();

	m_sRetrieveAttributes = (char**)new char*[m_oRetrieveAttibuteArray.Length()+1];

	if(m_sRetrieveAttributes == NULL)
	{
		return agNSD_LDAPMemoryError;
	}

	long nPos;

	for(nPos=0;
		nPos < m_oRetrieveAttibuteArray.Length();
		nPos++)
	{
		CAGString	sAttr(m_oRetrieveAttibuteArray[nPos]);
		long		nStrLength = sAttr.GetLength();

		sAttr.MakeLower();

		m_sRetrieveAttributes[nPos] = (char*)new char[nStrLength+1];

		strcpy(	m_sRetrieveAttributes[nPos],
				(LPCTSTR)sAttr);
	}
	m_sRetrieveAttributes[nPos] = NULL;

	return agNSD_Success;
}

//***********************************************
void CNSDirectory::DestroyRetrieveAttributeTab()
{
	if(m_sRetrieveAttributes)
	{
		for(long nPos=0;
			m_sRetrieveAttributes[nPos];
			nPos++)
		{
			delete m_sRetrieveAttributes[nPos];
		}
		
		delete [] m_sRetrieveAttributes;
		m_sRetrieveAttributes = NULL;
	}
}

//***********************************************
AGReturnCode CNSDirectory::CreateAddAttributeList()
{
	DestroyAddAttributeList();

//	OutputDebugString(m_oAddAttibuteFrame.Dump());

	m_oAddAttributesList = (LDAPMod**)new LDAPMod*[m_oAddAttibuteFrame.Length()+1];

	if(m_oAddAttributesList == NULL)
	{
		return agNSD_LDAPMemoryError;
	}

	m_sAddAttributesValues = (char***)new char**[m_oAddAttibuteFrame.Length()+1];

	m_oAddAttibuteFrame.MakeSlotArray(m_oAddAttributeSlotNameArray);

	long nPos;
	for(nPos=0;
		nPos < m_oAddAttributeSlotNameArray.Length();
		nPos++)
	{
		CAGString	sAttr(m_oAddAttributeSlotNameArray[nPos]);

		m_oAddAttributesList[nPos] = (LDAPMod*)new LDAPMod;

		m_sAddAttributesValues[nPos] = (char**) new char*[2];

		m_sAddAttributesValues[nPos][0] = (LPTSTR)(LPCTSTR)(CAGString)m_oAddAttibuteFrame[sAttr];
		m_sAddAttributesValues[nPos][1] = NULL;

		m_oAddAttributesList[nPos]->mod_op		= LDAP_MOD_ADD;
		m_oAddAttributesList[nPos]->mod_type	= (LPTSTR)(LPCTSTR)sAttr;
		m_oAddAttributesList[nPos]->mod_values	= m_sAddAttributesValues[nPos];
	}
	m_oAddAttributesList[nPos] = NULL;
	m_sAddAttributesValues[nPos] = NULL;

	return agNSD_Success;
}

//***********************************************
void CNSDirectory::DestroyAddAttributeList()
{
	m_oAddAttributeSlotNameArray.Reset();

	if(m_oAddAttributesList)
	{
		for(long nPos=0;
			m_oAddAttributesList[nPos];
			nPos++)
		{
			delete m_oAddAttributesList[nPos];
		}
		
		delete [] m_oAddAttributesList;
		m_oAddAttributesList = NULL;
	}

	if(m_sAddAttributesValues)
	{
		for(long nPos=0;
			m_sAddAttributesValues[nPos];
			nPos++)
		{
			delete m_sAddAttributesValues[nPos];
		}
		
		delete [] m_sAddAttributesValues;
		m_sAddAttributesValues = NULL;
	}
}

//***********************************************
AGReturnCode CNSDirectory::CreateModifyAttributeList()
{
	DestroyModifyAttributeList();

//	OutputDebugString(m_oModifyAttibuteFrame.Dump());

	long		nNbAttribute=0;
	CAGFrame	oAddFrame;
	CAGFrame	oDelFrame;
	CAGFrame	oModFrame;
	if(m_oModifyAttibuteFrame.IsFrame(NSDIRECTORY_MODIFY_ADD_ATTRIBUTES_FRAME,		&oAddFrame) == agSuccess)
	{
		nNbAttribute += oAddFrame.Length();
	}
	if(m_oModifyAttibuteFrame.IsFrame(NSDIRECTORY_MODIFY_DELETE_ATTRIBUTES_FRAME,	&oDelFrame) == agSuccess)
	{
		nNbAttribute += oDelFrame.Length();
	}
	if(m_oModifyAttibuteFrame.IsFrame(NSDIRECTORY_MODIFY_MODIFY_ATTRIBUTES_FRAME,	&oModFrame) == agSuccess)
	{
		nNbAttribute += oModFrame.Length();
	}

	m_oModifyAttributesList = (LDAPMod**)new LDAPMod*[nNbAttribute+1];

	if(m_oModifyAttributesList == NULL)
	{
		return agNSD_LDAPMemoryError;
	}

	m_sModifyAttributesValues = (char***)new char**[nNbAttribute+1];

	long nPos;
	if(oAddFrame.Length() > 0)
	{	
		oAddFrame.MakeSlotArray(m_oModifyAddAttributeSlotNameArray);
		for(nPos=0;
			nPos < m_oModifyAddAttributeSlotNameArray.Length();
			nPos++)
		{
			CAGString	sAttr(m_oModifyAddAttributeSlotNameArray[nPos]);

			m_oModifyAttributesList[nPos] = (LDAPMod*)new LDAPMod;

			m_sModifyAttributesValues[nPos] = (char**) new char*[2];

			m_sModifyAttributesValues[nPos][0] = (LPTSTR)(LPCTSTR)(CAGString)oAddFrame[sAttr];
			m_sModifyAttributesValues[nPos][1] = NULL;

			m_oModifyAttributesList[nPos]->mod_op		= LDAP_MOD_ADD;
			m_oModifyAttributesList[nPos]->mod_type		= (LPTSTR)(LPCTSTR)sAttr;
			m_oModifyAttributesList[nPos]->mod_values	= m_sModifyAttributesValues[nPos];
		}
	}
	if(oDelFrame.Length() > 0)
	{	
		oDelFrame.MakeSlotArray(m_oModifyDelAttributeSlotNameArray);
		for(nPos;
			nPos < m_oModifyDelAttributeSlotNameArray.Length();
			nPos++)
		{
			CAGString	sAttr(m_oModifyDelAttributeSlotNameArray[nPos]);

			m_oModifyAttributesList[nPos] = (LDAPMod*)new LDAPMod;

			m_sModifyAttributesValues[nPos] = (char**) new char*[2];

			m_sModifyAttributesValues[nPos][0] = (LPTSTR)(LPCTSTR)(CAGString)oDelFrame[sAttr];
			m_sModifyAttributesValues[nPos][1] = NULL;

			m_oModifyAttributesList[nPos]->mod_op		= LDAP_MOD_DELETE;
			m_oModifyAttributesList[nPos]->mod_type		= (LPTSTR)(LPCTSTR)sAttr;
			m_oModifyAttributesList[nPos]->mod_values	= m_sModifyAttributesValues[nPos];
		}
	}
	if(oModFrame.Length() > 0)
	{	
		oModFrame.MakeSlotArray(m_oModifyModAttributeSlotNameArray);
		for(nPos;
			nPos < m_oModifyModAttributeSlotNameArray.Length();
			nPos++)
		{
			CAGString	sAttr(m_oModifyModAttributeSlotNameArray[nPos]);

			m_oModifyAttributesList[nPos] = (LDAPMod*)new LDAPMod;

			m_sModifyAttributesValues[nPos] = (char**) new char*[2];

			m_sModifyAttributesValues[nPos][0] = (LPTSTR)(LPCTSTR)(CAGString)oModFrame[sAttr];
			m_sModifyAttributesValues[nPos][1] = NULL;

			m_oModifyAttributesList[nPos]->mod_op		= LDAP_MOD_REPLACE;
			m_oModifyAttributesList[nPos]->mod_type		= (LPTSTR)(LPCTSTR)sAttr;
			m_oModifyAttributesList[nPos]->mod_values	= m_sModifyAttributesValues[nPos];
		}
	}
	m_oModifyAttributesList[nPos]	= NULL;
	m_sModifyAttributesValues[nPos]	= NULL;

	return agNSD_Success;
}

//***********************************************
void CNSDirectory::DestroyModifyAttributeList()
{
	m_oModifyAddAttributeSlotNameArray.Reset();
	m_oModifyDelAttributeSlotNameArray.Reset();
	m_oModifyModAttributeSlotNameArray.Reset();

	if(m_oModifyAttributesList)
	{
		for(long nPos=0;
			m_oModifyAttributesList[nPos];
			nPos++)
		{
			delete m_oModifyAttributesList[nPos];
		}
		
		delete [] m_oModifyAttributesList;
		m_oModifyAttributesList = NULL;
	}

	if(m_sModifyAttributesValues)
	{
		for(long nPos=0;
			m_sModifyAttributesValues[nPos];
			nPos++)
		{
			delete m_sModifyAttributesValues[nPos];
		}
		
		delete [] m_sModifyAttributesValues;
		m_sModifyAttributesValues = NULL;
	}
}
