//	Copyright 1996-2000 Netsize SA. All Rights reserved.
//	e-mail	:	agsupport@netsize.com
//				aginfo@netsize.com
//	web		:	http://www.netsize.com/
//
//	NSDirectory.h: interface for the CNSDirectory class.
//
//////////////////////////////////////////////////////////////////////

//	#include <NSDirectory.h>

#ifndef	_NSDIRECTORY_H_
#define _NSDIRECTORY_H_

#include <NSDirectoryDefines.h>

#include <ldap.h>
#include <ldap_ssl.h>

////////////////////////////////////////////////////
class CNSDirectory : public CAGObject
{
public:
	CNSDirectory();
	virtual ~CNSDirectory();

	AGReturnCode			DoConnect(		CAGFrame	oInMessage,
											CAGFrame &	oOutMessage);
	AGReturnCode			DoDisconnect();
	AGReturnCode			DoSearch(		CAGFrame	oInMessage,
											CAGFrame &	oOutMessage);
	AGReturnCode			DoAdd(			CAGFrame	oInMessage,
											CAGFrame &	oOutMessage);
	AGReturnCode			DoModify(		CAGFrame	oInMessage,
											CAGFrame &	oOutMessage);
	AGReturnCode			DoDelete(		CAGFrame	oInMessage,
											CAGFrame &	oOutMessage);
	AGReturnCode			DoStoredRequest(CAGFrame	oInMessage,
											CAGFrame &	oOutMessage);

private:
	AGReturnCode	Search(	CAGString		sSEARCH_BASEDN,
							long			iScope,
							long			iSizeLimit,
							CAGFrame		oInMessageFrame,
							CAGFrame&		oOutMessageFrame);

	AGReturnCode	Add(	CAGString		sADD_BASEDN,
							CAGFrame		oInMessageFrame,
							CAGFrame&		oOutMessageFrame);

	AGReturnCode	Delete(	CAGString		sDELETE_BASEDN,
							CAGFrame		oInMessageFrame,
							CAGFrame&		oOutMessageFrame);

	AGReturnCode	Modify(	CAGString		sDELETE_BASEDN,
							CAGFrame		oInMessageFrame,
							CAGFrame&		oOutMessageFrame);

	AGReturnCode	Bind(	LPCTSTR		sIP,
							LPCTSTR		sPort,
							LPCTSTR		sLogin,
							LPCTSTR		sPassword);
	AGReturnCode	Bind(	LPCTSTR		sIP,
							long		iPort,
							LPCTSTR		sLogin,
							LPCTSTR		sPassword);

	AGReturnCode	Disconnect();

	AGReturnCode	CreateRetrieveAttributeTab();
	void			DestroyRetrieveAttributeTab();

	AGReturnCode	CreateAddAttributeList();
	void			DestroyAddAttributeList();

	AGReturnCode	CreateModifyAttributeList();
	void			DestroyModifyAttributeList();

private:
	// LDAP connection handle  *****************************
	LDAP *					m_ld;

	// SEARCH  *********************************************
	char **					m_sRetrieveAttributes;
	CAGArray				m_oRetrieveAttibuteArray;
	CAGString				m_sFilter;

	// ADD *************************************************
	char ***				m_sAddAttributesValues;
	LDAPMod**				m_oAddAttributesList;
	CAGArray				m_oAddAttributeSlotNameArray;
	CAGFrame				m_oAddAttibuteFrame;

	// MODIFY **********************************************
	char ***				m_sModifyAttributesValues;
	LDAPMod**				m_oModifyAttributesList;
	CAGArray				m_oModifyAddAttributeSlotNameArray;
	CAGArray				m_oModifyDelAttributeSlotNameArray;
	CAGArray				m_oModifyModAttributeSlotNameArray;
	CAGFrame				m_oModifyAttibuteFrame;
};

#endif	//	ndef	_NSDIRECTORY_H_
