#if !defined(LDAP_SSL_H)
#define LDAP_SSL_H

/* ldap_ssl.h - prototypes for LDAP over SSL functions */

#ifdef __cplusplus
extern "C" {
#endif

/*
 * Initialize the secure parts (Security and SSL) of the runtime for use
 * by a client application.  This is only called once.
 */
int LDAP_CALL ldapssl_client_init(const char *certdbpath, 
		void *certdbhandle );

/*
 * Initialize LDAP library for SSL
 */
LDAP * LDAP_CALL ldapssl_init( const char *defhost, int defport,
	int defsecure );

/*
 * Install I/O routines to make SSL over LDAP possible.
 * Use this after ldap_init() or just use ldapssl_init() instead.
 */
int LDAP_CALL ldapssl_install_routines( LDAP *ld );


/*
 * Initialize the secure parts (Security and SSL) of the runtime for use
 * by a client application that may want to do SSL client authentication.
 * This or ldapssl_client_init() should only be called once.
 */
int LDAP_CALL ldapssl_clientauth_init( char *certdbpath, void *certdbhandle,
	int needkeydb, char *keydbpath, void *keydbhandle );


/*
 * Enable SSL client authentication on the given ld.
 * XXXmcs: this API is temporary and is likely to change considerably before
 * 3.0 ships.
 */
int LDAP_CALL ldapssl_enable_clientauth( LDAP *ld, char *keynickname,
	char *keypasswd, char *certnickname );

#ifdef __cplusplus
}
#endif
#endif /* !defined(LDAP_SSL_H) */
