/*
  Exemple SMS de programme en C

  Livre "Construire un annuaire d'entreprise avec LDAP"
  Auteur : Marcel Rizcallah
*/

#include "stdafx.h"
#include "version.h"

#include "SMSLDAPDemoExt.h"
#include "SMSLDAPDemoExtDefines.h"
#include "../AG/AGSmsDatabaseDesignDefines.h"

#include <AGSmsExtDefines.h>

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

AG_EXPORT_AGB_EXTENSION_CLASS(CSMSLDAPDemoExt)

//*************************************************************
//*************************************************************
CSMSLDAPDemoExt::CSMSLDAPDemoExt(CAGFrame &	oSessionParams)
	:	CAGbAPI(						oSessionParams)
{
}

//*************************************************************
//*************************************************************
/*virtual*/CSMSLDAPDemoExt::~CSMSLDAPDemoExt()
{
}

//*************************************************************
//*************************************************************
/*virtual */AGReturnCode CSMSLDAPDemoExt::Idle()
{
	if (IsBrokerSession())
	{
	}
	if (IsEndpointSession())
	{
	}

	return (0);
}

//*************************************************************
//*************************************************************
AGReturnCode	CSMSLDAPDemoExt::InitSession()
{
	// On est dans une session Endpoint, 
	// c'est  dire lorsqu'un autre module se connecte  celui-ci
	if (IsEndpointSession()) 
	{
		//Etablir une connexion avec l'annuaire
		m_pLdapId = ldap_init("localhost", 389);
		if (m_pLdapId == NULL)
		{
			return (-1);
		}

		//S'identier  l'annuaire en tant qu'utilisateur anonyme
		if ( (ldap_simple_bind_s(	m_pLdapId,
									NULL,
									NULL)) != LDAP_SUCCESS )
		{
			return (-1);
		}	
	}

	return (0);
}

//*************************************************************
//*************************************************************
void	CSMSLDAPDemoExt::DeinitSession()
{
	if(m_pLdapId)
	{
		ldap_unbind(m_pLdapId);
		m_pLdapId = NULL;
	}
}

//*************************************************************
//*************************************************************
// POINT D'ENTREE DU MODULE
AGReturnCode CSMSLDAPDemoExt::Process(	CAGFrame&			oInMessageFrame,
										CAGFrame&			oInParams,
										CAGFrame&			oOutMessageFrame,
										CAGFrame&			oOutParams)
{
	long			iCheckSlot;
	CAGArray		oMessageArray;
	CAGString		sMessage, sSMS;
	CAGString		sTarget;

	//Petite prcaution
	if (m_pLdapId == NULL)
	{
		return (-1);
	}

	// Tester l'existence des donnes que l'on attend de SMS Gateway
	//		sTarget		contient le numero de tlphone de l'emetteur du SMS
	//		sMessage	contient le texte du SMS hors alias (1er mot)
	iCheckSlot = oInMessageFrame.IsString(AGSMS_INCOMING_MESSAGE_ORIGIN, &sTarget)+
				 oInMessageFrame.IsString(AGSMS_INCOMING_MESSAGE, &sMessage);

	if (iCheckSlot != 0)
	{
		return (-1);
	}

	// On reformate les caracteres spciaux du message SMS (Line Feed).
	CleanIncomingMessage(sMessage);

	// On interroge le serveur LDAP qui nous retourne le(s) rsultat(s) de la recherche
	// dans un tableau de chaine de caratres d'au plus 160 caractres chacunes.
	if(GetPhone(sMessage, sSMS) != 0)
	{
		return (-1);
	}

	// On envoie par SMS le(s) resultat(s)  l'emetteur de la requete
	if(SendSMS(sTarget, sSMS) != 0)
	{
		return (-1);
	}

	return (0);
}


//*************************************************************
//*************************************************************
AGReturnCode CSMSLDAPDemoExt::CleanIncomingMessage(CAGString &		sMessage)
{
	long nLength = sMessage.GetLength();
	while	(	(sMessage[nLength - 1L] == _T('\r'))
			 ||	(sMessage[nLength - 1L] == _T('\n')))
	{
		sMessage = sMessage.Left(nLength - 1L);
		nLength = sMessage.GetLength();
	}

	return agSuccess;
}

//*************************************************************
//*************************************************************
AGReturnCode CSMSLDAPDemoExt::GetPhone(	CAGString		sSearchString,
										CAGString &		sMessage)
{
	CAGString		sLdapFilter;
	char			*tcAttributs[4];
	int				nMessageID	= 0;
	int				parse_rc;

	BerElement*		ber;
	LDAPControl**	serverctrls;
	struct timeval	zerotime;
	char*			matched_msg = NULL;
	char*			error_msg = NULL;
	bool			finished = false;
	long			nResultPos = -1;
	LDAPMessage *	result		= NULL;
	
	//On ne recherche que les objets de ce type
	sLdapFilter = "(objectclass=organizationalperson)";

	//On va extraire les mots de la chaine donne en argument
	//afin de constituer le filtre de recherche
	int  mot = 0;
	bool fin = false;
	while ( !fin )
	{
		CAGString sTmp;
		int offset = sSearchString.Find(" ");
		if (offset < 0)
		{
			fin = true;
			offset = sSearchString.GetLength();
		}
		mot++;
		switch (mot)
		{
		case 1: //Filtre sur le nom
			sTmp.Format ("&%s(sn=%s*)",sLdapFilter, sSearchString.Mid(0,offset));
			break;
		case 2: //Filtre sur le prnom
			sTmp.Format ("%s(givenname=%s*)",sLdapFilter, sSearchString.Mid(0,offset));
			break;
		default:
			sTmp = sLdapFilter;
		}
		//On met  jour la chaine de filtre
		sLdapFilter = sTmp;

		//On passe au mot suivant
		if (offset+1 < sSearchString.GetLength())
		{
			sSearchString = sSearchString.Mid(offset+1);
		}
		else
			break;
	}

	//On encadre le filtre par des paranthses
	CAGString sTmp = sLdapFilter;
	sLdapFilter.Format("(%s)",sTmp);

	//On prpare la liste des attributs a extraire
	tcAttributs [0] = "sn";
	tcAttributs [1] = "givenname";
	tcAttributs [2] = "telephonenumber";
	tcAttributs [3] = NULL;

	//On effectue la recherche en asynchrone
	//afin d'illuster ce type de mcanisme
	if (ldap_search_ext(m_pLdapId,
						"o=Entreprise.com",
						LDAP_SCOPE_SUBTREE,
						(LPCTSTR)sLdapFilter,
						(char **)tcAttributs,
						0,
						NULL,
						NULL,
						NULL,
						3,
						&nMessageID) != LDAP_SUCCESS)
	{
		return (-1);
	}

	//Initialisation
	zerotime.tv_sec = zerotime.tv_usec = 0L;

	while ( !finished )
	{
		//Lire un rsultat
		int rc = ldap_result( m_pLdapId, nMessageID, 
							  LDAP_MSG_ONE, &zerotime, &result );
		switch(rc)
		{
			case -1:
				return (-1);

			case 0:
				//Pas de rsultat disponible pour le moment
				//Il faut ritrer la demande
				break;

			case LDAP_RES_SEARCH_ENTRY: //Resultat obtenu

				char*			pAttr;
				char**			vals;

				//On incrmente le nombre de rponses
				nResultPos++;

				// Lire chaque attribut
				for	(	pAttr = ldap_first_attribute( m_pLdapId, result, &ber );
						pAttr != NULL;
						pAttr = ldap_next_attribute( m_pLdapId, result, ber ) )
				{
					// Lire les valeurs pour chaque attribut
					if (( vals = ldap_get_values( m_pLdapId, 
												  result, pAttr )) != NULL )
					{
						for(int i = 0; vals[i] != NULL;	i++ )
						{
							CAGString sTmp;
							sTmp.Format("%s ",vals[i]);
							sMessage += sTmp;
						}
						
						ldap_value_free( vals );
					}

					ldap_memfree( pAttr );
				}

				if(ber != NULL)
				{
					ldap_ber_free( ber, 0 );
				}

				ldap_msgfree( result );

				break;
				
			case LDAP_RES_SEARCH_REFERENCE:

				break;

			case LDAP_RES_SEARCH_RESULT:

				//On recoit ce code retour losque la recherche est
				//termine
				finished = true;
				parse_rc = ldap_parse_result(	m_pLdapId,
												result,
												&rc,
												&matched_msg,
												&error_msg,
												NULL,
												&serverctrls,
												1);

				if (   parse_rc != LDAP_SUCCESS 
					|| rc != LDAP_SUCCESS)
				{
					return (-1);
				}

				break;
			default:
				break;
		}

		// La recherche tant asynchrone, il est possible d'effectuer
		//d'autre traitement a cet endroit
		if(!finished)
		{
			//TODO
		}
	}

	return agSuccess;
}

//*****************************************************
//*****************************************************
// Renvoi de(s) reponse(s)  la recherche par SMS
AGReturnCode CSMSLDAPDemoExt::SendSMS(	CAGString	sTarget,	// tel du destinataire
										CAGString	sMessage)	// message SMS  envoyer
{
	CAGFrame		oInMessageFrame;
	CAGFrame		oInParams;
	CAGFrame		oOutMessageFrame;
	CAGFrame		oOutParams;

	if(sMessage.GetLength() == 0)
	{
		return agSuccess;
	}

	// Identification aupres d'SMS Gateway
	oInMessageFrame[CAGPath(AG_EXTENSION_REQUEST)+AG_EXTENSION_REQUEST]		= AGSMS_REQ_LOGIN;
	oInMessageFrame[CAGPath(AG_EXTENSION_REQUEST)+AGSMS_REQSLOT_LOGIN_NAME]	= _T("demo");
	oInMessageFrame[CAGPath(AG_EXTENSION_REQUEST)+AGSMS_REQSLOT_LOGIN_PWD]	= _T("demo");

	// Ajout d'un message  envoyer
	long iTmpPos = 1;	// +1 parce que la requete de login est en position 0

	// Ajout d'un message  envoyer
	oInMessageFrame[CAGPath(AG_EXTENSION_REQUEST) + iTmpPos + AG_EXTENSION_REQUEST]		 = AGSMS_REQ_SEND;
	oInMessageFrame[CAGPath(AG_EXTENSION_REQUEST) + iTmpPos + AGSMS_REQSLOT_SEND_TARGET] = sTarget;
	oInMessageFrame[CAGPath(AG_EXTENSION_REQUEST) + iTmpPos + AGSMS_REQSLOT_SEND_MESSAGE]= sMessage;

	// Envoi  SMS Gateway du rsultat
	return	ProcessByAnotherExtension(	oInMessageFrame,
										oInParams,
										oOutMessageFrame,
										oOutParams,
										AGSMSEXT_PEER_NAME); //Nom de la gateway SMS
}

