//	Copyright 1996-1999 Netsize SA. All Rights reserved.
//	e-mail	:	agsupport@netsize.com
//				aginfo@netsize.com
//	web		:	http://www.netsize.com/
//
//	SMSLDAPDemoExt.h: interface for the CSMSLDAPDemoExt class.
//
//////////////////////////////////////////////////////////////////////

#ifndef	_SMSLDAP_DEMO_EXT_H_
#define _SMSLDAP_DEMO_EXT_H_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include "NSDirectory.h"

//#include "NSPreferences.h"
//#include "NSPreferencesDefines.h"

#include <ldap.h>
#include <ldap_ssl.h>

////////////////////////////////////////////////////
class CSMSLDAPDemoExt : public CAGbAPI
{
public:
	CSMSLDAPDemoExt(CAGFrame &	oSessionParams);
	virtual ~CSMSLDAPDemoExt();

	virtual AGReturnCode	InitSession();

	virtual void			DeinitSession();

	virtual AGReturnCode Idle();

	virtual AGReturnCode Process(			CAGFrame &	oInMessage,
											CAGFrame &	oInParams,
											CAGFrame &	oOutMessage,
											CAGFrame &	oOutParams);

	virtual AGReturnCode Info(				CAGFrame &	oInformation,
											CAGFrame &	oParams);

	AGReturnCode	GetPhone(				CAGString	sName,
											CAGString &	sMessage);
	
	AGReturnCode	CleanIncomingMessage(	CAGString &	sMessage);
					
	AGReturnCode	SendSMS(				CAGString	sTarget,
											CAGString	sSMS);
					
	AGReturnCode	ParseWordInString(		CAGString	sSearchString,
											CAGString &	sWord,
											long		nWordPos);
					
	AGReturnCode	GetGroupFromCode(		CAGString	sCode,
											CAGString &	sGroup);
					
	AGReturnCode	ComputePhoneFile(		CAGString	sPhoneFile);
					
	AGReturnCode	ReadPhoneFileLine(		CAGFile&	oAGFile,
											CAGString&	sOneTarget,
											CAGString&	sOneOrganisationUnit);
public:

	AGReturnCode	InformFrom(				CAGString	sInfoPrefix,
											LPCTSTR		lpszFormat,
											...);
	AGReturnCode	InformFrom(				CAGString	sInfoPrefix,
											LPCTSTR		lpszFormat,
											va_list		va_args);
	AGReturnCode	InformFrom(				CAGString	sInfoPrefix,
											CAGString	sInfo);

private:

	AGReturnCode	Inform(					LPCTSTR		lpszFormat,
											...);
	AGReturnCode	Inform(					LPCTSTR		lpszFormat,
											va_list		va_args);
	AGReturnCode	Inform(					CAGString	sInfo);

private:
	LDAP *					m_pLdapId;
	

	// Extension preferences frame.
	CAGFrame				m_oPreferences;
	CAGFrame				m_oPreferencesFormat;
//	CNSPreferences *		m_pNSPreferences;

	CAGArray				m_oSearchAttibuteArray;
	CAGArray				m_oRetrieveAttibuteArray;
	CAGArray				m_oRetrieveAttibuteFormatArray;

	CAGFrame				m_sPhoneFilterFrame;
	
	CNSDirectory			m_oNSDirectory;

	AG_DECLARE_AGB_EXTENSION(CSMSLDAPDemoExt)
};

#endif	//	ndef	_SMSLDAP_DEMO_EXT_H_
