#ifndef _SMSLDAP_DEMO_EXT_DEFINE_H_
#define _SMSLDAP_DEMO_EXT_DEFINE_H_

#include "NetsizeRegistry.h"

#define SMSLDAPEXT_PEER_NAME						_T("SMSLDAPDemoExt^Netsize")

#define SMSLDAPEXT_ROOT_MAXMESSAGE					_T("MaxMessage")
// SERVER ==========================================
#define SMSLDAPEXT_SERVER_ADDR						_T("Server.Address")
#define SMSLDAPEXT_SERVER_PORT						_T("Server.Port")
#define SMSLDAPEXT_SERVER_LOGIN						_T("Server.Login")
#define SMSLDAPEXT_SERVER_PASSWORD					_T("Server.Password")
// Netsize SMS Gateway =============================
#define SMSLDAPEXT_SMSGATEWAY_LOGIN					_T("NSG.Login")
#define SMSLDAPEXT_SMSGATEWAY_PASSWORD				_T("NSG.Password")
#define SMSLDAPEXT_SMSGATEWAY_MAX_CAR				_T("NSG.MaxCharacter")
// SEARCH ==========================================
#define SMSLDAPEXT_SEARCH_BASEDN					_T("Search.BaseDN")
#define SMSLDAPEXT_SEARCH_ATTRIBUTES				_T("Search.Attributes")
#define SMSLDAPEXT_SEARCH_OBLIGATORY_ATTRIBUTES		_T("Search.ObligatoryAttributes")
#define SMSLDAPEXT_SEARCH_ALLOWEMPTYATTRIBUTES		_T("Search.AllowEmptyAttributes")
#define SMSLDAPEXT_SEARCH_SIZE_LIMIT				_T("Search.SizeLimit")
// RETRIEVE ========================================
#define SMSLDAPEXT_RETRIEVE_ATTRIBUTES				_T("Retrieve.Attributes")

#define SMSLDAPEXT_PREFERENCE_FRAME_INIT(frame)					\
	CAGArray	oSearchAttributeArray;							\
	CAGArray	oRetrieveAttributeArray;						\
	oSearchAttributeArray[0L]		= "sn*";					\
	oSearchAttributeArray[1L]		= "givenname*";				\
	oRetrieveAttributeArray[0L]		= "sn";						\
	oRetrieveAttributeArray[1L]		= "# ";						\
	oRetrieveAttributeArray[2L]		= "givenname";				\
	oRetrieveAttributeArray[3L]		= "# ";						\
	oRetrieveAttributeArray[4L]		= "telephonenumber";		\
	frame[SMSLDAPEXT_ROOT_MAXMESSAGE]				= 5L;						\
	frame[SMSLDAPEXT_SERVER_ADDR]					= _T("172.17.1.203");		\
	frame[SMSLDAPEXT_SERVER_PORT]					= 389L;						\
	frame[SMSLDAPEXT_SERVER_LOGIN]					= _T("");					\
	frame[SMSLDAPEXT_SERVER_PASSWORD]				= _T("");					\
	frame[SMSLDAPEXT_SEARCH_BASEDN]					= _T("o=Demo");				\
	frame[SMSLDAPEXT_SEARCH_ATTRIBUTES]				= oSearchAttributeArray;	\
	frame[SMSLDAPEXT_SEARCH_OBLIGATORY_ATTRIBUTES]	= _T("");					\
	frame[SMSLDAPEXT_SEARCH_ALLOWEMPTYATTRIBUTES]	= 1L;						\
	frame[SMSLDAPEXT_SEARCH_SIZE_LIMIT]				= -1L;						\
	frame[SMSLDAPEXT_RETRIEVE_ATTRIBUTES]			= oRetrieveAttributeArray;	\
	frame[SMSLDAPEXT_SMSGATEWAY_LOGIN]				= _T("demo");				\
	frame[SMSLDAPEXT_SMSGATEWAY_PASSWORD]			= _T("demo");				\
	frame[SMSLDAPEXT_SMSGATEWAY_MAX_CAR]			= 160L;

// Information messages.
#define SMSLDAPEXT_INFO_PREFIX						_T("***** INFO        - ")
#define SMSLDAPEXT_ERROR_PREFIX						_T("***** ERROR       - ")
#define SMSLDAPEXT_INFO_SEPARATOR					_T(" - ")
#define SMSLDAPEXT_INFO_SUFFIX						_T("\r\n")


#endif	//	_SMSLDAP_DEMO_EXT_DEFINE_H_
