/////////////////////////////////////////////////////////////////////////////
//	AGSmsExtDefines.h
//
//	Copyright 1996-2000 Netsize Corporation. All Rights reserved.
//	e-mail	:	info@netsize.com
//				support@netsize.com
//	web		:	http://www.netsize.com/
//

#ifndef AGSMS_EXT_DEFINES_H
#define AGSMS_EXT_DEFINES_H

//#include "AGSmsDatabaseDesignDefines.h"

//***************************************************************************
// PEER NAME ////////////////////////////////////////////////////////////////

#define AGSMSEXT_PEER_NAME								_T("AGSMSExt^Netsize")

//***************************************************************************
// MESSAGE HEADERS //////////////////////////////////////////////////////////

#define AGSMS_HEADER_SEPARATOR_CHARSET					_T("#*- ")
#define AGSMS_HEADER_SEPARATOR_WIDTH					1L

//***************************************************************************
// NOTIFICATION MESSAGES ////////////////////////////////////////////////////

// Event.
#define NSG_DRV_EVENT_TYPE								_T("EventType")

enum	nsgDriverEvent {				nsg_deSubmitMessage			= 0L,
										nsg_deStatusReport			= 1L,
										nsg_deReceiveMessage		= 2L};

// Submit message.
/*
#define NSG_DRV_EVENT_SM_*								AGSMS_REQSLOT_SEND_*
*/

// Status report.
#define NSG_DRV_EVENT_SR_HEADER							_T("Header")
#define NSG_DRV_EVENT_SR_MESSAGE_REFERENCE				_T("MessageReference")
#define NSG_DRV_EVENT_SR_RECIPIENT_ADDRESS				_T("RecipientAddress")
#define NSG_DRV_EVENT_SR_TYPE_OF_ADDRESS				_T("AddressType")
#define NSG_DRV_EVENT_SR_SMSC_TIMESTAMP					_T("SmscTimestamp")
#define NSG_DRV_EVENT_SR_DISCHARGE_TIME					_T("DischargeTime")
#define NSG_DRV_EVENT_SR_STATUS							_T("Status")

// Receive message.
#define AGSMS_INCOMING_MESSAGE							_T("SMSMessage")
#define AGSMS_INCOMING_MESSAGE_ORIGIN					_T("SMSOrigin")
#define AGSMS_INCOMING_MESSAGE_ID						_T("SMSMessageId")

#define NSG_DRV_EVENT_RM_MESSAGE						AGSMS_INCOMING_MESSAGE
#define NSG_DRV_EVENT_RM_MESSAGE_ORIGIN					AGSMS_INCOMING_MESSAGE_ORIGIN
#define NSG_DRV_EVENT_RM_MESSAGE_ID						AGSMS_INCOMING_MESSAGE_ID

//***************************************************************************
// REQUESTS /////////////////////////////////////////////////////////////////

// Ordonancement.
#define AGSMS_REQSLOTOPT_DEPENDS_ON_REQ					_T("DEPENDS")

// REQUEST CODES ////////////////////////////////////////////////////////////

//***** Authentification process *****
// Login.
#define AGSMS_REQ_LOGIN									_T("r_l_sms")

#define AGSMS_REQSLOT_LOGIN_NAME						_T("LOGIN")
#define AGSMS_REQSLOT_LOGIN_PWD							_T("PASSWORD")

//***** Messages requests *****
// Send.
#define AGSMS_REQ_SEND									_T("r_s_sms")

#define AGSMS_REQSLOT_SEND_MESSAGE						AGSMS_DB_TMESSAGE_MESSAGE
#define AGSMS_REQSLOT_SEND_TARGET						AGSMS_DB_TTARGET_TARGET
#define AGSMS_REQSLOTPARAM_SEND_TARGET_SEPARATOR		_T(';')

#define AGSMS_REQSLOT_OPT_SEND_PRIORITY					AGSMS_DB_TOUTGOING_PRIORITY				// smsMessagePriority
#define AGSMS_REQSLOT_OPT_SEND_DELAY_DATE				AGSMS_DB_TOUTGOING_DELAY_DATE
#define AGSMS_REQSLOT_OPT_SEND_MESSAGE_CLASS_TYPE		AGSMS_DB_TOUTGOING_CLASS_TYPE			// smsMessageClassType
#define AGSMS_REQSLOT_OPT_SEND_VALIDITY_DATE			AGSMS_DB_TOUTGOING_VALIDITY_DATE
#define AGSMS_REQSLOT_OPT_SEND_NOTIFICATION				AGSMS_DB_TOUTGOING_NOTIFICATION			// smsMessageNotification
#define AGSMS_REQSLOT_OPT_SEND_NOTIFICATION_TARGET		AGSMS_DB_TOUTGOING_NOTIFICATION_TARGET

#define AGSMS_REQSLOT_OPT_SEND_EXTENDED_PARAMS			_T("EXTENDED")
#define AGSMS_REQSLOT_OPT_SEND_EXTENDED_TPUDHI			_T("TPUDHI")
#define AGSMS_REQSLOT_OPT_SEND_EXTENDED_TPUDH			_T("TPUDH")
#define AGSMS_REQSLOT_OPT_SEND_EXTENDED_TPUDLb			_T("TPUDLb")
#define AGSMS_REQSLOT_OPT_SEND_EXTENDED_TPPID			_T("TPPID")

#define AGSMS_RESSLOT_SEND_MESSAGE_ID_TICKET			AGSMS_DB_TTICKET_ID_TICKET
#define AGSMS_RESSLOT_SEND_MESSAGE_ADDRESS				AGSMS_DB_TTARGET_ADDRESS
#define AGSMS_RESSLOT_SEND_MESSAGE_RESULT_CODE			_T("STATUS")

// Update.
#define AGSMS_REQ_OUTGOING_SMS_UPDATE					_T("r_mt_upd")

#define AGSMS_REQSLOT_OUTGOING_SMS_UPDATE_ID_TICKET		AGSMS_DB_TTICKET_ID_TICKET
#define AGSMS_REQSLOT_OUTGOING_SMS_UPDATE_MESSAGE		AGSMS_DB_TMESSAGE_MESSAGE

// Delete.
#define AGSMS_REQ_OUTGOING_SMS_DELETE					_T("r_mt_del")

#define AGSMS_REQSLOT_OUTGOING_SMS_DELETE_ID_TICKET		AGSMS_DB_TTICKET_ID_TICKET

// Find.
#define AGSMS_REQ_OUTGOING_SMS_FIND						_T("r_mt_fnd")

// Status.
#define AGSMS_REQ_OUTGOING_SMS_STATUS					_T("r_mt_sts")

#define AGSMS_REQSLOT_OUTGOING_SMS_STATUS_ID_TICKET		AGSMS_DB_TTICKET_ID_TICKET

#define AGSMS_RESSLOT_OUTGOING_SMS_STATUS				_T("STATUS")
#define AGSMS_RESSLOT_OUTGOING_SMS_STATUS_ID_MSG		AGSMS_DB_TEVENT_ID_MSG
#define AGSMS_RESSLOT_OUTGOING_SMS_STATUS_EVENT			AGSMS_DB_TEVENT_EVENT
#define AGSMS_RESSLOT_OUTGOING_SMS_STATUS_DATE			AGSMS_DB_TEVENT_DATE

//***** Administrative Request *****
// List outgoing.
#define AGSMS_REQ_OUTGOING_SMS_LIST						_T("r_mt_lst")

#define AGSMS_REQSLOT_OUTGOING_SMS_ORG					AGSMS_DB_TORGANISATION_ORG
#define AGSMS_REQSLOT_OUTGOING_SMS_LOGIN				AGSMS_DB_TACCOUNT_LOGIN
#define AGSMS_REQSLOT_OUTGOING_SMS_ENDPOINT				AGSMS_DB_TACCOUNT_ENDPOINT
#define AGSMS_REQSLOT_OUTGOING_SMS_GROUP				AGSMS_DB_TGROUP_GROUP
#define AGSMS_REQSLOT_OUTGOING_SMS_TARGET				AGSMS_DB_TTARGET_TARGET
#define AGSMS_REQSLOT_OUTGOING_SMS_ADDRESS				AGSMS_DB_TTARGET_ADDRESS
#define AGSMS_REQSLOT_OUTGOING_SMS_LENGTH_FROM			_T("LENGTH_FROM")
#define AGSMS_REQSLOT_OUTGOING_SMS_LENGTH_TO			_T("LENGTH_TO")
#define AGSMS_REQSLOT_OUTGOING_SMS_LENGTH				AGSMS_DB_TOUTGOING_LENGTH
#define AGSMS_REQSLOT_OUTGOING_SMS_PRIORITY_FROM		_T("PRIORITY_FROM")
#define AGSMS_REQSLOT_OUTGOING_SMS_PRIORITY_TO			_T("PRIORITY_TO")
#define AGSMS_REQSLOT_OUTGOING_SMS_PRIORITY				AGSMS_DB_TOUTGOING_PRIORITY
#define AGSMS_REQSLOT_OUTGOING_SMS_DELAY_DATE_FROM		_T("DELAY_DATE_FROM")
#define AGSMS_REQSLOT_OUTGOING_SMS_DELAY_DATE_TO		_T("DELAY_DATE_TO")
#define AGSMS_REQSLOT_OUTGOING_SMS_DELAY_DATE			AGSMS_DB_TOUTGOING_DELAY_DATE
#define AGSMS_REQSLOT_OUTGOING_SMS_CLASS_TYPE_FROM		_T("CLASS_TYPE_FROM")
#define AGSMS_REQSLOT_OUTGOING_SMS_CLASS_TYPE_TO		_T("CLASS_TYPE_TO")
#define AGSMS_REQSLOT_OUTGOING_SMS_CLASS_TYPE			AGSMS_DB_TOUTGOING_CLASS_TYPE
#define AGSMS_REQSLOT_OUTGOING_SMS_VALIDITY_DATE_FROM	_T("VALIDITY_DATE_FROM")
#define AGSMS_REQSLOT_OUTGOING_SMS_VALIDITY_DATE_TO		_T("VALIDITY_DATE_TO")
#define AGSMS_REQSLOT_OUTGOING_SMS_VALIDITY_DATE		AGSMS_DB_TOUTGOING_VALIDITY_DATE
#define AGSMS_REQSLOT_OUTGOING_SMS_NOTIFICATION			AGSMS_DB_TOUTGOING_NOTIFICATION
#define AGSMS_REQSLOT_OUTGOING_SMS_NOTIFICATION_TARGET	AGSMS_DB_TOUTGOING_NOTIFICATION_TARGET
#define AGSMS_REQSLOT_OUTGOING_SMS_EVENT				AGSMS_DB_TEVENT_EVENT
#define AGSMS_REQSLOT_OUTGOING_SMS_DATE_FROM			_T("DATE_FROM")
#define AGSMS_REQSLOT_OUTGOING_SMS_DATE_TO				_T("DATE_TO")
#define AGSMS_REQSLOT_OUTGOING_SMS_DATE					AGSMS_DB_TEVENT_DATE

#define AGSMS_RESSLOT_OUTGOING_SMS_LIST					_T("OUTGOING_LIST")
#define AGSMS_RESSLOT_OUTGOING_SMS_ORG					AGSMS_DB_TORGANISATION_ORG
#define AGSMS_RESSLOT_OUTGOING_SMS_LOGIN				AGSMS_DB_TACCOUNT_LOGIN
#define AGSMS_RESSLOT_OUTGOING_SMS_ENDPOINT				AGSMS_DB_TACCOUNT_ENDPOINT
#define AGSMS_RESSLOT_OUTGOING_SMS_TARGET				AGSMS_DB_TTARGET_TARGET
#define AGSMS_RESSLOT_OUTGOING_SMS_ADDRESS				AGSMS_DB_TTARGET_ADDRESS
#define AGSMS_RESSLOT_OUTGOING_SMS_LENGTH				AGSMS_DB_TOUTGOING_LENGTH
#define AGSMS_RESSLOT_OUTGOING_SMS_PRIORITY				AGSMS_DB_TOUTGOING_PRIORITY
#define AGSMS_RESSLOT_OUTGOING_SMS_DELAY_DATE			AGSMS_DB_TOUTGOING_DELAY_DATE
#define AGSMS_RESSLOT_OUTGOING_SMS_CLASS_TYPE			AGSMS_DB_TOUTGOING_CLASS_TYPE
#define AGSMS_RESSLOT_OUTGOING_SMS_VALIDITY_DATE		AGSMS_DB_TOUTGOING_VALIDITY_DATE
#define AGSMS_RESSLOT_OUTGOING_SMS_NOTIFICATION			AGSMS_DB_TOUTGOING_NOTIFICATION
#define AGSMS_RESSLOT_OUTGOING_SMS_NOTIFICATION_TARGET	AGSMS_DB_TOUTGOING_NOTIFICATION_TARGET
#define AGSMS_RESSLOT_OUTGOING_SMS_EVENT				AGSMS_DB_TEVENT_EVENT
#define AGSMS_RESSLOT_OUTGOING_SMS_DATE					AGSMS_DB_TEVENT_DATE

// List incoming.
#define AGSMS_REQ_INCOMING_SMS_LIST						_T("r_mo_lst")

#define AGSMS_REQSLOT_INCOMING_SMS_ORG					AGSMS_DB_TORGANISATION_ORG
#define AGSMS_REQSLOT_INCOMING_SMS_LOGIN				AGSMS_DB_TACCOUNT_LOGIN
#define AGSMS_REQSLOT_INCOMING_SMS_ENDPOINT				AGSMS_DB_TACCOUNT_ENDPOINT
#define AGSMS_REQSLOT_INCOMING_SMS_GROUP				AGSMS_DB_TGROUP_GROUP
#define AGSMS_REQSLOT_INCOMING_SMS_TARGET				AGSMS_DB_TTARGET_TARGET
#define AGSMS_REQSLOT_INCOMING_SMS_ADDRESS				AGSMS_DB_TTARGET_ADDRESS
#define AGSMS_REQSLOT_INCOMING_SMS_LENGTH_FROM			_T("LENGTH_FROM")
#define AGSMS_REQSLOT_INCOMING_SMS_LENGTH_TO			_T("LENGTH_TO")
#define AGSMS_REQSLOT_INCOMING_SMS_LENGTH				AGSMS_DB_TINCOMING_LENGTH
#define AGSMS_REQSLOT_INCOMING_SMS_EVENT				AGSMS_DB_TEVENT_EVENT
#define AGSMS_REQSLOT_INCOMING_SMS_DATE_FROM			_T("DATE_FROM")
#define AGSMS_REQSLOT_INCOMING_SMS_DATE_TO				_T("DATE_TO")
#define AGSMS_REQSLOT_INCOMING_SMS_DATE					AGSMS_DB_TEVENT_DATE

#define AGSMS_RESSLOT_INCOMING_SMS_LIST					_T("INCOMING_LIST")
#define AGSMS_RESSLOT_INCOMING_SMS_ORG					AGSMS_DB_TORGANISATION_ORG
#define AGSMS_RESSLOT_INCOMING_SMS_LOGIN				AGSMS_DB_TACCOUNT_LOGIN
#define AGSMS_RESSLOT_INCOMING_SMS_ENDPOINT				AGSMS_DB_TACCOUNT_ENDPOINT
#define AGSMS_RESSLOT_INCOMING_SMS_TARGET				AGSMS_DB_TTARGET_TARGET
#define AGSMS_RESSLOT_INCOMING_SMS_ALIAS				AGSMS_DB_TALIAS_ALIAS
#define AGSMS_RESSLOT_INCOMING_SMS_ADDRESS				AGSMS_DB_TTARGET_ADDRESS
#define AGSMS_RESSLOT_INCOMING_SMS_LENGTH				AGSMS_DB_TINCOMING_LENGTH
#define AGSMS_RESSLOT_INCOMING_SMS_EVENT				AGSMS_DB_TEVENT_EVENT
#define AGSMS_RESSLOT_INCOMING_SMS_DATE					AGSMS_DB_TEVENT_DATE

// Get Invoice.
#define AGSMS_REQ_GET_INVOICE							_T("r_g_inv")

#define AGSMS_REQSLOT_GET_INVOICE_SMS_ACCOUNT			AGSMS_DB_TACCOUNT_LOGIN
#define AGSMS_REQSLOT_GET_INVOICE_SMS_DATE_FROM			_T("DATE_FROM")
#define AGSMS_REQSLOT_GET_INVOICE_SMS_DATE_TO			_T("DATE_TO")

#define AGSMS_RESSLOT_GET_INVOICE_SMS_LIST				_T("INVOICE_LIST")

// Set Invoice.
#define AGSMS_REQ_SET_SERVICE_INVOICE					_T("r_s_svr_inv")

#define AGSMS_REQSLOT_SET_SERVICE_INVOICE_ACCOUNT		AGSMS_DB_TACCOUNT_LOGIN
#define AGSMS_REQSLOT_SET_SERVICE_INVOICE_SERVICE		_T("SERVICE")
#define AGSMS_REQSLOT_SET_SERVICE_INVOICE_USEDATE		_T("USEDATE")
#define AGSMS_REQSLOT_SET_SERVICE_INVOICE_NBSMS			_T("NBSMS")

//***** Database entities *****
// Organisation management.
#define AGSMS_REQ_INSERT_ORGANISATION					_T("r_org_ins")
#define AGSMS_REQ_UPDATE_ORGANISATION					_T("r_org_upd")
#define AGSMS_REQ_DELETE_ORGANISATION					_T("r_org_del")
#define AGSMS_REQ_LIST_ORGANISATION						_T("r_org_lst")

#define AGSMS_REQSLOT_ORGANISATION_ID					AGSMS_DB_TORGANISATION_ID_ORG
#define AGSMS_REQSLOT_ORGANISATION_NAME					AGSMS_DB_TORGANISATION_ORG
#define AGSMS_REQSLOT_ORGANISATION_DESC					AGSMS_DB_TORGANISATION_DESCRIPTION
#define AGSMS_REQSLOT_ORGANISATION_DISABLED				AGSMS_DB_TORGANISATION_ORG_DISABLED

#define AGSMS_REQSLOT_ORGANISATION_NAME_DEF				_T("")
#define AGSMS_REQSLOT_ORGANISATION_DESC_DEF				_T("")
#define AGSMS_REQSLOT_ORGANISATION_DISABLED_DEF			0L

#define AGSMS_RESSLOT_ORGANISATION_LIST					_T("ORG_LIST")

// Group management.
#define AGSMS_REQ_INSERT_GROUP							_T("r_grp_ins")
#define AGSMS_REQ_UPDATE_GROUP							_T("r_grp_upd")
#define AGSMS_REQ_DELETE_GROUP							_T("r_grp_del")
#define AGSMS_REQ_LIST_GROUP							_T("r_grp_lst")

#define AGSMS_REQSLOT_GROUP_ID_GROUP					AGSMS_DB_TGROUP_ID_GROUP
#define AGSMS_REQSLOT_GROUP_ID_ORG						AGSMS_DB_TGROUP_ID_ORG
#define AGSMS_REQSLOT_GROUP_GROUP						AGSMS_DB_TGROUP_GROUP
#define AGSMS_REQSLOT_GROUP_DESCRIPTION					AGSMS_DB_TGROUP_DESCRIPTION
#define AGSMS_REQSLOT_GROUP_GROUP_DISABLED				AGSMS_DB_TGROUP_GROUP_DISABLED

#define AGSMS_REQSLOT_GROUP_ID_ORG_DEF					-1L
#define AGSMS_REQSLOT_GROUP_GROUP_DEF					_T("")
#define AGSMS_REQSLOT_GROUP_DESCRIPTION_DEF				_T("")
#define AGSMS_REQSLOT_GROUP_GROUP_DISABLED_DEF			0L

#define AGSMS_RESSLOT_GROUP_LIST						_T("GROUP_LIST")

// Target management.
#define AGSMS_REQ_INSERT_TARGET							_T("r_tgt_ins")
#define AGSMS_REQ_UPDATE_TARGET							_T("r_tgt_upd")
#define AGSMS_REQ_DELETE_TARGET							_T("r_tgt_del")
#define AGSMS_REQ_LIST_TARGET							_T("r_tgt_lst")

#define AGSMS_REQSLOT_TARGET_ID_TARGET					AGSMS_DB_TTARGET_ID_TARGET
#define AGSMS_REQSLOT_TARGET_ID_GROUP					AGSMS_DB_TTARGET_ID_GROUP
#define AGSMS_REQSLOT_TARGET_TARGET						AGSMS_DB_TTARGET_TARGET
#define AGSMS_REQSLOT_TARGET_ADDRESS					AGSMS_DB_TTARGET_ADDRESS
#define AGSMS_REQSLOT_TARGET_DESCRIPTION				AGSMS_DB_TTARGET_DESCRIPTION
#define AGSMS_REQSLOT_TARGET_TARGET_DISABLED			AGSMS_DB_TTARGET_TARGET_DISABLED

#define AGSMS_REQSLOT_TARGET_ID_GROUP_DEF				-1L
#define AGSMS_REQSLOT_TARGET_TARGET_DEF					_T("")
#define AGSMS_REQSLOT_TARGET_ADDRESS_DEF				_T("")
#define AGSMS_REQSLOT_TARGET_DESCRIPTION_DEF			_T("")
#define AGSMS_REQSLOT_TARGET_TARGET_DISABLED_DEF		0L

#define AGSMS_RESSLOT_TARGET_LIST						_T("TARGET_LIST")

// Broadcast management.
#define AGSMS_REQ_INSERT_BROADCAST_LINK					_T("r_bcl_ins")
#define AGSMS_REQ_DELETE_BROADCAST_LINK					_T("r_bcl_del")

#define AGSMS_REQSLOT_BROADCAST_ID_GROUP				AGSMS_DB_TBROADCAST_ID_GROUP
#define AGSMS_REQSLOT_BROADCAST_ID_TARGET				AGSMS_DB_TBROADCAST_ID_TARGET

// Alias management.
#define AGSMS_REQ_INSERT_ALIAS							_T("r_als_ins")
#define AGSMS_REQ_UPDATE_ALIAS							_T("r_als_upd")
#define AGSMS_REQ_DELETE_ALIAS							_T("r_als_del")
#define AGSMS_REQ_LIST_ALIAS							_T("r_als_lst")

#define AGSMS_REQSLOT_ALIAS_ID_ALIAS					AGSMS_DB_TALIAS_ID_ALIAS
#define AGSMS_REQSLOT_ALIAS_ID_SRV						AGSMS_DB_TALIAS_ID_SRV
#define AGSMS_REQSLOT_ALIAS_ID_ORG						AGSMS_DB_TALIAS_ID_ORG
#define AGSMS_REQSLOT_ALIAS_ID_GROUP					AGSMS_DB_TALIAS_ID_GROUP
#define AGSMS_REQSLOT_ALIAS_ID_TARGET					AGSMS_DB_TALIAS_ID_TARGET
#define AGSMS_REQSLOT_ALIAS_ID_ACCOUNT					AGSMS_DB_TALIAS_ID_ACCOUNT
#define AGSMS_REQSLOT_ALIAS_ALIAS						AGSMS_DB_TALIAS_ALIAS
#define AGSMS_REQSLOT_ALIAS_DESCRIPTION					AGSMS_DB_TALIAS_DESCRIPTION
#define AGSMS_REQSLOT_ALIAS_DISABLED					AGSMS_DB_TALIAS_DISABLED

#define AGSMS_REQSLOT_ALIAS_ID_SRV_DEF					-1L
#define AGSMS_REQSLOT_ALIAS_ID_ORG_DEF					-1L
#define AGSMS_REQSLOT_ALIAS_ID_GROUP_DEF				-1L
#define AGSMS_REQSLOT_ALIAS_ID_TARGET_DEF				-1L
#define AGSMS_REQSLOT_ALIAS_ID_ACCOUNT_DEF				-1L
#define AGSMS_REQSLOT_ALIAS_ALIAS_DEF					_T("")
#define AGSMS_REQSLOT_ALIAS_DESCRIPTION_DEF				_T("")
#define AGSMS_REQSLOT_ALIAS_DISABLED_DEF				0L

#define AGSMS_RESSLOT_ALIAS_LIST						_T("ALIAS_LIST")
#define AGSMS_RESSLOT_ALIAS_ID_ALIAS					AGSMS_DB_TALIAS_ID_ALIAS
#define AGSMS_RESSLOT_ALIAS_ID_SRV						AGSMS_DB_TALIAS_ID_SRV
#define AGSMS_RESSLOT_ALIAS_ID_ORG						AGSMS_DB_TALIAS_ID_ORG
#define AGSMS_RESSLOT_ALIAS_ID_GROUP					AGSMS_DB_TALIAS_ID_GROUP
#define AGSMS_RESSLOT_ALIAS_ID_TARGET					AGSMS_DB_TALIAS_ID_TARGET
#define AGSMS_RESSLOT_ALIAS_ID_ACCOUNT					AGSMS_DB_TALIAS_ID_ACCOUNT
#define AGSMS_RESSLOT_ALIAS_ALIAS						AGSMS_DB_TALIAS_ALIAS
#define AGSMS_RESSLOT_ALIAS_DESCRIPTION					AGSMS_DB_TALIAS_DESCRIPTION
#define AGSMS_RESSLOT_ALIAS_DISABLED					AGSMS_DB_TALIAS_DISABLED
#define AGSMS_RESSLOT_ALIAS_ACCOUNT_LOGIN				AGSMS_DB_TACCOUNT_LOGIN
#define AGSMS_RESSLOT_ALIAS_ACCOUNT_ENDPOINT			AGSMS_DB_TACCOUNT_ENDPOINT
#define AGSMS_RESSLOT_ALIAS_ORGANISATION_SRV			_T("SRV")
#define AGSMS_RESSLOT_ALIAS_ORGANISATION_ORG			AGSMS_DB_TORGANISATION_ORG
#define AGSMS_RESSLOT_ALIAS_GROUP_GROUP					AGSMS_DB_TGROUP_GROUP
#define AGSMS_RESSLOT_ALIAS_TARGET_TARGET				AGSMS_DB_TTARGET_TARGET
#define AGSMS_RESSLOT_ALIAS_TARGET_ADDRESS				AGSMS_DB_TTARGET_ADDRESS

// Account management.
#define AGSMS_REQ_INSERT_ACCOUNT						_T("r_act_ins")
#define AGSMS_REQ_UPDATE_ACCOUNT						_T("r_act_upd")
#define AGSMS_REQ_DELETE_ACCOUNT						_T("r_act_del")
#define AGSMS_REQ_LIST_ACCOUNT							_T("r_act_lst")

#define AGSMS_REQSLOT_ACCOUNT_ID_ACCOUNT				AGSMS_DB_TACCOUNT_ID_ACCOUNT
#define AGSMS_REQSLOT_ACCOUNT_ID_ORG					AGSMS_DB_TACCOUNT_ID_ORG
#define AGSMS_REQSLOT_ACCOUNT_LOGIN						AGSMS_DB_TACCOUNT_LOGIN
#define AGSMS_REQSLOT_ACCOUNT_PASSWORD					AGSMS_DB_TACCOUNT_PASSWORD
#define AGSMS_REQSLOT_ACCOUNT_ENDPOINT					AGSMS_DB_TACCOUNT_ENDPOINT
#define AGSMS_REQSLOT_ACCOUNT_DESCRIPTION				AGSMS_DB_TACCOUNT_DESCRIPTION
#define AGSMS_REQSLOT_ACCOUNT_STREAM_QUOTA				AGSMS_DB_TACCOUNT_STREAM_QUOTA
#define AGSMS_REQSLOT_ACCOUNT_MESSAGE_ALLOWED			AGSMS_DB_TACCOUNT_MESSAGE_ALLOWED
#define AGSMS_REQSLOT_ACCOUNT_MAX_PRIORITY				AGSMS_DB_TACCOUNT_MAX_PRIORITY
#define AGSMS_REQSLOT_ACCOUNT_DEFAULT_PRIORITY			AGSMS_DB_TACCOUNT_DEFAULT_PRIORITY
#define AGSMS_REQSLOT_ACCOUNT_DELAY_MSG					AGSMS_DB_TACCOUNT_DELAY_MSG
#define AGSMS_REQSLOT_ACCOUNT_BROADCAST					AGSMS_DB_TACCOUNT_BROADCAST
#define AGSMS_REQSLOT_ACCOUNT_ADMIN						AGSMS_DB_TACCOUNT_ADMIN
#define AGSMS_REQSLOT_ACCOUNT_DISABLED					AGSMS_DB_TACCOUNT_ACCOUNT_DISABLED

#define AGSMS_REQSLOT_ACCOUNT_ID_ORG_DEF				-1L
#define AGSMS_REQSLOT_ACCOUNT_LOGIN_DEF					_T("")
#define AGSMS_REQSLOT_ACCOUNT_PASSWORD_DEF				_T("")
#define AGSMS_REQSLOT_ACCOUNT_ENDPOINT_DEF				_T("")
#define AGSMS_REQSLOT_ACCOUNT_DESCRIPTION_DEF			_T("")
#define AGSMS_REQSLOT_ACCOUNT_STREAM_QUOTA_DEF			0L
#define AGSMS_REQSLOT_ACCOUNT_MESSAGE_ALLOWED_DEF		0L
#define AGSMS_REQSLOT_ACCOUNT_MAX_PRIORITY_DEF			0L
#define AGSMS_REQSLOT_ACCOUNT_DEFAULT_PRIORITY_DEF		0L
#define AGSMS_REQSLOT_ACCOUNT_DELAY_MSG_DEF				0L
#define AGSMS_REQSLOT_ACCOUNT_BROADCAST_DEF				0L
#define AGSMS_REQSLOT_ACCOUNT_ADMIN_DEF					0L
#define AGSMS_REQSLOT_ACCOUNT_DISABLED_DEF				0L

#define AGSMS_RESSLOT_ACCOUNT_MESSAGE_SENT				AGSMS_DB_TACCOUNT_MESSAGE_SENT

#define AGSMS_REQSLOT_ACCOUNT_LIST						_T("USER_LIST")

//***** Console requests *****
// Extension management.
#define AGSMS_REQ_LIST_CURRENT_TASKS					_T("r_lst_tsk")

#define AGSMS_REQSLOT_TASKS								_T("TASKS")
#define AGSMS_REQSLOT_TASK_ID							_T("TASK_ID")
#define AGSMS_REQSLOT_TASK_NOTIFICATION					_T("TASK_NOTIFICATION")
#define AGSMS_REQSLOT_TASK_STATE						_T("TASK_STATE")

#define AGSMS_REQ_EXTENSION_LOG							_T("r_ext_log")

#define AGSMS_REQSLOT_EXTENSION_LOG						_T("EXTENSION_LOG")
#define AGSMS_REQSLOT_EXTENSION_LOG_STATUS				_T("STATUS")
#define AGSMS_REQSLOT_EXTENSION_LOG_CONNECTIONS			_T("CONNECTIONS")
#define AGSMS_REQSLOT_EXTENSION_LOG_ERRORS				_T("ERRORS")

// Settings.
#define AGSMS_REQ_GET_SETTINGS							_T("r_set_get")

#define AGSMS_RESSLOT_SETTINGS							_T("SETTINGS")

#define AGSMS_REQ_SET_SETTINGS							_T("r_set_set")

#define AGSMS_REQSLOT_SETTINGS							_T("SETTINGS")

#define AGSMS_REQSLOT_PREFS_INFO_LEVEL					_T("InfoLevel")
#define AGSMS_REQSLOT_PREFS_CONSOLE_LOG_LEVEL			_T("ConsoleLogLevel")
#define AGSMS_REQSLOT_PREFS_FILE_LOG_LEVEL				_T("FileLogLevel")
#define AGSMS_REQSLOT_PREFS_DATABASE_LOG_LEVEL			_T("DatabaseLogLevel")
#define AGSMS_REQSLOT_PREFS_EMAIL_NOTIF_LEVEL			_T("EmailNotifLevel")
#define AGSMS_REQSLOT_PREFS_SMS_NOTIF_LEVEL				_T("SmsNotifLevel")
#define AGSMS_REQSLOT_PREFS_EMAIL_NOTIF_ADDRESS			_T("EmailNotifAddress")
#define AGSMS_REQSLOT_PREFS_SMS_NOTIF_ADDRESS			_T("SmsNotifAddress")

// Services management.
#define AGSMS_REQ_INSERT_SERVICE						_T("r_srv_ins")
#define AGSMS_REQ_REMOVE_SERVICE						_T("r_srv_del")
#define AGSMS_REQ_START_SERVICE							_T("r_srv_sta")
#define AGSMS_REQ_STOP_SERVICE							_T("r_srv_stp")

#define AGSMS_REQSLOT_SERVICE							_T("SERVICE")

#define AGSMS_REQ_SET_SRV_DEV							_T("r_adm_set_srv_dev")
#define AGSMS_REQ_LIST_SRVS_DEVS						_T("r_adm_list_srvs_devs")

// Queue management.
#define AGSMS_REQ_SRV_QUEUE_INS							_T("r_svq_ins")
#define AGSMS_REQ_SRV_QUEUE_UPD							_T("r_svq_upd")
#define AGSMS_REQ_SRV_QUEUE_DEL							_T("r_svq_del")
#define AGSMS_REQ_SRV_QUEUE_LST							_T("r_svq_lst")

#define AGSMS_REQSLOT_QUEUE_TYPE						_T("QUEUE_TYPE")

#define AGSMS_REQSLOTVAL_QUEUE_TO_BE_SENT				0L
#define AGSMS_REQSLOTVAL_QUEUE_BEING_SENT				1L
#define AGSMS_REQSLOTVAL_QUEUE_NOT_SENT					2L

#define AGSMS_RESSLOT_QUEUE_TO_BE_SENT					_T("TO_BE_SENT")
#define AGSMS_RESSLOT_QUEUE_BEING_SENT					_T("BEING_SENT")
#define AGSMS_RESSLOT_QUEUE_NOT_SENT					_T("NOT_SENT")

// Devices management.
#define AGSMS_REQ_INSERT_DEVICE							_T("r_dev_ins")
#define AGSMS_REQ_REMOVE_DEVICE							_T("r_dev_del")
#define AGSMS_REQ_START_DEVICE							_T("r_dev_sta")
#define AGSMS_REQ_STOP_DEVICE							_T("r_dev_stp")

#define AGSMS_REQSLOT_DEVICE							_T("DEVICE")

#define AGSMS_REQ_DEVICE_STATE							_T("r_dev_ste")

#define AGSMS_REQSLOT_DEVICE_STATE						_T("DEVICE_STATE")

#define AGSMS_REQ_DEVICE_LOG							_T("r_dev_log")

#define AGSMS_REQSLOT_DEVICE_LOG						_T("DEVICE_LOG")

// Database synchronisation.
#define AGSMS_REQ_DB_SYNC_ALIAS							_T("r_syn_als")

// Database SQL query.
#define AGSMS_REQ_EXEC_SQL								_T("r_exec_sql")

#define AGSMS_REQSLOT_EXEC_SQL_QUERY_STRING				_T("QueryString")

//***** Mobile simulation *****
// Messages.
#define AGSMS_REQ_SIMULATION_RECV						_T("r_simul_recv")

#define AGSMS_REQSLOT_SIMUL_RECV_MESSAGE				AGSMS_INCOMING_MESSAGE
#define AGSMS_REQSLOT_SIMUL_RECV_MESSAGE_ORIGIN			AGSMS_INCOMING_MESSAGE_ORIGIN
#define AGSMS_REQSLOT_SIMUL_RECV_SERVICE				_T("Service")

#endif	// ndef AGSMS_EXT_DEFINES_H
