<html>
	<head>
		<title>Exemple d'application LDAP avec PHP - Annuaires LDAP - Marcel Rizcallah</title>
	</head>
	<body>
		<?php
		echo "<h3>Test de l'installation de LDAP avec PHP</h3>";
		
		//Mettre ici l'adresse du serveur LDAP et le port dans une URL
		$serveur = "localhost:10000";
		echo "Connexion avec le serveur ".$serveur."<p>";
		$ds=ldap_connect($serveur);
		if ($ds) 
		{ 
			echo "Liaison Anonyme...<br>"; 
			$r=ldap_bind($ds);
			if ($r) 
			{
				$filtre="objectclass=person";
				echo "Recherche des objets avec le filtre : ".$filtre."<br>";
				// Recherche de tous les objets correspondant au critre de filtre
				$sr=ldap_search($ds,"dc=valoris,dc=com", $filtre);  
				if ($sr) 
				{
					echo "Le nombre d'entres retournes est ".ldap_count_entries($ds,$sr)."<p>";
					echo "Lecture des 5 premires entres ...<p>";
					$info = ldap_get_entries($ds, $sr);
					for ($i=0; $i<$info["count"] & $i < 5; $i++) 
					{
						echo "Entre ".($i+1)."<br>";
						echo "dn est : ". $info[$i]["dn"] ."<br>";
						echo "cn : ". $info[$i]["cn"][0] ."<br>";
						echo "sn : ". $info[$i]["sn"][0] ."<p>";
					} 
				}
			} 
			else 
			{
				echo "<h4>Impossible de s'authentifier en anonyme au serveur LDAP.</h4>";
			}
			echo "Fermeture de la connexion";
			ldap_close($ds);
		} 
		else 
		{
			echo "<h4>Impossible de se connecter au serveur LDAP.</h4>";
		}
		?> 
	</body>
</html>
