<?php
 	//Exemple de script avec ldap_delete
	//----------------------------------
	
 	//Mettre ici l'adresse du serveur LDAP et le port dans une URL
	$serveur = "localhost:10000";
	echo "Connexion avec le serveur ".$serveur."<p>";
	$ds=ldap_connect($serveur);
	if ($ds) 
	{ 
		echo "Identification...<br>"; 
		//Attention, il faut avoir les droits de suppression
		//Une identification anonyme ne suffit pas !
		$r=ldap_bind($ds, "cn=Directory Manager", "secret");
		if ($r) 
		{
			$filtre="uid=jbert";
			echo "Recherche des objets avec le filtre : ".$filtre."<br>";
			// Recherche de tous les objets correspondant au critre de filtre
			$sr=ldap_search($ds,"dc=valoris,dc=com", $filtre);  
			if ($sr) 
			{
				echo "Le nombre d'entres renvoy est ".ldap_count_entries($ds,$sr)."<p>";
				echo "<b>Lecture de la premire entre ...</b><br>";
				$entry = ldap_first_entry ($ds, $sr);
				if ($entry) 
				{
					while($entry)
					{
						//Lecture du DN de l'entre
						$dn = ldap_get_dn($ds,$entry);
						//Suppression de l'entre
						if (ldap_delete($ds, $dn)) 
						{
						    echo "Entre supprime avec succs.<br>";
						}						
						$entry = ldap_next_entry($ds, $entry);
						if ($entry) 
						{
							echo "<p><b>Lecture de l'entre suivante ...</b><br>";
						}
					} // while
				}
			}
		} 
		else 
		{
			echo "Impossible de s'authentifier au serveur LDAP.";
		}
		echo "<p><b>Fermeture de la connexion</b>";
		ldap_close($ds);
	} 
	else 
	{
		echo "Impossible de se connecter au serveur LDAP.";
	}


?>