<?php
 	//Exemple de script avec ldap_first_entry et ldap_next_entry
	//----------------------------------------------------------
	
 	//Mettre ici l'adresse du serveur LDAP et le port dans une URL
	$serveur = "localhost:10000";
	echo "Connexion avec le serveur ".$serveur."<p>";
	$ds=ldap_connect($serveur);
	if ($ds) 
	{ 
		echo "Liaison Anonyme...<br>"; 
		$r=ldap_bind($ds);
		if ($r) 
		{
			$filtre="objectclass=person";
			echo "Recherche des objets avec le filtre : ".$filtre."<br>";
			// Recherche de tous les objets correspondant au critre de filtre
			$sr=ldap_search($ds,"dc=valoris,dc=com", "objectclass=person");  
			if ($sr) 
			{
				echo "Le nombre d'entres renvoy est ".ldap_count_entries($ds,$sr)."<p>";
				echo "<b>Lecture de la premire entre ...</b><br>";
				$entry = ldap_first_entry ($ds, $sr);
				if ($entry) 
				{
					while($entry)
					{
						//Affichage des attributs de cette entre
						$attrs = ldap_get_attributes($ds, $entry);
						echo $attrs["count"]." attributs dans cette entre :<br>";
						for ($i=0; $i<$attrs["count"]; $i++)
						{
						    echo $attrs[$i]."=".$attrs[$attrs[$i]][0]."<br>";
						}
						
						$entry = ldap_next_entry($ds, $entry);
						if ($entry) 
						{
							echo "<p><b>Lecture de l'entre suivante ...</b><br>";
						}
					} // while
				}
			}
		} 
		else 
		{
			echo "Impossible de s'authentifier en anonyme au serveur LDAP.";
		}
		echo "<p><b>Fermeture de la connexion</b>";
		ldap_close($ds);
	} 
	else 
	{
		echo "Impossible de se connecter au serveur LDAP.";
	}


?>