<?php
 	//Exemple de script avec ldap_delete
	//----------------------------------
	
 	//Mettre ici l'adresse du serveur LDAP et le port dans une URL
	$serveur = "localhost:10000";
	echo "Connexion avec le serveur ".$serveur."<p>";
	$ds=ldap_connect($serveur);
	if ($ds) 
	{ 
		echo "Identification...<br>"; 
		//Attention, il faut avoir les droits de suppression
		//Une identification anonyme ne suffit pas !
		$r=ldap_bind($ds, "cn=Directory Manager", "rizcallah");
		if ($r) 
		{
			$filtre="uid=PTurand";
			echo "Recherche des objets avec le filtre : ".$filtre."<br>";
			// Recherche de tous les objets correspondant au critre de filtre
			$sr=ldap_search($ds,"dc=valoris,dc=com", $filtre);  
			if ($sr) 
			{
				echo "Le nombre d'entres renvoy est ".ldap_count_entries($ds,$sr)."<p>";
				echo "<b>Lecture de la premire entre ...</b><br>";
				$entry = ldap_first_entry ($ds, $sr);
				if ($entry) 
				{
					//Lecture du DN de l'entre
					$dn = ldap_get_dn($ds,$entry);
					
					//Ajouter une adresse de messagerie
					$attributes["mail"]="paul.turand@company.com";
					ldap_mod_add ($ds,$dn,$attributes);
					
					//Il faut relire l'entre pour avoir les attributs ajoutes !
					$sr=ldap_search($ds,"dc=valoris,dc=com", $filtre);  
					$entry = ldap_first_entry ($ds, $sr);
					//Lecture des attributs  nouveau 
					$attrs = ldap_get_attributes($ds, $entry);
					if (isset($attrs["mail"]))
					{
						//Afficher les valeurs
						for ($i=0; $i<$attrs["mail"]["count"]; $i++)
						    echo "mail=".$attrs["mail"][$i]."<br>";
	
						//Supprimer toutes les valeurs mail
						for ($i=0; $i<$attrs["mail"]["count"]; $i++)
						{
							$attributes["mail"]=$attrs["mail"][$i];
							ldap_mod_del ($ds,$dn,$attributes);
						}
					}
					
					//Modifier un attribut
					$modify["cn"]="Pierre Turand";
					ldap_mod_replace($ds, $dn, $modify);
				}
			}
		} 
		else 
		{
			echo "Impossible de s'authentifier au serveur LDAP.";
		}
		echo "<p><b>Fermeture de la connexion</b>";
		ldap_close($ds);
	} 
	else 
	{
		echo "Impossible de se connecter au serveur LDAP.";
	}
?>