/*
	Exemple de programme JNDI : Recherche.java
	Livre "Construire un annuaire d'entreprise avec LDAP"
	Auteur : Marcel Rizcallah
*/
import java.util.Hashtable;
import java.util.Enumeration;

import javax.naming.*;
import javax.naming.directory.*;

class Search 
{
	public static void main(String[] args) 
	{
		Hashtable env = new Hashtable();
		
		//Dfinit la classe a utiliser comme fournisseur de service d'annuaire
		env.put(Context.INITIAL_CONTEXT_FACTORY, "com.sun.jndi.ldap.LdapCtxFactory");

		//Dfinit l'adresse de l'annuaire LDAP
		env.put(Context.PROVIDER_URL, "ldap://localhost:1389");
		
		//Fournir une identification  l'annuaire
		env.put(Context.SECURITY_AUTHENTICATION, "simple"); 
		env.put(Context.SECURITY_PRINCIPAL, "cn=Directory Manager"); 
		env.put(Context.SECURITY_CREDENTIALS, "password"); 
		
		try {
			//Recuperer un pointeur sur contexte
			DirContext ctx = new InitialDirContext(env);
			
			//Dfinir les options de recherche
			SearchControls constraints = new SearchControls();
			constraints.setSearchScope(SearchControls.SUBTREE_SCOPE);
			
			//Prciser les options de recherche, le DN de la base et le filtre
			NamingEnumeration results = ctx.search("o=entreprise.com", "objectclass=inetorgperson", constraints);
			
			//Pour chaque entre, afficher les attributs
			while (results != null && results.hasMore()) 
			{
				//Lire une entre
				SearchResult entry = (SearchResult)results.next();
				
				//Imprimer le DN
				System.out.println("DN: " + entry.getName());
				
				Attributes attrs = entry.getAttributes();
				if (attrs == null) 
				{
					System.out.println("Pas d'attributs");
				} 
				else 
				{
					//Afficher chaque attribut
					for (NamingEnumeration attEnum = attrs.getAll(); attEnum.hasMoreElements();) 
					{
						Attribute attr = (Attribute)attEnum.next();
						String attrId = attr.getID();
						//Afficher toutes les valeurs d'un attribut
						for (Enumeration vals = attr.getAll(); vals.hasMoreElements();
							 System.out.println(attrId + ": " + vals.nextElement()));
					}
				}
				System.out.println();
			}
		} 
		catch (NamingException e) 
		{
			System.err.println("La recherche a echouee");
			e.printStackTrace();
		}
	}
}