Object subclass: #Fourchette
	instanceVariableNames: 'semaphore '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Philosophes'!

!Fourchette methodsFor: 'as yet unclassified' stamp: 'xb 12/6/2001 16:16'!
initialize
	semaphore := Semaphore forMutualExclusion! !

!Fourchette methodsFor: 'as yet unclassified' stamp: 'xb 12/6/2001 16:13'!
semaphore
	^semaphore! !

!Fourchette methodsFor: 'as yet unclassified' stamp: 'xb 12/6/2001 16:14'!
semaphore: unSemaphore
	semaphore := unSemaphore! !

!Fourchette methodsFor: 'as yet unclassified' stamp: 'xb 12/6/2001 15:59'!
signal
	semaphore signal.! !

!Fourchette methodsFor: 'as yet unclassified' stamp: 'xb 12/6/2001 15:59'!
wait
	semaphore wait.! !

"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

Fourchette class
	instanceVariableNames: ''!

!Fourchette class methodsFor: 'as yet unclassified' stamp: 'xb 12/6/2001 16:18'!
new
	^super new initialize! !


Object subclass: #Philosophe
	instanceVariableNames: 'fourchetteGauche fourchetteDroite nom etat '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Philosophes'!

!Philosophe methodsFor: 'as yet unclassified' stamp: 'xb 12/6/2001 16:11'!
etat
	^etat! !

!Philosophe methodsFor: 'as yet unclassified' stamp: 'xb 12/6/2001 16:49'!
etat: unEtat
	etat := unEtat.
	Transcript cr; show: self nom printString,' est dans l''tat ', unEtat! !

!Philosophe methodsFor: 'as yet unclassified' stamp: 'xb 12/6/2001 16:11'!
fourchetteDroite
	^fourchetteDroite! !

!Philosophe methodsFor: 'as yet unclassified' stamp: 'xb 12/6/2001 16:11'!
fourchetteDroite: uneFourchette
	fourchetteDroite := uneFourchette! !

!Philosophe methodsFor: 'as yet unclassified' stamp: 'xb 12/6/2001 16:10'!
fourchetteGauche
	^fourchetteGauche! !

!Philosophe methodsFor: 'as yet unclassified' stamp: 'xb 12/6/2001 16:10'!
fourchetteGauche: uneFourchette
	fourchetteGauche := uneFourchette! !

!Philosophe methodsFor: 'as yet unclassified' stamp: 'xb 12/6/2001 16:34'!
fourchetteGauche: fGauche fourchetteDroite: fDroite
	self fourchetteGauche: fGauche; fourchetteDroite: fDroite! !

!Philosophe methodsFor: 'as yet unclassified' stamp: 'xb 12/6/2001 16:07'!
mange
	self etat: #philosopheMangeant.
	( Random new next * 20 ) rounded timesRepeat: [Processor yield]! !

!Philosophe methodsFor: 'as yet unclassified' stamp: 'xb 12/6/2001 16:11'!
nom
	^nom! !

!Philosophe methodsFor: 'as yet unclassified' stamp: 'xb 12/6/2001 16:22'!
nom: unNom	
	nom := unNom! !

!Philosophe methodsFor: 'as yet unclassified' stamp: 'xb 12/6/2001 16:43'!
pense
	self etat: #philosophePensant.
	( Random new next * 20 ) rounded timesRepeat: [Processor yield]! !

!Philosophe methodsFor: 'as yet unclassified' stamp: 'xb 12/6/2001 16:49'!
philosopheCycle: rep
	[rep timesRepeat: [
			self pense.
			self recupereFourchettes.
			self mange.
			self relacheFourchettes.].
		self etat: # philosopheEndormi.] fork! !

!Philosophe methodsFor: 'as yet unclassified' stamp: 'xb 12/6/2001 16:08'!
recupereFourchettes
	self etat: #philosopheAffame.
	nom \\ 2 == 0
	ifTrue: [
		self fourchetteGauche wait.
		self fourchetteDroite wait.]
	ifFalse:[
		self fourchetteDroite wait.
		self fourchetteGauche wait.]! !

!Philosophe methodsFor: 'as yet unclassified' stamp: 'xb 12/6/2001 16:08'!
relacheFourchettes
	self etat: #philosophePosant.
	self fourchetteDroite signal.
	self fourchetteGauche signal.! !

"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

Philosophe class
	instanceVariableNames: ''!

!Philosophe class methodsFor: 'as yet unclassified' stamp: 'xb 12/6/2001 16:22'!
new: nom	
	^self new nom: nom! !


Object subclass: #TableDePhilosophes
	instanceVariableNames: 'nombreDeDineurs fourchettes philosophes '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Philosophes'!

!TableDePhilosophes methodsFor: 'as yet unclassified' stamp: 'xb 12/6/2001 16:06'!
dine: rep
	1 to: self nombreDeDineurs do: [:p |
		(self philosophes at: p) philosopheCycle: rep].! !

!TableDePhilosophes methodsFor: 'as yet unclassified' stamp: 'xb 12/6/2001 16:12'!
fourchettes
	^fourchettes! !

!TableDePhilosophes methodsFor: 'as yet unclassified' stamp: 'xb 12/6/2001 16:13'!
fourchettes: uneCollection
	fourchettes := uneCollection! !

!TableDePhilosophes methodsFor: 'as yet unclassified' stamp: 'xb 12/6/2001 16:15'!
initialize: n
	self nombreDeDineurs: n.
	self fourchettes: (Array new: n).
	self philosophes: (Array new: n).
	1 to: n do: [:p |
		self fourchettes at: p put: (Fourchette new).
		self philosophes at: p put: (Philosophe new: p)].
	1 to: n do: [:p |
		(self philosophes at: p) fourchetteGauche: (self fourchettes at: p) fourchetteDroite: (self fourchettes at: ((p\\n) + 1))].! !

!TableDePhilosophes methodsFor: 'as yet unclassified' stamp: 'xb 12/6/2001 16:12'!
nombreDeDineurs
	^nombreDeDineurs! !

!TableDePhilosophes methodsFor: 'as yet unclassified' stamp: 'xb 12/6/2001 16:12'!
nombreDeDineurs: unNombre
	nombreDeDineurs := unNombre! !

!TableDePhilosophes methodsFor: 'as yet unclassified' stamp: 'xb 12/6/2001 16:13'!
philosophes
	^philosophes! !

!TableDePhilosophes methodsFor: 'as yet unclassified' stamp: 'xb 12/6/2001 16:13'!
philosophes: uneCollection
	philosophes := uneCollection! !

"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

TableDePhilosophes class
	instanceVariableNames: ''!

!TableDePhilosophes class methodsFor: 'as yet unclassified' stamp: 'xb 12/6/2001 16:26'!
new
	^self new: 5! !

!TableDePhilosophes class methodsFor: 'as yet unclassified' stamp: 'xb 12/6/2001 16:36'!
new: nbDineurs
	self halt.
	^super new initialize: nbDineurs ! !
