'From Squeak3.0 of 4 February 2001 [latest update: #3545] on 6 December 2001 at 2:56:11 pm'!
PluggableTextMorph subclass: #MAT
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Morphic-MAT'!
PluggableTextMorph subclass: #MATXB
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Morphic-MATXB'!

!Object methodsFor: 'MATXB' stamp: 'XB 7/24/2001 17:33'!
isMATAcceptable
	^false! !

!Object methodsFor: 'MATXB' stamp: 'XB 7/24/2001 17:38'!
isSketch
	^false! !

!Object methodsFor: 'MATXB' stamp: 'XB 7/24/2001 17:38'!
isSound
	^false! !

!Object methodsFor: 'MATXB' stamp: 'XB 7/24/2001 17:38'!
isText
	^false! !


!MAT methodsFor: 'menu' stamp: 'AM 4/29/1999 08:13'!
addCustomMenuItems: aCustomMenu hand: aHandMorph
	super addCustomMenuItems: aCustomMenu hand: aHandMorph.
	aCustomMenu addLine.
	aCustomMenu add: 'save as HTML' action: #saveAsHTML.! !

!MAT methodsFor: 'menu' stamp: 'AM 12/15/1998 09:47'!
saveAsHTML
	self handleEdit: [textMorph editor saveAsHTML]! !

!MAT methodsFor: 'dropping/grabbing' stamp: 'AM 5/7/1999 18:19'!
acceptDroppingMorph: aMorph event: evt
	| contents form soundName txt attrib |
	(aMorph isKindOf: SketchMorph) ifTrue: [
		form _ aMorph form copy.
		aMorph delete.
		attrib _ TextAnchor new anchoredMorph: form.
		txt _ '   ' asText.
		txt addAttribute: attrib from: 2 to: 2.
		self handleEdit: [textMorph editor zapSelectionWith: txt].
	].
	(aMorph isKindOf: SoundTile) ifTrue: [
		" generate corresponding link "
		soundName _ aMorph literal copy.
		aMorph delete.
		self handleEdit: [textMorph editor zapSelectionWith: '**SOUND|',soundName,'**'].
	].
	(aMorph isKindOf: TextMorph) ifTrue: [
		contents _ aMorph contents copy.
		aMorph delete.
		self handleEdit: [textMorph editor zapSelectionWith: contents].
	].
! !

!MAT methodsFor: 'dropping/grabbing' stamp: 'AM 5/7/1999 18:20'!
wantsDroppedMorph: aMorph event: evt
	" allow only SketchMorph, SoundTile, and TextMorph to be dropped "

	^ (aMorph isKindOf: SketchMorph) |
	  (aMorph isKindOf: SoundTile) |
	  (aMorph isKindOf: TextMorph)
! !


!MAT class methodsFor: 'utilities' stamp: 'AM 12/2/1998 21:02'!
generateHTMLRGBfromColor: aColor
	"MAT generateHTMLRGBfromColor: Color black"
	| r g b |
	(aColor isKindOf: Color) ifFalse: [^nil].

	r _ (aColor red * 255) asInteger.
	(r < 16)
	ifTrue: [r _ '0', r asHexDigit asString]
	ifFalse: [r _ r hex copyFrom: 4 to: 5].

	g _ (aColor green * 255) asInteger.
	(g < 16)
	ifTrue: [g _ '0', g asHexDigit asString]
	ifFalse: [g _ g hex copyFrom: 4 to: 5].

	b _ (aColor blue * 255) asInteger.
	(b < 16)
	ifTrue: [b _ '0', b asHexDigit asString]
	ifFalse: [b _ b hex copyFrom: 4 to: 5].

	^'#',r,g,b.! !

!MAT class methodsFor: 'instance creation' stamp: 'AM 12/15/1998 10:15'!
new
	| aMAT |
	aMAT _ super new.
	aMAT on: self text: nil accept: nil readSelection: nil menu: nil.
	aMAT color: Color white.
	^aMAT! !


!MATXB methodsFor: 'menu' stamp: 'XB 7/24/2001 17:27'!
addCustomMenuItems: aCustomMenu hand: aHandMorph
	super addCustomMenuItems: aCustomMenu hand: aHandMorph.
	aCustomMenu addLine.
	aCustomMenu add: 'save as HTML' action: #saveAsHTML.! !

!MATXB methodsFor: 'menu' stamp: 'XB 7/24/2001 17:54'!
saveAsHTML
	self handleEdit: [textMorph editor saveAsHTML2]! !

!MATXB methodsFor: 'dropping/grabbing' stamp: 'XB 7/24/2001 17:51'!
acceptDroppingMorph: aMorph event: evt
	aMorph isSketch ifTrue: [self acceptDroppingSketch: aMorph event: evt].
	aMorph isText ifTrue: [self acceptDroppingText: aMorph event: evt].
	aMorph isSound ifTrue: [self acceptDroppingSound: aMorph event: evt].
	aMorph delete.

! !

!MATXB methodsFor: 'dropping/grabbing' stamp: 'XB 7/24/2001 17:52'!
acceptDroppingSketch: aMorph event: evt
	|  attrib txt |
	attrib _ TextAnchor new anchoredMorph: aMorph form copy.
	txt _ '   ' asText.
	txt addAttribute: attrib from: 2 to: 2.
	self handleEdit: [textMorph editor zapSelectionWith: txt].
! !

!MATXB methodsFor: 'dropping/grabbing' stamp: 'XB 7/24/2001 17:51'!
acceptDroppingSound: aMorph event: evt
	self handleEdit: [textMorph editor zapSelectionWith: '**SOUND|',(aMorph literal),'**'].


! !

!MATXB methodsFor: 'dropping/grabbing' stamp: 'XB 7/24/2001 17:51'!
acceptDroppingText: aMorph event: evt
	self handleEdit: [textMorph editor zapSelectionWith: aMorph contents copy].
! !

!MATXB methodsFor: 'dropping/grabbing' stamp: 'XB 7/24/2001 17:36'!
wantsDroppedMorph: aMorph event: evt
	^ aMorph isMATAcceptable
! !


!MATXB class methodsFor: 'instance creation' stamp: 'XB 7/26/2001 16:31'!
new
	| aMAT |
	aMAT _ super new.
	aMAT on: self text: nil accept: nil readSelection: nil menu: nil.
	aMAT color: Color white.
	^aMAT! !


!ParagraphEditor methodsFor: 'MAT' stamp: 'AM 12/15/1998 10:42'!
isStringASound: aString
	"check the string to see if it is a SOUND link"

	"basic error checking"
	(aString isNil) ifTrue: [^nil].
	"if sound, extract sound"
	(aString beginsWith: 'SOUND|')
	ifTrue: [^(aString copyFrom: 7 to: aString size)]
	ifFalse: [^nil].! !

!ParagraphEditor methodsFor: 'MAT' stamp: 'AM 6/16/1999 15:43'!
linkFor: aString
	| fileName returnStr soundName entry samples samplingRate f |

	(soundName _ self isStringASound: aString) ifNotNil: [
		"SOUND link is encountered"
		fileName _ FillInTheBlank request: 'Save as AIFF' initialAnswer: soundName,'.aif'.
		fileName isEmpty ifTrue: [^nil].
		" retrieve samples and sampling rate info "
		entry _ SampledSound soundLibrary
			at: soundName asString
			ifAbsent:
				[self inform: soundName asString, ' not found in the Sound Library'.
				^ nil].
		entry ifNil: [^ nil].
		samples _ entry at: 1.
		samples class isBytes ifTrue: [samples _ SampledSound convert8bitSignedTo16Bit: samples].
		samplingRate _ (entry at: 2) asInteger.
		f _ (FileStream fileNamed: fileName) binary.
		AbstractSound new storeAIFFSamples: samples samplingRate: samplingRate on: f.
		f close.
		returnStr _ '<A HREF="',fileName,'">',fileName,'</A>'.
		^returnStr.
	].

	" don't know what to do, return nil "
	^nil.
! !

!ParagraphEditor methodsFor: 'MAT' stamp: 'AM 12/15/1998 10:51'!
saveAsHTML
	| sourceStream targetStream aLine start end specialCharacter text htmlFileName file link |

	" create a new file "
	htmlFileName _ FillInTheBlank request: 'Save as HTML' initialAnswer: 'mat.htm'.
	htmlFileName isEmpty ifTrue: [^nil].
	file _ FileStream newFileNamed: htmlFileName.
	file text.

	specialCharacter _ $*.
	" translate Squeak-rendered text to HTML tags "
	text _ self text.
	text _ self translateSqueakToHTMLtags: text.

	sourceStream _ ReadStream on: text.
	targetStream _ WriteStream on: ''.
	[sourceStream atEnd] whileFalse: [
		aLine _ sourceStream upTo: (Character cr).
		" Now, look for links "
		start _ 1.
		[(start _ aLine indexOfSubCollection: (specialCharacter asString) 
				startingAt: start ifAbsent: [0]) ~= 0
			and: [start < aLine size]]
		whileTrue: ["extract **LINK** combination"
			(aLine at: start+1) = specialCharacter
			ifFalse: [start _ start + 1]
			ifTrue: [
				(end _ aLine indexOfSubCollection: (specialCharacter asString)  
					startingAt: (start+2) ifAbsent: [0]) ~= 0
				ifFalse: [start _ start + 2]
				ifTrue: [
					(aLine at: end+1) = specialCharacter
					ifFalse: [start _ end+1]
					ifTrue: [
						link _ self linkFor: (aLine copyFrom: start+2 to: end-1).
						link isNil ifFalse: [
							aLine _ aLine copyReplaceFrom: start to: end+1 with: link asString.
						].
						start _ end + 2.
					].
				].
			].
		]. " whileTrue: "
		targetStream nextPutAll: aLine.
		targetStream cr.
	]. " whileFalse: "

	" put HTML data into file "
	file nextPutAll: targetStream contents.
	file close.! !

!ParagraphEditor methodsFor: 'MAT' stamp: 'AM 4/29/1999 08:56'!
translateSqueakToHTMLtags: aText
	" translate Squeak-rendered text to HTML tags.
	TextAttribute's considered: TextEmphasis, TextURL, TextColor, TextFontChange "

	| runArray runs value values readStream targetStream rgbColor fontSize fileName |

	readStream _ ReadStream on: (aText string).
	targetStream _ WriteStream on: ''.
	targetStream nextPutAll: (HTMLformatter startPage: 'Page created in MAT').
	targetStream nextPutAll: '<PRE>'.
	runArray _ aText runs.
	runs _ runArray runs.
	values _ runArray values.
	1 to: (runs size) do: [:index |
		value _ values at: index.
		value do: [:attr |
			(attr isKindOf: TextEmphasis) ifTrue: [
				(attr = TextEmphasis bold) ifTrue: [targetStream nextPutAll: '<B>'].
				(attr = TextEmphasis italic) ifTrue: [targetStream nextPutAll: '<I>'].
				(attr = TextEmphasis underlined) ifTrue: [targetStream nextPutAll: '<U>'].
			].
			(attr isKindOf: TextColor) ifTrue: [
				rgbColor _ MAT generateHTMLRGBfromColor: (attr color).
				targetStream nextPutAll: '<FONT COLOR="',rgbColor,'">'.
			].
			(attr isKindOf: TextFontChange) ifTrue: [
				fontSize _ attr fontNumber + 2.
				targetStream nextPutAll: '<FONT SIZE="',fontSize asString,'">'.
			].
			(attr isKindOf: TextURL) ifTrue: [
				targetStream nextPutAll: '<A HREF="',attr info,'">'.
			].
			(attr isKindOf: TextAnchor) ifTrue: [
				fileName _ FillInTheBlank request: 'Save as GIF' initialAnswer: 'mat.gif'.
				fileName isEmpty
				ifFalse: [
					GIFReadWriter putForm: attr anchoredMorph onFileNamed: fileName.
					targetStream nextPutAll: '<IMG SRC="',fileName,'">'.
				].
				" skip '   ' part "
			].
		].
		targetStream nextPutAll: (readStream next: (runs at: index)).
		value do: [:attr |
			(attr isKindOf: TextEmphasis) ifTrue: [
				(attr = TextEmphasis bold) ifTrue: [targetStream nextPutAll: '</B>'].
				(attr = TextEmphasis italic) ifTrue: [targetStream nextPutAll: '</I>'].
				(attr = TextEmphasis underlined) ifTrue: [targetStream nextPutAll: '</U>'].
			].
			(attr isKindOf: TextColor) ifTrue: [targetStream nextPutAll: '</FONT>'].
			(attr isKindOf: TextFontChange) ifTrue: [targetStream nextPutAll: '</FONT>'].
			(attr isKindOf: TextURL) ifTrue: [targetStream nextPutAll: '</A>'].
		].
	].

	targetStream nextPutAll: '</PRE>'.
	targetStream nextPutAll: (HTMLformatter endPage).
	^targetStream contents.! !

!ParagraphEditor methodsFor: 'MATXB' stamp: 'XB 7/24/2001 18:04'!
createNewHTMLFile
	| htmlFileName file |
	htmlFileName _ FillInTheBlank request: 'Save as HTML' initialAnswer: 'mat.htm'.
	htmlFileName isEmpty ifTrue: [^nil].
	file _ FileStream newFileNamed: htmlFileName.
	file text.
	^file
! !

!ParagraphEditor methodsFor: 'MATXB' stamp: 'XB 7/26/2001 17:44'!
createTagsForTextAttributes: attributes ofStream: readStream index: index withRuns: runs
	|  targetStream fileName |

	targetStream := String new writeStream.

	attributes do: [:attr |
		(attr isKindOf: TextAnchor) 
			ifTrue: [
				fileName _ FillInTheBlank request: 'Save as GIF' initialAnswer: 'mat.gif'.
				fileName isEmpty
				ifFalse: [
					GIFReadWriter putForm: attr anchoredMorph onFileNamed: fileName.
					targetStream nextPutAll: '<IMG SRC="',fileName,'">']]
			ifFalse: [targetStream nextPutAll: attr htmlStartTag.]].

	targetStream nextPutAll: (readStream next: (runs at: index)).

	attributes do: [:attr | targetStream nextPutAll: attr htmlEndTag].

	^targetStream contents
	
	! !

!ParagraphEditor methodsFor: 'MATXB' stamp: 'XB 7/26/2001 16:53'!
generateHTMLCodeForLine: aLine

	| start specialCharacter end link aLineAsHTML |
	aLineAsHTML := aLine copy.
	specialCharacter := self specialMATCharacter.
	start _ 1.
	[(start _ aLineAsHTML indexOfSubCollection: (specialCharacter asString) startingAt: start ifAbsent: [0]) ~= 0 and: [start < aLine size]]
		whileTrue: ["extract **LINK** combination"
			(aLineAsHTML at: start+1) = specialCharacter
				ifFalse: [start _ start + 1]
				ifTrue: [
					(end _ aLineAsHTML indexOfSubCollection: (specialCharacter asString) startingAt: (start+2) ifAbsent: [0]) ~= 0
				 		ifFalse: [start _ start + 2]
						ifTrue: [
							(aLineAsHTML at: end+1) = specialCharacter
							ifFalse: [start _ end+1]
							ifTrue: [
								link _ self linkFor2: (aLine copyFrom: start+2 to: end-1).
								link isNil ifFalse: [
								  	 aLineAsHTML_ aLineAsHTML copyReplaceFrom: start to: end+1 with: link asString]]]]].
	^aLineAsHTML! !

!ParagraphEditor methodsFor: 'MATXB' stamp: 'XB 7/26/2001 16:55'!
linkFor2: aString
	| fileName soundName entry samples samplingRate f |

	(soundName _ self isStringASound: aString) ifNotNil: [
		"SOUND link is encountered"
		fileName _ FillInTheBlank request: 'Save as AIFF' initialAnswer: soundName,'.aif'.
		fileName isEmpty ifTrue: [^nil].
		" retrieve samples and sampling rate info "
		entry _ SampledSound soundLibrary
			at: soundName asString
			ifAbsent:
				[self inform: soundName asString, ' not found in the Sound Library'.
				^ nil].
		entry ifNil: [^ nil].
		samples _ entry at: 1.
		samples class isBytes ifTrue: [samples _ SampledSound convert8bitSignedTo16Bit: samples].
		samplingRate _ (entry at: 2) asInteger.
		f _ (FileStream fileNamed: fileName) binary.
		AbstractSound new storeAIFFSamples: samples samplingRate: samplingRate on: f.
		f close.
		^ '<A HREF="',fileName,'">',fileName,'</A>'].

	" don't know what to do, return nil "
	^nil.
! !

!ParagraphEditor methodsFor: 'MATXB' stamp: 'XB 7/25/2001 11:18'!
saveAsHTML2
	| sourceStream targetStream aLine text file |

	" create a new file "
	(file := self createNewHTMLFile) ifNil: [^nil].

	text _ self translateSqueakToHTMLtags2: self text.

	sourceStream _ ReadStream on: text.
	targetStream _ WriteStream on: ''.
	[sourceStream atEnd] whileFalse: [
		aLine _ sourceStream upTo: (Character cr).
		targetStream nextPutAll: (self generateHTMLCodeForLine: aLine);cr.]. 

	file nextPutAll: targetStream contents.
	file close.! !

!ParagraphEditor methodsFor: 'MATXB' stamp: 'XB 7/26/2001 16:53'!
specialMATCharacter
	^$*! !

!ParagraphEditor methodsFor: 'MATXB' stamp: 'XB 7/26/2001 17:44'!
translateSqueakToHTMLtags2: aText
	" translate Squeak-rendered text to HTML tags.
	TextAttribute's considered: TextEmphasis, TextURL, TextColor, TextFontChange "

	| runArray runs values targetStream readStream |
	readStream _ ReadStream on: (aText string).
	targetStream _ WriteStream on: ''.
	targetStream nextPutAll: (HTMLformatter startPage: 'Page created in MAT').
	targetStream nextPutAll: '<PRE>'.
	runArray _ aText runs.
	runs _ aText runs runs.
	values _ runArray values.

	1 to: (runs size) do: [:index |
		targetStream nextPutAll: (self createTagsForTextAttributes: (values at: index) ofStream: readStream index: index withRuns: runs) ; cr].

	targetStream nextPutAll: '</PRE>'.
	targetStream nextPutAll: (HTMLformatter endPage).
	^targetStream contents.! !


!SketchMorph methodsFor: 'MATXB' stamp: 'XB 7/24/2001 17:32'!
isMATAcceptable
	^true! !

!SketchMorph methodsFor: 'MATXB' stamp: 'XB 7/24/2001 17:38'!
isSketch
	^true! !


!SoundTile methodsFor: 'MATXB' stamp: 'XB 7/24/2001 17:35'!
isMATAcceptable
	^true! !

!SoundTile methodsFor: 'MATXB' stamp: 'XB 7/24/2001 17:37'!
isSound
	^true! !


!TextAnchor methodsFor: 'MATXB' stamp: 'XB 7/26/2001 16:36'!
htmlEndTag
	^String new! !


!TextColor methodsFor: 'MATXB' stamp: 'XB 7/26/2001 16:13'!
generateHTMLRGBfromColor: aColor
	"MAT generateHTMLRGBfromColor: Color black"
	| r g b |
	(aColor isKindOf: Color) ifFalse: [^nil].

	r _ (aColor red * 255) asInteger.
	(r < 16)
	ifTrue: [r _ '0', r asHexDigit asString]
	ifFalse: [r _ r hex copyFrom: 4 to: 5].

	g _ (aColor green * 255) asInteger.
	(g < 16)
	ifTrue: [g _ '0', g asHexDigit asString]
	ifFalse: [g _ g hex copyFrom: 4 to: 5].

	b _ (aColor blue * 255) asInteger.
	(b < 16)
	ifTrue: [b _ '0', b asHexDigit asString]
	ifFalse: [b _ b hex copyFrom: 4 to: 5].

	^'#',r,g,b.! !

!TextColor methodsFor: 'MATXB' stamp: 'XB 7/26/2001 16:17'!
htmlEndTag

	^'</FONT>'.! !

!TextColor methodsFor: 'MATXB' stamp: 'XB 7/26/2001 16:13'!
htmlStartTag
	| rgbColor |
	rgbColor _ self generateHTMLRGBfromColor: (self color).
	^'<FONT COLOR="',rgbColor,'">'.! !


!TextEmphasis methodsFor: 'MATXB' stamp: 'XB 7/26/2001 16:10'!
htmlEndTag
	(self = TextEmphasis bold) ifTrue: [^ '</B>'].
	(self = TextEmphasis italic) ifTrue: [^ '</I>'].
	(self = TextEmphasis underlined) ifTrue: [^'</U>' ]! !

!TextEmphasis methodsFor: 'MATXB' stamp: 'XB 7/26/2001 16:15'!
htmlStartTag
	(self = TextEmphasis bold) ifTrue: [^ '<B>'].
	(self = TextEmphasis italic) ifTrue: [^ '<I>'].
	(self = TextEmphasis underlined) ifTrue: [^'<U>' ]! !


!TextFontChange methodsFor: 'MATXB' stamp: 'XB 7/26/2001 16:18'!
htmlEndTag
	^ '</FONT>'.! !

!TextFontChange methodsFor: 'MATXB' stamp: 'XB 7/26/2001 16:18'!
htmlStartTag
	| fontSize |
	fontSize _ self fontNumber + 2.
	^ '<FONT SIZE="',fontSize asString,'">'.! !


!TextMorph methodsFor: 'MATXB' stamp: 'XB 7/24/2001 17:36'!
isMATAcceptable
	^true! !

!TextMorph methodsFor: 'MATXB' stamp: 'XB 7/24/2001 17:37'!
isText	
	^true! !


!TextURL methodsFor: 'MATXB' stamp: 'XB 7/26/2001 16:20'!
htmlEndTag
	^ '</A>'.! !

!TextURL methodsFor: 'MATXB' stamp: 'XB 7/26/2001 16:20'!
htmlStartTag
	^ '<A HREF="',self info,'">'.! !

ParagraphEditor removeSelector: #createTagsForTextAttributes:ofText:index:!
