/*------------------------------------------------------------------------------------------------*/
/* Script de cration de la base de donnes de l'tude de cas du "Cahier du Programmeur ASP.NET"  */
/* Langage : Transact SQL (test avec SQL Server 2000 et MSDE 2000)                               */
/*                                                                                                */
/* Ce script cre une base nomme 'SDS' (structure + donnes)                                    */
/*                                                                                                */
/* ATTENTION !! Si la base existe dj, elle sera supprime et recre !!                         */
/*                                                                                                */
/* Pour plus d'informations, voir : www.savonsdusoleil.com                                        */
/*											          */
/* Version : 1.2										  */
/* Date    : 10-04-03										  */
/*												  */
/* Syntaxe : osql -S<NomServeur> -E -iCahierASP-NET-CreationBase.sql				  */
/*												  */
/*------------------------------------------------------------------------------------------------*/

/*==============================*/
/*                              */
/*     Cration de la base      */
/*                              */
/*==============================*/

use Master
go

IF EXISTS (SELECT name FROM master.dbo.sysdatabases WHERE name = N'SDS')
BEGIN
	PRINT ' '
	PRINT ' '
	PRINT '-> Suppression de la base de donnees SDS actuelle'
	PRINT ' '

	DROP DATABASE [SDS]
	
END

PRINT ' '
PRINT ' '
PRINT '-> Creation de la base de donnees SDS'	
PRINT ' '

CREATE DATABASE SDS
GO

exec sp_dboption N'SDS', N'autoclose', N'false'
GO

exec sp_dboption N'SDS', N'bulkcopy', N'false'
GO

exec sp_dboption N'SDS', N'trunc. log', N'false'
GO

exec sp_dboption N'SDS', N'torn page detection', N'true'
GO

exec sp_dboption N'SDS', N'read only', N'false'
GO

exec sp_dboption N'SDS', N'dbo use', N'false'
GO

exec sp_dboption N'SDS', N'single', N'false'
GO

exec sp_dboption N'SDS', N'autoshrink', N'false'
GO

exec sp_dboption N'SDS', N'ANSI null default', N'false'
GO

exec sp_dboption N'SDS', N'recursive triggers', N'false'
GO

exec sp_dboption N'SDS', N'ANSI nulls', N'false'
GO

exec sp_dboption N'SDS', N'concat null yields null', N'false'
GO

exec sp_dboption N'SDS', N'cursor close on commit', N'false'
GO

exec sp_dboption N'SDS', N'default to local cursor', N'false'
GO

exec sp_dboption N'SDS', N'quoted identifier', N'false'
GO

exec sp_dboption N'SDS', N'ANSI warnings', N'false'
GO

exec sp_dboption N'SDS', N'auto create statistics', N'true'
GO

exec sp_dboption N'SDS', N'auto update statistics', N'true'
GO

use [SDS]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[FK_LigneCommande_Commande]') and OBJECTPROPERTY(id, N'IsForeignKey') = 1)
ALTER TABLE [dbo].[LigneCommande] DROP CONSTRAINT FK_LigneCommande_Commande
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[FK_Produit_FamilleProduit]') and OBJECTPROPERTY(id, N'IsForeignKey') = 1)
ALTER TABLE [dbo].[Produit] DROP CONSTRAINT FK_Produit_FamilleProduit
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[FK_Vente_FamilleProduit]') and OBJECTPROPERTY(id, N'IsForeignKey') = 1)
ALTER TABLE [dbo].[Vente] DROP CONSTRAINT FK_Vente_FamilleProduit
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[FK_Commande_Fournisseur]') and OBJECTPROPERTY(id, N'IsForeignKey') = 1)
ALTER TABLE [dbo].[Commande] DROP CONSTRAINT FK_Commande_Fournisseur
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[FK_RefFournisseur_Fournisseur]') and OBJECTPROPERTY(id, N'IsForeignKey') = 1)
ALTER TABLE [dbo].[ReferenceFournisseur] DROP CONSTRAINT FK_RefFournisseur_Fournisseur
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[FK_MouvementStock_Produit]') and OBJECTPROPERTY(id, N'IsForeignKey') = 1)
ALTER TABLE [dbo].[MouvementStock] DROP CONSTRAINT FK_MouvementStock_Produit
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[FK_LigneCommande_RefFournisseur]') and OBJECTPROPERTY(id, N'IsForeignKey') = 1)
ALTER TABLE [dbo].[LigneCommande] DROP CONSTRAINT FK_LigneCommande_RefFournisseur
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[FK_Vente_Region]') and OBJECTPROPERTY(id, N'IsForeignKey') = 1)
ALTER TABLE [dbo].[Vente] DROP CONSTRAINT FK_Vente_Region
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[CreerCommande]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[CreerCommande]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[DetailsCommande]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[DetailsCommande]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[EtatStock]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[EtatStock]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[HistoriqueStock]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[HistoriqueStock]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[ListeCommandes]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[ListeCommandes]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[ListeLignesCommandes]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[ListeLignesCommandes]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[VentesMensuellesParFamille]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[VentesMensuellesParFamille]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[VentesMensuellesParRegion]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[VentesMensuellesParRegion]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[Commande]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[Commande]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[FamilleProduit]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[FamilleProduit]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[Fournisseur]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[Fournisseur]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[LigneCommande]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[LigneCommande]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[MouvementStock]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[MouvementStock]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[Produit]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[Produit]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[ReferenceFournisseur]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[ReferenceFournisseur]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[Region]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[Region]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[Vente]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[Vente]
GO

/*==========================================*/
/*                                          */
/*       Cration des tables                */
/*                                          */
/*==========================================*/

PRINT ' '
PRINT ' '
PRINT '-> Creation des tables'
PRINT ' '

CREATE TABLE [Commande] (
	[ID_Commande] [int] IDENTITY (1, 1) NOT NULL ,
	[ID_Fournisseur] [int] NOT NULL ,
	[DateLivraison] [datetime] NOT NULL ,
	[Livree] [bit] NOT NULL 
) ON [PRIMARY]
GO

CREATE TABLE [FamilleProduit] (
	[ID_FamilleProduit] [int] IDENTITY (1, 1) NOT NULL ,
	[NomFamille] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL 
) ON [PRIMARY]
GO


CREATE TABLE [Fournisseur] (
	[ID_Fournisseur] [int] IDENTITY (1, 1) NOT NULL ,
	[NomFournisseur] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL ,
	[Telecopie] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL 
) ON [PRIMARY]
GO

CREATE TABLE [LigneCommande] (
	[ID_LigneCommande] [int] IDENTITY (1, 1) NOT NULL ,
	[ID_Commande] [int] NOT NULL ,
	[ID_ReferenceFournisseur] [int] NOT NULL ,
	[Quantite] [int] NOT NULL 
) ON [PRIMARY]
GO

CREATE TABLE [MouvementStock] (
	[ID_MouvementStock] [int] IDENTITY (1, 1) NOT NULL ,
	[ID_Produit] [int] NOT NULL ,
	[DateMouvement] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL ,
	[Quantite] [int] NOT NULL 
) ON [PRIMARY]
GO

CREATE TABLE [Produit] (
	[ID_Produit] [int] IDENTITY (1, 1) NOT NULL ,
	[ID_FamilleProduit] [int] NOT NULL ,
	[Code] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL ,
	[Designation] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL 
) ON [PRIMARY]
GO

CREATE TABLE [ReferenceFournisseur] (
	[ID_ReferenceFournisseur] [int] IDENTITY (1, 1) NOT NULL ,
	[ID_Fournisseur] [int] NOT NULL ,
	[Code] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL ,
	[Designation] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL 
) ON [PRIMARY]
GO

ALTER TABLE [Commande] WITH NOCHECK ADD 
	CONSTRAINT [PK_Commande] PRIMARY KEY  CLUSTERED 
	(
		[ID_Commande]
	)  ON [PRIMARY] 
GO

ALTER TABLE [Fournisseur] WITH NOCHECK ADD 
	CONSTRAINT [PK_Fournisseur] PRIMARY KEY  CLUSTERED 
	(
		[ID_Fournisseur]
	)  ON [PRIMARY] 
GO

ALTER TABLE [LigneCommande] WITH NOCHECK ADD 
	CONSTRAINT [PK_LigneCommande] PRIMARY KEY  CLUSTERED 
	(
		[ID_LigneCommande]
	)  ON [PRIMARY] 
GO

ALTER TABLE [ReferenceFournisseur] WITH NOCHECK ADD 
	CONSTRAINT [PK_RefFournisseur] PRIMARY KEY  CLUSTERED 
	(
		[ID_ReferenceFournisseur]
	)  ON [PRIMARY] 
GO

ALTER TABLE [Commande] WITH NOCHECK ADD 
	CONSTRAINT [DF_Commande_Livree] DEFAULT (0) FOR [Livree]
GO

ALTER TABLE [FamilleProduit] WITH NOCHECK ADD 
	CONSTRAINT [PK_FamilleProduit] PRIMARY KEY  NONCLUSTERED 
	(
		[ID_FamilleProduit]
	)  ON [PRIMARY] 
GO

ALTER TABLE [MouvementStock] WITH NOCHECK ADD 
	CONSTRAINT [PK_MouvementStock] PRIMARY KEY  NONCLUSTERED 
	(
		[ID_MouvementStock]
	)  ON [PRIMARY] 
GO

ALTER TABLE [Produit] WITH NOCHECK ADD 
	CONSTRAINT [PK_Produit] PRIMARY KEY  NONCLUSTERED 
	(
		[ID_Produit]
	)  ON [PRIMARY] 
GO

ALTER TABLE [Commande] ADD 
	CONSTRAINT [FK_Commande_Fournisseur] FOREIGN KEY 
	(
		[ID_Fournisseur]
	) REFERENCES [Fournisseur] (
		[ID_Fournisseur]
	)
GO

ALTER TABLE [LigneCommande] ADD 
	CONSTRAINT [FK_LigneCommande_Commande] FOREIGN KEY 
	(
		[ID_Commande]
	) REFERENCES [Commande] (
		[ID_Commande]
	) ON DELETE CASCADE ,
	CONSTRAINT [FK_LigneCommande_RefFournisseur] FOREIGN KEY 
	(
		[ID_ReferenceFournisseur]
	) REFERENCES [ReferenceFournisseur] (
		[ID_ReferenceFournisseur]
	)
GO

ALTER TABLE [MouvementStock] ADD 
	CONSTRAINT [FK_MouvementStock_Produit] FOREIGN KEY 
	(
		[ID_Produit]
	) REFERENCES [Produit] (
		[ID_Produit]
	)
GO

ALTER TABLE [Produit] ADD 
	CONSTRAINT [FK_Produit_FamilleProduit] FOREIGN KEY 
	(
		[ID_FamilleProduit]
	) REFERENCES [FamilleProduit] (
		[ID_FamilleProduit]
	)
GO

ALTER TABLE [ReferenceFournisseur] ADD 
	CONSTRAINT [FK_RefFournisseur_Fournisseur] FOREIGN KEY 
	(
		[ID_Fournisseur]
	) REFERENCES [Fournisseur] (
		[ID_Fournisseur]
	)
GO

CREATE TABLE [Region] (
	[ID_Region] [int] IDENTITY (1, 1) NOT NULL ,
	[Region] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL 
) ON [PRIMARY]
GO

CREATE TABLE [Vente] (
	[ID_Vente] [int] IDENTITY (1, 1) NOT NULL ,
	[ID_FamilleProduit] [int] NOT NULL ,
	[ID_Region] [int] NOT NULL ,
	[CodeMois] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL ,
	[Montant] [float] NOT NULL 
) ON [PRIMARY]
GO

ALTER TABLE [Region] WITH NOCHECK ADD 
	CONSTRAINT [PK_Region] PRIMARY KEY  CLUSTERED 
	(
		[ID_Region]
	)  ON [PRIMARY] 
GO

ALTER TABLE [Vente] WITH NOCHECK ADD 
	CONSTRAINT [PK_Vente] PRIMARY KEY  CLUSTERED 
	(
		[ID_Vente]
	)  ON [PRIMARY] 
GO

ALTER TABLE [Vente] ADD 
	CONSTRAINT [FK_Vente_FamilleProduit] FOREIGN KEY 
	(
		[ID_FamilleProduit]
	) REFERENCES [FamilleProduit] (
		[ID_FamilleProduit]
	),
	CONSTRAINT [FK_Vente_Region] FOREIGN KEY 
	(
		[ID_Region]
	) REFERENCES [Region] (
		[ID_Region]
	)
GO


/*==========================================*/
/*                                          */
/*       Cration des procdures            */
/*                                          */
/*==========================================*/

PRINT ' '
PRINT ' '
PRINT '-> Creation des procedures'
PRINT ' '

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO


CREATE PROCEDURE CreerCommande (
	@FournisseurID int,
	@DateLivraison datetime,
	@CommandeID int output)
AS
	INSERT INTO Commande(ID_Fournisseur,DateLivraison)
	VALUES(@FournisseurID,@DateLivraison)
	
	SET @CommandeID = (SELECT MAX(ID_Commande) FROM Commande)
GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

CREATE PROCEDURE DetailsCommande (@CommandeID int)AS
	SELECT 	ID_Commande,NomFournisseur,Telecopie,
		              DateLivraison,Livree
	 FROM Commande
	 INNER JOIN Fournisseur 
	ON Commande.ID_Fournisseur = Fournisseur.ID_Fournisseur
	WHERE (ID_Commande = @CommandeID)
GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO


CREATE PROCEDURE EtatStock (@FamilleID int)
AS

SELECT    MIN(Code) AS Code, 
	MIN(Designation) AS Designation, 
	SUM(Quantite) AS Stock, 
                ID_FamilleProduit,
	MouvementStock.ID_Produit
								
FROM        MouvementStock INNER JOIN   Produit ON MouvementStock.ID_Produit = Produit.ID_Produit

GROUP BY MouvementStock.ID_Produit, ID_FamilleProduit

HAVING ID_FamilleProduit = @FamilleID

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO



CREATE PROCEDURE HistoriqueStock (@ProduitID int) AS

SELECT 
	MIN(DateMouvement) AS DateMouvement,
	SUM(ISNULL(NULLIF(Quantite,ABS(Quantite)),NULL)) AS Ventes,
	SUM(ISNULL(NULLIF(Quantite,-ABS(Quantite)),NULL)) As Approvisionnements,
	MIN(Produit.ID_Produit) AS ID_Produit,
	MIN(Designation) As Designation

FROM 	MouvementStock 

INNER JOIN Produit ON MouvementStock.ID_Produit = Produit.ID_Produit

GROUP BY DateMouvement, MouvementStock.ID_Produit

HAVING MIN(MouvementStock.ID_Produit) = @ProduitID

ORDER BY DateMouvement

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO


CREATE PROCEDURE ListeCommandes AS
	SELECT   ID_Commande,NomFournisseur,
		              DateLivraison,Livree
	 FROM Commande
	 INNER JOIN Fournisseur 
	ON Commande.ID_Fournisseur = Fournisseur.ID_Fournisseur
	ORDER BY ID_Commande DESC
GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

CREATE PROCEDURE ListeLignesCommandes (@CommandeID int) AS
	SELECT ID_Commande,Code,Designation,Quantite 
	FROM LigneCommande
	INNER JOIN ReferenceFournisseur 
	ON 
	LigneCommande.ID_ReferenceFournisseur = ReferenceFournisseur.ID_ReferenceFournisseur
	WHERE ID_Commande = @CommandeID
GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO


SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

CREATE PROCEDURE VentesMensuellesParFamille (@Mois int)
AS

DECLARE @MontantTotal int
SET @MontantTotal = (SELECT SUM(Montant) FROM Vente GROUP BY CodeMois HAVING CodeMois = @Mois)

SELECT MIN(NomFamille) AS NomFamille, MIN(CodeMois) As Mois, SUM(Montant)As Montant, 100*(SUM(Montant)/@MontantTotal) AS Pourcentage
FROM Vente INNER JOIN FamilleProduit ON Vente.ID_FamilleProduit = FamilleProduit.ID_FamilleProduit GROUP BY Vente.ID_FamilleProduit,CodeMois
HAVING CodeMois = @Mois

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

CREATE PROCEDURE VentesMensuellesParRegion (@Mois int)
AS

DECLARE @MontantTotal int
SET @MontantTotal = (SELECT SUM(Montant) FROM Vente GROUP BY CodeMois HAVING CodeMois = @Mois)

SELECT MIN(ID_Region) AS ID_Region,MIN(CodeMois) As Mois, SUM(Montant)As Montant, 100*(SUM(Montant)/@MontantTotal) AS Pourcentage
FROM Vente GROUP BY Vente.ID_Region,CodeMois
HAVING CodeMois = @Mois

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

/*==================================*/
/*                                  */
/*    Mise  jour des permissions   */
/*                                  */
/*==================================*/

PRINT ' '
PRINT ' '
PRINT '-> Mise a jour des permissions'	
PRINT ' '

GRANT SELECT,INSERT,UPDATE,DELETE ON Commande TO public
GRANT SELECT On FamilleProduit TO public
GRANT SELECT ON Fournisseur TO public
GRANT SELECT,INSERT ON LigneCommande TO public
GRANT SELECT ON MouvementStock TO public
GRANT SELECT ON Produit TO public
GRANT SELECT ON ReferenceFournisseur TO public
GRANT SELECT ON Region TO public
GRANT SELECT ON Vente TO public
GRANT EXEC ON CreerCommande TO public
GRANT EXEC ON DetailsCommande TO public
GRANT EXEC ON EtatStock TO public
GRANT EXEC ON HistoriqueStock TO public
GRANT EXEC ON ListeCommandes TO public
GRANT EXEC ON ListeLignesCommandes TO public
GRANT EXEC ON VentesMensuellesParFamille TO public
GRANT EXEC ON VentesMensuellesParRegion TO public
GO

/*==============================*/
/*                              */
/*    Remplissage des tables    */
/*                              */
/*==============================*/

PRINT ' '
PRINT ' '
PRINT '-> Remplissage des tables'
PRINT ' '
GO

SET NOCOUNT ON

DELETE FROM FamilleProduit
SET IDENTITY_INSERT FamilleProduit ON
INSERT INTO FamilleProduit(ID_FamilleProduit,NomFamille) VALUES(1,'Savons')
INSERT INTO FamilleProduit(ID_FamilleProduit,NomFamille) VALUES(2,'Shampoings')
INSERT INTO FamilleProduit(ID_FamilleProduit,NomFamille) VALUES(3,'Gels douche')
SET IDENTITY_INSERT FamilleProduit OFF

DELETE FROM Produit
SET IDENTITY_INSERT Produit ON
INSERT INTO Produit(ID_Produit,ID_FamilleProduit,Code,Designation) VALUES(1,1,'101','Savon miel')
INSERT INTO Produit(ID_Produit,ID_FamilleProduit,Code,Designation) VALUES(2,1,'102','Savon miel & amandes')
INSERT INTO Produit(ID_Produit,ID_FamilleProduit,Code,Designation) VALUES(3,1,'103','Savon lavande')
INSERT INTO Produit(ID_Produit,ID_FamilleProduit,Code,Designation) VALUES(4,2,'201','Shampoing miel')
INSERT INTO Produit(ID_Produit,ID_FamilleProduit,Code,Designation) VALUES(5,2,'202','Shampoing verveine')
INSERT INTO Produit(ID_Produit,ID_FamilleProduit,Code,Designation) VALUES(6,3,'301','Gel douche lavande')
INSERT INTO Produit(ID_Produit,ID_FamilleProduit,Code,Designation) VALUES(7,3,'302','Gel douche tilleul')
SET IDENTITY_INSERT Produit OFF

DELETE FROM MouvementStock
SET IDENTITY_INSERT MouvementStock ON
INSERT INTO MouvementStock(ID_MouvementStock,ID_Produit,DateMouvement,Quantite) VALUES(1,1,'01/2002',-3250)
INSERT INTO MouvementStock(ID_MouvementStock,ID_Produit,DateMouvement,Quantite) VALUES(2,1,'02/2002',-2800)
INSERT INTO MouvementStock(ID_MouvementStock,ID_Produit,DateMouvement,Quantite) VALUES(3,1,'03/2002',-2950)
INSERT INTO MouvementStock(ID_MouvementStock,ID_Produit,DateMouvement,Quantite) VALUES(4,1,'04/2002',-3150)
INSERT INTO MouvementStock(ID_MouvementStock,ID_Produit,DateMouvement,Quantite) VALUES(5,1,'05/2002',-3350)
INSERT INTO MouvementStock(ID_MouvementStock,ID_Produit,DateMouvement,Quantite) VALUES(6,1,'06/2002',-3050)
INSERT INTO MouvementStock(ID_MouvementStock,ID_Produit,DateMouvement,Quantite) VALUES(7,1,'07/2002',-3200)
INSERT INTO MouvementStock(ID_MouvementStock,ID_Produit,DateMouvement,Quantite) VALUES(8,1,'08/2002',-2650)
INSERT INTO MouvementStock(ID_MouvementStock,ID_Produit,DateMouvement,Quantite) VALUES(9,1,'09/2002',-2750)
INSERT INTO MouvementStock(ID_MouvementStock,ID_Produit,DateMouvement,Quantite) VALUES(10,1,'01/2002',7000)
INSERT INTO MouvementStock(ID_MouvementStock,ID_Produit,DateMouvement,Quantite) VALUES(11,1,'03/2002',7000)
INSERT INTO MouvementStock(ID_MouvementStock,ID_Produit,DateMouvement,Quantite) VALUES(12,1,'05/2002',7000)
INSERT INTO MouvementStock(ID_MouvementStock,ID_Produit,DateMouvement,Quantite) VALUES(13,1,'07/2002',7000)
INSERT INTO MouvementStock(ID_MouvementStock,ID_Produit,DateMouvement,Quantite) VALUES(14,2,'01/2002',-2550)
INSERT INTO MouvementStock(ID_MouvementStock,ID_Produit,DateMouvement,Quantite) VALUES(15,2,'02/2002',-2650)
INSERT INTO MouvementStock(ID_MouvementStock,ID_Produit,DateMouvement,Quantite) VALUES(16,2,'03/2002',-2800)
INSERT INTO MouvementStock(ID_MouvementStock,ID_Produit,DateMouvement,Quantite) VALUES(17,2,'04/2002',-2950)
INSERT INTO MouvementStock(ID_MouvementStock,ID_Produit,DateMouvement,Quantite) VALUES(18,2,'05/2002',-2750)
INSERT INTO MouvementStock(ID_MouvementStock,ID_Produit,DateMouvement,Quantite) VALUES(19,2,'06/2002',-2500)
INSERT INTO MouvementStock(ID_MouvementStock,ID_Produit,DateMouvement,Quantite) VALUES(20,2,'07/2002',-2650)
INSERT INTO MouvementStock(ID_MouvementStock,ID_Produit,DateMouvement,Quantite) VALUES(21,2,'08/2002',-2250)
INSERT INTO MouvementStock(ID_MouvementStock,ID_Produit,DateMouvement,Quantite) VALUES(22,2,'09/2002',-2600)
INSERT INTO MouvementStock(ID_MouvementStock,ID_Produit,DateMouvement,Quantite) VALUES(23,2,'01/2002',6000)
INSERT INTO MouvementStock(ID_MouvementStock,ID_Produit,DateMouvement,Quantite) VALUES(24,2,'03/2002',6000)
INSERT INTO MouvementStock(ID_MouvementStock,ID_Produit,DateMouvement,Quantite) VALUES(25,2,'05/2002',6000)
INSERT INTO MouvementStock(ID_MouvementStock,ID_Produit,DateMouvement,Quantite) VALUES(26,2,'07/2002',6000)
INSERT INTO MouvementStock(ID_MouvementStock,ID_Produit,DateMouvement,Quantite) VALUES(27,4,'01/2002',-1500)
INSERT INTO MouvementStock(ID_MouvementStock,ID_Produit,DateMouvement,Quantite) VALUES(28,4,'02/2002',-1650)
INSERT INTO MouvementStock(ID_MouvementStock,ID_Produit,DateMouvement,Quantite) VALUES(29,4,'03/2002',-1750)
INSERT INTO MouvementStock(ID_MouvementStock,ID_Produit,DateMouvement,Quantite) VALUES(30,4,'04/2002',-1450)
INSERT INTO MouvementStock(ID_MouvementStock,ID_Produit,DateMouvement,Quantite) VALUES(31,4,'05/2002',-1550)
INSERT INTO MouvementStock(ID_MouvementStock,ID_Produit,DateMouvement,Quantite) VALUES(32,4,'06/2002',-1700)
INSERT INTO MouvementStock(ID_MouvementStock,ID_Produit,DateMouvement,Quantite) VALUES(33,4,'07/2002',-1750)
INSERT INTO MouvementStock(ID_MouvementStock,ID_Produit,DateMouvement,Quantite) VALUES(34,4,'08/2002',-1350)
INSERT INTO MouvementStock(ID_MouvementStock,ID_Produit,DateMouvement,Quantite) VALUES(35,4,'01/2002',3500)
INSERT INTO MouvementStock(ID_MouvementStock,ID_Produit,DateMouvement,Quantite) VALUES(36,4,'03/2002',3500)
INSERT INTO MouvementStock(ID_MouvementStock,ID_Produit,DateMouvement,Quantite) VALUES(37,4,'05/2002',3500)
INSERT INTO MouvementStock(ID_MouvementStock,ID_Produit,DateMouvement,Quantite) VALUES(38,4,'07/2002',3500)
INSERT INTO MouvementStock(ID_MouvementStock,ID_Produit,DateMouvement,Quantite) VALUES(39,3,'01/2002',-2250)
INSERT INTO MouvementStock(ID_MouvementStock,ID_Produit,DateMouvement,Quantite) VALUES(40,3,'02/2002',-2350)
INSERT INTO MouvementStock(ID_MouvementStock,ID_Produit,DateMouvement,Quantite) VALUES(41,3,'03/2002',-2150)
INSERT INTO MouvementStock(ID_MouvementStock,ID_Produit,DateMouvement,Quantite) VALUES(42,3,'04/2002',-1950)
INSERT INTO MouvementStock(ID_MouvementStock,ID_Produit,DateMouvement,Quantite) VALUES(43,3,'05/2002',-2200)
INSERT INTO MouvementStock(ID_MouvementStock,ID_Produit,DateMouvement,Quantite) VALUES(44,3,'06/2002',-2050)
INSERT INTO MouvementStock(ID_MouvementStock,ID_Produit,DateMouvement,Quantite) VALUES(45,3,'07/2002',-2250)
INSERT INTO MouvementStock(ID_MouvementStock,ID_Produit,DateMouvement,Quantite) VALUES(46,3,'08/2002',-1950)
INSERT INTO MouvementStock(ID_MouvementStock,ID_Produit,DateMouvement,Quantite) VALUES(47,3,'09/2002',-2200)
INSERT INTO MouvementStock(ID_MouvementStock,ID_Produit,DateMouvement,Quantite) VALUES(48,3,'01/2002',5000)
INSERT INTO MouvementStock(ID_MouvementStock,ID_Produit,DateMouvement,Quantite) VALUES(49,3,'03/2002',5000)
INSERT INTO MouvementStock(ID_MouvementStock,ID_Produit,DateMouvement,Quantite) VALUES(50,3,'05/2002',5000)
INSERT INTO MouvementStock(ID_MouvementStock,ID_Produit,DateMouvement,Quantite) VALUES(51,3,'07/2002',5000)
INSERT INTO MouvementStock(ID_MouvementStock,ID_Produit,DateMouvement,Quantite) VALUES(52,5,'01/2002',-1300)
INSERT INTO MouvementStock(ID_MouvementStock,ID_Produit,DateMouvement,Quantite) VALUES(53,5,'02/2002',-1450)
INSERT INTO MouvementStock(ID_MouvementStock,ID_Produit,DateMouvement,Quantite) VALUES(54,5,'03/2002',-1350)
INSERT INTO MouvementStock(ID_MouvementStock,ID_Produit,DateMouvement,Quantite) VALUES(55,5,'04/2002',-1250)
INSERT INTO MouvementStock(ID_MouvementStock,ID_Produit,DateMouvement,Quantite) VALUES(56,5,'05/2002',-1150)
INSERT INTO MouvementStock(ID_MouvementStock,ID_Produit,DateMouvement,Quantite) VALUES(57,5,'06/2002',-1350)
INSERT INTO MouvementStock(ID_MouvementStock,ID_Produit,DateMouvement,Quantite) VALUES(58,5,'07/2002',-1400)
INSERT INTO MouvementStock(ID_MouvementStock,ID_Produit,DateMouvement,Quantite) VALUES(59,5,'08/2002',-1100)
INSERT INTO MouvementStock(ID_MouvementStock,ID_Produit,DateMouvement,Quantite) VALUES(60,5,'09/2002',-1300)
INSERT INTO MouvementStock(ID_MouvementStock,ID_Produit,DateMouvement,Quantite) VALUES(61,5,'01/2002',3000)
INSERT INTO MouvementStock(ID_MouvementStock,ID_Produit,DateMouvement,Quantite) VALUES(62,5,'03/2002',3000)
INSERT INTO MouvementStock(ID_MouvementStock,ID_Produit,DateMouvement,Quantite) VALUES(63,5,'05/2002',3000)
INSERT INTO MouvementStock(ID_MouvementStock,ID_Produit,DateMouvement,Quantite) VALUES(64,5,'07/2002',3000)
INSERT INTO MouvementStock(ID_MouvementStock,ID_Produit,DateMouvement,Quantite) VALUES(65,6,'01/2002',-2800)
INSERT INTO MouvementStock(ID_MouvementStock,ID_Produit,DateMouvement,Quantite) VALUES(66,6,'02/2002',-2600)
INSERT INTO MouvementStock(ID_MouvementStock,ID_Produit,DateMouvement,Quantite) VALUES(67,6,'03/2002',-2700)
INSERT INTO MouvementStock(ID_MouvementStock,ID_Produit,DateMouvement,Quantite) VALUES(68,6,'04/2002',-2650)
INSERT INTO MouvementStock(ID_MouvementStock,ID_Produit,DateMouvement,Quantite) VALUES(69,6,'05/2002',-2550)
INSERT INTO MouvementStock(ID_MouvementStock,ID_Produit,DateMouvement,Quantite) VALUES(70,6,'06/2002',-2900)
INSERT INTO MouvementStock(ID_MouvementStock,ID_Produit,DateMouvement,Quantite) VALUES(71,6,'07/2002',-2950)
INSERT INTO MouvementStock(ID_MouvementStock,ID_Produit,DateMouvement,Quantite) VALUES(72,6,'08/2002',-2500)
INSERT INTO MouvementStock(ID_MouvementStock,ID_Produit,DateMouvement,Quantite) VALUES(73,6,'09/2002',-2650)
INSERT INTO MouvementStock(ID_MouvementStock,ID_Produit,DateMouvement,Quantite) VALUES(74,6,'01/2002',6000)
INSERT INTO MouvementStock(ID_MouvementStock,ID_Produit,DateMouvement,Quantite) VALUES(75,6,'03/2002',6000)
INSERT INTO MouvementStock(ID_MouvementStock,ID_Produit,DateMouvement,Quantite) VALUES(76,6,'05/2002',6000)
INSERT INTO MouvementStock(ID_MouvementStock,ID_Produit,DateMouvement,Quantite) VALUES(77,6,'07/2002',8000)
INSERT INTO MouvementStock(ID_MouvementStock,ID_Produit,DateMouvement,Quantite) VALUES(78,7,'01/2002',-2450)
INSERT INTO MouvementStock(ID_MouvementStock,ID_Produit,DateMouvement,Quantite) VALUES(79,7,'02/2002',-2550)
INSERT INTO MouvementStock(ID_MouvementStock,ID_Produit,DateMouvement,Quantite) VALUES(80,7,'03/2002',-2650)
INSERT INTO MouvementStock(ID_MouvementStock,ID_Produit,DateMouvement,Quantite) VALUES(81,7,'04/2002',-2500)
INSERT INTO MouvementStock(ID_MouvementStock,ID_Produit,DateMouvement,Quantite) VALUES(82,7,'05/2002',-2750)
INSERT INTO MouvementStock(ID_MouvementStock,ID_Produit,DateMouvement,Quantite) VALUES(83,7,'06/2002',-2650)
INSERT INTO MouvementStock(ID_MouvementStock,ID_Produit,DateMouvement,Quantite) VALUES(84,7,'07/2002',-2950)
INSERT INTO MouvementStock(ID_MouvementStock,ID_Produit,DateMouvement,Quantite) VALUES(85,7,'08/2002',-2550)
INSERT INTO MouvementStock(ID_MouvementStock,ID_Produit,DateMouvement,Quantite) VALUES(86,7,'09/2002',-2850)
INSERT INTO MouvementStock(ID_MouvementStock,ID_Produit,DateMouvement,Quantite) VALUES(87,7,'01/2002',6500)
INSERT INTO MouvementStock(ID_MouvementStock,ID_Produit,DateMouvement,Quantite) VALUES(88,7,'03/2002',6500)
INSERT INTO MouvementStock(ID_MouvementStock,ID_Produit,DateMouvement,Quantite) VALUES(89,7,'05/2002',6500)
INSERT INTO MouvementStock(ID_MouvementStock,ID_Produit,DateMouvement,Quantite) VALUES(90,7,'07/2002',6500)
SET IDENTITY_INSERT MouvementStock OFF

DELETE FROM Fournisseur

SET IDENTITY_INSERT Fournisseur ON
INSERT INTO Fournisseur(ID_Fournisseur,NomFournisseur,Telecopie) VALUES(1,'Miel Daniel SA','04 30 01 30 01')
INSERT INTO Fournisseur(ID_Fournisseur,NomFournisseur,Telecopie) VALUES(2,'Flacons Vignon SA','02 99 99 99 99')
INSERT INTO Fournisseur(ID_Fournisseur,NomFournisseur,Telecopie) VALUES(3,'Cartonnage du Sud','01 88 88 88 88')
INSERT INTO Fournisseur(ID_Fournisseur,NomFournisseur,Telecopie) VALUES(4,'Imprimerie Henri','03 77 77 77 77')
SET IDENTITY_INSERT Fournisseur OFF

DELETE FROM ReferenceFournisseur

SET IDENTITY_INSERT ReferenceFournisseur ON
INSERT INTO ReferenceFournisseur(ID_ReferenceFournisseur,ID_Fournisseur,Code,Designation) VALUES (1,1,'M50','Miel bidon 50kg')
INSERT INTO ReferenceFournisseur(ID_ReferenceFournisseur,ID_Fournisseur,Code,Designation) VALUES (2,1,'G20','Gele royale bidon 20kg')
INSERT INTO ReferenceFournisseur(ID_ReferenceFournisseur,ID_Fournisseur,Code,Designation) VALUES (3,1,'P20','Pollen bidon 50kg ')
INSERT INTO ReferenceFournisseur(ID_ReferenceFournisseur,ID_Fournisseur,Code,Designation) VALUES (4,2,'F250','Flacon plastique 250ml')
INSERT INTO ReferenceFournisseur(ID_ReferenceFournisseur,ID_Fournisseur,Code,Designation) VALUES (5,2,'F500','Flacon plastique 500ml')
INSERT INTO ReferenceFournisseur(ID_ReferenceFournisseur,ID_Fournisseur,Code,Designation) VALUES (6,2,'B100','Bouchon plastique blanc')
INSERT INTO ReferenceFournisseur(ID_ReferenceFournisseur,ID_Fournisseur,Code,Designation) VALUES (7,2,'B110','Bouchon plastique vert')
INSERT INTO ReferenceFournisseur(ID_ReferenceFournisseur,ID_Fournisseur,Code,Designation) VALUES (8,3,'C120','Caisse carton 50x50x25')
INSERT INTO ReferenceFournisseur(ID_ReferenceFournisseur,ID_Fournisseur,Code,Designation) VALUES (9,3,'C150','Caisse carton 150x60x30')
INSERT INTO ReferenceFournisseur(ID_ReferenceFournisseur,ID_Fournisseur,Code,Designation) VALUES(10,3,'C180','Caisse carton 180x100x50')
INSERT INTO ReferenceFournisseur(ID_ReferenceFournisseur,ID_Fournisseur,Code,Designation) VALUES(11,4,'E201','Etiquette shampoing verveine 50x25')
INSERT INTO ReferenceFournisseur(ID_ReferenceFournisseur,ID_Fournisseur,Code,Designation) VALUES(12,4,'E202','Etiquette shampoing miel 50x25')

SET IDENTITY_INSERT ReferenceFournisseur OFF

DELETE FROM Commande

SET IDENTITY_INSERT Commande ON
INSERT INTO Commande(ID_Commande,ID_Fournisseur,DateLivraison) VALUES(1,1,'20021201')
INSERT INTO Commande(ID_Commande,ID_Fournisseur,DateLivraison) VALUES(2,2,'20021215')
INSERT INTO Commande(ID_Commande,ID_Fournisseur,DateLivraison) VALUES(3,3,'20030115')
INSERT INTO Commande(ID_Commande,ID_Fournisseur,DateLivraison) VALUES(4,4,'20030115')
SET IDENTITY_INSERT Commande OFF

DELETE FROM LigneCommande

SET IDENTITY_INSERT LigneCommande ON
INSERT INTO LigneCommande(ID_LigneCommande,ID_Commande,ID_ReferenceFournisseur,Quantite) VALUES(1,1,1,30)
INSERT INTO LigneCommande(ID_LigneCommande,ID_Commande,ID_ReferenceFournisseur,Quantite) VALUES(2,1,2,15)
INSERT INTO LigneCommande(ID_LigneCommande,ID_Commande,ID_ReferenceFournisseur,Quantite) VALUES(3,1,3,20)
INSERT INTO LigneCommande(ID_LigneCommande,ID_Commande,ID_ReferenceFournisseur,Quantite) VALUES(4,2,4,1500)
INSERT INTO LigneCommande(ID_LigneCommande,ID_Commande,ID_ReferenceFournisseur,Quantite) VALUES(5,2,5,750)
INSERT INTO LigneCommande(ID_LigneCommande,ID_Commande,ID_ReferenceFournisseur,Quantite) VALUES(6,2,6,1000)
INSERT INTO LigneCommande(ID_LigneCommande,ID_Commande,ID_ReferenceFournisseur,Quantite) VALUES(7,2,7,1000)
INSERT INTO LigneCommande(ID_LigneCommande,ID_Commande,ID_ReferenceFournisseur,Quantite) VALUES(8,3,8,400)
INSERT INTO LigneCommande(ID_LigneCommande,ID_Commande,ID_ReferenceFournisseur,Quantite) VALUES(9,3,9,300)
INSERT INTO LigneCommande(ID_LigneCommande,ID_Commande,ID_ReferenceFournisseur,Quantite) VALUES(10,3,10,300)
INSERT INTO LigneCommande(ID_LigneCommande,ID_Commande,ID_ReferenceFournisseur,Quantite) VALUES(11,4,11,800)
INSERT INTO LigneCommande(ID_LigneCommande,ID_Commande,ID_ReferenceFournisseur,Quantite) VALUES(12,4,12,800)
SET IDENTITY_INSERT LigneCommande OFF

DELETE FROM Region
SET IDENTITY_INSERT Region ON
INSERT INTO Region(ID_Region,Region) VALUES(1,'Alsace')
INSERT INTO Region(ID_Region,Region) VALUES(2,'Aquitaine')
INSERT INTO Region(ID_Region,Region) VALUES(3,'Auvergne')
INSERT INTO Region(ID_Region,Region) VALUES(4,'Basse-Normandie')
INSERT INTO Region(ID_Region,Region) VALUES(5,'Bourgogne')
INSERT INTO Region(ID_Region,Region) VALUES(6,'Bretagne')
INSERT INTO Region(ID_Region,Region) VALUES(7,'Centre')
INSERT INTO Region(ID_Region,Region) VALUES(8,'Champagne-Ardennes')
INSERT INTO Region(ID_Region,Region) VALUES(9,'Corse')
INSERT INTO Region(ID_Region,Region) VALUES(10,'Franche-Comt')
INSERT INTO Region(ID_Region,Region) VALUES(11,'Haute-Normandie')
INSERT INTO Region(ID_Region,Region) VALUES(12,'Ile-de-France')
INSERT INTO Region(ID_Region,Region) VALUES(13,'Languedoc-Roussillon')
INSERT INTO Region(ID_Region,Region) VALUES(14,'Limousin')
INSERT INTO Region(ID_Region,Region) VALUES(15,'Lorraine')
INSERT INTO Region(ID_Region,Region) VALUES(16,'Midi-Pyrnes')
INSERT INTO Region(ID_Region,Region) VALUES(17,'Nord-Pas-de-Calais')
INSERT INTO Region(ID_Region,Region) VALUES(18,'Pays de la Loire')
INSERT INTO Region(ID_Region,Region) VALUES(19,'Picardie')
INSERT INTO Region(ID_Region,Region) VALUES(20,'Poitou-Charentes')
INSERT INTO Region(ID_Region,Region) VALUES(21,'Provence-Alpes-Cte Azur')
INSERT INTO Region(ID_Region,Region) VALUES(22,'Rhne-Alpes')
SET IDENTITY_INSERT Region OFF	

DELETE FROM Vente
INSERT INTO Vente VALUES(1,1,'200201',6)
INSERT INTO Vente VALUES(1,1,'200202',2817)
INSERT INTO Vente VALUES(1,1,'200203',966)
INSERT INTO Vente VALUES(1,1,'200204',4043)
INSERT INTO Vente VALUES(1,1,'200205',2925)
INSERT INTO Vente VALUES(1,1,'200206',2399)
INSERT INTO Vente VALUES(1,1,'200207',1751)
INSERT INTO Vente VALUES(1,1,'200208',4479)
INSERT INTO Vente VALUES(1,1,'200209',4114)
INSERT INTO Vente VALUES(1,1,'200210',3733)
INSERT INTO Vente VALUES(1,1,'200211',870)
INSERT INTO Vente VALUES(1,1,'200212',4294)
INSERT INTO Vente VALUES(1,2,'200201',3552)
INSERT INTO Vente VALUES(1,2,'200202',2567)
INSERT INTO Vente VALUES(1,2,'200203',1519)
INSERT INTO Vente VALUES(1,2,'200204',74)
INSERT INTO Vente VALUES(1,2,'200205',457)
INSERT INTO Vente VALUES(1,2,'200206',1822)
INSERT INTO Vente VALUES(1,2,'200207',736)
INSERT INTO Vente VALUES(1,2,'200208',829)
INSERT INTO Vente VALUES(1,2,'200209',4942)
INSERT INTO Vente VALUES(1,2,'200210',2228)
INSERT INTO Vente VALUES(1,2,'200211',595)
INSERT INTO Vente VALUES(1,2,'200212',23)
INSERT INTO Vente VALUES(1,3,'200201',44)
INSERT INTO Vente VALUES(1,3,'200202',1889)
INSERT INTO Vente VALUES(1,3,'200203',2658)
INSERT INTO Vente VALUES(1,3,'200204',2855)
INSERT INTO Vente VALUES(1,3,'200205',3008)
INSERT INTO Vente VALUES(1,3,'200206',3035)
INSERT INTO Vente VALUES(1,3,'200207',831)
INSERT INTO Vente VALUES(1,3,'200208',3315)
INSERT INTO Vente VALUES(1,3,'200209',2253)
INSERT INTO Vente VALUES(1,3,'200210',1760)
INSERT INTO Vente VALUES(1,3,'200211',285)
INSERT INTO Vente VALUES(1,3,'200212',3038)
INSERT INTO Vente VALUES(1,4,'200201',3916)
INSERT INTO Vente VALUES(1,4,'200202',4013)
INSERT INTO Vente VALUES(1,4,'200203',2599)
INSERT INTO Vente VALUES(1,4,'200204',1509)
INSERT INTO Vente VALUES(1,4,'200205',4379)
INSERT INTO Vente VALUES(1,4,'200206',3633)
INSERT INTO Vente VALUES(1,4,'200207',4779)
INSERT INTO Vente VALUES(1,4,'200208',4628)
INSERT INTO Vente VALUES(1,4,'200209',2696)
INSERT INTO Vente VALUES(1,4,'200210',711)
INSERT INTO Vente VALUES(1,4,'200211',2310)
INSERT INTO Vente VALUES(1,4,'200212',1176)
INSERT INTO Vente VALUES(1,5,'200201',4311)
INSERT INTO Vente VALUES(1,5,'200202',1048)
INSERT INTO Vente VALUES(1,5,'200203',3898)
INSERT INTO Vente VALUES(1,5,'200204',4218)
INSERT INTO Vente VALUES(1,5,'200205',4983)
INSERT INTO Vente VALUES(1,5,'200206',4998)
INSERT INTO Vente VALUES(1,5,'200207',3057)
INSERT INTO Vente VALUES(1,5,'200208',1962)
INSERT INTO Vente VALUES(1,5,'200209',1331)
INSERT INTO Vente VALUES(1,5,'200210',1486)
INSERT INTO Vente VALUES(1,5,'200211',4200)
INSERT INTO Vente VALUES(1,5,'200212',118)
INSERT INTO Vente VALUES(1,6,'200201',1879)
INSERT INTO Vente VALUES(1,6,'200202',463)
INSERT INTO Vente VALUES(1,6,'200203',3386)
INSERT INTO Vente VALUES(1,6,'200204',281)
INSERT INTO Vente VALUES(1,6,'200205',43)
INSERT INTO Vente VALUES(1,6,'200206',4593)
INSERT INTO Vente VALUES(1,6,'200207',1379)
INSERT INTO Vente VALUES(1,6,'200208',1364)
INSERT INTO Vente VALUES(1,6,'200209',2939)
INSERT INTO Vente VALUES(1,6,'200210',3455)
INSERT INTO Vente VALUES(1,6,'200211',4188)
INSERT INTO Vente VALUES(1,6,'200212',3632)
INSERT INTO Vente VALUES(1,7,'200201',2424)
INSERT INTO Vente VALUES(1,7,'200202',1026)
INSERT INTO Vente VALUES(1,7,'200203',3718)
INSERT INTO Vente VALUES(1,7,'200204',2342)
INSERT INTO Vente VALUES(1,7,'200205',2289)
INSERT INTO Vente VALUES(1,7,'200206',4745)
INSERT INTO Vente VALUES(1,7,'200207',3722)
INSERT INTO Vente VALUES(1,7,'200208',541)
INSERT INTO Vente VALUES(1,7,'200209',2995)
INSERT INTO Vente VALUES(1,7,'200210',1926)
INSERT INTO Vente VALUES(1,7,'200211',3675)
INSERT INTO Vente VALUES(1,7,'200212',3044)
INSERT INTO Vente VALUES(1,8,'200201',2862)
INSERT INTO Vente VALUES(1,8,'200202',1806)
INSERT INTO Vente VALUES(1,8,'200203',757)
INSERT INTO Vente VALUES(1,8,'200204',1125)
INSERT INTO Vente VALUES(1,8,'200205',2125)
INSERT INTO Vente VALUES(1,8,'200206',4014)
INSERT INTO Vente VALUES(1,8,'200207',2585)
INSERT INTO Vente VALUES(1,8,'200208',4949)
INSERT INTO Vente VALUES(1,8,'200209',3757)
INSERT INTO Vente VALUES(1,8,'200210',1727)
INSERT INTO Vente VALUES(1,8,'200211',844)
INSERT INTO Vente VALUES(1,8,'200212',3286)
INSERT INTO Vente VALUES(1,9,'200201',2459)
INSERT INTO Vente VALUES(1,9,'200202',317)
INSERT INTO Vente VALUES(1,9,'200203',3498)
INSERT INTO Vente VALUES(1,9,'200204',2524)
INSERT INTO Vente VALUES(1,9,'200205',737)
INSERT INTO Vente VALUES(1,9,'200206',4747)
INSERT INTO Vente VALUES(1,9,'200207',707)
INSERT INTO Vente VALUES(1,9,'200208',4525)
INSERT INTO Vente VALUES(1,9,'200209',3464)
INSERT INTO Vente VALUES(1,9,'200210',1515)
INSERT INTO Vente VALUES(1,9,'200211',2132)
INSERT INTO Vente VALUES(1,9,'200212',351)
INSERT INTO Vente VALUES(1,10,'200201',4833)
INSERT INTO Vente VALUES(1,10,'200202',3415)
INSERT INTO Vente VALUES(1,10,'200203',766)
INSERT INTO Vente VALUES(1,10,'200204',4386)
INSERT INTO Vente VALUES(1,10,'200205',4108)
INSERT INTO Vente VALUES(1,10,'200206',2910)
INSERT INTO Vente VALUES(1,10,'200207',956)
INSERT INTO Vente VALUES(1,10,'200208',889)
INSERT INTO Vente VALUES(1,10,'200209',4085)
INSERT INTO Vente VALUES(1,10,'200210',2376)
INSERT INTO Vente VALUES(1,10,'200211',777)
INSERT INTO Vente VALUES(1,10,'200212',2519)
INSERT INTO Vente VALUES(1,11,'200201',3660)
INSERT INTO Vente VALUES(1,11,'200202',2027)
INSERT INTO Vente VALUES(1,11,'200203',1397)
INSERT INTO Vente VALUES(1,11,'200204',2843)
INSERT INTO Vente VALUES(1,11,'200205',3411)
INSERT INTO Vente VALUES(1,11,'200206',3779)
INSERT INTO Vente VALUES(1,11,'200207',3609)
INSERT INTO Vente VALUES(1,11,'200208',2376)
INSERT INTO Vente VALUES(1,11,'200209',615)
INSERT INTO Vente VALUES(1,11,'200210',1839)
INSERT INTO Vente VALUES(1,11,'200211',4173)
INSERT INTO Vente VALUES(1,11,'200212',175)
INSERT INTO Vente VALUES(1,12,'200201',2585)
INSERT INTO Vente VALUES(1,12,'200202',3314)
INSERT INTO Vente VALUES(1,12,'200203',2131)
INSERT INTO Vente VALUES(1,12,'200204',523)
INSERT INTO Vente VALUES(1,12,'200205',4746)
INSERT INTO Vente VALUES(1,12,'200206',4606)
INSERT INTO Vente VALUES(1,12,'200207',2747)
INSERT INTO Vente VALUES(1,12,'200208',1729)
INSERT INTO Vente VALUES(1,12,'200209',2358)
INSERT INTO Vente VALUES(1,12,'200210',1874)
INSERT INTO Vente VALUES(1,12,'200211',4234)
INSERT INTO Vente VALUES(1,12,'200212',1584)
INSERT INTO Vente VALUES(1,13,'200201',2280)
INSERT INTO Vente VALUES(1,13,'200202',1359)
INSERT INTO Vente VALUES(1,13,'200203',4914)
INSERT INTO Vente VALUES(1,13,'200204',1488)
INSERT INTO Vente VALUES(1,13,'200205',3695)
INSERT INTO Vente VALUES(1,13,'200206',2836)
INSERT INTO Vente VALUES(1,13,'200207',979)
INSERT INTO Vente VALUES(1,13,'200208',3806)
INSERT INTO Vente VALUES(1,13,'200209',4197)
INSERT INTO Vente VALUES(1,13,'200210',1988)
INSERT INTO Vente VALUES(1,13,'200211',2504)
INSERT INTO Vente VALUES(1,13,'200212',4450)
INSERT INTO Vente VALUES(1,14,'200201',137)
INSERT INTO Vente VALUES(1,14,'200202',4973)
INSERT INTO Vente VALUES(1,14,'200203',2862)
INSERT INTO Vente VALUES(1,14,'200204',252)
INSERT INTO Vente VALUES(1,14,'200205',2656)
INSERT INTO Vente VALUES(1,14,'200206',970)
INSERT INTO Vente VALUES(1,14,'200207',4215)
INSERT INTO Vente VALUES(1,14,'200208',3133)
INSERT INTO Vente VALUES(1,14,'200209',3288)
INSERT INTO Vente VALUES(1,14,'200210',989)
INSERT INTO Vente VALUES(1,14,'200211',4210)
INSERT INTO Vente VALUES(1,14,'200212',616)
INSERT INTO Vente VALUES(1,15,'200201',549)
INSERT INTO Vente VALUES(1,15,'200202',3715)
INSERT INTO Vente VALUES(1,15,'200203',1570)
INSERT INTO Vente VALUES(1,15,'200204',4705)
INSERT INTO Vente VALUES(1,15,'200205',1430)
INSERT INTO Vente VALUES(1,15,'200206',1681)
INSERT INTO Vente VALUES(1,15,'200207',701)
INSERT INTO Vente VALUES(1,15,'200208',3665)
INSERT INTO Vente VALUES(1,15,'200209',4173)
INSERT INTO Vente VALUES(1,15,'200210',3539)
INSERT INTO Vente VALUES(1,15,'200211',3001)
INSERT INTO Vente VALUES(1,15,'200212',3736)
INSERT INTO Vente VALUES(1,16,'200201',1263)
INSERT INTO Vente VALUES(1,16,'200202',722)
INSERT INTO Vente VALUES(1,16,'200203',8)
INSERT INTO Vente VALUES(1,16,'200204',305)
INSERT INTO Vente VALUES(1,16,'200205',4031)
INSERT INTO Vente VALUES(1,16,'200206',4263)
INSERT INTO Vente VALUES(1,16,'200207',1052)
INSERT INTO Vente VALUES(1,16,'200208',578)
INSERT INTO Vente VALUES(1,16,'200209',2766)
INSERT INTO Vente VALUES(1,16,'200210',71)
INSERT INTO Vente VALUES(1,16,'200211',568)
INSERT INTO Vente VALUES(1,16,'200212',2272)
INSERT INTO Vente VALUES(1,17,'200201',3761)
INSERT INTO Vente VALUES(1,17,'200202',3430)
INSERT INTO Vente VALUES(1,17,'200203',2717)
INSERT INTO Vente VALUES(1,17,'200204',369)
INSERT INTO Vente VALUES(1,17,'200205',2183)
INSERT INTO Vente VALUES(1,17,'200206',1009)
INSERT INTO Vente VALUES(1,17,'200207',3481)
INSERT INTO Vente VALUES(1,17,'200208',1451)
INSERT INTO Vente VALUES(1,17,'200209',2183)
INSERT INTO Vente VALUES(1,17,'200210',1162)
INSERT INTO Vente VALUES(1,17,'200211',2889)
INSERT INTO Vente VALUES(1,17,'200212',2662)
INSERT INTO Vente VALUES(1,18,'200201',3143)
INSERT INTO Vente VALUES(1,18,'200202',800)
INSERT INTO Vente VALUES(1,18,'200203',2520)
INSERT INTO Vente VALUES(1,18,'200204',4815)
INSERT INTO Vente VALUES(1,18,'200205',3478)
INSERT INTO Vente VALUES(1,18,'200206',4624)
INSERT INTO Vente VALUES(1,18,'200207',949)
INSERT INTO Vente VALUES(1,18,'200208',1679)
INSERT INTO Vente VALUES(1,18,'200209',891)
INSERT INTO Vente VALUES(1,18,'200210',4975)
INSERT INTO Vente VALUES(1,18,'200211',2287)
INSERT INTO Vente VALUES(1,18,'200212',4990)
INSERT INTO Vente VALUES(1,19,'200201',487)
INSERT INTO Vente VALUES(1,19,'200202',3125)
INSERT INTO Vente VALUES(1,19,'200203',471)
INSERT INTO Vente VALUES(1,19,'200204',2188)
INSERT INTO Vente VALUES(1,19,'200205',4657)
INSERT INTO Vente VALUES(1,19,'200206',242)
INSERT INTO Vente VALUES(1,19,'200207',4473)
INSERT INTO Vente VALUES(1,19,'200208',1450)
INSERT INTO Vente VALUES(1,19,'200209',1136)
INSERT INTO Vente VALUES(1,19,'200210',3845)
INSERT INTO Vente VALUES(1,19,'200211',2053)
INSERT INTO Vente VALUES(1,19,'200212',1009)
INSERT INTO Vente VALUES(1,20,'200201',3140)
INSERT INTO Vente VALUES(1,20,'200202',3020)
INSERT INTO Vente VALUES(1,20,'200203',2258)
INSERT INTO Vente VALUES(1,20,'200204',2331)
INSERT INTO Vente VALUES(1,20,'200205',2989)
INSERT INTO Vente VALUES(1,20,'200206',3173)
INSERT INTO Vente VALUES(1,20,'200207',4273)
INSERT INTO Vente VALUES(1,20,'200208',4143)
INSERT INTO Vente VALUES(1,20,'200209',3123)
INSERT INTO Vente VALUES(1,20,'200210',3604)
INSERT INTO Vente VALUES(1,20,'200211',2828)
INSERT INTO Vente VALUES(1,20,'200212',1875)
INSERT INTO Vente VALUES(1,21,'200201',921)
INSERT INTO Vente VALUES(1,21,'200202',3689)
INSERT INTO Vente VALUES(1,21,'200203',2775)
INSERT INTO Vente VALUES(1,21,'200204',4525)
INSERT INTO Vente VALUES(1,21,'200205',1214)
INSERT INTO Vente VALUES(1,21,'200206',944)
INSERT INTO Vente VALUES(1,21,'200207',3023)
INSERT INTO Vente VALUES(1,21,'200208',3492)
INSERT INTO Vente VALUES(1,21,'200209',2923)
INSERT INTO Vente VALUES(1,21,'200210',1756)
INSERT INTO Vente VALUES(1,21,'200211',2472)
INSERT INTO Vente VALUES(1,21,'200212',401)
INSERT INTO Vente VALUES(1,22,'200201',3703)
INSERT INTO Vente VALUES(1,22,'200202',3060)
INSERT INTO Vente VALUES(1,22,'200203',3101)
INSERT INTO Vente VALUES(1,22,'200204',3455)
INSERT INTO Vente VALUES(1,22,'200205',4022)
INSERT INTO Vente VALUES(1,22,'200206',745)
INSERT INTO Vente VALUES(1,22,'200207',2880)
INSERT INTO Vente VALUES(1,22,'200208',4338)
INSERT INTO Vente VALUES(1,22,'200209',4557)
INSERT INTO Vente VALUES(1,22,'200210',3073)
INSERT INTO Vente VALUES(1,22,'200211',3638)
INSERT INTO Vente VALUES(1,22,'200212',216)
INSERT INTO Vente VALUES(2,1,'200201',3338)
INSERT INTO Vente VALUES(2,1,'200202',4882)
INSERT INTO Vente VALUES(2,1,'200203',1575)
INSERT INTO Vente VALUES(2,1,'200204',2846)
INSERT INTO Vente VALUES(2,1,'200205',1529)
INSERT INTO Vente VALUES(2,1,'200206',869)
INSERT INTO Vente VALUES(2,1,'200207',542)
INSERT INTO Vente VALUES(2,1,'200208',4345)
INSERT INTO Vente VALUES(2,1,'200209',4256)
INSERT INTO Vente VALUES(2,1,'200210',3721)
INSERT INTO Vente VALUES(2,1,'200211',774)
INSERT INTO Vente VALUES(2,1,'200212',1634)
INSERT INTO Vente VALUES(2,2,'200201',396)
INSERT INTO Vente VALUES(2,2,'200202',383)
INSERT INTO Vente VALUES(2,2,'200203',3204)
INSERT INTO Vente VALUES(2,2,'200204',4100)
INSERT INTO Vente VALUES(2,2,'200205',2725)
INSERT INTO Vente VALUES(2,2,'200206',2241)
INSERT INTO Vente VALUES(2,2,'200207',2044)
INSERT INTO Vente VALUES(2,2,'200208',1493)
INSERT INTO Vente VALUES(2,2,'200209',2327)
INSERT INTO Vente VALUES(2,2,'200210',2506)
INSERT INTO Vente VALUES(2,2,'200211',763)
INSERT INTO Vente VALUES(2,2,'200212',1615)
INSERT INTO Vente VALUES(2,3,'200201',3689)
INSERT INTO Vente VALUES(2,3,'200202',1569)
INSERT INTO Vente VALUES(2,3,'200203',4133)
INSERT INTO Vente VALUES(2,3,'200204',4795)
INSERT INTO Vente VALUES(2,3,'200205',4366)
INSERT INTO Vente VALUES(2,3,'200206',3625)
INSERT INTO Vente VALUES(2,3,'200207',1500)
INSERT INTO Vente VALUES(2,3,'200208',4719)
INSERT INTO Vente VALUES(2,3,'200209',636)
INSERT INTO Vente VALUES(2,3,'200210',328)
INSERT INTO Vente VALUES(2,3,'200211',3924)
INSERT INTO Vente VALUES(2,3,'200212',2622)
INSERT INTO Vente VALUES(2,4,'200201',3048)
INSERT INTO Vente VALUES(2,4,'200202',4780)
INSERT INTO Vente VALUES(2,4,'200203',361)
INSERT INTO Vente VALUES(2,4,'200204',4378)
INSERT INTO Vente VALUES(2,4,'200205',3269)
INSERT INTO Vente VALUES(2,4,'200206',1610)
INSERT INTO Vente VALUES(2,4,'200207',524)
INSERT INTO Vente VALUES(2,4,'200208',2525)
INSERT INTO Vente VALUES(2,4,'200209',1135)
INSERT INTO Vente VALUES(2,4,'200210',1451)
INSERT INTO Vente VALUES(2,4,'200211',4599)
INSERT INTO Vente VALUES(2,4,'200212',2755)
INSERT INTO Vente VALUES(2,5,'200201',3314)
INSERT INTO Vente VALUES(2,5,'200202',572)
INSERT INTO Vente VALUES(2,5,'200203',2462)
INSERT INTO Vente VALUES(2,5,'200204',1895)
INSERT INTO Vente VALUES(2,5,'200205',2484)
INSERT INTO Vente VALUES(2,5,'200206',3966)
INSERT INTO Vente VALUES(2,5,'200207',2546)
INSERT INTO Vente VALUES(2,5,'200208',1911)
INSERT INTO Vente VALUES(2,5,'200209',3440)
INSERT INTO Vente VALUES(2,5,'200210',2660)
INSERT INTO Vente VALUES(2,5,'200211',3031)
INSERT INTO Vente VALUES(2,5,'200212',1975)
INSERT INTO Vente VALUES(2,6,'200201',29)
INSERT INTO Vente VALUES(2,6,'200202',3539)
INSERT INTO Vente VALUES(2,6,'200203',503)
INSERT INTO Vente VALUES(2,6,'200204',3115)
INSERT INTO Vente VALUES(2,6,'200205',4316)
INSERT INTO Vente VALUES(2,6,'200206',2457)
INSERT INTO Vente VALUES(2,6,'200207',3736)
INSERT INTO Vente VALUES(2,6,'200208',2484)
INSERT INTO Vente VALUES(2,6,'200209',1900)
INSERT INTO Vente VALUES(2,6,'200210',3926)
INSERT INTO Vente VALUES(2,6,'200211',2764)
INSERT INTO Vente VALUES(2,6,'200212',1785)
INSERT INTO Vente VALUES(2,7,'200201',4778)
INSERT INTO Vente VALUES(2,7,'200202',3154)
INSERT INTO Vente VALUES(2,7,'200203',882)
INSERT INTO Vente VALUES(2,7,'200204',1871)
INSERT INTO Vente VALUES(2,7,'200205',658)
INSERT INTO Vente VALUES(2,7,'200206',3716)
INSERT INTO Vente VALUES(2,7,'200207',4758)
INSERT INTO Vente VALUES(2,7,'200208',3059)
INSERT INTO Vente VALUES(2,7,'200209',139)
INSERT INTO Vente VALUES(2,7,'200210',1649)
INSERT INTO Vente VALUES(2,7,'200211',279)
INSERT INTO Vente VALUES(2,7,'200212',3196)
INSERT INTO Vente VALUES(2,8,'200201',658)
INSERT INTO Vente VALUES(2,8,'200202',4235)
INSERT INTO Vente VALUES(2,8,'200203',4321)
INSERT INTO Vente VALUES(2,8,'200204',2984)
INSERT INTO Vente VALUES(2,8,'200205',3608)
INSERT INTO Vente VALUES(2,8,'200206',4269)
INSERT INTO Vente VALUES(2,8,'200207',73)
INSERT INTO Vente VALUES(2,8,'200208',632)
INSERT INTO Vente VALUES(2,8,'200209',3539)
INSERT INTO Vente VALUES(2,8,'200210',3085)
INSERT INTO Vente VALUES(2,8,'200211',1087)
INSERT INTO Vente VALUES(2,8,'200212',329)
INSERT INTO Vente VALUES(2,9,'200201',844)
INSERT INTO Vente VALUES(2,9,'200202',3120)
INSERT INTO Vente VALUES(2,9,'200203',1704)
INSERT INTO Vente VALUES(2,9,'200204',1597)
INSERT INTO Vente VALUES(2,9,'200205',1837)
INSERT INTO Vente VALUES(2,9,'200206',3305)
INSERT INTO Vente VALUES(2,9,'200207',4011)
INSERT INTO Vente VALUES(2,9,'200208',4034)
INSERT INTO Vente VALUES(2,9,'200209',2632)
INSERT INTO Vente VALUES(2,9,'200210',3055)
INSERT INTO Vente VALUES(2,9,'200211',3990)
INSERT INTO Vente VALUES(2,9,'200212',4503)
INSERT INTO Vente VALUES(2,10,'200201',724)
INSERT INTO Vente VALUES(2,10,'200202',3150)
INSERT INTO Vente VALUES(2,10,'200203',2012)
INSERT INTO Vente VALUES(2,10,'200204',1268)
INSERT INTO Vente VALUES(2,10,'200205',682)
INSERT INTO Vente VALUES(2,10,'200206',4275)
INSERT INTO Vente VALUES(2,10,'200207',330)
INSERT INTO Vente VALUES(2,10,'200208',2139)
INSERT INTO Vente VALUES(2,10,'200209',2866)
INSERT INTO Vente VALUES(2,10,'200210',1511)
INSERT INTO Vente VALUES(2,10,'200211',2740)
INSERT INTO Vente VALUES(2,10,'200212',1127)
INSERT INTO Vente VALUES(2,11,'200201',1556)
INSERT INTO Vente VALUES(2,11,'200202',553)
INSERT INTO Vente VALUES(2,11,'200203',4040)
INSERT INTO Vente VALUES(2,11,'200204',673)
INSERT INTO Vente VALUES(2,11,'200205',1421)
INSERT INTO Vente VALUES(2,11,'200206',3940)
INSERT INTO Vente VALUES(2,11,'200207',4476)
INSERT INTO Vente VALUES(2,11,'200208',3948)
INSERT INTO Vente VALUES(2,11,'200209',3718)
INSERT INTO Vente VALUES(2,11,'200210',3076)
INSERT INTO Vente VALUES(2,11,'200211',1805)
INSERT INTO Vente VALUES(2,11,'200212',4283)
INSERT INTO Vente VALUES(2,12,'200201',1142)
INSERT INTO Vente VALUES(2,12,'200202',4317)
INSERT INTO Vente VALUES(2,12,'200203',1147)
INSERT INTO Vente VALUES(2,12,'200204',1247)
INSERT INTO Vente VALUES(2,12,'200205',2712)
INSERT INTO Vente VALUES(2,12,'200206',4924)
INSERT INTO Vente VALUES(2,12,'200207',269)
INSERT INTO Vente VALUES(2,12,'200208',407)
INSERT INTO Vente VALUES(2,12,'200209',2623)
INSERT INTO Vente VALUES(2,12,'200210',2134)
INSERT INTO Vente VALUES(2,12,'200211',473)
INSERT INTO Vente VALUES(2,12,'200212',1293)
INSERT INTO Vente VALUES(2,13,'200201',4457)
INSERT INTO Vente VALUES(2,13,'200202',1163)
INSERT INTO Vente VALUES(2,13,'200203',732)
INSERT INTO Vente VALUES(2,13,'200204',625)
INSERT INTO Vente VALUES(2,13,'200205',4658)
INSERT INTO Vente VALUES(2,13,'200206',400)
INSERT INTO Vente VALUES(2,13,'200207',235)
INSERT INTO Vente VALUES(2,13,'200208',293)
INSERT INTO Vente VALUES(2,13,'200209',1682)
INSERT INTO Vente VALUES(2,13,'200210',4573)
INSERT INTO Vente VALUES(2,13,'200211',1993)
INSERT INTO Vente VALUES(2,13,'200212',2163)
INSERT INTO Vente VALUES(2,14,'200201',4730)
INSERT INTO Vente VALUES(2,14,'200202',4185)
INSERT INTO Vente VALUES(2,14,'200203',2671)
INSERT INTO Vente VALUES(2,14,'200204',4210)
INSERT INTO Vente VALUES(2,14,'200205',3467)
INSERT INTO Vente VALUES(2,14,'200206',1988)
INSERT INTO Vente VALUES(2,14,'200207',1295)
INSERT INTO Vente VALUES(2,14,'200208',21)
INSERT INTO Vente VALUES(2,14,'200209',2627)
INSERT INTO Vente VALUES(2,14,'200210',4774)
INSERT INTO Vente VALUES(2,14,'200211',1993)
INSERT INTO Vente VALUES(2,14,'200212',1205)
INSERT INTO Vente VALUES(2,15,'200201',2927)
INSERT INTO Vente VALUES(2,15,'200202',1275)
INSERT INTO Vente VALUES(2,15,'200203',3420)
INSERT INTO Vente VALUES(2,15,'200204',4726)
INSERT INTO Vente VALUES(2,15,'200205',2177)
INSERT INTO Vente VALUES(2,15,'200206',4451)
INSERT INTO Vente VALUES(2,15,'200207',35)
INSERT INTO Vente VALUES(2,15,'200208',4704)
INSERT INTO Vente VALUES(2,15,'200209',3007)
INSERT INTO Vente VALUES(2,15,'200210',3930)
INSERT INTO Vente VALUES(2,15,'200211',2883)
INSERT INTO Vente VALUES(2,15,'200212',712)
INSERT INTO Vente VALUES(2,16,'200201',1111)
INSERT INTO Vente VALUES(2,16,'200202',1915)
INSERT INTO Vente VALUES(2,16,'200203',21)
INSERT INTO Vente VALUES(2,16,'200204',2089)
INSERT INTO Vente VALUES(2,16,'200205',411)
INSERT INTO Vente VALUES(2,16,'200206',3299)
INSERT INTO Vente VALUES(2,16,'200207',4275)
INSERT INTO Vente VALUES(2,16,'200208',324)
INSERT INTO Vente VALUES(2,16,'200209',4055)
INSERT INTO Vente VALUES(2,16,'200210',3310)
INSERT INTO Vente VALUES(2,16,'200211',3457)
INSERT INTO Vente VALUES(2,16,'200212',4013)
INSERT INTO Vente VALUES(2,17,'200201',2650)
INSERT INTO Vente VALUES(2,17,'200202',3428)
INSERT INTO Vente VALUES(2,17,'200203',713)
INSERT INTO Vente VALUES(2,17,'200204',3447)
INSERT INTO Vente VALUES(2,17,'200205',3639)
INSERT INTO Vente VALUES(2,17,'200206',3888)
INSERT INTO Vente VALUES(2,17,'200207',155)
INSERT INTO Vente VALUES(2,17,'200208',4343)
INSERT INTO Vente VALUES(2,17,'200209',3222)
INSERT INTO Vente VALUES(2,17,'200210',3532)
INSERT INTO Vente VALUES(2,17,'200211',427)
INSERT INTO Vente VALUES(2,17,'200212',2759)
INSERT INTO Vente VALUES(2,18,'200201',4739)
INSERT INTO Vente VALUES(2,18,'200202',293)
INSERT INTO Vente VALUES(2,18,'200203',1374)
INSERT INTO Vente VALUES(2,18,'200204',725)
INSERT INTO Vente VALUES(2,18,'200205',4908)
INSERT INTO Vente VALUES(2,18,'200206',3099)
INSERT INTO Vente VALUES(2,18,'200207',1461)
INSERT INTO Vente VALUES(2,18,'200208',4612)
INSERT INTO Vente VALUES(2,18,'200209',1837)
INSERT INTO Vente VALUES(2,18,'200210',3472)
INSERT INTO Vente VALUES(2,18,'200211',1093)
INSERT INTO Vente VALUES(2,18,'200212',779)
INSERT INTO Vente VALUES(2,19,'200201',1202)
INSERT INTO Vente VALUES(2,19,'200202',2607)
INSERT INTO Vente VALUES(2,19,'200203',4511)
INSERT INTO Vente VALUES(2,19,'200204',532)
INSERT INTO Vente VALUES(2,19,'200205',4513)
INSERT INTO Vente VALUES(2,19,'200206',2208)
INSERT INTO Vente VALUES(2,19,'200207',400)
INSERT INTO Vente VALUES(2,19,'200208',3910)
INSERT INTO Vente VALUES(2,19,'200209',858)
INSERT INTO Vente VALUES(2,19,'200210',4871)
INSERT INTO Vente VALUES(2,19,'200211',3879)
INSERT INTO Vente VALUES(2,19,'200212',4351)
INSERT INTO Vente VALUES(2,20,'200201',1053)
INSERT INTO Vente VALUES(2,20,'200202',2283)
INSERT INTO Vente VALUES(2,20,'200203',18)
INSERT INTO Vente VALUES(2,20,'200204',3753)
INSERT INTO Vente VALUES(2,20,'200205',570)
INSERT INTO Vente VALUES(2,20,'200206',2023)
INSERT INTO Vente VALUES(2,20,'200207',1555)
INSERT INTO Vente VALUES(2,20,'200208',4963)
INSERT INTO Vente VALUES(2,20,'200209',192)
INSERT INTO Vente VALUES(2,20,'200210',1260)
INSERT INTO Vente VALUES(2,20,'200211',946)
INSERT INTO Vente VALUES(2,20,'200212',1238)
INSERT INTO Vente VALUES(2,21,'200201',767)
INSERT INTO Vente VALUES(2,21,'200202',3101)
INSERT INTO Vente VALUES(2,21,'200203',4426)
INSERT INTO Vente VALUES(2,21,'200204',4695)
INSERT INTO Vente VALUES(2,21,'200205',978)
INSERT INTO Vente VALUES(2,21,'200206',3898)
INSERT INTO Vente VALUES(2,21,'200207',3227)
INSERT INTO Vente VALUES(2,21,'200208',3283)
INSERT INTO Vente VALUES(2,21,'200209',4545)
INSERT INTO Vente VALUES(2,21,'200210',2277)
INSERT INTO Vente VALUES(2,21,'200211',4606)
INSERT INTO Vente VALUES(2,21,'200212',3320)
INSERT INTO Vente VALUES(2,22,'200201',753)
INSERT INTO Vente VALUES(2,22,'200202',3181)
INSERT INTO Vente VALUES(2,22,'200203',2847)
INSERT INTO Vente VALUES(2,22,'200204',2110)
INSERT INTO Vente VALUES(2,22,'200205',4715)
INSERT INTO Vente VALUES(2,22,'200206',2702)
INSERT INTO Vente VALUES(2,22,'200207',2892)
INSERT INTO Vente VALUES(2,22,'200208',2682)
INSERT INTO Vente VALUES(2,22,'200209',1276)
INSERT INTO Vente VALUES(2,22,'200210',1984)
INSERT INTO Vente VALUES(2,22,'200211',1751)
INSERT INTO Vente VALUES(2,22,'200212',183)
INSERT INTO Vente VALUES(3,1,'200201',3976)
INSERT INTO Vente VALUES(3,1,'200202',982)
INSERT INTO Vente VALUES(3,1,'200203',351)
INSERT INTO Vente VALUES(3,1,'200204',1947)
INSERT INTO Vente VALUES(3,1,'200205',2953)
INSERT INTO Vente VALUES(3,1,'200206',354)
INSERT INTO Vente VALUES(3,1,'200207',988)
INSERT INTO Vente VALUES(3,1,'200208',779)
INSERT INTO Vente VALUES(3,1,'200209',3221)
INSERT INTO Vente VALUES(3,1,'200210',2271)
INSERT INTO Vente VALUES(3,1,'200211',3021)
INSERT INTO Vente VALUES(3,1,'200212',3486)
INSERT INTO Vente VALUES(3,2,'200201',2206)
INSERT INTO Vente VALUES(3,2,'200202',3422)
INSERT INTO Vente VALUES(3,2,'200203',1982)
INSERT INTO Vente VALUES(3,2,'200204',4178)
INSERT INTO Vente VALUES(3,2,'200205',2961)
INSERT INTO Vente VALUES(3,2,'200206',997)
INSERT INTO Vente VALUES(3,2,'200207',4747)
INSERT INTO Vente VALUES(3,2,'200208',4380)
INSERT INTO Vente VALUES(3,2,'200209',1958)
INSERT INTO Vente VALUES(3,2,'200210',4937)
INSERT INTO Vente VALUES(3,2,'200211',926)
INSERT INTO Vente VALUES(3,2,'200212',4478)
INSERT INTO Vente VALUES(3,3,'200201',2872)
INSERT INTO Vente VALUES(3,3,'200202',2210)
INSERT INTO Vente VALUES(3,3,'200203',3136)
INSERT INTO Vente VALUES(3,3,'200204',3542)
INSERT INTO Vente VALUES(3,3,'200205',248)
INSERT INTO Vente VALUES(3,3,'200206',1427)
INSERT INTO Vente VALUES(3,3,'200207',1301)
INSERT INTO Vente VALUES(3,3,'200208',2038)
INSERT INTO Vente VALUES(3,3,'200209',4476)
INSERT INTO Vente VALUES(3,3,'200210',3550)
INSERT INTO Vente VALUES(3,3,'200211',3642)
INSERT INTO Vente VALUES(3,3,'200212',4480)
INSERT INTO Vente VALUES(3,4,'200201',1967)
INSERT INTO Vente VALUES(3,4,'200202',1987)
INSERT INTO Vente VALUES(3,4,'200203',4519)
INSERT INTO Vente VALUES(3,4,'200204',1543)
INSERT INTO Vente VALUES(3,4,'200205',1940)
INSERT INTO Vente VALUES(3,4,'200206',2852)
INSERT INTO Vente VALUES(3,4,'200207',1767)
INSERT INTO Vente VALUES(3,4,'200208',3668)
INSERT INTO Vente VALUES(3,4,'200209',3726)
INSERT INTO Vente VALUES(3,4,'200210',3681)
INSERT INTO Vente VALUES(3,4,'200211',3697)
INSERT INTO Vente VALUES(3,4,'200212',696)
INSERT INTO Vente VALUES(3,5,'200201',1000)
INSERT INTO Vente VALUES(3,5,'200202',1362)
INSERT INTO Vente VALUES(3,5,'200203',3402)
INSERT INTO Vente VALUES(3,5,'200204',4555)
INSERT INTO Vente VALUES(3,5,'200205',1839)
INSERT INTO Vente VALUES(3,5,'200206',2588)
INSERT INTO Vente VALUES(3,5,'200207',546)
INSERT INTO Vente VALUES(3,5,'200208',4537)
INSERT INTO Vente VALUES(3,5,'200209',1015)
INSERT INTO Vente VALUES(3,5,'200210',2589)
INSERT INTO Vente VALUES(3,5,'200211',3274)
INSERT INTO Vente VALUES(3,5,'200212',2192)
INSERT INTO Vente VALUES(3,6,'200201',3438)
INSERT INTO Vente VALUES(3,6,'200202',452)
INSERT INTO Vente VALUES(3,6,'200203',397)
INSERT INTO Vente VALUES(3,6,'200204',378)
INSERT INTO Vente VALUES(3,6,'200205',139)
INSERT INTO Vente VALUES(3,6,'200206',1775)
INSERT INTO Vente VALUES(3,6,'200207',1536)
INSERT INTO Vente VALUES(3,6,'200208',3486)
INSERT INTO Vente VALUES(3,6,'200209',713)
INSERT INTO Vente VALUES(3,6,'200210',1974)
INSERT INTO Vente VALUES(3,6,'200211',339)
INSERT INTO Vente VALUES(3,6,'200212',3378)
INSERT INTO Vente VALUES(3,7,'200201',3624)
INSERT INTO Vente VALUES(3,7,'200202',993)
INSERT INTO Vente VALUES(3,7,'200203',3470)
INSERT INTO Vente VALUES(3,7,'200204',3078)
INSERT INTO Vente VALUES(3,7,'200205',3274)
INSERT INTO Vente VALUES(3,7,'200206',2719)
INSERT INTO Vente VALUES(3,7,'200207',491)
INSERT INTO Vente VALUES(3,7,'200208',2726)
INSERT INTO Vente VALUES(3,7,'200209',248)
INSERT INTO Vente VALUES(3,7,'200210',4872)
INSERT INTO Vente VALUES(3,7,'200211',2320)
INSERT INTO Vente VALUES(3,7,'200212',4849)
INSERT INTO Vente VALUES(3,8,'200201',3639)
INSERT INTO Vente VALUES(3,8,'200202',2654)
INSERT INTO Vente VALUES(3,8,'200203',3399)
INSERT INTO Vente VALUES(3,8,'200204',3464)
INSERT INTO Vente VALUES(3,8,'200205',1860)
INSERT INTO Vente VALUES(3,8,'200206',1943)
INSERT INTO Vente VALUES(3,8,'200207',249)
INSERT INTO Vente VALUES(3,8,'200208',4048)
INSERT INTO Vente VALUES(3,8,'200209',847)
INSERT INTO Vente VALUES(3,8,'200210',304)
INSERT INTO Vente VALUES(3,8,'200211',1552)
INSERT INTO Vente VALUES(3,8,'200212',3922)
INSERT INTO Vente VALUES(3,9,'200201',1062)
INSERT INTO Vente VALUES(3,9,'200202',1609)
INSERT INTO Vente VALUES(3,9,'200203',2423)
INSERT INTO Vente VALUES(3,9,'200204',45)
INSERT INTO Vente VALUES(3,9,'200205',2199)
INSERT INTO Vente VALUES(3,9,'200206',2539)
INSERT INTO Vente VALUES(3,9,'200207',3029)
INSERT INTO Vente VALUES(3,9,'200208',3792)
INSERT INTO Vente VALUES(3,9,'200209',2005)
INSERT INTO Vente VALUES(3,9,'200210',1749)
INSERT INTO Vente VALUES(3,9,'200211',4213)
INSERT INTO Vente VALUES(3,9,'200212',4711)
INSERT INTO Vente VALUES(3,10,'200201',3116)
INSERT INTO Vente VALUES(3,10,'200202',4986)
INSERT INTO Vente VALUES(3,10,'200203',267)
INSERT INTO Vente VALUES(3,10,'200204',2814)
INSERT INTO Vente VALUES(3,10,'200205',4317)
INSERT INTO Vente VALUES(3,10,'200206',1933)
INSERT INTO Vente VALUES(3,10,'200207',1532)
INSERT INTO Vente VALUES(3,10,'200208',1421)
INSERT INTO Vente VALUES(3,10,'200209',133)
INSERT INTO Vente VALUES(3,10,'200210',3062)
INSERT INTO Vente VALUES(3,10,'200211',1955)
INSERT INTO Vente VALUES(3,10,'200212',93)
INSERT INTO Vente VALUES(3,11,'200201',155)
INSERT INTO Vente VALUES(3,11,'200202',2278)
INSERT INTO Vente VALUES(3,11,'200203',4289)
INSERT INTO Vente VALUES(3,11,'200204',4683)
INSERT INTO Vente VALUES(3,11,'200205',2009)
INSERT INTO Vente VALUES(3,11,'200206',3636)
INSERT INTO Vente VALUES(3,11,'200207',3057)
INSERT INTO Vente VALUES(3,11,'200208',4041)
INSERT INTO Vente VALUES(3,11,'200209',4377)
INSERT INTO Vente VALUES(3,11,'200210',2912)
INSERT INTO Vente VALUES(3,11,'200211',2975)
INSERT INTO Vente VALUES(3,11,'200212',395)
INSERT INTO Vente VALUES(3,12,'200201',3965)
INSERT INTO Vente VALUES(3,12,'200202',2311)
INSERT INTO Vente VALUES(3,12,'200203',2953)
INSERT INTO Vente VALUES(3,12,'200204',2947)
INSERT INTO Vente VALUES(3,12,'200205',2846)
INSERT INTO Vente VALUES(3,12,'200206',4080)
INSERT INTO Vente VALUES(3,12,'200207',3363)
INSERT INTO Vente VALUES(3,12,'200208',1717)
INSERT INTO Vente VALUES(3,12,'200209',51)
INSERT INTO Vente VALUES(3,12,'200210',1336)
INSERT INTO Vente VALUES(3,12,'200211',1707)
INSERT INTO Vente VALUES(3,12,'200212',1160)
INSERT INTO Vente VALUES(3,13,'200201',3855)
INSERT INTO Vente VALUES(3,13,'200202',1858)
INSERT INTO Vente VALUES(3,13,'200203',4349)
INSERT INTO Vente VALUES(3,13,'200204',584)
INSERT INTO Vente VALUES(3,13,'200205',3627)
INSERT INTO Vente VALUES(3,13,'200206',3144)
INSERT INTO Vente VALUES(3,13,'200207',4469)
INSERT INTO Vente VALUES(3,13,'200208',915)
INSERT INTO Vente VALUES(3,13,'200209',2677)
INSERT INTO Vente VALUES(3,13,'200210',4510)
INSERT INTO Vente VALUES(3,13,'200211',3900)
INSERT INTO Vente VALUES(3,13,'200212',4826)
INSERT INTO Vente VALUES(3,14,'200201',986)
INSERT INTO Vente VALUES(3,14,'200202',4507)
INSERT INTO Vente VALUES(3,14,'200203',3987)
INSERT INTO Vente VALUES(3,14,'200204',4766)
INSERT INTO Vente VALUES(3,14,'200205',4244)
INSERT INTO Vente VALUES(3,14,'200206',4451)
INSERT INTO Vente VALUES(3,14,'200207',3143)
INSERT INTO Vente VALUES(3,14,'200208',927)
INSERT INTO Vente VALUES(3,14,'200209',3084)
INSERT INTO Vente VALUES(3,14,'200210',1324)
INSERT INTO Vente VALUES(3,14,'200211',1253)
INSERT INTO Vente VALUES(3,14,'200212',3661)
INSERT INTO Vente VALUES(3,15,'200201',3940)
INSERT INTO Vente VALUES(3,15,'200202',854)
INSERT INTO Vente VALUES(3,15,'200203',3569)
INSERT INTO Vente VALUES(3,15,'200204',2404)
INSERT INTO Vente VALUES(3,15,'200205',407)
INSERT INTO Vente VALUES(3,15,'200206',4032)
INSERT INTO Vente VALUES(3,15,'200207',4276)
INSERT INTO Vente VALUES(3,15,'200208',623)
INSERT INTO Vente VALUES(3,15,'200209',1537)
INSERT INTO Vente VALUES(3,15,'200210',2866)
INSERT INTO Vente VALUES(3,15,'200211',2364)
INSERT INTO Vente VALUES(3,15,'200212',3810)
INSERT INTO Vente VALUES(3,16,'200201',959)
INSERT INTO Vente VALUES(3,16,'200202',3638)
INSERT INTO Vente VALUES(3,16,'200203',4975)
INSERT INTO Vente VALUES(3,16,'200204',76)
INSERT INTO Vente VALUES(3,16,'200205',3238)
INSERT INTO Vente VALUES(3,16,'200206',3458)
INSERT INTO Vente VALUES(3,16,'200207',870)
INSERT INTO Vente VALUES(3,16,'200208',360)
INSERT INTO Vente VALUES(3,16,'200209',1374)
INSERT INTO Vente VALUES(3,16,'200210',3383)
INSERT INTO Vente VALUES(3,16,'200211',4194)
INSERT INTO Vente VALUES(3,16,'200212',2783)
INSERT INTO Vente VALUES(3,17,'200201',1856)
INSERT INTO Vente VALUES(3,17,'200202',3897)
INSERT INTO Vente VALUES(3,17,'200203',1162)
INSERT INTO Vente VALUES(3,17,'200204',3191)
INSERT INTO Vente VALUES(3,17,'200205',1158)
INSERT INTO Vente VALUES(3,17,'200206',1022)
INSERT INTO Vente VALUES(3,17,'200207',4855)
INSERT INTO Vente VALUES(3,17,'200208',1408)
INSERT INTO Vente VALUES(3,17,'200209',114)
INSERT INTO Vente VALUES(3,17,'200210',3846)
INSERT INTO Vente VALUES(3,17,'200211',759)
INSERT INTO Vente VALUES(3,17,'200212',234)
INSERT INTO Vente VALUES(3,18,'200201',46)
INSERT INTO Vente VALUES(3,18,'200202',1742)
INSERT INTO Vente VALUES(3,18,'200203',3219)
INSERT INTO Vente VALUES(3,18,'200204',1716)
INSERT INTO Vente VALUES(3,18,'200205',2072)
INSERT INTO Vente VALUES(3,18,'200206',2082)
INSERT INTO Vente VALUES(3,18,'200207',453)
INSERT INTO Vente VALUES(3,18,'200208',2725)
INSERT INTO Vente VALUES(3,18,'200209',3496)
INSERT INTO Vente VALUES(3,18,'200210',1689)
INSERT INTO Vente VALUES(3,18,'200211',3287)
INSERT INTO Vente VALUES(3,18,'200212',4381)
INSERT INTO Vente VALUES(3,19,'200201',2677)
INSERT INTO Vente VALUES(3,19,'200202',2850)
INSERT INTO Vente VALUES(3,19,'200203',269)
INSERT INTO Vente VALUES(3,19,'200204',2328)
INSERT INTO Vente VALUES(3,19,'200205',1299)
INSERT INTO Vente VALUES(3,19,'200206',2134)
INSERT INTO Vente VALUES(3,19,'200207',4316)
INSERT INTO Vente VALUES(3,19,'200208',2432)
INSERT INTO Vente VALUES(3,19,'200209',437)
INSERT INTO Vente VALUES(3,19,'200210',2829)
INSERT INTO Vente VALUES(3,19,'200211',3547)
INSERT INTO Vente VALUES(3,19,'200212',3892)
INSERT INTO Vente VALUES(3,20,'200201',4321)
INSERT INTO Vente VALUES(3,20,'200202',4252)
INSERT INTO Vente VALUES(3,20,'200203',1465)
INSERT INTO Vente VALUES(3,20,'200204',4321)
INSERT INTO Vente VALUES(3,20,'200205',3224)
INSERT INTO Vente VALUES(3,20,'200206',3734)
INSERT INTO Vente VALUES(3,20,'200207',4143)
INSERT INTO Vente VALUES(3,20,'200208',3828)
INSERT INTO Vente VALUES(3,20,'200209',4359)
INSERT INTO Vente VALUES(3,20,'200210',4541)
INSERT INTO Vente VALUES(3,20,'200211',4562)
INSERT INTO Vente VALUES(3,20,'200212',2609)
INSERT INTO Vente VALUES(3,21,'200201',2200)
INSERT INTO Vente VALUES(3,21,'200202',538)
INSERT INTO Vente VALUES(3,21,'200203',1770)
INSERT INTO Vente VALUES(3,21,'200204',4115)
INSERT INTO Vente VALUES(3,21,'200205',2138)
INSERT INTO Vente VALUES(3,21,'200206',849)
INSERT INTO Vente VALUES(3,21,'200207',4)
INSERT INTO Vente VALUES(3,21,'200208',3287)
INSERT INTO Vente VALUES(3,21,'200209',3867)
INSERT INTO Vente VALUES(3,21,'200210',318)
INSERT INTO Vente VALUES(3,21,'200211',449)
INSERT INTO Vente VALUES(3,21,'200212',1928)
INSERT INTO Vente VALUES(3,22,'200201',3419)
INSERT INTO Vente VALUES(3,22,'200202',4038)
INSERT INTO Vente VALUES(3,22,'200203',770)
INSERT INTO Vente VALUES(3,22,'200204',714)
INSERT INTO Vente VALUES(3,22,'200205',242)
INSERT INTO Vente VALUES(3,22,'200206',1730)
INSERT INTO Vente VALUES(3,22,'200207',92)
INSERT INTO Vente VALUES(3,22,'200208',4892)
INSERT INTO Vente VALUES(3,22,'200209',3238)
INSERT INTO Vente VALUES(3,22,'200210',268)
INSERT INTO Vente VALUES(3,22,'200211',4570)
INSERT INTO Vente VALUES(3,22,'200212',3187)


PRINT ' '
PRINT '--------------------------------------------'
PRINT 'La base de donnees a ete correctement cree'
PRINT 'Plus d informations : www.savonsdusoleil.com'
PRINT ' '
