﻿namespace SDS.Controls {

    using System;                
    using System.Data;    
    using System.Drawing;    
    using System.Drawing.Imaging;
    using System.Web;
    using System.Web.UI;
    using System.Web.UI.WebControls;

    public class Camembert : WebControl {
                                          
        DataView _dataSource;
        
        public DataView DataSource
        {
            get {return _dataSource;  }
			set {_dataSource = value; }		
        }
        
        public string DataValueField
        {
            get {return (string)ViewState["DataValueField"];  }
			set {ViewState["DataValueField"] = value; }
        }
            
        public string DataTextField
        {
            get {return (string)ViewState["DataTextField"];  }
			set {ViewState["DataTextField"] = value; }
        }
                                                
        private Brush GetBrush(int index)
        {
            Brush br = Brushes.Black; // Par défaut
            
            switch(index)
            {
                case 0 :
                    br = Brushes.CornflowerBlue;
                break;
        
                case 1 :
                    br = Brushes.HotPink;
                break;
        
                case 2 :
                    br = Brushes.MediumSpringGreen;
                break;                
            }
            
            return br;
        }
                           
        protected override void Render(HtmlTextWriter output)
		{			   
			// Création d'une image de type Bitmap 400x200
            Bitmap bm = new Bitmap(400,200);

            // Obtention de l'objet graphique associé
            Graphics g = Graphics.FromImage(bm);

            // On initialise tout en blanc
            g.Clear(Color.White);
           
            Font f = new Font("Verdana", 8);
            int i = 0;
           
            float startAngle = -90;
            float sweepAngle = 0;
                                                        
            
            foreach(DataRowView dr in DataSource)                        
            {
               float  pourcentage = Convert.ToSingle(dr[DataValueField]);
               string etiquette   = dr[DataTextField].ToString();
               string legend = String.Format("{0} ({1:F1}%)",etiquette,pourcentage);

                // Dessin de la portion de camembert
                sweepAngle = pourcentage*360/100;
                g.FillPie(GetBrush(i),10,10,180,180,startAngle,sweepAngle);
                startAngle += sweepAngle;

                // Légende
                g.FillRectangle(GetBrush(i),240,50+i*40,20,20);
                g.DrawString(legend, f, Brushes.Black,270,52+i*40);

                i++;
            }

            // Sauvegarde de l'image vers un fichier temporaire (dans le sous-répertoire img de l'application)
            
            HttpRequest rq = Context.Request;            
            string path = rq.MapPath(rq.ApplicationPath)+"\\img";

            bm.Save(path+"\\"+"Camembert.gif",ImageFormat.Gif);
            output.Write("<img src='imageHandler.aspx?path="+path+"&src=camembert.gif'>");                        

            // Libération des ressources graphiques

            f.Dispose();
            g.Dispose();
            bm.Dispose();
    
		}
    }
}
