﻿<%@ Page Language="C#" %>
<%@ Register TagPrefix="SDS" TagName="NavBar" Src="NavBar.ascx" %>
<%@ Register TagPrefix="SDS" TagName="Footer" Src="Footer.ascx" %>
<%@ import Namespace="System.Data" %>
<%@ import Namespace="System.Data.SqlClient" %>
<script runat="server">

    // Variables membres de la page
    
    SqlDataAdapter    myAdapter;
    DataTable         myDataTable;
    
    void Page_Load(Object sender, EventArgs e)
    {
       // Définition de la connexion
       SqlConnection myConnection = new SqlConnection(ConfigurationSettings.AppSettings["ConnectionString"]);
    
       // Récupération du numéro de commande
       ID   = Request.Params["id"];
    
        // Allocation du 'DataAdapter'
    
        string SelectSQL = "DetailsCommande";
        string UpdateSQL = "UPDATE Commande Set Livree = @Livree WHERE ID_Commande  = "+ID;
    
        myAdapter = new SqlDataAdapter(SelectSQL,myConnection);
    
        myAdapter.SelectCommand.CommandType = CommandType.StoredProcedure;
        myAdapter.SelectCommand.Parameters.Add("@CommandeID",SqlDbType.Int);
        myAdapter.SelectCommand.Parameters["@CommandeID"].Value = ID;
    
        // Il est important de remplir le DataAdapter avant de définir UpdateCommande
    
        myDataTable = new DataTable();
        myAdapter.Fill(myDataTable);
    
        myAdapter.UpdateCommand = new SqlCommand(UpdateSQL,myConnection);
        myAdapter.UpdateCommand.Parameters.Add("@Livree",SqlDbType.Bit,1,"Livree");
    
    
        if (!IsPostBack)
        {
            DataRow CurrentRow = myDataTable.Rows[0];
    
            // Affichage des informations d'en-tête
    
            NoCommande.Text = ID;
    
            NomFournisseur.Text = (string)CurrentRow["NomFournisseur"];
            DateLivraison.Text = String.Format("{0:d}",CurrentRow["DateLivraison"]);
    
            bool Livree = (bool)CurrentRow["Livree"];
            StatutLivraison.SelectedIndex = ( (Livree == true)? 0 : 1);
    
            // Récupération des informations relatives aux lignes de commandes
    
            string SQL = "ListeLignesCommandes";
            SqlCommand myCommand = new SqlCommand(SQL,myConnection);
            myCommand.CommandType = CommandType.StoredProcedure;
            myCommand.Parameters.Add("@CommandeID",SqlDbType.Int).Value = ID;
            
            myConnection.Open();        
            SqlDataReader myReader = myCommand.ExecuteReader();
            
            LignesCommande.DataSource = myReader;
            LignesCommande.DataBind();
            
            myReader.Close();
            myConnection.Close();
        }
    }
    
    void OnEnregistrerClicked(Object sender, EventArgs e)
    {
        if(StatutLivraison.SelectedIndex == 0)
        {
            myDataTable.Rows[0]["Livree"]=true;
        }
        else
        {
            myDataTable.Rows[0]["Livree"]=false;
        }
    
        myAdapter.Update(myDataTable);
    
        Response.Redirect("fournisseurs.aspx");
    
    }
    
    void OnAnnulerClicked(Object sender, EventArgs e)
    {
       Response.Redirect("fournisseurs.aspx");
    }

</script>
<html>
<head>
    <title>Cahier du programmeur ASP.NET - Etude de cas</title>
</head>
<body>
    <link href="SDS.css" type="text/css" rel="stylesheet" />
    <SDS:NavBar id="NavBar" SelectedIndex="2" runat="server"></SDS:NavBar>
    <form runat="server">
        <h4>Détail de la commande n° 
            <asp:Label id="NoCommande" runat="server">[NoCommande]</asp:Label>
        </h4>
        <table bordercolor="black">
            <tbody>
                <tr bgcolor="#aaaadd">
                    <td width="100%" colspan="2">
                        <font color="white"><b>En-tête de la commande</b></font> 
                    </td>
                </tr>
                <tr valign="center" height="25">
                    <td width="150">
                        Fournisseur 
                    </td>
                    <td width="250">
                        &nbsp;<asp:Label id="NomFournisseur" runat="server" Height="14px" Font-Bold="True"></asp:Label>
                    </td>
                </tr>
                <tr valign="center" height="25">
                    <td width="150">
                        Date livraison prévue</td>
                    <td width="250">
                        &nbsp;<asp:Label id="DateLivraison" runat="server" Height="12px" width="80px">[DateLivraison]</asp:Label>
                    </td>
                </tr>
                <tr valign="center" height="25">
                    <td width="150">
                        Livrée 
                    </td>
                    <td width="250">
                        <asp:RadioButtonList id="StatutLivraison" runat="server" Height="7px" Width="68px" RepeatDirection="Horizontal">
                            <asp:ListItem>Oui</asp:ListItem>
                            <asp:ListItem>Non</asp:ListItem>
                        </asp:RadioButtonList>
                    </td>
                </tr>
            </tbody>
        </table>
        <br />
        <table bordercolor="black" bgcolor="#aaaadd">
            <tbody>
                <tr>
                    <td width="380">
                        <font color="white"><b>Lignes de commandes</b></font></td>
                </tr>
            </tbody>
        </table>
        <asp:DataGrid id="LignesCommande" runat="server" AutoGenerateColumns="false">
            <Columns>
                <asp:BoundColumn HeaderText="Code" DataField="Code">
                    <HeaderStyle font-bold="true" width="50px"></HeaderStyle>
                </asp:BoundColumn>
                <asp:BoundColumn HeaderText="Désignation" DataField="Designation">
                    <HeaderStyle font-bold="true" width="271px"></HeaderStyle>
                </asp:BoundColumn>
                <asp:BoundColumn HeaderText="Quantité" DataField="Quantite">
                    <HeaderStyle font-bold="true" width="50px"></HeaderStyle>
                </asp:BoundColumn>
            </Columns>
        </asp:DataGrid>
        <br />
        <br />
        <asp:Button id="BoutonEnregistrer" onclick="OnEnregistrerClicked" runat="server" Text="Enregistrer"></asp:Button>
        <asp:Button id="BoutonAnnuler" onclick="OnAnnulerClicked" runat="server" Text="Annuler" CausesValidation="False"></asp:Button>
        <br />
        <SDS:Footer id="MyFooter" runat="server"></SDS:Footer>
    </form>
    <pre></pre>
</body>
</html>
