﻿<%@ Page Language="C#" %>
<%@ import Namespace="System.Web.Mail" %>
<script runat="server">

    void Envoyer_Click(Object sender, EventArgs e)
    {
        MailMessage mail = new MailMessage();
    
        try
        {
            string ID = Request.Params["id"];
    
            mail.From = "webmaster@savonsdusoleil.com";
            mail.To = Adresse.Text;
            mail.Subject = "Nouvelle commande";
            mail.Body = "Veuillez trouver ci-joint le fichier XML correspondant à la commande "+ID;
            mail.BodyFormat = MailFormat.Html;
    
            string VirtualPath = Request.ApplicationPath+"\\xml\\Commande"+ID+".xml";
            string FilePath    = Request.MapPath(VirtualPath);
    
            MailAttachment MyAttachment = new MailAttachment(FilePath);
    
            mail.Attachments.Add(MyAttachment);
    
            string server = ConfigurationSettings.AppSettings["SmtpServer"];
    
            if (server=="VotreServeurSMTP")
            {
                throw new Exception("Vous n'avez pas précisé la valeur de SmtpServer dans le fichier web.config");
            }
    
            SmtpMail.SmtpServer = server;
            SmtpMail.Send(mail);
            Resultat.Text = "Le message a été correctement envoyé !";
    
         }
         catch(Exception myException)
         {
            Resultat.Text = "Echec de l'envoi du message : '"+myException.Message+"'";
         }
    }

</script>
<html>
<head>
    <link href="SDS.css" type="text/css" rel="stylesheet" />
</head>
<body>
    <form runat="server">
        <h4>Simulation envoi commande 
        </h4>
        <p>
            Entrez votre adresse e-mail 
            <asp:TextBox id="Adresse" runat="server" Height="20px"></asp:TextBox>
            <asp:Button id="Envoyer" onclick="Envoyer_Click" runat="server" Height="21px" Text="Envoyer"></asp:Button>
        </p>
        <p>
            &nbsp;<asp:Label id="Resultat" runat="server" Font-Bold="True"></asp:Label>
            <asp:RegularExpressionValidator id="ValiderAdresse" runat="server" ValidationExpression="\w+([-+.]\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*" ControlToValidate="Adresse" ErrorMessage="Merci de saisir une adresse e-mail valide">Merci de saisir une adresse e-mail valide</asp:RegularExpressionValidator>
        </p>
        <p>
            <table width="370">
                <tbody>
                    <tr>
                        <td align="right">
                            <a onclick="window.close()" href=".">Fermer cette fenêtre</a> 
                        </td>
                    </tr>
                </tbody>
            </table>
        </p>
        <p>
        </p>
    </form>
</body>
</html>
