﻿<%@ Page Language="C#" %>
<%@ Register TagPrefix="SDS" TagName="NavBar" Src="NavBar.ascx" %>
<%@ Register TagPrefix="SDS" TagName="Footer" Src="Footer.ascx" %>
<%@ import Namespace="System.Data.SqlClient" %>
<%@ import Namespace="SDS" %>
<script runat="server">

    void Page_Load(object sender, EventArgs e)
    {
        // Récupération du numéro de commande (passé en paramètre)
    
        string ID = Request.Params["id"];
    
        // Mise à jour du numéro de commande
    
        NoCommande.Text = ID;
    
        // Création d'une instance de myGenerator
    
        string path, xmlFile, xslFile, htmlFile;
    
        SqlConnection myConnection = new SqlConnection(ConfigurationSettings.AppSettings["ConnectionString"]);
    
        path = Request.MapPath(Request.ApplicationPath)+"\\xml\\";
        XmlGenerator myGenerator = new XmlGenerator(ID,myConnection,path);
    
        xmlFile  = "Commande"+ID+".xml";
        xslFile  = "GenererTelecopie.xslt";
        htmlFile = "Commande"+ID+".html";
    
        myGenerator.GenererFichierXml(xmlFile);
        myGenerator.GenererTelecopie(xmlFile,xslFile,htmlFile);
    
        string PopupArgs;
    
        PopupArgs = "'scrollbars=no,status=no,resizable=yes,width=500,height=400'";
    
        VoirXML.NavigateUrl="javascript:openpopup('xml/"+xmlFile+"',"+PopupArgs+")";
        VoirFax.NavigateUrl="javascript:openpopup('xml/"+htmlFile+"',"+PopupArgs+")";
    
        string MailPopupUrl;
        string MailPopupArgs;
    
        MailPopupUrl  = "EnvoiCommande.aspx?id="+ID;
        MailPopupArgs = "'scrollbars=no,status=no,resizable=yes,width=400,height=150'";
    
        EnvoyerXML.NavigateUrl="javascript:openpopup('"+MailPopupUrl+"',"+MailPopupArgs+")";
    
    }

</script>
<html>
<head>
    <title>Cahier du programmeur ASP.NET - Etude de cas</title>
    <link href="SDS.css" type="text/css" rel="stylesheet" />
</head>
<body>
    <SDS:NavBar id="NavBar" runat="server" SelectedIndex="2"></SDS:NavBar>
    <script>
    function openpopup(popup_url,params)
    {	   
	   retcode=window.open(popup_url,'',params);	   
    }
</script>
    <form runat="server">
        <h4>Cette nouvelle commande a été enregistrée sous le n°<asp:Label id="NoCommande" runat="server"></asp:Label>
        </h4>
        <p>
            <table style="BORDER-COLLAPSE: collapse" bordercolor="black" cellpadding="3" border="1">
                <tbody>
                    <tr valign="center">
                        <td align="middle" width="50">
                            <img src="img/XML.gif" /></td>
                        <td width="400">
                            <asp:HyperLink id="VoirXML" runat="server">Voir le fichier XML correspondant à la commande </asp:HyperLink>
                        </td>
                    </tr>
                    <tr valign="center">
                        <td align="middle" width="50">
                            <img src="img/Fax.gif" /></td>
                        <td width="400">
                            <asp:HyperLink id="VoirFax" runat="server">Voir la télécopie correspondant à la commande</asp:HyperLink>
                        </td>
                    </tr>
                    <tr valign="center">
                        <td align="middle" width="50">
                            <img src="img/Email.gif" /></td>
                        <td width="400">
                            <asp:HyperLink id="EnvoyerXML" runat="server">Envoyer le fichier XML au fournisseur</asp:HyperLink>
                        </td>
                    </tr>
                </tbody>
            </table>
        </p>
        <a href="./fournisseurs.aspx">[Retour à la page d'accueil du module]</a> 
        <br />
        <SDS:Footer id="MyFooter" runat="server"></SDS:Footer>
    </form>
</body>
</html>
