﻿<%@ Page Language="c#" %>
<%@ Register TagPrefix="SDS" TagName="NavBar" Src="NavBar.ascx" %>
<%@ Register TagPrefix="SDS" TagName="Footer" Src="Footer.ascx" %>
<%@ import Namespace="System.Data" %>
<%@ import Namespace="System.Data.SqlClient" %>
<%@ import Namespace="System.Drawing" %>
<script runat="server">

    SqlConnection myConnection;
    
    
    string AfficherBooleen(object o)
    {
        bool b = (bool)o;
        return (b ? "Oui" : "Non");
    }
    
    void Page_Load(Object sender, EventArgs e)
    {
        string connStr = ConfigurationSettings.AppSettings["ConnectionString"];
        myConnection   = new SqlConnection(connStr);
    
        if(!IsPostBack)
        {
            ViewState["PageIndex"] = 0;
            ChargerListeCommandes(0);
        }
    }
    
    void MettreAJourAffichagePagination(int NumeroPage, int NombrePages)
    {
        // Mise à jour du bouton "Page suivante"
    
        PageSuivante.Visible = ( NumeroPage == NombrePages ? false : true );
    
        // Mise à jour du bouton "Page précédente"
    
        PagePrecedente.Visible = ( NumeroPage == 1 ? false : true);
    
        // Mise à jour du label "numéro de page"
    
        NoPage.Text  = NumeroPage.ToString();
        NbPages.Text = NombrePages.ToString();
    }
    
    void ChargerListeCommandes(int index)
    {
    
        string SQL = "ListeCommandes";
        SqlDataAdapter myAdapter = new SqlDataAdapter(SQL,myConnection);
        myAdapter.SelectCommand.CommandType = CommandType.StoredProcedure;
    
        DataTable myDataTable = new DataTable();
        myAdapter.Fill(myDataTable);
    
        PagedDataSource myPager;
        myPager = new PagedDataSource();
        myPager.DataSource =  myDataTable.DefaultView;
        myPager.AllowPaging = true;
        myPager.PageSize    = 2;
        myPager.CurrentPageIndex = index;
    
        ListeCommandes.DataSource = myPager;
        ListeCommandes.DataBind();
    
        ListeVide.Visible = (ListeCommandes.Items.Count==0 ? true : false);
    
        MettreAJourAffichagePagination(myPager.CurrentPageIndex+1,myPager.PageCount);
    }
    
    
    void OnItemCommand(Object sender, RepeaterCommandEventArgs e)
    {
        // Suppression de l'élément sélectionné
    
        string SQL = "DELETE FROM Commande WHERE ID_Commande = "+e.CommandArgument;
        SqlCommand myCommand = new SqlCommand(SQL,myConnection);
    
        myConnection.Open();
        myCommand.ExecuteNonQuery();
        myConnection.Close();
    
        ViewState["PageIndex"] = 0;
        ChargerListeCommandes(0);
    }
    
    void OnItemCreated(Object sender, RepeaterItemEventArgs e)
    {
        // Association d'un script de confirmation de la suppression à chaque bouton
    
        LinkButton myDeleteButton;
    
        if (e.Item.ItemType==ListItemType.Item)
        {
              myDeleteButton = (LinkButton)e.Item.FindControl("btnDelete");
              myDeleteButton.Attributes.Add("onclick","return confirm('Confirmez-vous la suppression de cette commande?');");
         }
    
    }
    
    void OnPageSuivante(Object sender, EventArgs e)
    {
        // Récupération de la valeur actuelle de PageIndex
    
        int PageIndex = (int)ViewState["PageIndex"];
    
        // Incrémentation (rq : on est assuré que PageIndex < PageCount grace à MettreAJourAffichage)
    
        PageIndex++;
    
        // Chargement de la page correspondante
        ChargerListeCommandes(PageIndex);
    
        // Sauvegarde de la nouvelle valeur de PageIndex
    
         ViewState["PageIndex"] = PageIndex;
    
    }
    
    void OnPagePrecedente(Object sender, EventArgs e)
    {
        // Récupération de la valeur actuelle de PageIndex
    
        int PageIndex = (int)ViewState["PageIndex"];
    
        // Incrémentation (rq : on est assuré que PageIndex > 0 grace à MettreAJourAffichage)
    
        PageIndex--;
    
        // Chargement de la page correspondante
        ChargerListeCommandes(PageIndex);
    
        // Sauvegarde de la nouvelle valeur de PageIndex
    
         ViewState["PageIndex"] = PageIndex;
    }

</script>
<html>
<head>
    <title>Cahier du programmeur ASP.NET - Etude de cas</title>
    <link href="SDS.css" type="text/css" rel="stylesheet" />
</head>
<body>
    <SDS:NavBar id="NavBar" runat="server" SelectedIndex="2"></SDS:NavBar>
    <p>
    </p>
    <p>
    </p>
    <form runat="server">
        <h4>Liste des commandes fournisseurs (Page 
            <asp:Label id="NoPage" runat="server">#NoPage#</asp:Label>
            sur 
            <asp:Label id="NbPages" runat="server">#NbPages#</asp:Label>
            ) 
        </h4>
        <p>
        </p>
        <asp:Repeater id="ListeCommandes" runat="server" OnItemCreated="OnItemCreated" OnItemCommand="OnItemCommand">
            <ItemTemplate>
                <table bordercolor="black" bgcolor="#aaaadd">
                    <tbody>
                        <tr>
                            <td width="300" >
                                <b><font color="white"> Commande n°<%# DataBinder.Eval(Container.DataItem, "ID_Commande") %> </font></b> 
                            </td>
                            <td width="150" align="right">
                                <asp:HyperLink runat="server" NavigateUrl=<%#DataBinder.Eval(Container.DataItem,"ID_Commande","DetailCommande.aspx?id={0}")%>>
                                 [Détails]
                                </asp:HyperLink>
                                <asp:LinkButton id="btnDelete" CommandArgument='<%# DataBinder.Eval(Container.DataItem, "ID_Commande") %>' runat="server">[Supprimer]</asp:LinkButton>
                            </td>
                        </tr>
                    </tbody>
                </table>
                <table bordercolor="black" bgcolor="#ffffc0">
                    <tbody>
                        <tr>
                            <td width="150">
                                Fournisseur : 
                            </td>
                            <td width="300">
                                <b> <%# ((DataRowView)Container.DataItem)["NomFournisseur"] %> </b> 
                            </td>
                        </tr>
                        <tr>
                            <td width="150">
                                Date livraison prévue : 
                            </td>
                            <td width="250">
                                <%# DataBinder.Eval(Container.DataItem, "DateLivraison","{0:d}") %> 
                            </td>
                        </tr>
                        <tr>
                            <td width="150">
                                Livrée : 
                            </td>
                            <td width="250">
                                <%# AfficherBooleen(DataBinder.Eval(Container.DataItem,"Livree")) %> 
                            </td>
                        </tr>
                    </tbody>
                </table>
            </ItemTemplate>
            <SeparatorTemplate>
                <br />
            </SeparatorTemplate>
        </asp:Repeater>
        <br />
        <asp:Label id="ListeVide" runat="server">Il n'y a aucune commande dans cette liste</asp:Label>
        <h4>
        </h4>
        <p>
            <asp:Button id="PagePrecedente" onclick="OnPagePrecedente" runat="server" Text=" < "></asp:Button>
            <asp:Button id="PageSuivante" onclick="OnPageSuivante" runat="server" Text=" > "></asp:Button>
            &nbsp;<a href="NouvelleCommande.aspx">[Nouvelle commande]</a> 
        </p>
        <SDS:Footer id="MyFooter" runat="server"></SDS:Footer>
    </form>
</body>
</html>
