﻿<%@ Control Language="C#" %>
<%@ outputcache duration="7200" varybyparam="none" %>
<%@ import Namespace="WeatherServices" %>
<script runat="server">

    class WeatherInfos
    {
        public string imageUrl;
        public string temperature;
    }
    
    WeatherInfos GetWeatherInfos(string code)
    {
        GlobalWeather gw = new GlobalWeather();
        gw.Timeout = 3000;
    
    
        WeatherReport report;
    
        try
        {
            report = gw.getWeatherReport(code);
        }
        catch(Exception e)
        {
            report = null;
    
        }
        WeatherInfos infos = new WeatherInfos();
    
        bool absenceInfos = false;
    
        if (report != null)
        {
            if (report.sky != null)
            {
                if (report.sky.layers != null)
                {
                    if (report.sky.layers.Length>0)
                    {
                        int    tauxCouverture  = report.sky.layers[0].extent;
                        infos.imageUrl = String.Format("img/Couvert{0}-4.gif",tauxCouverture);
                    }
                    else
                        absenceInfos = true;
                }
                else
                    absenceInfos = true;
            }
            else
                absenceInfos = true;
        }
        else
            absenceInfos = true;
    
        if (absenceInfos == true)
        {
            infos.imageUrl = "img/AbsenceInfos.gif";
        }
    
        infos.temperature = ""; // par défaut
    
        if (report != null)
        {
            if (report.temperature != null)
            {
                infos.temperature = String.Format("{0} °",report.temperature.ambient);
            }
        }
    
        return infos;
    }
    
    void Page_Load(Object sender, EventArgs e)
    {
        string imageUrl;
        double temperature;
    
        WeatherInfos infos;
    
        Trace.Write("Contrôle météo","Avant GetWeatherInfos (Paris)");
        infos = GetWeatherInfos("LFPO");
        Trace.Write("Contrôle météo","Après GetWeatherInfos (Paris)");
    
        ImageParis.ImageUrl = infos.imageUrl;
        TemperatureParis.Text = infos.temperature;
    
    
        Trace.Write("Contrôle météo","Avant GetWeatherInfos (Marseille");
        infos = GetWeatherInfos("LFML");
        Trace.Write("Contrôle météo","Après GetWeatherInfos (Marseille)");
        ImageMarseille.ImageUrl = infos.imageUrl;
        TemperatureMarseille.Text = infos.temperature;
    
    }

</script>
<table style="BORDER-COLLAPSE: collapse" bordercolor="#111111" cellspacing="0" cellpadding="0" bgcolor="#ffffc0" border="1">
    <tbody>
        <tr>
            <td align="middle" colspan="2">
                <b><font color="#000080">Météo sur nos sites</font> </b></td>
        </tr>
        <tr border="1">
            <td width="100">
                <p align="center">
                    <strong>PARIS </strong>
                </p>
            </td>
            <td align="middle" width="100" bgcolor="white">
                <asp:Image id="ImageParis" runat="server"></asp:Image>
                <br />
                <b>
                <asp:Label id="TemperatureParis" runat="server">Label</asp:Label>
                <br />
                <br />
                </b></td>
        </tr>
        <tr>
            <td width="100">
                <p align="center">
                    <strong>MARSEILLE </strong>
                </p>
            </td>
            <td align="middle" width="100" bgcolor="white">
                <asp:Image id="ImageMarseille" runat="server"></asp:Image>
                <br />
                <b>
                <asp:Label id="TemperatureMarseille" runat="server">Label</asp:Label>
                <br />
                <br />
                </b></td>
        </tr>
        <tr>
            <td colspan="2">
                <p align="center">
                    <em>Service fourni par</em> <a href="http://www.capescience.com/webservices/globalweather/index.shtml" target="_blank">CapeScience</a> 
                </p>
            </td>
        </tr>
    </tbody>
</table>