﻿<%@ Control Language="C#" %>
<%@ import Namespace="System.Security.Principal" %>
<script runat="server">

    public int SelectedIndex; // Propriété publique spécifiant la rubrique active
    
        void Page_Load(Object sender, EventArgs e)
        {
            // Mise à jour des liens
    
            Rubrique1.Text = "Accueil";
            Rubrique1.NavigateUrl = "default.aspx";
    
            Rubrique2.Text = "Stocks";
            Rubrique2.NavigateUrl = "stocks.aspx";
    
            Rubrique3.Text = "Fournisseurs";
            Rubrique3.NavigateUrl = "fournisseurs.aspx";
    
            Rubrique4.Text = "Ventes";
            Rubrique4.NavigateUrl = "ventes.aspx";
    
            // Mise à jour du titre
    
            switch (SelectedIndex)
            {
                case 0 :
                    Titre.Text = "Accueil Intranet";
                    Rubrique1.CssClass = "active-rubrique";
                break;
    
                case 1 :
                    Titre.Text = "Suivi des stocks";
                    Rubrique2.CssClass = "active-rubrique";
                break;
    
                case 2 :
                    Titre.Text = "Gestion des fournisseurs";
                    Rubrique3.CssClass = "active-rubrique";
                break;
    
                case 3 :
                    Titre.Text = "Analyse des ventes";
                    Rubrique4.CssClass = "active-rubrique";
                break;
            }
    
    
            string userName = Context.User.Identity.Name;
            Utilisateur.Text = userName;
    
            if (userName == "marketing")
            {
                if ((SelectedIndex ==1) || (SelectedIndex == 2))
                    Response.Redirect("login.aspx");
    
                Separator2.Visible = false;
                Separator3.Visible = false;
                Rubrique2.Visible = false;
                Rubrique3.Visible = false;
                Separator4.Visible = false;
            }
    
            if (userName == "logistique")
            {
                if ((SelectedIndex ==3))
                    Response.Redirect("login.aspx");
    
                Separator4.Visible = false;
                Rubrique4.Visible = false;
            }
        }

</script>
<!-- Insert content here -->
<table style="WIDTH: 100%">
    <tbody>
        <tr>
            <td bgcolor="#00c000" colspan="2">
                <img src="./img/soleil.gif" align="center" /> 
                <asp:Label id="Titre" runat="server" Font-Bold="True" Font-Size="Large" ForeColor="#FFFF80">Label</asp:Label>
            </td>
        </tr>
        <tr bgcolor="#ffff80">
            <td>
                <asp:HyperLink id="Rubrique1" runat="server">HyperLink</asp:HyperLink>
                <asp:Label id="Separator1" runat="server">&nbsp;|</asp:Label>
                <asp:HyperLink id="Rubrique2" runat="server">HyperLink</asp:HyperLink>
                <asp:Label id="Separator2" runat="server">&nbsp;|</asp:Label>
                <asp:HyperLink id="Rubrique3" runat="server">HyperLink</asp:HyperLink>
                <asp:Label id="Separator3" runat="server">&nbsp;|</asp:Label>
                <asp:HyperLink id="Rubrique4" runat="server">HyperLink</asp:HyperLink>
                <asp:Label id="Separator4" runat="server">&nbsp;|</asp:Label>
            </td>
            <td align="right">
                Utilisateur : 
                <asp:Label id="Utilisateur" runat="server" Font-Bold="True">Label</asp:Label>
            </td>
        </tr>
    </tbody>
</table>
<p>
</p>
<p>
</p>
<p>
</p>
<p>
</p>