﻿<%@ Page Language="C#" %>
<%@ Register TagPrefix="SDS" TagName="NavBar" Src="NavBar.ascx" %>
<%@ Register TagPrefix="SDS" TagName="Footer" Src="Footer.ascx" %>
<%@ import Namespace="System.Data" %>
<%@ import Namespace="System.Data.SqlClient" %>
<%@ import Namespace="System.Xml" %>
<%@ import Namespace="System.Xml.Xsl" %>
<%@ import Namespace="System.Xml.XPath" %>
<script runat="server">

    // Variables membres de la page
    
    SqlConnection     myConnection;
    SqlDataAdapter    myAdapter;
    DataSet           myDataSet;
    
    void Page_Load(Object sender, EventArgs e)
    {
       // Création d'une connexion
    
       string connStr = ConfigurationSettings.AppSettings["ConnectionString"];
       myConnection   = new SqlConnection(connStr);
    
       if(!IsPostBack)
       {
             ChargerListeFournisseurs();
             Calendrier.SelectedDate = DateTime.Now.AddDays(7);
       }
    }
    
    
    void OnFournisseurChanged(Object sender, EventArgs e)
    {
        AfficherListeReferences();
    }
    
    void ChargerListeFournisseurs()
    {
        // Chargement de la liste des fournisseurs
    
        SqlCommand    myCommand;
        string        SQL = "SELECT * FROM Fournisseur";
    
        myCommand = new SqlCommand(SQL,myConnection);
    
        SqlDataReader myDataReader;
    
        myConnection.Open();
        myDataReader= myCommand.ExecuteReader();
    
        ListeFournisseurs.DataSource = myDataReader;
        ListeFournisseurs.DataTextField  = "NomFournisseur";
        ListeFournisseurs.DataValueField = "ID_Fournisseur";
        ListeFournisseurs.DataBind();
    
        myDataReader.Close();
        myConnection.Close();
    
        // Chargement de la liste des références pour le fournisseur actif
    
        AfficherListeReferences();
    }
    
    void AfficherListeReferences()
    {
        string ID  = ListeFournisseurs.SelectedItem.Value;
    
        string SQL = "SELECT * FROM ReferenceFournisseur WHERE ID_Fournisseur = " + ID;
    
        SqlDataReader  myReader;
        SqlCommand     myCommand = new SqlCommand(SQL,myConnection);
    
        myConnection.Open();
        myReader = myCommand.ExecuteReader();
    
        DetailCommande.DataSource = myReader;
        DetailCommande.DataKeyField = "ID_ReferenceFournisseur";
        DetailCommande.DataBind();
    
        myReader.Close();
        myConnection.Close();
    }
    
    
    void OnEnregistrerClicked(Object sender, EventArgs e)
    {
        AuMoinsUneLigne.Visible=false;
    
    
        if (Page.IsValid==false)
        {
            return;
        }
    
        if (NbLignesCommandeNonVides()==0)
        {
            AuMoinsUneLigne.Visible=true;
            return;
        }
    
    
        // Création nouvelle commande
    
        string RedirectionURL = "";
        string SQL;
    
        SqlDataAdapter CommandAdapter,
                        LinesAdapter;
    
        myDataSet = new DataSet();
    
        // Création nouvelle transaction
    
        myConnection.Open();
        SqlTransaction myTransaction = myConnection.BeginTransaction();
    
        // Préparation de DataSet & SqlDataAdapter pour la table "Commande"
    
        try
        {
            SQL = "SELECT * FROM Commande WHERE ID_Commande = 0";
    
            CommandAdapter = new SqlDataAdapter(SQL,myConnection);
    
            CommandAdapter.SelectCommand.Transaction = myTransaction;
    
            CommandAdapter.Fill(myDataSet,"Commande");
    
            CommandAdapter.InsertCommand = new SqlCommand("CreerCommande",myConnection);
            CommandAdapter.InsertCommand.CommandType = CommandType.StoredProcedure;
            CommandAdapter.InsertCommand.Parameters.Add("@FournisseurID",SqlDbType.Int,4,"ID_Fournisseur");
            CommandAdapter.InsertCommand.Parameters.Add("@DateLivraison",SqlDbType.DateTime,8,"DateLivraison");
    
            CommandAdapter.InsertCommand.Transaction = myTransaction;
    
    
            SqlParameter OutputParam = new SqlParameter("@CommandeID",SqlDbType.Int,4);
            OutputParam.Direction = ParameterDirection.Output;
            CommandAdapter.InsertCommand.Parameters.Add(OutputParam);
    
            // Préparation de DataSet & SqlDataAdapter pour la table "LigneCommande"
    
            SQL = "SELECT * FROM LigneCommande WHERE ID_LigneCommande = 0";
    
            LinesAdapter = new SqlDataAdapter(SQL,myConnection);
            LinesAdapter.SelectCommand.Transaction = myTransaction;
            LinesAdapter.Fill(myDataSet,"LigneCommande");
    
            SqlCommandBuilder myBuilder = new SqlCommandBuilder(LinesAdapter);
    
            myBuilder.GetInsertCommand().Transaction = myTransaction;
    
    
            // Création de la commande dans le DataSet
    
            DataRow myDataRow = myDataSet.Tables["Commande"].NewRow();
    
            myDataRow["ID_Fournisseur"] = ListeFournisseurs.SelectedItem.Value;
            myDataRow["DateLivraison"] = Calendrier.SelectedDate;
            myDataSet.Tables["Commande"].Rows.Add(myDataRow);
    
            // Création effective de la commande (indispensable pour récupérer l'ID !)
    
            CommandAdapter.Update(myDataSet,"Commande");
    
            int NewCommandID = (int)OutputParam.Value;
    
            // Création des lignes de commande dans le DataSet
    
            for (int i = 0; i < DetailCommande.Items.Count; i++)
            {
                string Qte = ((TextBox)(DetailCommande.Items[i].Cells[2].FindControl("Qte"))).Text;
    
                if (Qte!="")
                {
                    myDataRow = myDataSet.Tables["LigneCommande"].NewRow();
                    myDataRow["ID_Commande"] = NewCommandID;
                    myDataRow["ID_ReferenceFournisseur"] = DetailCommande.DataKeys[i];
                    myDataRow["Quantite"] =  System.Convert.ToInt32(Qte);
                    myDataSet.Tables["LigneCommande"].Rows.Add(myDataRow);
                }
            }
    
            // Création effective des lignes de commande dans la base
            LinesAdapter.Update(myDataSet,"LigneCommande");
            RedirectionURL = "FinCommande.aspx?id="+NewCommandID;
    
        }
        catch(Exception myException)
        {
            myTransaction.Rollback();
            myConnection.Close();
            Response.Redirect("ErreurCde.aspx?erreurmsg="+myException.Message);
        }
    
        myTransaction.Commit();
        myConnection.Close();
    
        // Redirection vers la page de fin de commande
        Response.Redirect(RedirectionURL);
    
    
    }
    
    void OnAnnulerClicked(Object sender, EventArgs e)
    {
       Response.Redirect("fournisseurs.aspx");
    }
    
    
    int NbLignesCommandeNonVides()
    {
        int nb = 0;
    
        for (int i = 0; i < DetailCommande.Items.Count; i++)
        {
            string Qte = ((TextBox)(DetailCommande.Items[i].Cells[2].FindControl("Qte"))).Text;
    
            if (Qte != "")
                nb++;
    
        }
    
        return nb;
    }

</script>
<html>
<head>
    <title>Cahier du programmeur ASP.NET - Etude de cas</title>
    <link href="SDS.css" type="text/css" rel="stylesheet" />
</head>
<body>
    <SDS:NavBar id="NavBar" SelectedIndex="2" runat="server"></SDS:NavBar>
    <form runat="server">
        <h4>Saisie d'une nouvelle commande 
        </h4>
        <table bordercolor="black" bgcolor="#aaaadd">
            <tbody>
                <tr>
                    <td width="380">
                        <font color="white"><b>En-tête de la commande</b></font></td>
                </tr>
            </tbody>
        </table>
        <table id="TableEnTete" runat="server">
            <tbody>
                <tr>
                    <td width="150">
                        Fournisseur 
                    </td>
                    <td width="250">
                        <asp:DropDownList id="ListeFournisseurs" runat="server" AutoPostBack="true" OnSelectedIndexChanged="OnFournisseurChanged" width="230px"></asp:DropDownList>
                    </td>
                </tr>
                <tr>
                    <td valign="top" width="150">
                        Date livraison demandée</td>
                    <td width="250">
                        <asp:Calendar id="Calendrier" runat="server"></asp:Calendar>
                    </td>
                </tr>
            </tbody>
        </table>
        <br />
        <table bordercolor="black" bgcolor="#aaaadd">
            <tbody>
                <tr>
                    <td width="380">
                        <font color="white"><b>Détail de la commande</b></font></td>
                </tr>
            </tbody>
        </table>
        <asp:DataGrid id="DetailCommande" runat="server" AutoGenerateColumns="false">
            <Columns>
                <asp:BoundColumn HeaderText="Code" DataField="Code">
                    <HeaderStyle font-bold="true" width="50px"></HeaderStyle>
                </asp:BoundColumn>
                <asp:BoundColumn HeaderText="Désignation" DataField="Designation">
                    <HeaderStyle font-bold="true" width="265px"></HeaderStyle>
                </asp:BoundColumn>
                <asp:TemplateColumn HeaderText="Quantité">
                    <HeaderStyle font-bold="true" width="61px"></HeaderStyle>
                    <ItemTemplate>
                        <asp:TextBox width="50px" id="Qte" runat="server" />
                        <asp:RegularExpressionValidator id="ValiderQte" ControlToValidate="Qte" ValidationExpression="[1-9]*[0-9]*" runat="server" ErrorMessage=<%# DataBinder.Eval(Container.DataItem,"Code","{0} : quantité incorrecte")%>>*</asp:RegularExpressionValidator>
                    </ItemTemplate>
                </asp:TemplateColumn>
            </Columns>
        </asp:DataGrid>
        <p>
            <asp:Label id="AuMoinsUneLigne" runat="server" ForeColor="red" Visible="False">Merci de renseigner au moins une ligne de commande</asp:Label>
            <asp:ValidationSummary id="SyntheseValidation" runat="server" HeaderText="Merci de corriger les points suivants :" ControlToValidate="ListeFournisseurs"></asp:ValidationSummary>
            <br />
            <asp:Button id="Enregistrer" onclick="OnEnregistrerClicked" runat="server" Text="Enregistrer"></asp:Button>
            <asp:Button id="Annuler" onclick="OnAnnulerClicked" runat="server" Text="Annuler"></asp:Button>
        </p>
        <SDS:Footer id="MyFooter" runat="server"></SDS:Footer>
    </form>
</body>
</html>
