using System;
using System.Web.Services;
using System.Web.Services.Protocols;

namespace SDS 
{
     public class AuthHeader : SoapHeader      
     {
        public string Username; 
        public string Password;
     }
    
    [WebServiceBindingAttribute(Name="ServiceStocks",Namespace="http://tempuri.org/")]
    public class ServiceStocks : SoapHttpClientProtocol
    { 
        public AuthHeader AuthHeaderValue;        

        public ServiceStocks(string applicationRoot)  
        {          
           this.Url = applicationRoot+"/"+"ServiceStocks.asmx";
        }
    
        [SoapHeaderAttribute("AuthHeaderValue")]
        [SoapDocumentMethodAttribute("http://tempuri.org/AjouterMouvementStock", RequestNamespace="http://tempuri.org/", ResponseNamespace="http://tempuri.org/")]              
        public string AjouterMouvementStock(int produitID,int annee,int mois,int quantite) 
        {            
            //return "Hello, I am "+System.Environment.UserName;  
            object[] parameters = { produitID, annee, mois, quantite };
            object[] results = this.Invoke("AjouterMouvementStock",parameters);
            return (string)results[0];            
        }
     }
}
