﻿<%@ Page Language="c#" %>
<%@ Register TagPrefix="SDS" TagName="NavBar" Src="NavBar.ascx" %>
<%@ Register TagPrefix="SDS" TagName="Footer" Src="Footer.ascx" %>
<%@ import Namespace="System.Data" %>
<%@ import Namespace="System.Data.SqlClient" %>
<%@ import Namespace="System.Configuration" %>
<script runat="server">

    SqlConnection myConnection; // Variable partagée au sein de la page
    
         void AfficherStocksProduits()
         {
             SqlCommand      myCommand;
             SqlDataReader   myReader;
    
             string FamilleID = ListeFamilles.SelectedItem.Value;
    
    
             // Paramètrage du DataGrid
    
             myCommand = new SqlCommand("EtatStock '"+FamilleID+"'",myConnection);
    
             myConnection.Open();
             myReader = myCommand.ExecuteReader();
    
             EtatStock.DataSource = myReader;
             EtatStock.DataBind();
    
    
             myReader.Close();
             myConnection.Close();
    
    
         }
    
         void Page_Load(Object sender, EventArgs e)
         {
            string connStr = ConfigurationSettings.AppSettings["ConnectionString"];
            myConnection   = new SqlConnection(connStr);
    
            if(!IsPostBack)
            {
                ChargerListeFamilles_VersionSqlDataAdapter();
                AfficherStocksProduits();
            }
         }
    
         void OnFamilleChanged(Object sender, EventArgs e)
         {
             AfficherStocksProduits();
         }
    
         // Fonctions privées
    
         void ChargerListeFamilles_VersionSqlDataAdapter()
         {
             // Définition de SqlDataAdapter et DataTable
    
             SqlDataAdapter   myAdapter;
             DataTable        myDataTable;
    
             string strSQL = "SELECT * FROM FamilleProduit";
    
             myAdapter  = new SqlDataAdapter(strSQL,myConnection);
             myDataTable = new DataTable();
    
             // Remplissage du DataAdapter (il ouvre et ferme la connexion)
    
             myAdapter.Fill(myDataTable);
    
             // Paramètrage du contrôle ListeFamilles
    
             ListeFamilles.DataSource = myDataTable.DefaultView;
             ListeFamilles.DataValueField = "ID_FamilleProduit";
             ListeFamilles.DataTextField = "NomFamille";
             ListeFamilles.DataBind();
         }
    
    
         void ChargerListeFamilles_VersionSqlDataReader()
         {
             // Ouverture de la connexion
    
             myConnection.Open();
    
             // Définition de SqlCommand
    
             string strSQL = "SELECT * FROM FamilleProduit";
             SqlCommand myCommand = new SqlCommand(strSQL,myConnection);
    
             SqlDataReader myReader = myCommand.ExecuteReader();
    
             // Paramètrage du contrôle ListeFamilles
    
             ListeFamilles.DataSource = myReader;
             ListeFamilles.DataValueField = "ID_FamilleProduit";
             ListeFamilles.DataTextField = "NomFamille";
             ListeFamilles.DataBind();
    
             myReader.Close();
    
             // Fermeture de la connexion
    
             myConnection.Close();
         }

</script>
<html>
<head>
    <title>Cahier du programmeur ASP.NET - Etude de cas</title>
    <link href="SDS.css" type="text/css" rel="stylesheet" />
</head>
<body>
    <SDS:NavBar id="myNavBar" runat="server" SelectedIndex="1"></SDS:NavBar>
    <p>
    </p>
    <p>
    </p>
    <form runat="server">
        <h4>Consultation de l'état du stock par famille de produits 
        </h4>
        <table style="WIDTH: 325px" bgcolor="#ffffc0">
            <tbody>
                <tr>
                    <td width="60">
                        Famille 
                    </td>
                    <td>
                        <asp:DropDownList id="ListeFamilles" runat="server" width="250px" OnSelectedIndexChanged="OnFamilleChanged" AutoPostBack="true"></asp:DropDownList>
                    </td>
                </tr>
            </tbody>
        </table>
        <p>
            <br />
            <asp:DataGrid id="EtatStock" runat="server" BorderColor="black" CellPadding="3" BorderWidth="1" AutoGenerateColumns="false" HeaderStyle-BackColor="#aaaadd" CellSpacing="0" GridLines="Both">
                <HeaderStyle backcolor="#AAAADD"></HeaderStyle>
                <Columns>
                    <asp:BoundColumn DataField="Code" HeaderText="Code">
                        <HeaderStyle width="50px"></HeaderStyle>
                    </asp:BoundColumn>
                    <asp:HyperLinkColumn DataNavigateUrlField="ID_Produit" DataNavigateUrlFormatString="DetailStocks.aspx?id={0}" DataTextField="Designation" HeaderText="D&#233;signation">
                        <HeaderStyle width="150px"></HeaderStyle>
                    </asp:HyperLinkColumn>
                    <asp:BoundColumn DataField="Stock" HeaderText="Stock">
                        <HeaderStyle width="100px"></HeaderStyle>
                        <ItemStyle horizontalalign="Right"></ItemStyle>
                    </asp:BoundColumn>
                </Columns>
            </asp:DataGrid>
            <br />
            <br />
            <a href="TestServiceStocks.aspx">Tester le service Web de mise à jour des stocks</a> 
        </p>
        <p>
        </p>
        <SDS:Footer id="MyFooter" runat="server"></SDS:Footer>
    </form>
</body>
</html>
