﻿namespace SDS {
    
    using System;
    using System.Text; // Pour Encoding
    using System.Xml;
    using System.Xml.Xsl;
    using System.Data;            // Pour DataSet
    using System.Data.SqlClient; // Pour SqlConnection
        
    public class XmlGenerator
    {
        private SqlConnection Connection;
        private string NoCommande;
        private string Path;
        
        
        public XmlGenerator(string noCommande, SqlConnection connection,string path) 
        {
            Connection  = connection;
            NoCommande  = noCommande;                                            
            Path        = path;
        }
                                    
        public void GenererFichierXml(string xmlFile)
        // Ecriture d'un fichier XML correspondant à la commande
        {
            // Chargement des données depuis la base
                        
            DataSet myDataSet = new DataSet();            
            
            SqlDataAdapter CommandAdapter,LinesAdapter;            
                                                                                       
            CommandAdapter = new SqlDataAdapter("DetailsCommande",Connection);            
            CommandAdapter.SelectCommand.CommandType = CommandType.StoredProcedure;
            CommandAdapter.SelectCommand.Parameters.Add("@CommandeID",SqlDbType.Int);
            CommandAdapter.SelectCommand.Parameters["@CommandeID"].Value = NoCommande;
            
            CommandAdapter.Fill(myDataSet,"Commande");
                                                                                      
            LinesAdapter = new SqlDataAdapter("ListeLignesCommandes",Connection);            
            LinesAdapter.SelectCommand.CommandType = CommandType.StoredProcedure;
            LinesAdapter.SelectCommand.Parameters.Add("@CommandeID",SqlDbType.Int);
            LinesAdapter.SelectCommand.Parameters["@CommandeID"].Value = NoCommande;
            
            LinesAdapter.Fill(myDataSet,"LigneCommande");
                                               
            // Création relation entre les deux tables du recordset
        
            myDataSet.Relations.Add(
                "Commande_LigneCommande",
                myDataSet.Tables["Commande"].Columns["ID_Commande"],
                myDataSet.Tables["LigneCommande"].Columns["ID_Commande"]
            );
        
            myDataSet.Relations["Commande_LigneCommande"].Nested = true;            
                       
            // Ecriture du fichier
        
            myDataSet.WriteXml(Path+xmlFile);
       }
        
                           
        public void GenererTelecopie(string xmlFile, string xslFile, string outputFile)
        {           
            XslTransform myTransform = new XslTransform();            
            myTransform.Load(Path+xslFile);
        
            XmlDocument myDocument = new XmlDocument();
            myDocument.Load(Path+xmlFile);
            
            XmlTextWriter writer = new XmlTextWriter(Path+outputFile,Encoding.UTF8);        
            myTransform.Transform(myDocument,null,writer);        
            writer.Close();
        }      
    }    
}
