﻿Imports System            
Imports System.Data 
Imports System.Drawing   
Imports System.Drawing.Imaging
Imports System.Web
Imports System.Web.UI
Imports System.Web.UI.WebControls

Namespace SDS.Controls 
    
    Public class Camembert : Inherits WebControl 
                                          
        Dim _dataSource As DataView
        
        Public Property DataSource As DataView
        
            Get 
                Return _dataSource
            End Get
            
			Set 
			    _dataSource = Value
		    End Set
		    
        End Property
        
        Public Property DataValueField AS String
        
            Get 
                Return CType(ViewState("DataValueField"),String)
            End Get
             
			Set 
			     ViewState("DataValueField") = Value
			End Set
			
        End Property
            
        Public Property DataTextField As String
        
            Get 
                Return CType(ViewState("DataTextField"),String)
            End Get
            
            Set
                ViewState("DataTextField") = Value
			End Set
        
        End Property
                                                
        Private Function GetBrush(index As Int32) As Brush
        
            Dim br As Brush = Brushes.Black ' Par défaut
            
            Select Case index
            
                Case 0 
                    br = Brushes.CornflowerBlue               
        
                Case 1 
                    br = Brushes.HotPink                
        
                Case 2
                    br = Brushes.MediumSpringGreen
                
            End Select
            
            Return br
            
        End Function 
                           
        Protected Overrides Sub Render(output As HtmlTextWriter)
					  
			' Création d'une image de type Bitmap 400x200
            Dim bm As Bitmap = new Bitmap(400,200)

            ' Obtention de l'objet graphique associé
            Dim g As Graphics = Graphics.FromImage(bm)

            ' On initialise tout en blanc
            g.Clear(Color.White)
           
            Dim f As Font = new Font("Verdana", 8)
            Dim i As Int32 = 0
           
            Dim startAngle As Single = -90
            Dim sweepAngle As Single = 0
                                                        
            
            Dim dr As DataRowView
            Dim pourcentage As Single 
            Dim etiquette As String
            Dim legend    As String
            
            
            For Each dr in DataSource                      
            
               pourcentage = Convert.ToSingle(dr(DataValueField))
               etiquette   = dr(DataTextField).ToString()
               legend = String.Format("{0} ({1:F1}%)",etiquette,pourcentage)

                ' Dessin de la portion de camembert
                sweepAngle = pourcentage*360/100
                g.FillPie(GetBrush(i),10,10,180,180,startAngle,sweepAngle)
                startAngle += sweepAngle

                ' Légende
                g.FillRectangle(GetBrush(i),240,50+i*40,20,20)
                g.DrawString(legend, f, Brushes.Black,270,52+i*40)

                i = i+1
                
            Next

            ' Sauvegarde de l'image vers un fichier temporaire (dans le sous-répertoire img de l'application)
            
            Dim rq As HttpRequest = Context.Request           
            Dim path As String    = rq.MapPath(rq.ApplicationPath)+"\\img"

            bm.Save(path+"\\"+"Camembert.gif",ImageFormat.Gif)
            output.Write("<img src='imageHandler.aspx?path="+path+"&src=camembert.gif'>")                        

            ' Libération des ressources graphiques

            f.Dispose()
            g.Dispose()
            bm.Dispose()
    
		End Sub
		
    End Class
    
End Namespace
