﻿<%@ Page Language="VB" %>
<%@ Register TagPrefix="SDS" TagName="NavBar" Src="NavBar.ascx" %>
<%@ Register TagPrefix="SDS" TagName="Footer" Src="Footer.ascx" %>
<%@ import Namespace="System.Data" %>
<%@ import Namespace="System.Data.SqlClient" %>
<script runat="server">

    ' Variables membres de la page
    
    Dim myAdapter   As SqlDataAdapter
    Dim myDataTable As DataTable
    Dim myConnection As SqlConnection
    
    Sub Page_Load(sender As Object,e As EventArgs)
    
       ' Initialisation de la connexion
       
       Dim connStr As String = ConfigurationSettings.AppSettings("ConnectionString")
       myConnection = new SqlConnection(connStr)
          
       ' Récupération du numéro de commande
    
       ID   = Request.Params("id")
    
       ' Allocation du SqlDataAdapter
    
        Dim SelectSQL As String
        Dim UpdateSQL As String
    
        SelectSQL = "DetailsCommande"
        UpdateSQL = "UPDATE Commande Set Livree = @Livree WHERE ID_Commande  = "+ID
    
        myAdapter = new SqlDataAdapter(SelectSQL,myConnection)
    
        myAdapter.SelectCommand.CommandType = CommandType.StoredProcedure
        myAdapter.SelectCommand.Parameters.Add("@CommandeID",SqlDbType.Int)
        myAdapter.SelectCommand.Parameters("@CommandeID").Value = ID
    
        ' Remplissage de la table
    
        myDataTable = new DataTable()
        myAdapter.Fill(myDataTable)
    
        ' Définition de la commande Update
    
        myAdapter.UpdateCommand = new SqlCommand(UpdateSQL,myConnection)
        myAdapter.UpdateCommand.Parameters.Add("@Livree",SqlDbType.Bit,1,"Livree")
    
    
        If (IsPostBack=False) Then
    
            Dim CurrentRow As DataRow
            CurrentRow = myDataTable.Rows(0)
    
            ' Affichage des informations d'en-tête
    
            NoCommande.Text = ID
    
            NomFournisseur.Text = CurrentRow("NomFournisseur")
            DateLivraison.Text = String.Format("{0:d}",CurrentRow("DateLivraison"))
    
            If (CurrentRow("Livree")=True) Then
                StatutLivraison.SelectedIndex = 0
            Else
                StatutLivraison.SelectedIndex = 1
            End If
    
            ' Récupération des informations relatives aux lignes de commandes
    
            Dim myCommand As SqlCommand
            Dim myReader As SqlDataReader
    
            myCommand = new SqlCommand("ListeLignesCommandes",myConnection)
            myCommand.CommandType = CommandType.StoredProcedure
            myCommand.Parameters.Add("@CommandeID",SqlDbType.Int).Value = ID
            
            myConnection.Open()
            myReader = myCommand.ExecuteReader()
            LignesCommande.DataSource = myReader
            LignesCommande.DataBind()
            myReader.Close()
            myConnection.Close()
    
        End If
    
    End Sub
    
    Sub OnEnregistrerClicked(sender As Object,e As EventArgs)
    
        If(StatutLivraison.SelectedIndex = 0) Then
            myDataTable.Rows(0)("Livree")=True
        Else
            myDataTable.Rows(0)("Livree")=False
        End If
    
        myAdapter.Update(myDataTable)
    
        Response.Redirect("fournisseurs.aspx")
    End Sub
    
    Sub OnAnnulerClicked(sender As Object,e As EventArgs)
    
       Response.Redirect("fournisseurs.aspx")
    
    End Sub

</script>
<html>
<head>
    <title>Cahier du programmeur ASP.NET - Etude de cas</title>
    <link href="SDS.css" type="text/css" rel="stylesheet" />
</head>
<body>
    <SDS:NavBar id="NavBar" runat="server" SelectedIndex="2"></SDS:NavBar>
    <form runat="server">
        <h4>Détail de la commande n° 
            <asp:Label id="NoCommande" runat="server">[NoCommande]</asp:Label>
        </h4>
        <table bordercolor="black">
            <tbody>
                <tr bgcolor="#aaaadd">
                    <td width="100%" colspan="2">
                        <font color="white"><b>En-tête de la commande</b></font> 
                    </td>
                </tr>
                <tr valign="center" height="25">
                    <td width="150">
                        Fournisseur 
                    </td>
                    <td width="250">
                        &nbsp; 
                        <asp:Label id="NomFournisseur" runat="server" Font-Bold="True" Height="14px"></asp:Label>
                    </td>
                </tr>
                <tr valign="center" height="25">
                    <td width="150">
                        Date livraison prévue</td>
                    <td width="250">
                        &nbsp; 
                        <asp:Label id="DateLivraison" runat="server" Height="12px" width="80px">[DateLivraison]</asp:Label>
                    </td>
                </tr>
                <tr valign="center" height="25">
                    <td width="150">
                        Livrée 
                    </td>
                    <td width="250">
                        <asp:RadioButtonList id="StatutLivraison" runat="server" Height="7px" RepeatDirection="Horizontal" Width="68px">
                            <asp:ListItem>Oui</asp:ListItem>
                            <asp:ListItem>Non</asp:ListItem>
                        </asp:RadioButtonList>
                    </td>
                </tr>
            </tbody>
        </table>
        <br />
        <table bordercolor="black" bgcolor="#aaaadd">
            <tbody>
                <tr>
                    <td width="380">
                        <font color="white"><b>Lignes de commandes</b></font></td>
                </tr>
            </tbody>
        </table>
        <asp:DataGrid id="LignesCommande" runat="server" AutoGenerateColumns="false">
            <Columns>
                <asp:BoundColumn HeaderText="Code" DataField="Code">
                    <HeaderStyle font-bold="true" width="50px"></HeaderStyle>
                </asp:BoundColumn>
                <asp:BoundColumn HeaderText="Désignation" DataField="Designation">
                    <HeaderStyle font-bold="true" width="271px"></HeaderStyle>
                </asp:BoundColumn>
                <asp:BoundColumn HeaderText="Quantité" DataField="Quantite">
                    <HeaderStyle font-bold="true" width="50px"></HeaderStyle>
                </asp:BoundColumn>
            </Columns>
        </asp:DataGrid>
        <br />
        <br />
        <asp:Button id="BoutonEnregistrer" onclick="OnEnregistrerClicked" runat="server" Text="Enregistrer"></asp:Button>
        <asp:Button id="BoutonAnnuler" onclick="OnAnnulerClicked" runat="server" Text="Annuler" CausesValidation="False"></asp:Button>
        <br />
        <br />
        <SDS:Footer id="MyFooter" runat="server"></SDS:Footer>
    </form>
</body>
</html>
