﻿<%@ Page Language="VB" %>
<%@ Register TagPrefix="SDS" TagName="NavBar" Src="NavBar.ascx" %>
<%@ Register TagPrefix="SDS" TagName="Footer" Src="Footer.ascx" %>
<%@ import Namespace="System.Data.SqlClient" %>
<%@ import Namespace="System.Data" %>
<script runat="server">

    Sub Page_Load(sender As Object,e As EventArgs)
    
        ' Déclaration des variables
    
        Dim myConnection As SqlConnection
        Dim myReader  As SqlDataReader
        Dim myCommand As SqlCommand
        
        ' Récupération de la connexion
    
        Dim connStr As String = ConfigurationSettings.AppSettings("ConnectionString")
        myConnection   = new SqlConnection(connStr)
    
        ' Commande associée à la procédure stockée
    
        myCommand = new SqlCommand("HistoriqueStock",myConnection)
        myCommand.CommandType = CommandType.StoredProcedure
        myCommand.Parameters.Add("@ProduitID",SqlDbType.Int)
        myCommand.Parameters("@ProduitID").Value = Request.Params("id")
    
        ' Ouverture de la connexion 
        
        myConnection.Open()
        
        ' Récupération du nom du produit
    
        myReader = myCommand.ExecuteReader()
        myReader.Read()
        NomProduit.Text = myReader.GetString(4)
        myReader.Close()
    
       ' Paramètrage de la grille de données
    
        myReader = myCommand.ExecuteReader()
        HistoriqueStocks.DataSource = myReader
        HistoriqueStocks.DataBind()
        myReader.Close()
        
        ' Fermeture de la connexion 
        
        myConnection.Close()
    
    End Sub

</script>
<html>
<head>
    <title>Cahier du programmeur ASP.NET - Etude de cas</title>
    <link href="SDS.css" type="text/css" rel="stylesheet" />
</head>
<body>
    <SDS:NavBar id="UserControl1" SelectedIndex="1" runat="server"></SDS:NavBar>
    <p>
    </p>
    <p>
    </p>
    <form runat="server">
        <h4>
            <asp:Label id="NomProduit" runat="server"></asp:Label>
            &nbsp;: historique du stock 
        </h4>
        <p>
        </p>
        <p>
            <asp:DataGrid id="HistoriqueStocks" runat="server" BorderColor="black" CellPadding="3" BorderWidth="1" AutoGenerateColumns="false" HeaderStyle-BackColor="#aaaadd" Font-Size="8pt" Font-Name="Verdana" CellSpacing="0" GridLines="Both">
                <Columns>
                    <asp:BoundColumn HeaderText="Mois" DataField="DateMouvement">
                        <HeaderStyle width="50px"></HeaderStyle>
                    </asp:BoundColumn>
                    <asp:BoundColumn HeaderText="Ventes" ItemStyle-HorizontalAlign="right" DataField="Ventes">
                        <HeaderStyle width="100px"></HeaderStyle>
                    </asp:BoundColumn>
                    <asp:BoundColumn HeaderText="Approvisionnements" ItemStyle-HorizontalAlign="right" DataField="Approvisionnements">
                        <HeaderStyle width="100px"></HeaderStyle>
                    </asp:BoundColumn>
                </Columns>
            </asp:DataGrid>
        </p>
        <p>
            <a href="./stocks.aspx">Retour à la page d'accueil du module</a> 
        </p>
        <SDS:Footer id="MyFooter" runat="server"></SDS:Footer>
    </form>
</body>
</html>
