﻿<%@ Page Language="VB" %>
<%@ import Namespace="System.Web.Mail" %>
<script runat="server">

    Sub Envoyer_Click(sender As Object, e As EventArgs)
    
        Try
    
            Dim mail As MailMessage
            mail = new MailMessage()
    
            Dim id, server, virtualPath,physicalPath As String
    
            id = Request.Params("id")
    
            mail.From = "webmaster@savonsdusoleil.com"
            mail.To = Adresse.Text
            mail.Subject = "Nouvelle commande"
            mail.Body = "Veuillez trouver ci-joint le fichier XML correspondant à la commande "+ID
            mail.BodyFormat = MailFormat.Html
    
            virtualPath = Request.ApplicationPath+"\\xml\\Commande"+id+".xml"
            physicalPath    = Request.MapPath(VirtualPath)
    
            Dim myAttachment As MailAttachment
            myAttachment = new MailAttachment(physicalPath)
    
            mail.Attachments.Add(myAttachment)
            
            server = ConfigurationSettings.AppSettings("SmtpServer")
    
            If (server="VotreServeurSMTP") Then        
                Throw new Exception("Vous n'avez pas précisé la valeur de SmtpServer dans le fichier web.config")
            End If
    
            SmtpMail.SmtpServer = server
            SmtpMail.Send(mail)
            Resultat.Text = "Le message a été correctement envoyé !"
    
         Catch myException As Exception
    
            Resultat.Text = "Echec de l'envoi du message : '"+myException.Message+"'"
    
         End Try
    
    End Sub

</script>
<html>
<head>
    <link href="SDS.css" type="text/css" rel="stylesheet" />
</head>
<body>
    <form runat="server">
        <h4>Simulation<!-- Insert content here -->
            envoi commande 
        </h4>
        <p>
            Entrez votre adresse e-mail 
            <asp:TextBox id="Adresse" runat="server" Height="20px"></asp:TextBox>
            <asp:Button id="Envoyer" onclick="Envoyer_Click" runat="server" Height="21px" Text="Envoyer"></asp:Button>
        </p>
        <p>
            <asp:Label id="Resultat" runat="server" Font-Bold="True"></asp:Label>
            <asp:RegularExpressionValidator id="ValiderAdresse" runat="server" ValidationExpression="\w+([-+.]\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*" ControlToValidate="Adresse" ErrorMessage="Merci de saisir une adresse e-mail valide">Merci de saisir une adresse e-mail valide</asp:RegularExpressionValidator>
        </p>
        <p>
            <table width="370">
                <tbody>
                    <tr>
                        <td align="right">
                            <a onclick="window.close()" href=".">Fermer cette fenêtre</a> 
                        </td>
                    </tr>
                </tbody>
            </table>
        </p>
        <p>
        </p>
    </form>
</body>
</html>
