﻿<%@ Control Language="C#" %>
<%@ import Namespace="System.IO" %>
<script runat="server">

    class SourceFileInfos : Object
    {
        public int FileID;
        public string FileName;
    
        public SourceFileInfos(string fileName, int fileID)
        {
            FileName   = fileName;
            FileID     = fileID;
        }
    }
    
    ArrayList SourceFileList;
    
    void LireInfosSources()
    // Récupère la liste des fichiers sources dans le fichier .src
    {
        // Récupération du chemin du fichier contenant les informations de source
    
        string filePath = Request.FilePath;
        filePath = filePath.Substring(filePath.LastIndexOf('/')+1);
        filePath = filePath.Substring(0,filePath.LastIndexOf("."));
        filePath = "src/"+filePath+".src";
    
        SourceFileList = new ArrayList();
    
        // Lecture du fichier
    
        try
        {
            FileStream fs = new FileStream(Server.MapPath(filePath),FileMode.Open,FileAccess.Read);
            StreamReader sr = new StreamReader(fs);
    
            string line,lineLanguage,lineEnd,fileName;
            int    fileID,languageID;
            int    ColonPosition;
    
            while ((line = sr.ReadLine()) != null)
            {
                // On ignore les lignes vides
    
                line= line.Trim();
    
                if (line.Length==0)
                    continue;
    
                // Analyse de la ligne
    
                lineLanguage = line.Substring(0,3);
    
                languageID = 0; // Par défaut
    
                if (lineLanguage=="vb/")
                {
                    lineEnd = line.Substring(3);
                    ColonPosition = lineEnd.LastIndexOf(':');
    
                    if (ColonPosition != -1)
                    {
                        fileName = lineEnd.Substring(0,ColonPosition);
                        fileID   = Int32.Parse(lineEnd.Substring(ColonPosition+1));
                        SourceFileList.Add(new SourceFileInfos(fileName,fileID));
                    }
                }
            }
    
             fs.Close();
    
            InfoMsg.Visible = false;
        }
        catch(Exception ex)
        {
            InfoMsg.Visible = true;
            InfoMsg.Text = ex.Message; //"(pas d'informations disponibles)";
        }
    }
    
    void AfficherInfosSources()
    // Affiche la liste des fichiers sources
    {
        // On parcourt le tableau 'SourceFileInfos'
        // (seuls les 5 premiers éléments sont pris en compte)
    
        int fileCount = SourceFileList.Count;
        int cpt = 0;
    
        SourceFileInfos infos;
    
        for (int i = 0 ; i < fileCount; i++)
        {
            infos = (SourceFileInfos)SourceFileList[i];
    
            cpt++;
    
            if (cpt == 1)
            {
                Link1.NavigateUrl="SrcView.aspx?filename="+infos.FileName;
                Link1.Text = infos.FileName;
            }
    
            if (cpt == 2)
            {
                Link2.NavigateUrl="SrcView.aspx?filename="+infos.FileName;
                Link2.Text = infos.FileName;
            }
    
            if (cpt == 3)
            {
                Link3.NavigateUrl="SrcView.aspx?filename="+infos.FileName;
                Link3.Text = infos.FileName;
            }
    
            if (cpt == 4)
            {
                Link4.NavigateUrl="SrcView.aspx?filename="+infos.FileName;
                Link4.Text = infos.FileName;
            }
    
            if (cpt == 5)
            {
                Link5.NavigateUrl="SrcView.aspx?filename="+infos.FileName;
                Link5.Text = infos.FileName;
            }
        }
    
    }
    
    void Page_Load(Object sender, EventArgs e)
    {
        if(!IsPostBack)
        {
            LireInfosSources();
            AfficherInfosSources();
        }
    }

</script>
<p>
    <br />
    <table style="BORDER-COLLAPSE: collapse" width="100%" border="1">
        <tbody>
            <tr bgcolor="#00c000" height="3">
                <td>
                </td>
            </tr>
            <tr bgcolor="#ffffcc">
                <td>
                    <p>
                        <strong>Etude de cas du <a href="http://www.savonsdusoleil.com" target="_blank">Cahier
                        du Programmeur ASP.NET</a></strong> <strong>(VB / SDK)</strong> - Version 1.2 (15-04-03) 
                    </p>
                    <p>
                        Fichiers sources associés à cette page&nbsp; : 
                        <asp:Label id="InfoMsg" Font-Italic="True" runat="server">Label</asp:Label>
                        <asp:HyperLink id="Link1" runat="server" Target="_blank"></asp:HyperLink>
                        &nbsp;<asp:HyperLink id="Link2" runat="server" Target="_blank"></asp:HyperLink>
                        &nbsp;<asp:HyperLink id="Link3" runat="server" Target="_blank"></asp:HyperLink>
                        &nbsp;<asp:HyperLink id="Link4" runat="server" Target="_blank"></asp:HyperLink>
                        &nbsp;<asp:HyperLink id="Link5" runat="server" Target="_blank"></asp:HyperLink>
                        &nbsp;<br />
                        &nbsp; 
                    </p>
                </td>
            </tr>
            <tr bgcolor="#00c000">
            </tr>
            <tr bgcolor="#00c000" height="3">
                <td>
                </td>
            </tr>
        </tbody>
    </table>
</p>
<a href="mailto:webmaster@savonsdusoleil.com">Envoyer un commentaire</a>&nbsp;- <a href="http://www.savonsdusoleil.com" target="_blank">Obtenir
de l'aide</a>