﻿<%@ Page Language="VB" %>
<%@ Register TagPrefix="SDS" TagName="NavBar" Src="NavBar.ascx" %>
<%@ Register TagPrefix="SDS" TagName="Footer" Src="Footer.ascx" %>
<%@ import Namespace="System.Data" %>
<%@ import Namespace="System.Data.SqlClient" %>
<%@ import Namespace="System.Drawing" %>
<script runat="server">

    Dim myConnection As SqlConnection
    
    Function AfficherBooleen(o As Object) As String
    
        If (o=True) Then
            return "Oui"
        Else
            return "Non"
        End If
    
    End Function
    
    Sub Page_Load(sender As Object,e As EventArgs)
    
        Dim connStr As String = ConfigurationSettings.AppSettings("ConnectionString")
        myConnection = new SqlConnection(connStr)
    
        If (IsPostBack=False) Then
            ViewState("PageIndex") = 0
            ChargerListeCommandes(0)
        End If
    
    End Sub
    
    
    Sub ChargerListeCommandes(index As Int32)
    
        Dim Sql As String
        Dim myAdapter As SqlDataAdapter
        Dim myDataTable As DataTable
        Dim myPager As PagedDataSource
    
        SQL = "ListeCommandes"
        myAdapter = new SqlDataAdapter(SQL,myConnection)
        myAdapter.SelectCommand.CommandType = CommandType.StoredProcedure
    
        myDataTable = new DataTable()
        myAdapter.Fill(myDataTable)
    
        myPager = new PagedDataSource()
        myPager.DataSource =  myDataTable.DefaultView
        myPager.AllowPaging = True
        myPager.PageSize    = 2
        myPager.CurrentPageIndex = index
    
        ListeCommandes.DataSource = myPager
        ListeCommandes.DataBind()
    
        If (ListeCommandes.Items.Count=0) Then
            ListeVide.Visible = True
        Else
            ListeVide.Visible = False
        End If
    
        MettreAJourAffichagePagination(myPager.CurrentPageIndex+1,myPager.PageCount)
    
    End Sub
    
    Sub OnItemCommand(sender As Object, e As RepeaterCommandEventArgs)
    
        Dim SQL As String
        Dim myCommand  As SqlCommand
    
        SQL = "DELETE FROM Commande WHERE ID_Commande = "+e.CommandArgument
    
        myCommand = new SqlCommand(SQL,myConnection)
        myConnection.Open()
        myCommand.ExecuteNonQuery()
        myConnection.Close()
    
        ViewState("PageIndex") = 0
        ChargerListeCommandes(0)
    
    End Sub
    
    Sub OnItemCreated(sender As Object,e As RepeaterItemEventArgs)
    
        Dim myDeleteButton As LinkButton
    
        If  (e.Item.ItemType=ListItemType.Item) Then
              myDeleteButton = e.Item.FindControl("btnDelete")
              myDeleteButton.Attributes.Add("onclick","return confirm('Confirmez-vous la suppression de cette commande?');")
        End If
    
    End Sub
    
    Sub MettreAJourAffichagePagination(NumeroPage As Int32, NombrePages As Int32)
    
        If (NumeroPage = NombrePages) Then
            PageSuivante.Visible = False
        Else
            PageSuivante.Visible = True
        End If
    
        If (NumeroPage = 1) Then
            PagePrecedente.Visible = False
        Else
            PagePrecedente.Visible = True
        End IF
    
        NoPage.Text  = NumeroPage.ToString()
        NbPages.Text = NombrePages.ToString()
    
    End Sub
    
    
    Sub OnPageSuivante(sender As Object,e As EventArgs)
    
        ' Récupération de la valeur actuelle de PageIndex
        Dim PageIndex As Int32
        PageIndex = ViewState("PageIndex")
    
        ' Incrémentation (rq : on est assuré que PageIndex < PageCount grace à MettreAJourAffichage)
    
        PageIndex = PageIndex + 1
    
        ' Chargement de la page correspondante
        ChargerListeCommandes(PageIndex)
    
        ' Sauvegarde de la nouvelle valeur de PageIndex
    
         ViewState("PageIndex") = PageIndex
    
    End Sub
    
    Sub OnPagePrecedente(sender As Object,e As EventArgs)
    
        ' Récupération de la valeur actuelle de PageIndex
    
        Dim PageIndex As Int32
        PageIndex = ViewState("PageIndex")
    
        ' Incrémentation (rq : on est assuré que PageIndex > 0 grace à MettreAJourAffichage)
    
        PageIndex = PageIndex - 1
    
        ' Chargement de la page correspondante
    
        ChargerListeCommandes(PageIndex)
    
        ' Sauvegarde de la nouvelle valeur de PageIndex
    
         ViewState("PageIndex") = PageIndex
    
    End Sub

</script>
<html>
<head>
    <title>Cahier du programmeur ASP.NET - Etude de cas</title>
    <link href="SDS.css" type="text/css" rel="stylesheet" />
</head>
<body>
    <SDS:NavBar id="NavBar" SelectedIndex="2" runat="server"></SDS:NavBar>
    <p>
    </p>
    <p>
    </p>
    <form runat="server">
        <h4>Liste des commandes fournisseurs&nbsp;(Page 
            <asp:Label id="NoPage" runat="server">#NoPage#</asp:Label>
            &nbsp;sur 
            <asp:Label id="NbPages" runat="server">#NbPages#</asp:Label>
            ) 
        </h4>
        <p>
        </p>
        <asp:Repeater id="ListeCommandes" runat="server" OnItemCommand="OnItemCommand" OnItemCreated="OnItemCreated">
            <ItemTemplate>
                <table bordercolor="black" cellspacing="0">
                    <tr bgcolor="#aaaadd">
                        <td width="150" >
                            <b><font color="white"> Commande n° <%# DataBinder.Eval(Container.DataItem, "ID_Commande") %> </font></b> 
                        </td>
                        <td width="300" align="right">
                            <asp:HyperLink NavigateUrl=<%#DataBinder.Eval(Container.DataItem,"ID_Commande","DetailCommande.aspx?id={0}")%> runat="server">[Détails]</asp:HyperLink>
                            <asp:LinkButton id="btnDelete" CommandArgument='<%# DataBinder.Eval(Container.DataItem, "ID_Commande") %>' runat="server">[Supprimer]
                             </asp:LinkButton>
                        </td>
                    </tr>
                    <tr bgcolor="#ffffc0">
                        <td width="150">
                            Fournisseur : 
                        </td>
                        <td width="300">
                            <b> <%# Container.DataItem("NomFournisseur") %> </b> 
                        </td>
                    </tr>
                    <tr bgcolor="#ffffc0">
                        <td width="150">
                            Date livraison prévue : 
                        </td>
                        <td width="300">
                            <%# DataBinder.Eval(Container.DataItem,"DateLivraison","{0:d}")%> 
                        </td>
                    </tr>
                    <tr bgcolor="#ffffc0">
                        <td width="150">
                            Livrée : 
                        </td>
                        <td width="300">
                            <%# AfficherBooleen(DataBinder.Eval(Container.DataItem,"Livree")) %> 
                        </td>
                    </tr>
                </table>
            </ItemTemplate>
            <SeparatorTemplate>
                <br />
            </SeparatorTemplate>
        </asp:Repeater>
        <br />
        <asp:Label id="ListeVide" runat="server">Il n'y a aucune commande dans cette liste</asp:Label>
        <h4>
        </h4>
        <p>
            <asp:Button id="PagePrecedente" onclick="OnPagePrecedente" runat="server" Text=" < "></asp:Button>
            <asp:Button id="PageSuivante" onclick="OnPageSuivante" runat="server" Text=" > "></asp:Button>
            &nbsp;<a href="NouvelleCommande.aspx">[Nouvelle commande]</a>&nbsp; 
        </p>
        <p>
        </p>
        <SDS:Footer id="MyFooter" runat="server"></SDS:Footer>
    </form>
</body>
</html>
