﻿<%@ Control Language="VB" %>
<%@ outputcache duration="7200" varybyparam="none" %>
<%@ import Namespace="WeatherServices" %>
<script runat="server">

    Class WeatherInfos
        public imageUrl As String
        public temperature As String
    End Class
    
    Function GetWeatherInfos(code As String) As WeatherInfos
    
        Dim gw As New GlobalWeather()
        gw.Timeout = 3000
    
        Dim report As WeatherReport
    
        Try
            report = gw.getWeatherReport(code)    
        Catch e As Exception
            report = Nothing
        End Try
        
        
        Dim infos As New WeatherInfos()
    
        Dim absenceInfos As Boolean = False
    
        
        If (Not report is Nothing) Then
    
            If (Not report.sky is Nothing) Then
    
                If (Not report.sky.layers is Nothing ) Then
    
                    If (report.sky.layers.Length>0) Then
    
                        Dim tauxCouverture As Integer = report.sky.layers(0).extent
                        infos.imageUrl = String.Format("img/Couvert{0}-4.gif",tauxCouverture)
    
                    Else
    
                        absenceInfos = True
    
                    End If
    
                Else
    
                    absenceInfos = True
    
                End If
    
            Else
    
                absenceInfos = True
    
            End If
        Else
    
            absenceInfos = True
    
        End If
    
        If (absenceInfos = True) Then
            infos.imageUrl = "img/AbsenceInfos.gif"
        End If
    
        infos.temperature = "" 
    
        If (Not report is Nothing) Then
    
            If (Not report.temperature is Nothing) Then
    
                infos.temperature = String.Format("{0} °",report.temperature.ambient)
    
            End If
    
        End If
    
        Return infos
    
    End Function
    
    Sub Page_Load(sender As Object,e As EventArgs)
    
        Dim imageUrl As String
        Dim temperature As Double
    
        Dim  infos As WeatherInfos
    
        Trace.Write("Contrôle météo","Avant GetWeatherInfos (Paris)")
        infos = GetWeatherInfos("LFPO")
        Trace.Write("Contrôle météo","Après GetWeatherInfos (Paris)")
    
        ImageParis.ImageUrl = infos.imageUrl
        TemperatureParis.Text = infos.temperature
    
    
        Trace.Write("Contrôle météo","Avant GetWeatherInfos (Marseille")
        infos = GetWeatherInfos("LFML")
        Trace.Write("Contrôle météo","Après GetWeatherInfos (Marseille)")
        ImageMarseille.ImageUrl = infos.imageUrl
        TemperatureMarseille.Text = infos.temperature
    
    End Sub

</script>
<table style="BORDER-COLLAPSE: collapse" bordercolor="#111111" cellspacing="0" cellpadding="0" bgcolor="#ffffc0" border="1">
    <tbody>
        <tr>
            <td align="middle" colspan="2">
                <b><font color="#000080">Météo sur nos sites</font> </b></td>
        </tr>
        <tr border="1">
            <td width="100">
                <p align="center">
                    <strong>PARIS </strong>
                </p>
            </td>
            <td align="middle" width="100" bgcolor="white">
                <asp:Image id="ImageParis" runat="server"></asp:Image>
                <br />
                <b>
                <asp:Label id="TemperatureParis" runat="server">Label</asp:Label>
                <br />
                <br />
                </b></td>
        </tr>
        <tr>
            <td width="100">
                <p align="center">
                    <strong>MARSEILLE </strong>
                </p>
            </td>
            <td align="middle" width="100" bgcolor="white">
                <asp:Image id="ImageMarseille" runat="server"></asp:Image>
                <br />
                <b>
                <asp:Label id="TemperatureMarseille" runat="server">Label</asp:Label>
                <br />
                <br />
                </b></td>
        </tr>
        <tr>
            <td colspan="2">
                <p align="center">
                    <em>Service fourni par</em> <a href="http://www.capescience.com/webservices/globalweather/index.shtml" target="_blank">CapeScience</a> 
                </p>
            </td>
        </tr>
    </tbody>
</table>