﻿<%@ Page Language="VB" %>
<%@ Register TagPrefix="SDS" TagName="NavBar" Src="NavBar.ascx" %>
<%@ Register TagPrefix="SDS" TagName="Footer" Src="Footer.ascx" %>
<%@ import Namespace="System.Data" %>
<%@ import Namespace="System.Data.SqlClient" %>
<script runat="server">

    ' Variables membres de la page
    
    Dim myConnection As SqlConnection
    Dim myAdapter As SqlDataAdapter
    Dim myDataSet As DataSet
    
    Sub Page_Load(sender As Object,e As EventArgs)
     
       Dim connStr As String = ConfigurationSettings.AppSettings("ConnectionString")
       myConnection = new SqlConnection(connStr)
    
       If (Not IsPostBack) Then
             ChargerListeFournisseurs()
             Calendrier.SelectedDate = DateTime.Now.AddDays(7)
       End If
    
    End Sub
    
    
    Sub OnFournisseurChanged(sender As Object,e As EventArgs)
    
        AfficherListeReferences()
    
    End Sub
    
    Sub ChargerListeFournisseurs()
    
        ' Chargement de la liste des fournisseurs
    
        Dim myCommand As SqlCommand
        Dim Sql As String
    
        SQL = "SELECT * FROM Fournisseur"
    
        myCommand = new SqlCommand(SQL,myConnection)
    
        Dim myDataReader As SqlDataReader
        
        myConnection.Open()
        myDataReader = myCommand.ExecuteReader()
    
        ListeFournisseurs.DataSource = myDataReader
        ListeFournisseurs.DataTextField  = "NomFournisseur"
        ListeFournisseurs.DataValueField = "ID_Fournisseur"
        ListeFournisseurs.DataBind()
    
        myDataReader.Close()
        myConnection.Close()
    
        ' Chargement de la liste des références pour le fournisseur actif
        AfficherListeReferences()
    
    End Sub
    
    Sub AfficherListeReferences()
    
        Dim ID As String
        ID = ListeFournisseurs.SelectedItem.Value
    
        Dim SQL As String
        SQL = "SELECT * FROM ReferenceFournisseur WHERE ID_Fournisseur = " + ID
    
        Dim myCommand As SqlCommand
        myCommand = new SqlCommand(SQL,myConnection)
    
        Dim myReader As SqlDataReader
        
        myConnection.Open()
        myReader  = myCommand.ExecuteReader()
    
        DetailCommande.DataSource = myReader
        DetailCommande.DataKeyField = "ID_ReferenceFournisseur"
        DetailCommande.DataBind()
    
        myReader.Close()
        myConnection.Close()
    
    End Sub
    
    
    Sub OnEnregistrerClicked(sender As Object,e As EventArgs)
    
        AuMoinsUneLigne.Visible=false
    
        If  (Page.IsValid=False) Then
           Return
        End If
    
        If (NbLignesCommandeNonVides()=0) Then
            AuMoinsUneLigne.Visible=True
            Return
        End If
    
        ' Création nouvelle commande
    
        Dim RedirectionURL As String
        Dim SQL As String
    
        Dim CommandAdapter,LinesAdapter As SqlDataAdapter
    
        myDataSet = new DataSet()
        
        ' Ouverture connexion
        
        myConnection.Open()
    
        ' Création nouvelle transaction
    
        Dim myTransaction As SqlTransaction
        myTransaction = myConnection.BeginTransaction()
    
        ' Préparation de DataSet & SqlDataAdapter pour la table "Commande"
    
        Try
    
            SQL = "SELECT * FROM Commande WHERE ID_Commande = 0"
    
            CommandAdapter = new SqlDataAdapter(SQL,myConnection)
    
            CommandAdapter.SelectCommand.Transaction = myTransaction
    
            CommandAdapter.Fill(myDataSet,"Commande")
    
            CommandAdapter.InsertCommand = new SqlCommand("CreerCommande",myConnection)
            CommandAdapter.InsertCommand.CommandType = CommandType.StoredProcedure
            CommandAdapter.InsertCommand.Parameters.Add("@FournisseurID",SqlDbType.Int,4,"ID_Fournisseur")
            CommandAdapter.InsertCommand.Parameters.Add("@DateLivraison",SqlDbType.DateTime,8,"DateLivraison")
    
            CommandAdapter.InsertCommand.Transaction = myTransaction
    
            Dim OutputParam As SqlParameter
            OutputParam = new SqlParameter("@CommandeID",SqlDbType.Int,4)
            OutputParam.Direction = ParameterDirection.Output
            CommandAdapter.InsertCommand.Parameters.Add(OutputParam)
    
            ' Préparation de DataSet & SqlDataAdapter pour la table "LigneCommande"
    
            SQL = "SELECT * FROM LigneCommande WHERE ID_LigneCommande = 0"
    
            LinesAdapter = new SqlDataAdapter(SQL,myConnection)
            LinesAdapter.SelectCommand.Transaction = myTransaction
            LinesAdapter.Fill(myDataSet,"LigneCommande")
    
            Dim myBuilder As SqlCommandBuilder
            myBuilder = new SqlCommandBuilder(LinesAdapter)
    
            myBuilder.GetInsertCommand().Transaction = myTransaction
    
    
            ' Création de la commande dans le DataSet
    
            Dim myDataRow As DataRow
            myDataRow = myDataSet.Tables("Commande").NewRow()
    
            myDataRow("ID_Fournisseur") = ListeFournisseurs.SelectedItem.Value
            myDataRow("DateLivraison") = Calendrier.SelectedDate
            myDataSet.Tables("Commande").Rows.Add(myDataRow)
    
            ' Création effective de la commande (indispensable pour récupérer l'ID !)
    
            CommandAdapter.Update(myDataSet,"Commande")
    
            Dim NewCommandID As Int32
            NewCommandID = OutputParam.Value
    
            ' Création des lignes de commande dans le DataSet
    
            Dim i As Int32
            Dim Qte As String
    
            For i = 0 To (DetailCommande.Items.Count-1)
    
                Qte = CType(DetailCommande.Items(i).Cells(2).FindControl("Qte"),TextBox).Text
    
                If (Qte<>"") Then
                    myDataRow = myDataSet.Tables("LigneCommande").NewRow()
                    myDataRow("ID_Commande") = NewCommandID
                    myDataRow("ID_ReferenceFournisseur") = DetailCommande.DataKeys(i)
                    myDataRow("Quantite") =  System.Convert.ToInt32(Qte)
                    myDataSet.Tables("LigneCommande").Rows.Add(myDataRow)
                End If
    
            Next
    
           ' Création effective des lignes de commande dans la base
    
            LinesAdapter.Update(myDataSet,"LigneCommande")
            RedirectionURL = "FinCommande.aspx?id="+NewCommandID.ToString()
    
        Catch myException As Exception
    
            myTransaction.Rollback()
            myConnection.Close()
            Response.Redirect("ErreurCde.aspx?erreurmsg="+myException.Message)
    
        End Try
    
        myTransaction.Commit()    
        myConnection.Close()
    
        ' Redirection vers la page de fin de commande
        Response.Redirect(RedirectionURL)
    
    End Sub
    
    Sub OnAnnulerClicked(sender As Object,e As EventArgs)
    
       Response.Redirect("fournisseurs.aspx")
    
    End Sub
    
    Function NbLignesCommandeNonVides() As Int32
    
        Dim i As Int32
        Dim nb As Int32
        Dim Qte As String
    
        nb = 0
    
        For i = 0 To (DetailCommande.Items.Count-1)
    
            Qte = CType(DetailCommande.Items(i).Cells(2).FindControl("Qte"),TextBox).Text
    
            If (Qte <> "") Then
                nb = nb+1
            End If
    
        Next
    
        Return nb
    
    End Function

</script>
<html>
<head>
    <title>Cahier du programmeur ASP.NET - Etude de cas</title>
    <link href="SDS.css" type="text/css" rel="stylesheet" />
</head>
<body>
    <SDS:NavBar id="NavBar" runat="server" SelectedIndex="2"></SDS:NavBar>
    <form runat="server">
        <h4>Saisie d'une nouvelle commande 
        </h4>
        <table bordercolor="black" bgcolor="#aaaadd">
            <tbody>
                <tr>
                    <td width="380">
                        <font color="white"><b>En-tête de la commande</b></font></td>
                </tr>
            </tbody>
        </table>
        <table id="TableEnTete" runat="server">
            <tbody>
                <tr>
                    <td width="150">
                        Fournisseur 
                    </td>
                    <td width="250">
                        <asp:DropDownList id="ListeFournisseurs" runat="server" width="230px" OnSelectedIndexChanged="OnFournisseurChanged" AutoPostBack="true"></asp:DropDownList>
                    </td>
                </tr>
                <tr>
                    <td valign="top" width="150">
                        Date livraison demandée</td>
                    <td width="250">
                        <asp:Calendar id="Calendrier" runat="server"></asp:Calendar>
                    </td>
                </tr>
            </tbody>
        </table>
        <br />
        <table bordercolor="black" bgcolor="#aaaadd">
            <tbody>
                <tr>
                    <td width="380">
                        <font color="white"><b>Détail de la commande</b></font></td>
                </tr>
            </tbody>
        </table>
        <asp:DataGrid id="DetailCommande" runat="server" AutoGenerateColumns="false">
            <Columns>
                <asp:BoundColumn HeaderText="Code" DataField="Code">
                    <HeaderStyle font-bold="true" width="50px"></HeaderStyle>
                </asp:BoundColumn>
                <asp:BoundColumn HeaderText="Désignation" DataField="Designation">
                    <HeaderStyle font-bold="true" width="265px"></HeaderStyle>
                </asp:BoundColumn>
                <asp:TemplateColumn HeaderText="Quantité">
                    <HeaderStyle font-bold="true" width="61px"></HeaderStyle>
                    <ItemTemplate>
                        <asp:TextBox width="50px" id="Qte" runat="server" />
                        <asp:RegularExpressionValidator id="ValiderQte" ControlToValidate="Qte" ValidationExpression="[1-9]*[0-9]*" runat="server" ErrorMessage=<%# DataBinder.Eval(Container.DataItem,"Code","{0} : quantité incorrecte")%>>*</asp:RegularExpressionValidator>
                    </ItemTemplate>
                </asp:TemplateColumn>
            </Columns>
        </asp:DataGrid>
        <p>
            <asp:Label id="AuMoinsUneLigne" runat="server" Visible="False" ForeColor="red">Merci de renseigner au moins une ligne de commande</asp:Label>
            <asp:ValidationSummary id="SyntheseValidation" runat="server" ControlToValidate="ListeFournisseurs" HeaderText="Merci de corriger les points suivants :"></asp:ValidationSummary>
            <br />
            <asp:Button id="Enregistrer" onclick="OnEnregistrerClicked" runat="server" Text="Enregistrer"></asp:Button>
            <asp:Button id="Annuler" onclick="OnAnnulerClicked" runat="server" Text="Annuler"></asp:Button>
        </p>
        <SDS:Footer id="MyFooter" runat="server"></SDS:Footer>
    </form>
</body>
</html>
