﻿<%@ Page Language="VB" %>
<%@ Register TagPrefix="SDS" TagName="NavBar" Src="NavBar.ascx" %>
<%@ Register TagPrefix="SDS" TagName="Footer" Src="Footer.ascx" %>
<%@ import Namespace="System.Data" %>
<%@ import Namespace="System.Data.SqlClient" %>
<script runat="server">

    Dim myConnection As SqlConnection
    
    Sub AfficherStocksProduits()
    
      Dim myCommand As SqlCommand
      Dim myReader  As SqlDataReader  
      Dim FamilleID  As String
    
      FamilleID    = ListeFamilles.SelectedItem.Value  
    
      myCommand = new SqlCommand("EtatStock",myConnection)
      myCommand.CommandType = CommandType.StoredProcedure  
      myCommand.Parameters.Add("@FamilleID",SqlDbType.Int).Value = FamilleID
      
      myConnection.Open()
      myReader = myCommand.ExecuteReader()
    
      TableauStocks.DataSource = myReader
      TableauStocks.DataBind()
    
      myReader.Close()
      myConnection.Close()
    
    End Sub
    
    Sub Page_Load(sender As Object, e As EventArgs)
    
       Dim connStr As String = ConfigurationSettings.AppSettings("ConnectionString")
       myConnection = new SqlConnection(connStr)
       
       If Not IsPostBack Then
            ChargerListeFamilles_DataReader()
            AfficherStocksProduits()
       End If
    
    End Sub
    
    Sub OnFamilleChanged(sender As Object, e As EventArgs)
    
           AfficherStocksProduits()
    
    End Sub
    
    
    Sub ChargerListeFamilles()
    
       Dim myAdapter    As SqlDataAdapter
       Dim myDataTable  As New DataTable()
       Dim SQL As String  
    
       SQL = "SELECT * FROM FamilleProduit"
       myAdapter  = new SqlDataAdapter(SQL,myConnection)
       myAdapter.Fill(myDataTable)
    
       ListeFamilles.DataSource = myDataTable.DefaultView
       ListeFamilles.DataValueField = "ID_FamilleProduit"
       ListeFamilles.DataTextField = "NomFamille"
       ListeFamilles.DataBind()
    
    End Sub
    
    Sub ChargerListeFamilles_DataReader()
    ' Version 'DataReader
       
       Dim myCommand As SqlCommand
       Dim  myReader As SqlDataReader
       Dim SQL As String
    
       
       SQL = "SELECT * FROM FamilleProduit"
       myCommand = new SqlCommand(SQL,myConnection)   
       
       myConnection.Open()
       myReader = myCommand.ExecuteReader()
    
    
       ListeFamilles.DataSource = myReader
       ListeFamilles.DataValueField = "ID_FamilleProduit"
       ListeFamilles.DataTextField = "NomFamille"
       ListeFamilles.DataBind()
    
       myReader.Close()
       myConnection.Close()
    
    End Sub

</script>
<html>
<head>
    <title>Cahier du programmeur ASP.NET - Etude de cas</title>
    <link href="SDS.css" type="text/css" rel="stylesheet" />
</head>
<body>
    <SDS:NavBar id="UserControl1" SelectedIndex="1" runat="server"></SDS:NavBar>
    <p>
    </p>
    <p>
    </p>
    <form runat="server">
        <h4>Consultation de l'état du stock par famille de produit 
        </h4>
        <table style="WIDTH: 325px" bgcolor="#ffffc0">
            <tbody>
                <tr>
                    <td width="60">
                        Famille 
                    </td>
                    <td>
                        <asp:DropDownList id="ListeFamilles" runat="server" OnSelectedIndexChanged="OnFamilleChanged" width="250px" AutoPostBack="true"></asp:DropDownList>
                    </td>
                </tr>
            </tbody>
        </table>
        <br />
        <asp:DataGrid id="TableauStocks" runat="server" GridLines="Both" CellSpacing="0" Font-Name="Verdana" Font-Size="8pt" HeaderStyle-BackColor="#aaaadd" AutoGenerateColumns="false" BorderWidth="1" CellPadding="3" BorderColor="black">
            <Columns>
                <asp:BoundColumn HeaderText="Code" DataField="Code">
                    <HeaderStyle width="50px"></HeaderStyle>
                </asp:BoundColumn>
                <asp:HyperLinkColumn HeaderText="Désignation" DataNavigateUrlField="ID_Produit" DataNavigateUrlFormatString="DetailStocks.aspx?id={0}" DataTextField="Designation">
                    <HeaderStyle width="150px"></HeaderStyle>
                </asp:HyperLinkColumn>
                <asp:BoundColumn HeaderText="Stock" ItemStyle-HorizontalAlign="right" DataField="Stock">
                    <HeaderStyle width="100px"></HeaderStyle>
                </asp:BoundColumn>
            </Columns>
        </asp:DataGrid>
        <br />
        <br />
        <a href="TestServiceStocks.aspx">Tester le service Web de mise à jour des stocks</a> 
        <br />
        <br />
        <SDS:Footer id="MyFooter" runat="server"></SDS:Footer>
    </form>
</body>
</html>
