﻿<%@ Page Language="VB" %>
<%@ Register TagPrefix="SDS" TagName="NavBar" Src="NavBar.ascx" %>
<%@ Register TagPrefix="SDS" TagName="Footer" Src="Footer.ascx" %>
<%@ import Namespace="SDS" %>
<%@ import Namespace="System.Data" %>
<%@ import Namespace="System.Data.SqlClient" %>
<script runat="server">

    Sub Appel_Click(sender As Object,e As EventArgs)
    
        Dim applicationRoot As String = ConfigurationSettings.AppSettings("WebServicesRoot")
    
        Dim proxy As ServiceStocks = New ServiceStocks(applicationRoot)
        Dim authInfo As AuthHeader= New AuthHeader()
        authInfo.Username = Login.Text
        authInfo.Password = Password.Text
        proxy.AuthHeaderValue = authInfo
        Resultat.Text = proxy.AjouterMouvementStock(Int32.Parse(Produit.SelectedItem.Value),Int32.Parse(Annee.SelectedItem.Text),Mois.SelectedIndex+1,Int32.Parse(Quantite.Text))
    
    End Sub
    
    Sub Page_Load(sender As Object, e As EventArgs)
    
        If(Not IsPostBack) Then
                            
            ' Produit
                    
            Dim connStr As String = ConfigurationSettings.AppSettings("ConnectionString")
            Dim myConnection As SqlConnection = new SqlConnection(connStr)
    
            Dim cmd As SqlCommand = New SqlCommand("SELECT * FROM Produit",myConnection)
            
            myConnection.Open()
            Dim myReader As SqlDataReader = cmd.ExecuteReader()
            Produit.DataValueField = "ID_Produit"
            Produit.DataTextField  ="Designation"
            Produit.DataSource = myReader
            Produit.DataBind()
            myReader.Close()
            myConnection.Close()
    
            ' Année
    
            Dim yearArray As ArrayList = New ArrayList()
            yearArray.Add("2002")
            yearArray.Add("2003")
            Annee.DataSource=yearArray
            Annee.DataBind()
    
            ' Mois
    
            Dim monthArray As ArrayList = new ArrayList()
            monthArray.Add("Janvier")
            monthArray.Add("Février")
            monthArray.Add("Mars")
            monthArray.Add("Avril")
            monthArray.Add("Mai")
            monthArray.Add("Juin")
            monthArray.Add("Juillet")
            monthArray.Add("Aout")
            monthArray.Add("Septembre")
            monthArray.Add("Octobre")
            monthArray.Add("Novembre")
            monthArray.Add("Décembre")
            Mois.DataSource = monthArray
            Mois.DataBind()
        End If
    End Sub

</script>
<html>
<head>
    <link href="SDS.css" type="text/css" rel="stylesheet" />
</head>
<body>
    <form runat="server">
        <SDS:NavBar id="myNavBar" runat="server" SelectedIndex="1"></SDS:NavBar>
        <h4>Test du service&nbsp;du mise à jour des stocks 
        </h4>
        <p>
            <strong>Informations d'authentification<br />
            </strong><em>(transmises dans l'en-tête SOAP du service; utiliser : guest/guest) </em>
        </p>
        <p>
            <table>
                <tbody>
                    <tr>
                        <td width="90">
                            Identifiant : 
                        </td>
                        <td>
                            <asp:TextBox id="Login" runat="server" Width="80px"></asp:TextBox>
                        </td>
                    </tr>
                    <tr>
                        <td width="90">
                            Mot de passe:</td>
                        <td>
                            <asp:TextBox id="Password" runat="server" Width="80px" TextMode="Password"></asp:TextBox>
                        </td>
                    </tr>
                </tbody>
            </table>
        </p>
        <p>
            <strong>Paramètres d'appel du service</strong> 
        </p>
        <p>
            <table>
                <tbody>
                    <tr>
                        <td width="90">
                            Produit : 
                        </td>
                        <td>
                            <asp:DropDownList id="Produit" runat="server" Width="150px"></asp:DropDownList>
                        </td>
                    </tr>
                    <tr>
                        <td width="90">
                            Année :</td>
                        <td>
                            <asp:DropDownList id="Annee" runat="server" Width="80px"></asp:DropDownList>
                        </td>
                    </tr>
                    <tr>
                        <td width="90">
                            Mois :</td>
                        <td>
                            <asp:DropDownList id="Mois" runat="server" Width="80px"></asp:DropDownList>
                        </td>
                    </tr>
                    <tr>
                        <td width="90">
                            Quantité :</td>
                        <td>
                            <asp:TextBox id="Quantite" runat="server" Width="80px"></asp:TextBox>
                            <asp:RegularExpressionValidator id="QteNumeriqueValidator" runat="server" ControlToValidate="Quantite" ValidationExpression="[-]*[0-9]+" ErrorMessage="Merci de saisir une quantité numérique entière">*</asp:RegularExpressionValidator>
                            <asp:RequiredFieldValidator id="QteRequiseValidator" runat="server" ControlToValidate="Quantite" ErrorMessage="Merci de saisir une quantité">*</asp:RequiredFieldValidator>
                        </td>
                    </tr>
                </tbody>
            </table>
        </p>
        <p>
            <asp:ValidationSummary id="ValidationSummary" runat="server"></asp:ValidationSummary>
        </p>
        <p>
            <asp:Button id="Appel" onclick="Appel_Click" runat="server" Text="Appeler le service"></asp:Button>
        </p>
        <p>
            Résultat : 
            <asp:Label id="Resultat" runat="server" Font-Bold="True"></asp:Label>
            <br />
            <br />
            <br />
            [<a href="stocks.aspx">Retour&nbsp;à la page d'accueil du module 'Stocks'</a>] 
        </p>
        <SDS:Footer id="MyFooter" runat="server"></SDS:Footer>
    </form>
</body>
</html>
