﻿<%@ Page Language="VB" %>
<%@ Register TagPrefix="SDS" TagName="NavBar" Src="NavBar.ascx" %>
<%@ Register TagPrefix="SDS" TagName="Footer" Src="Footer.ascx" %>
<%@ Register TagPrefix="SDS" Namespace="SDS.Controls" Assembly="SDS.Controls" %>
<%@ Register TagPrefix="n0" Namespace="Topic.Web.VisualMap.France" Assembly="Topic.Web.VisualMap.France, Culture=neutral, PublicKeyToken=615c61a4eeee5b74" %>
<%@ import Namespace="System.Data" %>
<%@ import Namespace="System.Collections" %>
<%@ import Namespace="System.Data.SqlClient" %>
<script runat="server">

    Dim myConnection As SqlConnection 
    
        Sub RemplirListeAxesAnalyse()    
        
            Dim list As New ArrayList
            list.Add("par région")
            list.Add("par famille de produit")
            ListeAxes.DataSource = list
            ListeAxes.DataBind()
            ListeAxes.SelectedIndex = 0
            
        End Sub
    
        Sub RemplirListeMois()
        
            Dim list As New ArrayList
            list.Add("2002 - Janvier")
            list.Add("2002 - Février")
            list.Add("2002 - Mars")
            list.Add("2002 - Avril")
            list.Add("2002 - Mai")
            list.Add("2002 - Juin")
            list.Add("2002 - Juillet")
            list.Add("2002 - Août")
            list.Add("2002 - Septembre")
            list.Add("2002 - Octobre")
            list.Add("2002 - Novembre")
            list.Add("2002 - Décembre")
            ListeMois.DataSource = list
            ListeMois.DataBind()
        
         End Sub
    
         Sub ParametrerGraphique()
         
             Dim mois As Integer = ListeMois.SelectedIndex+1
    
             If (ListeAxes.SelectedIndex = 0) Then 'Ventes par région
             
                ' Paramétrage de la carte
    
                 Carte.DataSource  = GetDataSource_Regions(mois)
                 Carte.Title       = String.Format("Ventes {0:D2}/2002",mois)
                 Carte.DataBind()
                 Carte.Visible         = True
                 VisualMapLogo.Visible = True
    
                 ' On masque le "camembert"
    
                 Camembert.Visible = false
                          
             Else   ' Ventes par famille de produit         
                 
                 ' Paramètrage du "camembert"
    
                 Camembert.DataSource  = GetDataSource_Familles(mois)
                 Camembert.Visible     = True
    
                 ' On masque la carte
    
                 Carte.Visible         = False
                 VisualMapLogo.Visible = False
                 
             End If
             
         End Sub
    
    
         Sub Page_Load(sender As Object, e As EventArgs)
         
             Dim connStr As String = ConfigurationSettings.AppSettings("ConnectionString")
             myConnection = new SqlConnection(connStr)
    
             If (Not IsPostBack)
                      
                 RemplirListeAxesAnalyse()
                 RemplirListeMois()
    
                 Carte.DataValueField = "Pourcentage"
                 Carte.DataKeyField   = "ID_Region"
    
                 Camembert.DataValueField = "Pourcentage"
                 Camembert.DataTextField = "NomFamille"
    
                 ParametrerGraphique()             
                 
             End If
             
         End Sub
    
         Function GetDataSource_Familles(mois As Integer) As DataView 
         
             Dim param As String = String.Format("2002{0:D2}",mois)
    
             Dim myAdapter As SqlDataAdapter = new SqlDataAdapter("VentesMensuellesParFamille",myConnection)
             myAdapter.SelectCommand.CommandType = CommandType.StoredProcedure
             myAdapter.SelectCommand.Parameters.Add("@Mois",SqlDbType.VarChar)
             myAdapter.SelectCommand.Parameters("@Mois").Value = param
    
             Dim myDataTable As New DataTable()
             myAdapter.Fill(myDataTable)
    
             return myDataTable.DefaultView
             
         End Function
    
         Function GetDataSource_Regions(mois As Integer) As DataView 
         
             Dim param As String = String.Format("2002{0:D2}",mois)
    
             Dim myAdapter As SqlDataAdapter  = new SqlDataAdapter("VentesMensuellesParRegion",myConnection)
             myAdapter.SelectCommand.CommandType = CommandType.StoredProcedure
             myAdapter.SelectCommand.Parameters.Add("@Mois",SqlDbType.VarChar)
             myAdapter.SelectCommand.Parameters("@Mois").Value = param
    
             Dim myDataTable As New DataTable()
             myAdapter.Fill(myDataTable)
    
             return myDataTable.DefaultView
             
         End Function
    
    
         Sub ListeMois_SelectedIndexChanged(sender As Object,e As EventArgs)     
                  ParametrerGraphique()         
         End Sub
    
         Sub ListeAxes_SelectedIndexChanged(sender As Object,e As EventArgs) 
             ParametrerGraphique()
         End Sub

</script>
<html>
<head>
    <title>Cahier du programmeur ASP.NET - Etude de cas</title>
    <link href="SDS.css" type="text/css" rel="stylesheet" />
</head>
<body>
    <SDS:NAVBAR id="UserControl1" SelectedIndex="3" runat="server"></SDS:NAVBAR>
    <p>
    </p>
    <p>
    </p>
    <form runat="server">
        <h4>Répartition du chiffre d'affaire (en %)&nbsp; 
        </h4>
        <table bgcolor="#ffffc0">
            <tbody>
                <tr>
                    <td>
                        Axe d'analyse 
                    </td>
                    <td>
                        <asp:DropDownList id="ListeAxes" runat="server" AutoPostBack="True" Width="180px" OnSelectedIndexChanged="ListeAxes_SelectedIndexChanged"></asp:DropDownList>
                    </td>
                </tr>
                <tr>
                    <td>
                        Période 
                    </td>
                    <td>
                        <asp:DropDownList id="ListeMois" runat="server" AutoPostBack="True" Width="180px" OnSelectedIndexChanged="ListeMois_SelectedIndexChanged"></asp:DropDownList>
                    </td>
                </tr>
            </tbody>
        </table>
        <p>
            <N0:VISUALMAPFRANCE id="Carte" runat="server" AutoGenerateLevels="False">
                <levels>
                    <level inferiorlimit="0" superiorlimit="2" formatstring="Entre 0% et 2%" />
                    <level inferiorlimit="2" superiorlimit="4" formatstring="Entre 2% et 4%" />
                    <level inferiorlimit="4" superiorlimit="6" formatstring="Entre 4% et 6%" />
                    <level inferiorlimit="6" superiorlimit="8" formatstring="Entre 6% et 8%" />
                    <level inferiorlimit="8" superiorlimit="10" formatstring="Entre 8% et 10%" />
                </levels>
            </N0:VISUALMAPFRANCE>
            &nbsp; <a href="http://www.visualmap.net" target="_blank">
            <asp:Image id="VisualMapLogo" runat="server" ImageUrl="img/PoweredByVisualMap.gif"></asp:Image>
            </a>
            <SDS:CAMEMBERT id="Camembert" runat="server"></SDS:CAMEMBERT>
        </p>
        <p>
        </p>
        <p>
        </p>
        <p>
        </p>
        <p>
            <a href="default.aspx">Retour au menu principal</a> 
        </p>
        <SDS:FOOTER id="MyFooter" runat="server" />
    </form>
</body>
</html>