Option Explicit
Option Strict

Imports System
Imports System.Text
Imports System.Data
Imports System.Data.SqlClient
Imports System.Xml
Imports System.Xml.Xsl
    
Namespace SDS 
          
    public Class XmlGenerator    
        private Connection As SqlConnection 
        private NoCommande As String
        private Path As String
                
        Public Sub New(no As String, conn As SqlConnection, p As String)   
            Connection  = conn
            NoCommande  = no
            Path        = p
        End Sub
                                    
        Public Sub GenererFichierXml(xmlFile As String)                
                                    
            Dim myDataSet As DataSet
            Dim CommandAdapter,LinesAdapter As SqlDataAdapter
            
            myDataSet = new DataSet()
                                                                                                              
            CommandAdapter = new SqlDataAdapter("DetailsCommande",Connection)            
            CommandAdapter.SelectCommand.CommandType = CommandType.StoredProcedure
            CommandAdapter.SelectCommand.Parameters.Add("@CommandeID",SqlDbType.Int)
            CommandAdapter.SelectCommand.Parameters("@CommandeID").Value = NoCommande            
            CommandAdapter.Fill(myDataSet,"Commande")
                                                                                      
            LinesAdapter = new SqlDataAdapter("ListeLignesCommandes",Connection)
            LinesAdapter.SelectCommand.CommandType = CommandType.StoredProcedure
            LinesAdapter.SelectCommand.Parameters.Add("@CommandeID",SqlDbType.Int)
            LinesAdapter.SelectCommand.Parameters("@CommandeID").Value = NoCommande            
            LinesAdapter.Fill(myDataSet,"LigneCommande")
                                                                   
            myDataSet.Relations.Add ("Commande_LigneCommande", _
                        myDataSet.Tables("Commande").Columns("ID_Commande"), _
                        myDataSet.Tables("LigneCommande").Columns("ID_Commande"))
        
            myDataSet.Relations("Commande_LigneCommande").Nested = True
                                          
            myDataSet.WriteXml(Path+xmlFile)       
        
        End Sub
        
                           
        Public Sub GenererTelecopie(xmlFile As String,xslFile As String, outputFile As String )
        
            Dim myTransform As XslTransform
            Dim myDocument  As XmlDocument
            Dim myWriter    As XmlWriter
            
            myTransform = new XslTransform()           
            myTransform.Load(Path+xslFile)
        
            myDocument = new XmlDocument()
            myDocument.Load(Path+xmlFile)
            
            myWriter = new XmlTextWriter(Path+outputFile,Encoding.UTF8)        
            myTransform.Transform(myDocument,Nothing,myWriter)        
            myWriter.Close()
            
        End Sub
        
    End Class

End Namespace 
