using System;
using System.Reflection;

public class MyApp {
	static void Main() {
		AppDomain child = AppDomain.CreateDomain("childapp");
		Console.WriteLine(GetAssemblyCount(child));
		AppDomain.Unload(child);
	}

	static int GetAssemblyCount(AppDomain target) {
		// create the delegate
		CrossAppDomainDelegate cb =
			new CrossAppDomainDelegate(CallbackProc);
		
		// inject and execute the code
		target.DoCallBack(cb);

		// extract the property
		return (int)target.GetData("LoadedAsmCount");
	}

	public static void CallbackProc() {
		AppDomain current = AppDomain.CurrentDomain;
		current.SetData("LoadedAsmCount",
		current.GetAssemblies().Length);
	}
}