using System;
using System.Reflection;


public class TestCallBack{
	static void Main() {
		AppDomain parent = AppDomain.CurrentDomain;
		Console.WriteLine("Domaine d'application principal:"+parent.FriendlyName);
		ListeAssemblages();

		Console.WriteLine("-------------------------------------------");

		AppDomain enfant = AppDomain.CreateDomain("AppDomain Enfant");
		Console.WriteLine("Domaine d'application enfant:"+enfant.FriendlyName);

		enfant.Load("DoCallBack");

		CrossAppDomainDelegate cb = new CrossAppDomainDelegate(ListeAssemblages);
		enfant.DoCallBack(cb);

		AppDomain.Unload(enfant);
	}

	public static void ListeAssemblages() {
		Console.WriteLine("Liste des assemblages chargs...");
		AppDomain encours = AppDomain.CurrentDomain;
		foreach(Assembly a in encours.GetAssemblies())
			Console.WriteLine(" -->"+a.FullName);
	}
}