using System;
using R = System.Reflection;
using E = System.Reflection.Emit;
using C = System.CodeDom;


class Class1 {
	static void Main(string[] args) {

		Microsoft.CSharp.CSharpCodeProvider cSharpCodeProvider;
		cSharpCodeProvider = new Microsoft.CSharp.CSharpCodeProvider();

		C.Compiler.ICodeGenerator iCodeGenerator;
		iCodeGenerator = cSharpCodeProvider.CreateGenerator();


		// Gnration d'un commentaire pour le code complet
		C.CodeCommentStatement codeComment = new C.CodeCommentStatement("Ceci est un commentaire", true);

		// Gnration des using
		C.CodeNamespaceImport usingSystem = new C.CodeNamespaceImport("System");
		C.CodeNamespaceImport usingMicrosoft = new C.CodeNamespaceImport("Microsoft");


		// Gnration d'une classe
		C.CodeTypeDeclaration mainClass = new C.CodeTypeDeclaration("TestClass");

		// Gnration d'une mthode Show
		C.CodeMemberMethod method = new C.CodeMemberMethod();
		method.Name = "Show";
		mainClass.Members.Add(method);

		// Gnration d'une mthode Main
		C.CodeEntryPointMethod mainMethod = new C.CodeEntryPointMethod();
		mainClass.Members.Add(mainMethod);


		// Gnration de l'arbre complet du code source
		C.CodeNamespace codeNameSpace = new C.CodeNamespace("MesOutils");
		codeNameSpace.Comments.Add(codeComment);
		codeNameSpace.Imports.Add(usingSystem);
		codeNameSpace.Imports.Add(usingMicrosoft);
		codeNameSpace.Types.Add(mainClass);


		C.Compiler.CodeGeneratorOptions op = new C.Compiler.CodeGeneratorOptions();
		op.BracingStyle = "Block";
		op.BlankLinesBetweenMembers = false;


		System.IO.StreamWriter file = new System.IO.StreamWriter("testGen.cs");
		iCodeGenerator.GenerateCodeFromNamespace(codeNameSpace, file, op);
		//iCodeGenerator.GenerateCodeFromNamespace(codeNameSpace, file, null);
		file.Close();
	}
}
