using System;

using CCSharp = Microsoft.CSharp;
using CDOM = System.CodeDom.Compiler;

class MyCsc {
	static void Main(string[] args) {
		if(args.Length!=1) {
			Console.WriteLine("MyCsc version 1.0");
			Console.WriteLine("- syntaxe: MyCsc fichier.cs");
		}
		else CompileFile(args[0]);
	}

	static void CompileFile(string filename) {
		Console.WriteLine("Compilation du fichier : "+filename);

		CCSharp.CSharpCodeProvider codeProvider = new CCSharp.CSharpCodeProvider();
		
		CDOM.ICodeCompiler iCodeCompiler = codeProvider.CreateCompiler();

		CDOM.CompilerParameters parameters = new CDOM.CompilerParameters();
		parameters.GenerateExecutable = true;
		parameters.OutputAssembly = "Test.exe";
			
		CDOM.CompilerResults results = iCodeCompiler.CompileAssemblyFromFile(parameters, filename);

		foreach(CDOM.CompilerError error in results.Errors) {
			string position = String.Format("[ligne: {0}, colonne: {1}]", error.Line, error.Column);

			string errorText = String.Format("Err n: {0}, {1}", error.ErrorNumber, error.ErrorText);

			Console.WriteLine(position);
			Console.WriteLine(errorText);
		}
	}
}