using System;
using R = System.Reflection;
using E = System.Reflection.Emit;

class EmitTest {
	static Type GenerateCode() {
		// Cration d'un assemblage
		R.AssemblyName assemblyName = new R.AssemblyName();
		assemblyName.Name = "MonTest";

		AppDomain currentDomain = AppDomain.CurrentDomain;
		E.AssemblyBuilder assemblyBuilder = currentDomain.DefineDynamicAssembly(assemblyName, E.AssemblyBuilderAccess.Run);

		// Objet permettant la cration d'un type comme une classe et ses lments
		E.ModuleBuilder moduleBuilder = assemblyBuilder.DefineDynamicModule("TestModule");

		// Cration d'une classe
		E.TypeBuilder typeBuilder = moduleBuilder.DefineType("TestClass", R.TypeAttributes.Public);

		// Cration d'une mthode
		E.MethodBuilder methodBuilder = typeBuilder.DefineMethod("ShowMe", R.MethodAttributes.Public, null, null);

		// Gnration du code de la mthode
		E.ILGenerator ilGenerator = methodBuilder.GetILGenerator();
		ilGenerator.EmitWriteLine("Salut IL !");

		ilGenerator.Emit(E.OpCodes.Ret);

		return typeBuilder.CreateType();
	}

	static void Main(string[] args) {
		try {
			Type t = GenerateCode();

			object o = Activator.CreateInstance(t);
			System.Reflection.MethodInfo mi = t.GetMethod("ShowMe");
			mi.Invoke(o, null);

			Console.Write("Fin de l'invocation...");
		}
		catch(Exception e) {
			Console.WriteLine(e.Message);
		}
	}
}
