using System;

public delegate void ExecuteHandler(string filename); 

public class Compression {

	private ExecuteHandler zipExecuteCompress;
	private ExecuteHandler zipExecuteDecompress; 

	public Compression() {
		ZipCompress zipCompress = new ZipCompress();
		zipExecuteCompress = new ExecuteHandler(zipCompress.Execute);
		
		ZipDecompress zipDecompress = new ZipDecompress(); 	
		zipExecuteDecompress = new ExecuteHandler(zipDecompress.Execute);
	}

	public void CompressFile(string filename) {
		zipExecuteDecompress(filename);
	}

	public void DeCompressFile(string filename) {
		zipExecuteDecompress(filename);
	}

	public void SetCompressMethod(ExecuteHandler executeHandler) {
		zipExecuteCompress = new ExecuteHandler(executeHandler);
	}
}