using System;


public delegate void StartEventHandler(object sender, VehiculeStartChangedEventArgs  e);


public class VehiculeStartChangedEventArgs : EventArgs {
	
	VehiculeModel vehicule;

	public VehiculeStartChangedEventArgs(VehiculeModel _vehicule) {
		vehicule = _vehicule;
	}

	public VehiculeModel Vehicule {
		get { return vehicule; }
	}
	
}


public class VehiculeModel {

	public event StartEventHandler StartChanged;

	private bool _start;
	public bool Start {
		get { return _start; }
		set { _start = value; OnStartChanged(); }
	}

	private void OnStartChanged() {
		StartChanged(this, new VehiculeStartChangedEventArgs(this));
	}

	

	public event StartEventHandler SpeedChanged;

	private int _speed;
	public int Speed {
		get { return _speed; }
		set { _speed = value; OnSpeedChanged(); }
	}

	private void OnSpeedChanged() {
		SpeedChanged(this, new VehiculeStartChangedEventArgs(this));
	}

}