using System;


public class VehiculeView: System.Windows.Forms.Form
{
	private System.Windows.Forms.Button btnStart;
	private System.Windows.Forms.Button btnEnable;
	private System.Windows.Forms.Button btnDisable;
	private System.Windows.Forms.Button btnReset;
	private System.Windows.Forms.CheckBox chkResetState;
	private System.Windows.Forms.Label lblState;
	private System.Windows.Forms.Button btnSpeedIncrease;
	private System.Windows.Forms.TextBox tbxSpeed;


	private VehiculeModel vehiculeModel;
	private VehiculeControler vehiculeControler;


	static void Main() {
		System.Windows.Forms.Application.Run(new VehiculeView());
	}

	public VehiculeView() {

		// Cration de l'interface
		CreateIHM();

		// Cration du modle
		CreateVehiculeModel();

		// Cration du contrleur
		CreateVehiculeControler();
	}

	private void CreateIHM() {
		btnStart = new System.Windows.Forms.Button();
		btnStart.Text = "Start";
		btnStart.Click += new System.EventHandler(btnStartClick);
		Controls.Add(btnStart);

		btnEnable = new System.Windows.Forms.Button();
		btnEnable.Top = 40;
		btnEnable.Text = "Enable";
		btnEnable.Click += new System.EventHandler(btnEnableClick);
		Controls.Add(btnEnable);

		btnDisable = new System.Windows.Forms.Button();
		btnDisable.Top = 40; btnDisable.Left = 100;
		btnDisable.Text = "Disable";
		btnDisable.Click += new System.EventHandler(btnDisableClick);
		Controls.Add(btnDisable);

		btnReset = new System.Windows.Forms.Button();
		btnReset.Top = 70; 
		btnReset.Text = "Reset";
		btnReset.Click += new System.EventHandler(btnResetClick);
		Controls.Add(btnReset);

		chkResetState = new System.Windows.Forms.CheckBox();
		chkResetState.Top = 70; chkResetState.Left = 100;
		chkResetState.Text = "Marche";
		chkResetState.Checked = false;
		Controls.Add(chkResetState);		

		lblState = new System.Windows.Forms.Label();
		lblState.Left = 90;
		lblState.Text = "No change";
		Controls.Add(lblState);

		btnSpeedIncrease = new System.Windows.Forms.Button();
		btnSpeedIncrease.Top = 90; 
		btnSpeedIncrease.Text = "Increase Speed";
		btnSpeedIncrease.Click += new System.EventHandler(btnSpeedIncreaseClick);
		Controls.Add(btnSpeedIncrease);

		tbxSpeed = new System.Windows.Forms.TextBox();
		tbxSpeed.Top = 90; tbxSpeed.Left = 100;
		tbxSpeed.Text = "0";
		Controls.Add(tbxSpeed);
	}

	private void CreateVehiculeModel() {
		vehiculeModel = new VehiculeModel();
		vehiculeModel.StartChanged += new StartEventHandler(ChangeButtonText);
		vehiculeModel.StartChanged += new StartEventHandler(ChangeLabelText);	
		vehiculeModel.SpeedChanged += new StartEventHandler(ChangeTextboxText);	
	}

	private void CreateVehiculeControler() {
		vehiculeControler = new VehiculeControler(this, vehiculeModel);
	}



	//===========================================================================================================
	//************************************************************** Dbut des mthodes lis aux vnements IHM
	private void btnStartClick(object sender, System.EventArgs e) {
		vehiculeControler.ChangeStartValue();	
	}

	private void btnEnableClick(object sender, System.EventArgs e) {
		vehiculeControler.EnableButtonsState();	
	}

	private void btnDisableClick(object sender, System.EventArgs e) {
		vehiculeControler.DisableButtonsState();	
	}


	private void btnResetClick(object sender, System.EventArgs e) {
		vehiculeControler.ResetButtonsState(chkResetState.Checked);	
	}

	private void btnSpeedIncreaseClick(object sender, System.EventArgs e) {
		vehiculeControler.SpeedIncreaseValue();	
	}
	//************************************************************** Fin des mthodes lis aux vnements IHM
	//-----------------------------------------------------------------------------------------------------------


	//===========================================================================================================
	//********************************************************* Dbut Mthodes lis au changement d'tat du model
	private void ChangeButtonText(object sender, VehiculeStartChangedEventArgs e) {
		btnStart.Text = (e.Vehicule.Start) ? "Stop" : "Start";
	}

	private void ChangeLabelText(object sender, VehiculeStartChangedEventArgs e) {
		lblState.Text = (e.Vehicule.Start) ? "Vehcule Start" : "Vehcule Stop";
	}

	private void ChangeTextboxText(object sender, VehiculeStartChangedEventArgs e) {
		tbxSpeed.Text = e.Vehicule.Speed.ToString();
	}
	//********************************************************* Fin Mthodes lis au changement d'tat du model
	//-----------------------------------------------------------------------------------------------------------


	//===========================================================================================================
	//********************************************************* Dbut Mthodes de changement de vue
	public void SetButtonsEnable() {
		btnStart.Enabled = true;
		//vehiculeView.lblState.Color = 
	}


	public void SetButtonsDisable() {
		btnStart.Enabled = false;
		//vehiculeView.lblState.Color = 
	}

	//********************************************************* Fin Mthodes de changement de vue
	//-----------------------------------------------------------------------------------------------------------
}
