using System;
using System.Messaging;

public class MsmqTest {
	private static MessageQueue cmdQueue;

	public static void Main(String[] args) {
		if(args.Length==0) {
			Console.WriteLine("utilisation: ServerTest [serveur|client] ");
		}
		else 
		if(args[0].Equals("serveur")){
			CreateQueue(@".\private$\MaFile");
			ReceiveCmd();
		}
		else
		if(args[0].Equals("client")) {
			SendCmd();
		}
		else {
			Console.WriteLine("Paramtre incorrect");
		}
	}


	public static void CreateQueue(String queueName) {
		try {
			MessageQueue.Create(queueName);

			cmdQueue = new MessageQueue();
			cmdQueue.Path = queueName;
		}
		catch(MessageQueueException mqe) {
			Console.WriteLine(mqe.Message);
		}
		catch (Exception e) {
			Console.WriteLine("Erreur: cration non ralise");
			Console.WriteLine(e.Message);
		}
	}

	public static void SendCmd() {
		try {
			cmdQueue = new MessageQueue();
			cmdQueue.Path = @".\private$\MaFile";
			cmdQueue.Send(new Object(), "Un texte");
		}
		catch(MessageQueueException mqe) {
			Console.WriteLine(mqe.Message);
		}
		catch (Exception e) {
			Console.WriteLine("Erreur: envoie non ralis");
			Console.WriteLine(e.Message);
		}
	}

	public static void ReceiveCmd() {
		try {
			Message msg = cmdQueue.Receive (new TimeSpan(0, 0, 5));
			Console.WriteLine("Le message {0} contient {1}", msg.Label, msg.Body);
		}
		catch(MessageQueueException mqe) {
			Console.WriteLine(mqe.Message);
		}
		catch (Exception e) {
			Console.WriteLine("Erreur: rception non ralise");
			Console.WriteLine(e.Message);
		}
	}
}