using System;


class Moto {
	public void Show() {
		Console.WriteLine("Une moto...");
	}

	public void ShowMore(int times) {
		Console.WriteLine("ShowMore de Moto...");
		for(int i=0; i<times; i++) 
			Show();
	}
}

class Voiture {
	public void Show() {
		Console.WriteLine("Une voiture...");
	}

	public void ShowMore(int times) {
		Console.WriteLine("ShowMore de Voiture...");
		for(int i=0; i<times; i++) 
			Show();
	}
}


public class TestMethodActivator {
	public static void Main() {
		Console.Write("Entrez un nom de classe (Moto ou Voiture) : ");
		string classname = Console.ReadLine();

		Object vehicule = Activator.CreateInstance(Type.GetType(classname));

		Type type = vehicule.GetType();

		// Invocation d'une mthode sans paramtre
		System.Reflection.MethodInfo method = type.GetMethod("Show");
		if (method!=null)
			method.Invoke(vehicule, null);
		else
			Console.WriteLine("Mthode sans paramtre non trouve");

		Console.Write("Donnez un nombre d'itration : ");
		int nbTimes = Convert.ToInt32(Console.ReadLine());

		// Invocation d'une mthode avec un entier paramtre
		Type[] argTypes = {typeof(int)};
		System.Reflection.MethodInfo methodShowMore = type.GetMethod("ShowMore", argTypes);

		if(methodShowMore!=null) {
			Object[] args = new Object[1]; args[0]=nbTimes;
			methodShowMore.Invoke(vehicule, args);
		}
		else
			Console.WriteLine("Mthode avec paramtre non trouve");
	}
}